/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.availability.tasks;

import haveno.common.app.Version;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.taskrunner.Model;
import haveno.common.taskrunner.Task;
import haveno.common.taskrunner.TaskRunner;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.availability.OfferAvailabilityModel;
import haveno.core.offer.messages.OfferAvailabilityRequest;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.messages.TradeProtocolVersion;
import haveno.core.user.User;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.SendDirectMessageListener;
import java.util.Date;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendOfferAvailabilityRequest
extends Task<OfferAvailabilityModel> {
    private static final Logger log = LoggerFactory.getLogger(SendOfferAvailabilityRequest.class);

    public SendOfferAvailabilityRequest(TaskRunner<OfferAvailabilityModel> taskHandler, OfferAvailabilityModel model) {
        super(taskHandler, (Model)model);
    }

    protected void run() {
        try {
            this.runInterceptHook();
            Offer offer = ((OfferAvailabilityModel)this.model).getOffer();
            User user = ((OfferAvailabilityModel)this.model).getUser();
            P2PService p2PService = ((OfferAvailabilityModel)this.model).getP2PService();
            XmrWalletService walletService = ((OfferAvailabilityModel)this.model).getXmrWalletService();
            String makerPaymentAccountId = offer.getOfferPayload().getMakerPaymentAccountId();
            String takerPaymentAccountId = ((OfferAvailabilityModel)this.model).getPaymentAccountId();
            String paymentMethodId = user.getPaymentAccount(takerPaymentAccountId).getPaymentAccountPayload().getPaymentMethodId();
            String payoutAddress = walletService.getOrCreateAddressEntry(offer.getId(), XmrAddressEntry.Context.TRADE_PAYOUT).getAddressString();
            byte[] sig = HavenoUtils.sign(((OfferAvailabilityModel)this.model).getP2PService().getKeyRing(), offer.getId());
            Price price = offer.getPrice();
            if (price == null) {
                throw new RuntimeException("Could not get price for offer");
            }
            InitTradeRequest tradeRequest = new InitTradeRequest(TradeProtocolVersion.MULTISIG_2_3, offer.getId(), ((OfferAvailabilityModel)this.model).getTradeAmount().longValueExact(), price.getValue(), paymentMethodId, null, user.getAccountId(), makerPaymentAccountId, takerPaymentAccountId, p2PService.getKeyRing().getPubKeyRing(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), sig, new Date().getTime(), offer.getMakerNodeAddress(), P2PService.getMyNodeAddress(), null, null, null, null, payoutAddress, null);
            ((OfferAvailabilityModel)this.model).setTradeRequest(tradeRequest);
            final OfferAvailabilityRequest message = new OfferAvailabilityRequest(((OfferAvailabilityModel)this.model).getOffer().getId(), ((OfferAvailabilityModel)this.model).getPubKeyRing(), ((OfferAvailabilityModel)this.model).getTakersTradePrice(), ((OfferAvailabilityModel)this.model).isTakerApiUser(), tradeRequest);
            log.info("Send {} with offerId {} and uid {} to peer {}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), message.getOfferId(), message.getUid(), ((OfferAvailabilityModel)this.model).getPeerNodeAddress()});
            ((OfferAvailabilityModel)this.model).getP2PService().sendEncryptedDirectMessage(((OfferAvailabilityModel)this.model).getPeerNodeAddress(), ((OfferAvailabilityModel)this.model).getOffer().getPubKeyRing(), (NetworkEnvelope)message, new SendDirectMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at peer: offerId={}; uid={}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), message.getOfferId(), message.getUid()});
                    SendOfferAvailabilityRequest.this.complete();
                }

                public void onFault(String errorMessage) {
                    log.error("Sending {} failed: uid={}; peer={}; error={}", new Object[]{((Object)((Object)message)).getClass().getSimpleName(), message.getUid(), ((OfferAvailabilityModel)SendOfferAvailabilityRequest.this.model).getPeerNodeAddress(), errorMessage});
                    ((OfferAvailabilityModel)SendOfferAvailabilityRequest.this.model).getOffer().setState(Offer.State.MAKER_OFFLINE);
                }
            });
        }
        catch (Throwable t) {
            ((OfferAvailabilityModel)this.model).getOffer().setErrorMessage("An error occurred.\nError message:\n" + t.getMessage());
            this.failed(t);
        }
    }
}

