/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer.availability;

import haveno.common.crypto.PubKeyRing;
import haveno.common.taskrunner.Model;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.messages.OfferAvailabilityResponse;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.trade.messages.InitTradeRequest;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.User;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import javax.annotation.Nullable;

public class OfferAvailabilityModel
implements Model {
    private final Offer offer;
    private final PubKeyRing pubKeyRing;
    private final XmrWalletService xmrWalletService;
    private final P2PService p2PService;
    private final User user;
    private final MediatorManager mediatorManager;
    private final TradeStatisticsManager tradeStatisticsManager;
    private NodeAddress peerNodeAddress;
    private OfferAvailabilityResponse message;
    private String paymentAccountId;
    private BigInteger tradeAmount;
    private OfferUtil offerUtil;
    private InitTradeRequest tradeRequest;
    @Nullable
    private byte[] makerSignature;
    private final boolean isTakerApiUser;

    public OfferAvailabilityModel(Offer offer, PubKeyRing pubKeyRing, XmrWalletService xmrWalletService, P2PService p2PService, User user, MediatorManager mediatorManager, TradeStatisticsManager tradeStatisticsManager, boolean isTakerApiUser, String paymentAccountId, BigInteger tradeAmount, OfferUtil offerUtil) {
        this.offer = offer;
        this.pubKeyRing = pubKeyRing;
        this.xmrWalletService = xmrWalletService;
        this.p2PService = p2PService;
        this.user = user;
        this.mediatorManager = mediatorManager;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.isTakerApiUser = isTakerApiUser;
        this.paymentAccountId = paymentAccountId;
        this.tradeAmount = tradeAmount;
        this.offerUtil = offerUtil;
    }

    public NodeAddress getPeerNodeAddress() {
        return this.peerNodeAddress;
    }

    void setPeerNodeAddress(NodeAddress peerNodeAddress) {
        this.peerNodeAddress = peerNodeAddress;
    }

    public void setMessage(OfferAvailabilityResponse message) {
        this.message = message;
    }

    public OfferAvailabilityResponse getMessage() {
        return this.message;
    }

    public long getTakersTradePrice() {
        return this.offer.getPrice() != null ? this.offer.getPrice().getValue() : 0L;
    }

    public void onComplete() {
    }

    public Offer getOffer() {
        return this.offer;
    }

    public PubKeyRing getPubKeyRing() {
        return this.pubKeyRing;
    }

    public XmrWalletService getXmrWalletService() {
        return this.xmrWalletService;
    }

    public P2PService getP2PService() {
        return this.p2PService;
    }

    public User getUser() {
        return this.user;
    }

    public MediatorManager getMediatorManager() {
        return this.mediatorManager;
    }

    public TradeStatisticsManager getTradeStatisticsManager() {
        return this.tradeStatisticsManager;
    }

    public String getPaymentAccountId() {
        return this.paymentAccountId;
    }

    public BigInteger getTradeAmount() {
        return this.tradeAmount;
    }

    public OfferUtil getOfferUtil() {
        return this.offerUtil;
    }

    public InitTradeRequest getTradeRequest() {
        return this.tradeRequest;
    }

    public void setTradeRequest(InitTradeRequest tradeRequest) {
        this.tradeRequest = tradeRequest;
    }

    public void setMakerSignature(@Nullable byte[] makerSignature) {
        this.makerSignature = makerSignature;
    }

    @Nullable
    public byte[] getMakerSignature() {
        return this.makerSignature;
    }

    public boolean isTakerApiUser() {
        return this.isTakerApiUser;
    }
}

