/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TriggerPriceService {
    private static final Logger log = LoggerFactory.getLogger(TriggerPriceService.class);
    private final P2PService p2PService;
    private final OpenOfferManager openOfferManager;
    private final PriceFeedService priceFeedService;
    private final Map<String, Set<OpenOffer>> openOffersByCurrency = new HashMap<String, Set<OpenOffer>>();

    @Inject
    public TriggerPriceService(P2PService p2PService, OpenOfferManager openOfferManager, PriceFeedService priceFeedService) {
        this.p2PService = p2PService;
        this.openOfferManager = openOfferManager;
        this.priceFeedService = priceFeedService;
    }

    public void onAllServicesInitialized() {
        if (this.p2PService.isBootstrapped()) {
            this.onBootstrapComplete();
        } else {
            this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                public void onDataReceived() {
                    TriggerPriceService.this.onBootstrapComplete();
                }
            });
        }
    }

    private void onBootstrapComplete() {
        this.openOfferManager.getObservableList().addListener(c -> {
            c.next();
            if (c.wasAdded()) {
                this.onAddedOpenOffers(c.getAddedSubList());
            }
            if (c.wasRemoved()) {
                this.onRemovedOpenOffers(c.getRemoved());
            }
        });
        this.onAddedOpenOffers((List<? extends OpenOffer>)this.openOfferManager.getObservableList());
        this.priceFeedService.updateCounterProperty().addListener((observable, oldValue, newValue) -> this.onPriceFeedChanged());
        this.onPriceFeedChanged();
    }

    private void onPriceFeedChanged() {
        this.openOffersByCurrency.keySet().stream().map(this.priceFeedService::getMarketPrice).filter(Objects::nonNull).filter(marketPrice -> this.openOffersByCurrency.containsKey(marketPrice.getCurrencyCode())).forEach(marketPrice -> this.openOffersByCurrency.get(marketPrice.getCurrencyCode()).stream().forEach(openOffer -> this.checkPriceThreshold((MarketPrice)marketPrice, (OpenOffer)openOffer)));
    }

    public static boolean isTriggered(MarketPrice marketPrice, OpenOffer openOffer) {
        boolean isSellOffer;
        Price price = openOffer.getOffer().getPrice();
        if (price == null || marketPrice == null) {
            return false;
        }
        String currencyCode = openOffer.getOffer().getCounterCurrencyCode();
        boolean traditionalCurrency = CurrencyUtil.isTraditionalCurrency(currencyCode);
        int smallestUnitExponent = traditionalCurrency ? 8 : 8;
        long marketPriceAsLong = MathUtils.roundDoubleToLong((double)MathUtils.scaleUpByPowerOf10((double)marketPrice.getPrice(), (int)smallestUnitExponent));
        long triggerPrice = openOffer.getTriggerPrice();
        if (triggerPrice <= 0L) {
            return false;
        }
        OfferDirection direction = openOffer.getOffer().getDirection();
        boolean bl = isSellOffer = direction == OfferDirection.SELL;
        return isSellOffer ? marketPriceAsLong < triggerPrice : marketPriceAsLong > triggerPrice;
    }

    private void checkPriceThreshold(MarketPrice marketPrice, OpenOffer openOffer) {
        int smallestUnitExponent;
        String currencyCode = openOffer.getOffer().getCounterCurrencyCode();
        int n = smallestUnitExponent = CurrencyUtil.isTraditionalCurrency(currencyCode) ? 8 : 8;
        if (openOffer.getState() == OpenOffer.State.AVAILABLE && TriggerPriceService.isTriggered(marketPrice, openOffer)) {
            log.info("Market price exceeded the trigger price of the open offer.\nWe deactivate the open offer with ID {}.\nCurrency: {};\nOffer direction: {};\nMarket price: {};\nTrigger price: {}", new Object[]{openOffer.getOffer().getShortId(), currencyCode, openOffer.getOffer().getDirection(), marketPrice.getPrice(), MathUtils.scaleDownByPowerOf10((long)openOffer.getTriggerPrice(), (int)smallestUnitExponent)});
            this.openOfferManager.deactivateOpenOffer(openOffer, true, () -> {}, errorMessage -> {});
        } else if (openOffer.getState() == OpenOffer.State.DEACTIVATED && openOffer.isDeactivatedByTrigger() && !TriggerPriceService.isTriggered(marketPrice, openOffer)) {
            log.info("Market price is back within the trigger price of the open offer.\nWe reactivate the open offer with ID {}.\nCurrency: {};\nOffer direction: {};\nMarket price: {};\nTrigger price: {}", new Object[]{openOffer.getOffer().getShortId(), currencyCode, openOffer.getOffer().getDirection(), marketPrice.getPrice(), MathUtils.scaleDownByPowerOf10((long)openOffer.getTriggerPrice(), (int)smallestUnitExponent)});
            this.openOfferManager.activateOpenOffer(openOffer, () -> {}, errorMessage -> {});
        }
    }

    private void onAddedOpenOffers(List<? extends OpenOffer> openOffers) {
        openOffers.forEach(openOffer -> {
            String currencyCode = openOffer.getOffer().getCounterCurrencyCode();
            this.openOffersByCurrency.putIfAbsent(currencyCode, new HashSet());
            this.openOffersByCurrency.get(currencyCode).add((OpenOffer)openOffer);
            MarketPrice marketPrice = this.priceFeedService.getMarketPrice(openOffer.getOffer().getCounterCurrencyCode());
            if (marketPrice != null) {
                this.checkPriceThreshold(marketPrice, (OpenOffer)openOffer);
            }
        });
    }

    private void onRemovedOpenOffers(List<? extends OpenOffer> openOffers) {
        openOffers.forEach(openOffer -> {
            String currencyCode = openOffer.getOffer().getCounterCurrencyCode();
            if (this.openOffersByCurrency.containsKey(currencyCode)) {
                Set<OpenOffer> set = this.openOffersByCurrency.get(currencyCode);
                set.remove(openOffer);
                if (set.isEmpty()) {
                    this.openOffersByCurrency.remove(currencyCode);
                }
            }
        });
    }
}

