/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import haveno.common.ThreadUtils;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.Capabilities;
import haveno.common.app.Capability;
import haveno.common.app.Version;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.persistence.PersistenceManager;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.common.proto.persistable.PersistableEnvelope;
import haveno.common.proto.persistable.PersistedDataHost;
import haveno.common.util.Tuple2;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.api.CoreContext;
import haveno.core.api.XmrConnectionService;
import haveno.core.exceptions.TradePriceOutOfToleranceException;
import haveno.core.filter.FilterManager;
import haveno.core.locale.Res;
import haveno.core.offer.AvailabilityResult;
import haveno.core.offer.MarketPriceNotAvailableException;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OfferRestrictions;
import haveno.core.offer.OpenOffer;
import haveno.core.offer.SignedOffer;
import haveno.core.offer.SignedOfferList;
import haveno.core.offer.TriggerPriceService;
import haveno.core.offer.messages.OfferAvailabilityRequest;
import haveno.core.offer.messages.OfferAvailabilityResponse;
import haveno.core.offer.messages.SignOfferRequest;
import haveno.core.offer.messages.SignOfferResponse;
import haveno.core.offer.placeoffer.PlaceOfferModel;
import haveno.core.offer.placeoffer.PlaceOfferProtocol;
import haveno.core.offer.placeoffer.tasks.ValidateOffer;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.support.dispute.mediation.mediator.MediatorManager;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.TradableList;
import haveno.core.trade.handlers.TransactionResultHandler;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.JsonUtil;
import haveno.core.util.PriceUtil;
import haveno.core.util.Validator;
import haveno.core.xmr.model.XmrAddressEntry;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.TradeWalletService;
import haveno.core.xmr.wallet.XmrKeyImageListener;
import haveno.core.xmr.wallet.XmrKeyImagePoller;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.AckMessage;
import haveno.network.p2p.AckMessageSourceType;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.DecryptedDirectMessageListener;
import haveno.network.p2p.DecryptedMessageWithPubKey;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.SendDirectMessageListener;
import haveno.network.p2p.peers.Broadcaster;
import haveno.network.p2p.peers.PeerManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nullable;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroTransferQuery;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletListener;
import monero.wallet.model.MoneroWalletListenerI;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOfferManager
implements PeerManager.Listener,
DecryptedDirectMessageListener,
PersistedDataHost {
    private static final Logger log = LoggerFactory.getLogger(OpenOfferManager.class);
    private static final String THREAD_ID = OpenOfferManager.class.getSimpleName();
    private static final long RETRY_REPUBLISH_DELAY_SEC = 10L;
    private static final long REPUBLISH_AGAIN_AT_STARTUP_DELAY_SEC = 30L;
    private static final long REPUBLISH_INTERVAL_MS = TimeUnit.MINUTES.toMillis(30L);
    private static final long REFRESH_INTERVAL_MS = OfferPayload.TTL / 2L;
    private static final int NUM_ATTEMPTS_THRESHOLD = 5;
    private static final long SHUTDOWN_TIMEOUT_MS = 60000L;
    private static final String OPEN_OFFER_GROUP_KEY_IMAGE_ID = OpenOffer.class.getSimpleName();
    private static final String SIGNED_OFFER_KEY_IMAGE_GROUP_ID = SignedOffer.class.getSimpleName();
    private final CoreContext coreContext;
    private final KeyRing keyRing;
    private final User user;
    private final P2PService p2PService;
    private final XmrConnectionService xmrConnectionService;
    private final BtcWalletService btcWalletService;
    private final XmrWalletService xmrWalletService;
    private final TradeWalletService tradeWalletService;
    private final OfferBookService offerBookService;
    private final ClosedTradableManager closedTradableManager;
    private final PriceFeedService priceFeedService;
    private final Preferences preferences;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final ArbitratorManager arbitratorManager;
    private final MediatorManager mediatorManager;
    private final FilterManager filterManager;
    private final Broadcaster broadcaster;
    private final PersistenceManager<TradableList<OpenOffer>> persistenceManager;
    private final Map<String, OpenOffer> offersToBeEdited = new HashMap<String, OpenOffer>();
    private final TradableList<OpenOffer> openOffers = new TradableList();
    private final SignedOfferList signedOffers = new SignedOfferList();
    private final PersistenceManager<SignedOfferList> signedOfferPersistenceManager;
    private final Map<String, PlaceOfferProtocol> placeOfferProtocols = new HashMap<String, PlaceOfferProtocol>();
    private boolean stopped;
    private Timer periodicRepublishOffersTimer;
    private Timer periodicRefreshOffersTimer;
    private Timer retryRepublishOffersTimer;
    private final ObservableList<Tuple2<OpenOffer, String>> invalidOffers = FXCollections.observableArrayList();
    private final AccountAgeWitnessService accountAgeWitnessService;
    private Object processOffersLock = new Object();

    @Inject
    public OpenOfferManager(CoreContext coreContext, KeyRing keyRing, User user, P2PService p2PService, XmrConnectionService xmrConnectionService, BtcWalletService btcWalletService, XmrWalletService xmrWalletService, TradeWalletService tradeWalletService, OfferBookService offerBookService, ClosedTradableManager closedTradableManager, PriceFeedService priceFeedService, Preferences preferences, TradeStatisticsManager tradeStatisticsManager, ArbitratorManager arbitratorManager, MediatorManager mediatorManager, FilterManager filterManager, Broadcaster broadcaster, PersistenceManager<TradableList<OpenOffer>> persistenceManager, PersistenceManager<SignedOfferList> signedOfferPersistenceManager, AccountAgeWitnessService accountAgeWitnessService) {
        this.coreContext = coreContext;
        this.keyRing = keyRing;
        this.user = user;
        this.p2PService = p2PService;
        this.xmrConnectionService = xmrConnectionService;
        this.btcWalletService = btcWalletService;
        this.xmrWalletService = xmrWalletService;
        this.tradeWalletService = tradeWalletService;
        this.offerBookService = offerBookService;
        this.closedTradableManager = closedTradableManager;
        this.priceFeedService = priceFeedService;
        this.preferences = preferences;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.arbitratorManager = arbitratorManager;
        this.mediatorManager = mediatorManager;
        this.filterManager = filterManager;
        this.broadcaster = broadcaster;
        this.persistenceManager = persistenceManager;
        this.signedOfferPersistenceManager = signedOfferPersistenceManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        HavenoUtils.openOfferManager = this;
        this.persistenceManager.initialize(this.openOffers, "OpenOffers", PersistenceManager.Source.PRIVATE);
        this.signedOfferPersistenceManager.initialize((PersistableEnvelope)this.signedOffers, "SignedOffers", PersistenceManager.Source.PRIVATE);
    }

    public void readPersisted(Runnable completeHandler) {
        this.persistenceManager.readPersisted(persisted -> {
            this.openOffers.setAll(persisted.getList());
            this.openOffers.forEach(openOffer -> openOffer.getOffer().setPriceFeedService(this.priceFeedService));
            this.signedOfferPersistenceManager.readPersisted(signedOfferPersisted -> {
                this.signedOffers.setAll(signedOfferPersisted.getList());
                completeHandler.run();
            }, completeHandler);
        }, completeHandler);
    }

    public void onAllServicesInitialized() {
        this.p2PService.addDecryptedDirectMessageListener((DecryptedDirectMessageListener)this);
        if (this.p2PService.isBootstrapped()) {
            this.onBootstrapComplete();
        } else {
            this.p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                public void onDataReceived() {
                    OpenOfferManager.this.onBootstrapComplete();
                }
            });
        }
        this.cleanUpAddressEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpAddressEntries() {
        Set openOffersIdSet;
        List list = this.openOffers.getList();
        synchronized (list) {
            openOffersIdSet = this.openOffers.getList().stream().map(OpenOffer::getId).collect(Collectors.toSet());
        }
        this.xmrWalletService.getAddressEntriesForOpenOffer().stream().filter(e -> !openOffersIdSet.contains(e.getOfferId())).forEach(e -> {
            log.warn("We found an outdated addressEntry with context {} for openOffer {} (openOffers does not contain that offer), offers.size={}", new Object[]{e.getContext(), e.getOfferId(), this.openOffers.size()});
            this.xmrWalletService.resetAddressEntriesForOpenOffer(e.getOfferId());
        });
    }

    public void shutDown(@Nullable Runnable completeHandler) {
        this.stopped = true;
        this.p2PService.getPeerManager().removeListener((PeerManager.Listener)this);
        this.p2PService.removeDecryptedDirectMessageListener((DecryptedDirectMessageListener)this);
        this.xmrConnectionService.getKeyImagePoller().removeKeyImages(OPEN_OFFER_GROUP_KEY_IMAGE_ID);
        this.xmrConnectionService.getKeyImagePoller().removeKeyImages(SIGNED_OFFER_KEY_IMAGE_GROUP_ID);
        this.stopPeriodicRefreshOffersTimer();
        this.stopPeriodicRepublishOffersTimer();
        this.stopRetryRepublishOffersTimer();
        int size = this.openOffers.size();
        log.info("Remove open offers at shutDown. Number of open offers: {}", (Object)size);
        if (this.offerBookService.isBootstrapped() && size > 0) {
            ThreadUtils.execute(() -> {
                List list = this.openOffers.getList();
                synchronized (list) {
                    this.openOffers.forEach(openOffer -> {
                        if (openOffer.getState() == OpenOffer.State.AVAILABLE) {
                            this.offerBookService.removeOfferAtShutDown(openOffer.getOffer().getOfferPayload());
                        }
                    });
                }
                this.broadcaster.flush();
                long delayMs = Math.min(3000, size * 200 + 500);
                HavenoUtils.waitFor(delayMs);
            }, (String)THREAD_ID);
        } else {
            this.broadcaster.flush();
        }
        ThreadUtils.submitToPool(() -> {
            this.shutDownThreadPool();
            if (completeHandler != null) {
                completeHandler.run();
            }
        });
    }

    private void shutDownThreadPool() {
        try {
            ThreadUtils.shutDown((String)THREAD_ID, (Long)60000L);
        }
        catch (Exception e) {
            log.error("Error shutting down OpenOfferManager thread pool", (Throwable)e);
        }
    }

    public void removeAllOpenOffers(@Nullable Runnable completeHandler) {
        this.removeOpenOffers((List<OpenOffer>)this.getObservableList(), completeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpenOffers(List<OpenOffer> openOffers, @Nullable Runnable completeHandler) {
        List<OpenOffer> list = openOffers;
        synchronized (list) {
            int size = openOffers.size();
            ArrayList<OpenOffer> openOffersList = new ArrayList<OpenOffer>(openOffers);
            openOffersList.forEach(openOffer -> this.cancelOpenOffer((OpenOffer)openOffer, () -> {}, errorMessage -> log.warn("Error removing open offer: " + errorMessage)));
            if (completeHandler != null) {
                UserThread.runAfter((Runnable)completeHandler, (long)(size * 200 + 500), (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
    }

    public void onDirectMessage(DecryptedMessageWithPubKey decryptedMessageWithPubKey, NodeAddress peerNodeAddress) {
        AckMessage ackMessage;
        NetworkEnvelope networkEnvelope = decryptedMessageWithPubKey.getNetworkEnvelope();
        if (networkEnvelope instanceof SignOfferRequest) {
            this.handleSignOfferRequest((SignOfferRequest)networkEnvelope, peerNodeAddress);
        }
        if (networkEnvelope instanceof SignOfferResponse) {
            this.handleSignOfferResponse((SignOfferResponse)networkEnvelope, peerNodeAddress);
        } else if (networkEnvelope instanceof OfferAvailabilityRequest) {
            this.handleOfferAvailabilityRequest((OfferAvailabilityRequest)networkEnvelope, peerNodeAddress);
        } else if (networkEnvelope instanceof AckMessage && (ackMessage = (AckMessage)networkEnvelope).getSourceType() == AckMessageSourceType.OFFER_MESSAGE) {
            if (ackMessage.isSuccess()) {
                log.info("Received AckMessage for {} with offerId {} and uid {}", new Object[]{ackMessage.getSourceMsgClassName(), ackMessage.getSourceId(), ackMessage.getSourceUid()});
            } else {
                log.warn("Received AckMessage with error state for {} with offerId {} and errorMessage={}", new Object[]{ackMessage.getSourceMsgClassName(), ackMessage.getSourceId(), ackMessage.getErrorMessage()});
            }
        }
    }

    private void onBootstrapComplete() {
        this.stopped = false;
        this.maybeUpdatePersistedOffers();
        this.xmrConnectionService.getKeyImagePoller().addListener(new XmrKeyImageListener(){

            @Override
            public void onSpentStatusChanged(Map<String, MoneroKeyImageSpentStatus> spentStatuses) {
                for (Map.Entry<String, MoneroKeyImageSpentStatus> entry : spentStatuses.entrySet()) {
                    if (!XmrKeyImagePoller.isSpent(entry.getValue())) continue;
                    OpenOfferManager.this.cancelOpenOffersOnSpent(entry.getKey());
                    OpenOfferManager.this.removeSignedOffers(entry.getKey());
                }
            }
        });
        ThreadUtils.submitToPool(() -> {
            this.priceFeedService.awaitExternalPrices();
            ThreadUtils.execute(() -> {
                this.republishOffers();
                this.startPeriodicRepublishOffersTimer();
                if (this.retryRepublishOffersTimer == null) {
                    this.retryRepublishOffersTimer = UserThread.runAfter(this::republishOffers, (long)30L);
                }
                this.p2PService.getPeerManager().addListener((PeerManager.Listener)this);
                this.processOffers(false, transaction -> {}, errorMessage -> log.warn("Error processing offers on bootstrap: " + errorMessage));
                this.xmrWalletService.addWalletListener((MoneroWalletListenerI)new MoneroWalletListener(){

                    public void onNewBlock(long height) {
                        OpenOfferManager.this.processOffers(true, transaction -> {}, errorMessage -> log.warn("Error processing offers on new block {}: {}", (Object)height, (Object)errorMessage));
                    }
                });
                List list = this.openOffers.getList();
                synchronized (list) {
                    for (OpenOffer openOffer : this.openOffers.getList()) {
                        this.xmrConnectionService.getKeyImagePoller().addKeyImages(openOffer.getOffer().getOfferPayload().getReserveTxKeyImages(), OPEN_OFFER_GROUP_KEY_IMAGE_ID);
                    }
                }
                list = this.signedOffers.getList();
                synchronized (list) {
                    for (SignedOffer signedOffer : this.signedOffers.getList()) {
                        this.xmrConnectionService.getKeyImagePoller().addKeyImages(signedOffer.getReserveTxKeyImages(), SIGNED_OFFER_KEY_IMAGE_GROUP_ID);
                    }
                }
            }, (String)THREAD_ID);
        });
    }

    public void onAllConnectionsLost() {
        log.info("onAllConnectionsLost");
        this.stopped = true;
        this.stopPeriodicRefreshOffersTimer();
        this.stopPeriodicRepublishOffersTimer();
        this.stopRetryRepublishOffersTimer();
        this.restart();
    }

    public void onNewConnectionAfterAllConnectionsLost() {
        log.info("onNewConnectionAfterAllConnectionsLost");
        this.stopped = false;
        this.restart();
    }

    public void onAwakeFromStandby() {
        log.info("onAwakeFromStandby");
        this.stopped = false;
        if (!this.p2PService.getNetworkNode().getAllConnections().isEmpty()) {
            this.restart();
        }
    }

    public void placeOffer(Offer offer, boolean useSavingsWallet, long triggerPrice, boolean reserveExactAmount, boolean resetAddressEntriesOnError, String sourceOfferId, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ThreadUtils.execute(() -> {
            if (triggerPrice != 0L && offer.getOfferPayload().getPrice() != 0L) {
                errorMessageHandler.handleErrorMessage("Cannot set trigger price for fixed price offers.");
                return;
            }
            OpenOffer sourceOffer = null;
            if (sourceOfferId != null) {
                Optional<OpenOffer> sourceOfferOptional = this.getOpenOffer(sourceOfferId);
                if (!sourceOfferOptional.isPresent()) {
                    errorMessageHandler.handleErrorMessage("Source offer not found to clone, offerId=" + sourceOfferId + ".");
                    return;
                }
                sourceOffer = sourceOfferOptional.get();
                int numClones = this.getOpenOfferGroup(sourceOffer.getGroupId()).size();
                if (numClones >= Restrictions.getMaxOffersWithSharedFunds()) {
                    errorMessageHandler.handleErrorMessage("Cannot create offer because maximum number of " + Restrictions.getMaxOffersWithSharedFunds() + " cloned offers with shared funds reached.");
                    return;
                }
            }
            OpenOffer openOffer = new OpenOffer(offer, triggerPrice, sourceOffer == null ? reserveExactAmount : sourceOffer.isReserveExactAmount());
            if (sourceOffer != null) {
                openOffer.setReserveTxHash(sourceOffer.getReserveTxHash());
                openOffer.setReserveTxHex(sourceOffer.getReserveTxHex());
                openOffer.setReserveTxKey(sourceOffer.getReserveTxKey());
                openOffer.setGroupId(sourceOffer.getGroupId());
                openOffer.getOffer().getOfferPayload().setReserveTxKeyImages(sourceOffer.getOffer().getOfferPayload().getReserveTxKeyImages());
                this.xmrWalletService.cloneAddressEntries(sourceOffer.getOffer().getId(), openOffer.getOffer().getId());
                if (this.hasConflictingClone(openOffer)) {
                    openOffer.setState(OpenOffer.State.DEACTIVATED);
                }
            }
            Object object = this.processOffersLock;
            synchronized (object) {
                this.addOpenOffer(openOffer);
            }
            if (sourceOffer != null && sourceOffer.isPending()) {
                resultHandler.handleResult(null);
                return;
            }
            object = this.processOffersLock;
            synchronized (object) {
                CountDownLatch latch = new CountDownLatch(1);
                this.processOffer(this.getOpenOffers(), openOffer, transaction -> {
                    this.requestPersistence();
                    latch.countDown();
                    resultHandler.handleResult(transaction);
                }, errorMessage -> {
                    if (!openOffer.isCanceled()) {
                        log.warn("Error processing offer {}: {}", (Object)openOffer.getId(), (Object)errorMessage);
                        this.doCancelOffer(openOffer, resetAddressEntriesOnError);
                    }
                    latch.countDown();
                    errorMessageHandler.handleErrorMessage(errorMessage);
                });
                HavenoUtils.awaitLatch(latch);
            }
        }, (String)THREAD_ID);
    }

    public void removeOffer(Offer offer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Optional<OpenOffer> openOfferOptional = this.getOpenOffer(offer.getId());
        if (openOfferOptional.isPresent()) {
            this.cancelOpenOffer(openOfferOptional.get(), resultHandler, errorMessageHandler);
        } else {
            String errorMsg = "Offer was not found in our list of open offers. We still try to remove it from the offerbook.";
            log.warn(errorMsg);
            errorMessageHandler.handleErrorMessage(errorMsg);
            this.offerBookService.removeOffer(offer.getOfferPayload(), () -> offer.setState(Offer.State.REMOVED), null);
        }
    }

    public void activateOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (openOffer.isPending()) {
            resultHandler.handleResult();
        } else if (this.offersToBeEdited.containsKey(openOffer.getId())) {
            errorMessageHandler.handleErrorMessage(Res.get("offerbook.cannotActivateEditedOffer.warning"));
        } else if (this.hasConflictingClone(openOffer)) {
            errorMessageHandler.handleErrorMessage(Res.get("offerbook.hasConflictingClone.warning"));
        } else {
            try {
                this.validateSignedState(openOffer);
                Offer offer = openOffer.getOffer();
                this.offerBookService.activateOffer(offer, () -> {
                    openOffer.setState(OpenOffer.State.AVAILABLE);
                    this.applyTriggerState(openOffer);
                    this.requestPersistence();
                    log.debug("activateOpenOffer, offerId={}", (Object)offer.getId());
                    resultHandler.handleResult();
                }, errorMessageHandler);
            }
            catch (Exception e) {
                errorMessageHandler.handleErrorMessage(e.getMessage());
                return;
            }
        }
    }

    private void applyTriggerState(OpenOffer openOffer) {
        if (openOffer.getState() != OpenOffer.State.AVAILABLE) {
            return;
        }
        if (TriggerPriceService.isTriggered(this.priceFeedService.getMarketPrice(openOffer.getOffer().getCounterCurrencyCode()), openOffer)) {
            openOffer.deactivate(true);
        }
    }

    public void deactivateOpenOffer(OpenOffer openOffer, boolean deactivatedByTrigger, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Offer offer = openOffer.getOffer();
        if (openOffer.isAvailable()) {
            this.offerBookService.deactivateOffer(offer.getOfferPayload(), () -> {
                openOffer.deactivate(deactivatedByTrigger);
                this.requestPersistence();
                log.debug("deactivateOpenOffer, offerId={}", (Object)offer.getId());
                resultHandler.handleResult();
            }, errorMessageHandler);
        } else {
            resultHandler.handleResult();
        }
    }

    public void cancelOpenOffer(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.info("Canceling open offer: {}", (Object)openOffer.getId());
        if (!this.offersToBeEdited.containsKey(openOffer.getId())) {
            if (this.isOnOfferBook(openOffer)) {
                openOffer.setState(OpenOffer.State.CANCELED);
                this.offerBookService.removeOffer(openOffer.getOffer().getOfferPayload(), () -> ThreadUtils.submitToPool(() -> {
                    this.doCancelOffer(openOffer);
                    if (resultHandler != null) {
                        resultHandler.handleResult();
                    }
                }), errorMessageHandler);
            } else {
                openOffer.setState(OpenOffer.State.CANCELED);
                ThreadUtils.submitToPool(() -> {
                    this.doCancelOffer(openOffer);
                    if (resultHandler != null) {
                        resultHandler.handleResult();
                    }
                });
            }
        } else if (errorMessageHandler != null) {
            errorMessageHandler.handleErrorMessage("You can't cancel an offer that is currently edited.");
        }
    }

    private boolean isOnOfferBook(OpenOffer openOffer) {
        return openOffer.isAvailable() || openOffer.isReserved();
    }

    public void editOpenOfferStart(OpenOffer openOffer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (this.offersToBeEdited.containsKey(openOffer.getId())) {
            log.warn("editOpenOfferStart called for an offer which is already in edit mode.");
            resultHandler.handleResult();
            return;
        }
        log.info("Editing open offer: {}", (Object)openOffer.getId());
        this.offersToBeEdited.put(openOffer.getId(), openOffer);
        if (openOffer.isAvailable()) {
            this.deactivateOpenOffer(openOffer, false, resultHandler, errorMessage -> {
                this.offersToBeEdited.remove(openOffer.getId());
                errorMessageHandler.handleErrorMessage(errorMessage);
            });
        } else {
            resultHandler.handleResult();
        }
    }

    public void editOpenOfferPublish(Offer editedOffer, long triggerPrice, OpenOffer.State originalState, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ThreadUtils.execute(() -> {
            Optional<OpenOffer> openOfferOptional = this.getOpenOffer(editedOffer.getId());
            if (openOfferOptional.isPresent()) {
                OpenOffer openOffer = openOfferOptional.get();
                openOffer.getOffer().setState(Offer.State.REMOVED);
                openOffer.setState(OpenOffer.State.CANCELED);
                this.removeOpenOffer(openOffer);
                OpenOffer editedOpenOffer = new OpenOffer(editedOffer, triggerPrice, openOffer);
                if (originalState == OpenOffer.State.DEACTIVATED && openOffer.isDeactivatedByTrigger()) {
                    if (this.hasConflictingClone(editedOpenOffer)) {
                        editedOpenOffer.setState(OpenOffer.State.DEACTIVATED);
                    } else {
                        editedOpenOffer.setState(OpenOffer.State.AVAILABLE);
                    }
                    this.applyTriggerState(editedOpenOffer);
                } else if (originalState == OpenOffer.State.AVAILABLE && this.hasConflictingClone(editedOpenOffer)) {
                    editedOpenOffer.setState(OpenOffer.State.DEACTIVATED);
                } else {
                    editedOpenOffer.setState(originalState);
                }
                this.addOpenOffer(editedOpenOffer);
                Arbitrator arbitrator = this.user.getAcceptedArbitratorByAddress(editedOpenOffer.getOffer().getOfferPayload().getArbitratorSigner());
                if (arbitrator == null || !HavenoUtils.isArbitratorSignatureValid(editedOpenOffer.getOffer().getOfferPayload(), arbitrator)) {
                    editedOpenOffer.getOffer().getOfferPayload().setArbitratorSignature(null);
                    editedOpenOffer.getOffer().getOfferPayload().setArbitratorSigner(null);
                    Object object = this.processOffersLock;
                    synchronized (object) {
                        CountDownLatch latch = new CountDownLatch(1);
                        this.processOffer(this.getOpenOffers(), editedOpenOffer, transaction -> {
                            this.offersToBeEdited.remove(openOffer.getId());
                            this.requestPersistence();
                            latch.countDown();
                            resultHandler.handleResult();
                        }, errorMsg -> {
                            latch.countDown();
                            errorMessageHandler.handleErrorMessage(errorMsg);
                        });
                        HavenoUtils.awaitLatch(latch);
                    }
                } else {
                    this.maybeRepublishOffer(editedOpenOffer, null);
                    this.offersToBeEdited.remove(openOffer.getId());
                    this.requestPersistence();
                    resultHandler.handleResult();
                }
            } else {
                errorMessageHandler.handleErrorMessage("There is no offer with this id existing to be published.");
            }
        }, (String)THREAD_ID);
    }

    public void editOpenOfferCancel(OpenOffer openOffer, OpenOffer.State originalState, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (this.offersToBeEdited.containsKey(openOffer.getId())) {
            this.offersToBeEdited.remove(openOffer.getId());
            if (originalState.equals((Object)OpenOffer.State.AVAILABLE)) {
                this.activateOpenOffer(openOffer, resultHandler, errorMessageHandler);
            } else {
                resultHandler.handleResult();
            }
            this.requestPersistence();
        } else {
            errorMessageHandler.handleErrorMessage("Editing of offer can't be canceled as it is not edited.");
        }
    }

    private void doCancelOffer(OpenOffer openOffer) {
        this.doCancelOffer(openOffer, true);
    }

    private void doCancelOffer(@NotNull OpenOffer openOffer, boolean resetAddressEntries) {
        Offer offer = openOffer.getOffer();
        offer.setState(Offer.State.REMOVED);
        openOffer.setState(OpenOffer.State.CANCELED);
        boolean hasClonedOffer = this.hasClonedOffer(offer.getId());
        this.removeOpenOffer(openOffer);
        if (!hasClonedOffer) {
            this.closedTradableManager.add(openOffer);
        }
        if (resetAddressEntries) {
            this.xmrWalletService.resetAddressEntriesForOpenOffer(offer.getId());
        }
        this.requestPersistence();
        if (!hasClonedOffer) {
            this.xmrWalletService.thawOutputs(offer.getOfferPayload().getReserveTxKeyImages());
        }
    }

    public void closeSpentOffer(Offer offer) {
        this.getOpenOffer(offer.getId()).ifPresent(openOffer -> {
            for (OpenOffer groupOffer : this.getOpenOfferGroup(openOffer.getGroupId())) {
                this.doCloseOpenOffer(groupOffer);
            }
        });
    }

    private void doCloseOpenOffer(OpenOffer openOffer) {
        this.removeOpenOffer(openOffer);
        openOffer.setState(OpenOffer.State.CLOSED);
        this.xmrWalletService.resetAddressEntriesForOpenOffer(openOffer.getId());
        this.offerBookService.removeOffer(openOffer.getOffer().getOfferPayload(), () -> log.info("Successfully removed offer {}", (Object)openOffer.getId()), arg_0 -> ((Logger)log).error(arg_0));
        this.requestPersistence();
    }

    public void reserveOpenOffer(OpenOffer openOffer) {
        openOffer.setState(OpenOffer.State.RESERVED);
        this.requestPersistence();
    }

    public void unreserveOpenOffer(OpenOffer openOffer) {
        openOffer.setState(OpenOffer.State.AVAILABLE);
        this.requestPersistence();
    }

    public boolean hasConflictingClone(OpenOffer openOffer) {
        for (OpenOffer clonedOffer : this.getOpenOfferGroup(openOffer.getGroupId())) {
            if (clonedOffer.getId().equals(openOffer.getId()) || clonedOffer.isDeactivated()) continue;
            List<OpenOffer> openOffers = this.getOpenOffers();
            if (clonedOffer.isPending() && openOffers.indexOf(clonedOffer) > openOffers.indexOf(openOffer) || !this.samePaymentMethodAndCurrency(clonedOffer.getOffer(), openOffer.getOffer())) continue;
            return true;
        }
        return false;
    }

    public boolean hasConflictingClone(Offer offer, OpenOffer sourceOffer) {
        return this.getOpenOfferGroup(sourceOffer.getGroupId()).stream().filter(openOffer -> !openOffer.isDeactivated()).anyMatch(openOffer -> this.samePaymentMethodAndCurrency(openOffer.getOffer(), offer));
    }

    private boolean samePaymentMethodAndCurrency(Offer offer1, Offer offer2) {
        return offer1.getPaymentMethodId().equalsIgnoreCase(offer2.getPaymentMethodId()) && offer1.getCounterCurrencyCode().equalsIgnoreCase(offer2.getCounterCurrencyCode()) && offer1.getBaseCurrencyCode().equalsIgnoreCase(offer2.getBaseCurrencyCode());
    }

    public boolean isMyOffer(Offer offer) {
        return offer.isMyOffer(this.keyRing);
    }

    public boolean hasAvailableOpenOffers() {
        for (OpenOffer openOffer : this.getOpenOffers()) {
            if (openOffer.getState() != OpenOffer.State.AVAILABLE) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpenOffer> getOpenOffers() {
        List list = this.openOffers.getList();
        synchronized (list) {
            return ImmutableList.copyOf(this.getObservableList());
        }
    }

    public List<OpenOffer> getOpenOfferGroup(String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId cannot be null");
        }
        return this.getOpenOffers().stream().filter(openOffer -> groupId.equals(openOffer.getGroupId())).collect(Collectors.toList());
    }

    public boolean hasClonedOffer(String offerId) {
        OpenOffer openOffer = this.getOpenOffer(offerId).orElse(null);
        if (openOffer == null) {
            return false;
        }
        return this.getOpenOfferGroup(openOffer.getGroupId()).size() > 1;
    }

    public boolean hasClonedOffers() {
        for (OpenOffer openOffer : this.getOpenOffers()) {
            if (this.getOpenOfferGroup(openOffer.getGroupId()).size() <= 1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SignedOffer> getSignedOffers() {
        List list = this.signedOffers.getList();
        synchronized (list) {
            return ImmutableList.copyOf((Collection)this.signedOffers.getObservableList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObservableList<SignedOffer> getObservableSignedOffersList() {
        List list = this.signedOffers.getList();
        synchronized (list) {
            return this.signedOffers.getObservableList();
        }
    }

    public ObservableList<OpenOffer> getObservableList() {
        return this.openOffers.getObservableList();
    }

    public Optional<OpenOffer> getOpenOffer(String offerId) {
        return this.getOpenOffers().stream().filter(e -> e.getId().equals(offerId)).findFirst();
    }

    public boolean hasOpenOffer(String offerId) {
        return this.getOpenOffer(offerId).isPresent();
    }

    public Optional<SignedOffer> getSignedOfferById(String offerId) {
        return this.getSignedOffers().stream().filter(e -> e.getOfferId().equals(offerId)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpenOffer(OpenOffer openOffer) {
        log.info("Adding open offer {}", (Object)openOffer.getId());
        List list = this.openOffers.getList();
        synchronized (list) {
            this.openOffers.add(openOffer);
            if (openOffer.getOffer().getOfferPayload().getReserveTxKeyImages() != null) {
                this.xmrConnectionService.getKeyImagePoller().addKeyImages(openOffer.getOffer().getOfferPayload().getReserveTxKeyImages(), OPEN_OFFER_GROUP_KEY_IMAGE_ID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOpenOffer(OpenOffer openOffer) {
        log.info("Removing open offer {}", (Object)openOffer.getId());
        List list = this.openOffers.getList();
        synchronized (list) {
            this.openOffers.remove(openOffer);
            if (openOffer.getOffer().getOfferPayload().getReserveTxKeyImages() != null) {
                this.xmrConnectionService.getKeyImagePoller().removeKeyImages(openOffer.getOffer().getOfferPayload().getReserveTxKeyImages(), OPEN_OFFER_GROUP_KEY_IMAGE_ID);
            }
        }
        ThreadUtils.execute(() -> {
            Object object = this.processOffersLock;
            synchronized (object) {
                Map<String, PlaceOfferProtocol> map = this.placeOfferProtocols;
                synchronized (map) {
                    PlaceOfferProtocol protocol = this.placeOfferProtocols.remove(openOffer.getId());
                    if (protocol != null) {
                        protocol.cancelOffer();
                    }
                }
            }
        }, (String)THREAD_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelOpenOffersOnSpent(String keyImage) {
        List list = this.openOffers.getList();
        synchronized (list) {
            for (OpenOffer openOffer : this.openOffers.getList()) {
                if (openOffer.getState() == OpenOffer.State.RESERVED || openOffer.getOffer().getOfferPayload().getReserveTxKeyImages() == null || !openOffer.getOffer().getOfferPayload().getReserveTxKeyImages().contains(keyImage)) continue;
                log.warn("Canceling open offer because reserved funds have been spent unexpectedly, offerId={}, state={}", (Object)openOffer.getId(), (Object)openOffer.getState());
                this.cancelOpenOffer(openOffer, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSignedOffer(SignedOffer signedOffer) {
        log.info("Adding SignedOffer for offer {}", (Object)signedOffer.getOfferId());
        List list = this.signedOffers.getList();
        synchronized (list) {
            for (String keyImage : signedOffer.getReserveTxKeyImages()) {
                this.removeSignedOffers(keyImage);
            }
            this.signedOffers.add(signedOffer);
            this.xmrConnectionService.getKeyImagePoller().addKeyImages(signedOffer.getReserveTxKeyImages(), SIGNED_OFFER_KEY_IMAGE_GROUP_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSignedOffer(SignedOffer signedOffer) {
        log.info("Removing SignedOffer for offer {}", (Object)signedOffer.getOfferId());
        List list = this.signedOffers.getList();
        synchronized (list) {
            this.signedOffers.remove(signedOffer);
        }
        this.xmrConnectionService.getKeyImagePoller().removeKeyImages(signedOffer.getReserveTxKeyImages(), SIGNED_OFFER_KEY_IMAGE_GROUP_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSignedOffers(String keyImage) {
        List list = this.signedOffers.getList();
        synchronized (list) {
            for (SignedOffer signedOffer : this.getSignedOffers()) {
                if (!signedOffer.getReserveTxKeyImages().contains(keyImage)) continue;
                this.removeSignedOffer(signedOffer);
            }
        }
    }

    private void processOffers(boolean skipOffersWithTooManyAttempts, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        ThreadUtils.execute(() -> {
            ArrayList errorMessages = new ArrayList();
            Object object = this.processOffersLock;
            synchronized (object) {
                List<OpenOffer> openOffers = this.getOpenOffers();
                for (OpenOffer offer : openOffers) {
                    if (skipOffersWithTooManyAttempts && offer.getNumProcessingAttempts() > 5) continue;
                    CountDownLatch latch = new CountDownLatch(1);
                    this.processOffer(openOffers, offer, transaction -> latch.countDown(), errorMessage -> {
                        errorMessages.add(errorMessage);
                        latch.countDown();
                    });
                    HavenoUtils.awaitLatch(latch);
                }
            }
            this.requestPersistence();
            if (errorMessages.isEmpty()) {
                if (resultHandler != null) {
                    resultHandler.handleResult(null);
                }
            } else if (errorMessageHandler != null) {
                errorMessageHandler.handleErrorMessage(((Object)errorMessages).toString());
            }
        }, (String)THREAD_ID);
    }

    private void processOffer(List<OpenOffer> openOffers, OpenOffer openOffer, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (openOffer.isProcessing()) {
            resultHandler.handleResult(null);
            return;
        }
        openOffer.setProcessing(true);
        this.doProcessOffer(openOffers, openOffer, transaction -> {
            openOffer.setProcessing(false);
            resultHandler.handleResult(transaction);
        }, errorMsg -> {
            openOffer.setProcessing(false);
            openOffer.setNumProcessingAttempts(openOffer.getNumProcessingAttempts() + 1);
            openOffer.getOffer().setErrorMessage(errorMsg);
            if (!openOffer.isCanceled()) {
                errorMsg = "Error processing offer, offerId=" + openOffer.getId() + ", attempt=" + openOffer.getNumProcessingAttempts() + ": " + (String)errorMsg;
                openOffer.getOffer().setErrorMessage(errorMsg);
                if (openOffer.getOffer().getState() == Offer.State.INVALID) {
                    log.warn("Canceling offer because it's invalid: {}", (Object)openOffer.getId());
                    this.doCancelOffer(openOffer);
                }
            }
            errorMessageHandler.handleErrorMessage(errorMsg);
        });
    }

    private void doProcessOffer(List<OpenOffer> openOffers, OpenOffer openOffer, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        new Thread(() -> {
            try {
                MoneroTxWallet splitOutputTx;
                block22: {
                    if (openOffer.isCanceled() || this.xmrWalletService.getWallet() == null) {
                        resultHandler.handleResult(null);
                        return;
                    }
                    try {
                        ValidateOffer.validateOffer(openOffer.getOffer(), this.accountAgeWitnessService, this.user);
                    }
                    catch (Exception e) {
                        openOffer.getOffer().setState(Offer.State.INVALID);
                        errorMessageHandler.handleErrorMessage("Failed to validate offer: " + e.getMessage());
                        return;
                    }
                    if (openOffer.isPending()) {
                        List<OpenOffer> openOfferClones;
                        if (openOffer.getGroupId() != null && (openOfferClones = this.getOpenOfferGroup(openOffer.getGroupId())).size() > 1 && !openOfferClones.get(0).getId().equals(openOffer.getId()) && openOfferClones.get(0).isPending()) {
                            resultHandler.handleResult(null);
                            return;
                        }
                    } else {
                        boolean skipValidation;
                        boolean bl = skipValidation = openOffer.isDeactivated() && this.hasConflictingClone(openOffer) && openOffer.getOffer().getOfferPayload().getArbitratorSignature() == null;
                        if (!skipValidation) {
                            try {
                                this.validateSignedState(openOffer);
                                resultHandler.handleResult(null);
                                return;
                            }
                            catch (Exception e) {
                                log.warn(e.getMessage());
                                openOffer.getOffer().getOfferPayload().setArbitratorSignature(null);
                                openOffer.getOffer().getOfferPayload().setArbitratorSigner(null);
                                if (!openOffer.isAvailable()) break block22;
                                openOffer.setState(OpenOffer.State.PENDING);
                            }
                        }
                    }
                }
                if (openOffer.getReserveTxHash() != null) {
                    this.signAndPostOffer(openOffer, false, resultHandler, errorMessageHandler);
                    return;
                }
                if (openOffer.getScheduledTxHashes() != null) {
                    boolean scheduledTxsAvailable = true;
                    for (MoneroTxWallet tx : this.xmrWalletService.getTxs(openOffer.getScheduledTxHashes())) {
                        if (tx.isLocked().booleanValue() || this.hasSpendableAmount(tx)) continue;
                        scheduledTxsAvailable = false;
                        break;
                    }
                    if (!scheduledTxsAvailable) {
                        log.warn("Canceling offer {} because scheduled txs are no longer available", (Object)openOffer.getId());
                        this.doCancelOffer(openOffer);
                        resultHandler.handleResult(null);
                        return;
                    }
                }
                BigInteger amountNeeded = openOffer.getOffer().getAmountNeeded();
                if (openOffer.isReserveExactAmount()) {
                    splitOutputTx = this.getSplitOutputFundingTx(openOffers, openOffer);
                    if (splitOutputTx != null && openOffer.getSplitOutputTxHash() == null) {
                        this.setSplitOutputTx(openOffer, splitOutputTx);
                    }
                    if (this.xmrWalletService.getAvailableBalance().equals(amountNeeded)) {
                        this.signAndPostOffer(openOffer, true, resultHandler, errorMessage -> this.splitOrSchedule(splitOutputTx, openOffers, openOffer, amountNeeded, resultHandler, errorMessageHandler));
                        return;
                    }
                } else {
                    boolean hasSufficientBalance;
                    boolean bl = hasSufficientBalance = this.xmrWalletService.getAvailableBalance().compareTo(amountNeeded) >= 0;
                    if (hasSufficientBalance) {
                        this.signAndPostOffer(openOffer, true, resultHandler, errorMessageHandler);
                        return;
                    }
                    if (openOffer.getScheduledTxHashes() == null) {
                        this.scheduleWithEarliestTxs(openOffers, openOffer);
                    }
                    resultHandler.handleResult(null);
                    return;
                }
                this.splitOrSchedule(splitOutputTx, openOffers, openOffer, amountNeeded, resultHandler, errorMessageHandler);
            }
            catch (Exception e) {
                if (!openOffer.isCanceled()) {
                    log.error("Error processing offer: {}\n", (Object)e.getMessage(), (Object)e);
                }
                errorMessageHandler.handleErrorMessage(e.getMessage());
            }
        }).start();
    }

    private void validateSignedState(OpenOffer openOffer) {
        Arbitrator arbitrator = this.user.getAcceptedArbitratorByAddress(openOffer.getOffer().getOfferPayload().getArbitratorSigner());
        if (openOffer.getOffer().getOfferPayload().getArbitratorSigner() == null) {
            throw new IllegalArgumentException("Offer " + openOffer.getId() + " has no arbitrator signer");
        }
        if (openOffer.getOffer().getOfferPayload().getArbitratorSignature() == null) {
            throw new IllegalArgumentException("Offer " + openOffer.getId() + " has no arbitrator signature");
        }
        if (arbitrator == null) {
            throw new IllegalArgumentException("Offer " + openOffer.getId() + " signed by unregistered arbitrator");
        }
        if (!HavenoUtils.isArbitratorSignatureValid(openOffer.getOffer().getOfferPayload(), arbitrator)) {
            throw new IllegalArgumentException("Offer " + openOffer.getId() + " has invalid arbitrator signature");
        }
        if (openOffer.getOffer().getOfferPayload().getReserveTxKeyImages() == null || openOffer.getOffer().getOfferPayload().getReserveTxKeyImages().isEmpty() || openOffer.getReserveTxHash() == null || openOffer.getReserveTxHash().isEmpty()) {
            throw new IllegalArgumentException("Offer " + openOffer.getId() + " is missing reserve tx hash or key images");
        }
    }

    private MoneroTxWallet getSplitOutputFundingTx(List<OpenOffer> openOffers, OpenOffer openOffer) {
        XmrAddressEntry addressEntry = this.xmrWalletService.getOrCreateAddressEntry(openOffer.getId(), XmrAddressEntry.Context.OFFER_FUNDING);
        return this.getSplitOutputFundingTx(openOffers, openOffer, openOffer.getOffer().getAmountNeeded(), addressEntry.getSubaddressIndex());
    }

    private MoneroTxWallet getSplitOutputFundingTx(List<OpenOffer> openOffers, OpenOffer openOffer, BigInteger reserveAmount, Integer preferredSubaddressIndex) {
        List<MoneroTxWallet> fundingTxs;
        MoneroTxWallet earliestUnscheduledTx;
        if (openOffer != null && openOffer.getSplitOutputTxHash() != null) {
            MoneroTxWallet splitOutputTx = this.xmrWalletService.getTx(openOffer.getSplitOutputTxHash());
            if (splitOutputTx != null) {
                if (splitOutputTx.isLocked().booleanValue()) {
                    return splitOutputTx;
                }
                boolean isAvailable = true;
                for (MoneroOutputWallet output : splitOutputTx.getOutputsWallet()) {
                    if (!output.isSpent().booleanValue() && !output.isFrozen().booleanValue()) continue;
                    isAvailable = false;
                    break;
                }
                if (isAvailable || this.isReservedByOffer(openOffer, splitOutputTx)) {
                    return splitOutputTx;
                }
                log.warn("Split output tx {} is no longer available for offer {}", (Object)openOffer.getSplitOutputTxHash(), (Object)openOffer.getId());
            } else {
                log.warn("Split output tx {} no longer exists for offer {}", (Object)openOffer.getSplitOutputTxHash(), (Object)openOffer.getId());
            }
        }
        if (preferredSubaddressIndex != null && (earliestUnscheduledTx = this.getEarliestUnscheduledTx(openOffers, openOffer, fundingTxs = this.getSplitOutputFundingTxs(reserveAmount, preferredSubaddressIndex))) != null) {
            return earliestUnscheduledTx;
        }
        fundingTxs = this.getSplitOutputFundingTxs(reserveAmount, null);
        return this.getEarliestUnscheduledTx(openOffers, openOffer, fundingTxs);
    }

    private boolean isReservedByOffer(OpenOffer openOffer, MoneroTxWallet tx) {
        if (openOffer.getOffer().getOfferPayload().getReserveTxKeyImages() == null) {
            return false;
        }
        HashSet<String> offerKeyImages = new HashSet<String>(openOffer.getOffer().getOfferPayload().getReserveTxKeyImages());
        for (MoneroOutputWallet output : tx.getOutputsWallet()) {
            if (!offerKeyImages.contains(output.getKeyImage().getHex())) continue;
            return true;
        }
        return false;
    }

    private List<MoneroTxWallet> getSplitOutputFundingTxs(BigInteger reserveAmount, Integer preferredSubaddressIndex) {
        List<MoneroTxWallet> splitOutputTxs = this.xmrWalletService.getTxs(new MoneroTxQuery().setIsFailed(Boolean.valueOf(false)));
        HashSet<MoneroTxWallet> removeTxs = new HashSet<MoneroTxWallet>();
        for (MoneroTxWallet tx : splitOutputTxs) {
            if (tx.getOutputs() != null) {
                for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                    if (!output.isSpent().booleanValue() && !output.isFrozen().booleanValue()) continue;
                    removeTxs.add(tx);
                }
            }
            if (this.hasExactOutput(tx, reserveAmount, preferredSubaddressIndex)) continue;
            removeTxs.add(tx);
        }
        splitOutputTxs.removeAll(removeTxs);
        return splitOutputTxs;
    }

    private boolean hasExactOutput(MoneroTxWallet tx, BigInteger amount, Integer preferredSubaddressIndex) {
        boolean hasExactOutput;
        boolean bl = hasExactOutput = tx.getOutputsWallet(new MoneroOutputQuery().setAccountIndex(Integer.valueOf(0)).setSubaddressIndex(preferredSubaddressIndex).setAmount(amount)).size() > 0;
        if (hasExactOutput) {
            return true;
        }
        boolean hasExactTransfer = tx.getTransfers(new MoneroTransferQuery().setAccountIndex(Integer.valueOf(0)).setSubaddressIndex(preferredSubaddressIndex).setIsIncoming(Boolean.valueOf(true)).setAmount(amount)).size() > 0;
        return hasExactTransfer;
    }

    private MoneroTxWallet getEarliestUnscheduledTx(List<OpenOffer> openOffers, OpenOffer excludeOpenOffer, List<MoneroTxWallet> txs) {
        MoneroTxWallet earliestUnscheduledTx = null;
        for (MoneroTxWallet tx : txs) {
            if (this.isTxScheduledByOtherOffer(openOffers, excludeOpenOffer, tx.getHash()) || earliestUnscheduledTx != null && earliestUnscheduledTx.getNumConfirmations() >= tx.getNumConfirmations()) continue;
            earliestUnscheduledTx = tx;
        }
        return earliestUnscheduledTx;
    }

    private void splitOrSchedule(MoneroTxWallet splitOutputTx, List<OpenOffer> openOffers, OpenOffer openOffer, BigInteger amountNeeded, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (splitOutputTx == null) {
            if (openOffer.getSplitOutputTxHash() != null) {
                log.warn("Split output tx unexpectedly unavailable for offer, offerId={}, split output tx={}", (Object)openOffer.getId(), (Object)openOffer.getSplitOutputTxHash());
                this.setSplitOutputTx(openOffer, null);
            }
            try {
                this.splitOrScheduleAux(openOffers, openOffer, amountNeeded);
                resultHandler.handleResult(null);
                return;
            }
            catch (Exception e) {
                log.warn("Unable to split or schedule funds for offer {}: {}", (Object)openOffer.getId(), (Object)e.getMessage());
                openOffer.getOffer().setState(Offer.State.INVALID);
                errorMessageHandler.handleErrorMessage(e.getMessage());
                return;
            }
        }
        if (!splitOutputTx.isLocked().booleanValue()) {
            this.signAndPostOffer(openOffer, true, resultHandler, errorMessageHandler);
            return;
        }
        resultHandler.handleResult(null);
    }

    private void splitOrScheduleAux(List<OpenOffer> openOffers, OpenOffer openOffer, BigInteger offerReserveAmount) {
        boolean sufficientAvailableBalance;
        boolean bl = sufficientAvailableBalance = this.xmrWalletService.getAvailableBalance().compareTo(offerReserveAmount) >= 0;
        if (sufficientAvailableBalance && openOffer.getSplitOutputTxHash() == null) {
            log.info("Splitting and scheduling outputs for offer {}", (Object)openOffer.getShortId());
            this.splitAndSchedule(openOffer);
        } else if (openOffer.getScheduledTxHashes() == null) {
            this.scheduleWithEarliestTxs(openOffers, openOffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MoneroTxWallet splitAndSchedule(OpenOffer openOffer) {
        BigInteger reserveAmount = openOffer.getOffer().getAmountNeeded();
        this.xmrWalletService.swapAddressEntryToAvailable(openOffer.getId(), XmrAddressEntry.Context.OFFER_FUNDING);
        MoneroTxWallet splitOutputTx = null;
        Object object = HavenoUtils.xmrWalletService.getWalletLock();
        synchronized (object) {
            XmrAddressEntry entry = this.xmrWalletService.getOrCreateAddressEntry(openOffer.getId(), XmrAddressEntry.Context.OFFER_FUNDING);
            Object object2 = HavenoUtils.getWalletFunctionLock();
            synchronized (object2) {
                long startTime = System.currentTimeMillis();
                for (int i = 0; i < 5; ++i) {
                    MoneroRpcConnection sourceConnection = this.xmrConnectionService.getConnection();
                    try {
                        log.info("Creating split output tx to fund offer {} at subaddress {}", (Object)openOffer.getShortId(), (Object)entry.getSubaddressIndex());
                        splitOutputTx = this.xmrWalletService.createTx(new MoneroTxConfig().setAccountIndex(Integer.valueOf(0)).setAddress(entry.getAddressString()).setAmount(reserveAmount).setRelay(Boolean.valueOf(true)).setPriority(XmrWalletService.PROTOCOL_FEE_PRIORITY));
                        break;
                    }
                    catch (Exception e) {
                        if (e.getMessage().contains("not enough")) {
                            throw e;
                        }
                        log.warn("Error creating split output tx to fund offer, offerId={}, subaddress={}, attempt={}/{}, error={}", new Object[]{openOffer.getShortId(), entry.getSubaddressIndex(), i + 1, 5, e.getMessage()});
                        this.xmrWalletService.handleWalletError(e, sourceConnection, i + 1);
                        if (this.stopped || i == 4) {
                            throw e;
                        }
                        HavenoUtils.waitFor(5000L);
                        continue;
                    }
                }
                log.info("Done creating split output tx to fund offer {} in {} ms", (Object)openOffer.getId(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
        this.setSplitOutputTx(openOffer, splitOutputTx);
        return splitOutputTx;
    }

    private void setSplitOutputTx(OpenOffer openOffer, MoneroTxWallet splitOutputTx) {
        openOffer.setSplitOutputTxHash(splitOutputTx == null ? null : splitOutputTx.getHash());
        openOffer.setSplitOutputTxFee(splitOutputTx == null ? 0L : splitOutputTx.getFee().longValueExact());
        openOffer.setScheduledTxHashes(splitOutputTx == null ? null : Arrays.asList(splitOutputTx.getHash()));
        openOffer.setScheduledAmount(splitOutputTx == null ? null : openOffer.getOffer().getAmountNeeded().toString());
        if (!openOffer.isCanceled()) {
            openOffer.setState(OpenOffer.State.PENDING);
        }
    }

    private void scheduleWithEarliestTxs(List<OpenOffer> openOffers, OpenOffer openOffer) {
        BigInteger offerReserveAmount = openOffer.getOffer().getAmountNeeded();
        BigInteger scheduledAmount = BigInteger.ZERO;
        HashSet<MoneroTxWallet> scheduledTxs = new HashSet<MoneroTxWallet>();
        for (MoneroTxWallet tx2 : this.xmrWalletService.getTxs()) {
            BigInteger spendableAmount = this.getUnscheduledSpendableAmount(tx2, openOffers);
            if (spendableAmount.equals(BigInteger.ZERO)) continue;
            scheduledAmount = scheduledAmount.add(spendableAmount);
            scheduledTxs.add(tx2);
            if (scheduledAmount.compareTo(offerReserveAmount) < 0) continue;
            break;
        }
        if (scheduledAmount.compareTo(offerReserveAmount) < 0) {
            throw new RuntimeException("Not enough funds to create offer");
        }
        openOffer.setScheduledTxHashes(scheduledTxs.stream().map(tx -> tx.getHash()).collect(Collectors.toList()));
        openOffer.setScheduledAmount(scheduledAmount.toString());
        openOffer.setState(OpenOffer.State.PENDING);
    }

    private BigInteger getUnscheduledSpendableAmount(MoneroTxWallet tx, List<OpenOffer> openOffers) {
        if (this.isScheduledWithUnknownAmount(tx, openOffers)) {
            return BigInteger.ZERO;
        }
        return this.getSpendableAmount(tx).subtract(this.getSplitAmount(tx, openOffers)).max(BigInteger.ZERO);
    }

    private boolean isScheduledWithUnknownAmount(MoneroTxWallet tx, List<OpenOffer> openOffers) {
        for (OpenOffer openOffer : openOffers) {
            if (openOffer.getScheduledTxHashes() == null || !openOffer.getScheduledTxHashes().contains(tx.getHash()) || tx.getHash().equals(openOffer.getSplitOutputTxHash())) continue;
            return true;
        }
        return false;
    }

    private BigInteger getSplitAmount(MoneroTxWallet tx, List<OpenOffer> openOffers) {
        for (OpenOffer openOffer : openOffers) {
            if (openOffer.getSplitOutputTxHash() == null || !openOffer.getSplitOutputTxHash().equals(tx.getHash())) continue;
            return openOffer.getOffer().getAmountNeeded();
        }
        return BigInteger.ZERO;
    }

    private BigInteger getSpendableAmount(MoneroTxWallet tx) {
        if (tx.isConfirmed().booleanValue()) {
            BigInteger spendableAmount = BigInteger.ZERO;
            if (tx.getOutputsWallet() != null) {
                for (MoneroOutputWallet output : tx.getOutputsWallet()) {
                    if (output.isSpent().booleanValue() || output.isFrozen().booleanValue() || output.getAccountIndex() != 0) continue;
                    spendableAmount = spendableAmount.add(output.getAmount());
                }
            }
            return spendableAmount;
        }
        BigInteger sentToSelfAmount = this.xmrWalletService.getAmountSentToSelf(tx);
        if (sentToSelfAmount.compareTo(BigInteger.ZERO) > 0) {
            return sentToSelfAmount;
        }
        return tx.getIncomingAmount() == null ? BigInteger.ZERO : tx.getIncomingAmount();
    }

    private boolean hasSpendableAmount(MoneroTxWallet tx) {
        return this.getSpendableAmount(tx).compareTo(BigInteger.ZERO) > 0;
    }

    private boolean isTxScheduledByOtherOffer(List<OpenOffer> openOffers, OpenOffer openOffer, String txHash) {
        for (OpenOffer otherOffer : openOffers) {
            if (otherOffer == openOffer || otherOffer.getState() != OpenOffer.State.PENDING) continue;
            if (txHash.equals(otherOffer.getSplitOutputTxHash())) {
                return true;
            }
            if (otherOffer.getScheduledTxHashes() == null) continue;
            for (String scheduledTxHash : otherOffer.getScheduledTxHashes()) {
                if (!txHash.equals(scheduledTxHash)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signAndPostOffer(OpenOffer openOffer, boolean useSavingsWallet, TransactionResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        log.info("Signing and posting offer " + openOffer.getId());
        PlaceOfferModel model = new PlaceOfferModel(openOffer, openOffer.getOffer().getAmountNeeded(), useSavingsWallet, this.p2PService, this.btcWalletService, this.xmrWalletService, this.tradeWalletService, this.offerBookService, this.arbitratorManager, this.mediatorManager, this.tradeStatisticsManager, this.user, this.keyRing, this.filterManager, this.accountAgeWitnessService, this);
        PlaceOfferProtocol placeOfferProtocol = new PlaceOfferProtocol(model, transaction -> {
            openOffer.setScheduledTxHashes(null);
            openOffer.setScheduledAmount(null);
            this.requestPersistence();
            if (!this.stopped) {
                this.startPeriodicRepublishOffersTimer();
                this.startPeriodicRefreshOffersTimer();
            } else {
                log.debug("We have stopped already. We ignore that placeOfferProtocol.placeOffer.onResult call.");
            }
            resultHandler.handleResult(transaction);
        }, errorMessageHandler);
        Map<String, PlaceOfferProtocol> map = this.placeOfferProtocols;
        synchronized (map) {
            this.placeOfferProtocols.put(openOffer.getOffer().getId(), placeOfferProtocol);
        }
        placeOfferProtocol.placeOffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSignOfferRequest(SignOfferRequest request, final NodeAddress peer) {
        log.info("Received SignOfferRequest from {} with offerId {} and uid {}", new Object[]{peer, request.getOfferId(), request.getUid()});
        boolean result = false;
        Object errorMessage = null;
        try {
            double makerFeePct;
            boolean hasBuyerAsTakerWithoutDeposit;
            Arbitrator thisArbitrator = this.user.getRegisteredArbitrator();
            NodeAddress thisAddress = this.p2PService.getNetworkNode().getNodeAddress();
            if (thisArbitrator == null || !thisArbitrator.getNodeAddress().equals((Object)thisAddress)) {
                errorMessage = "Cannot sign offer because we are not a registered arbitrator";
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            if (!thisAddress.equals((Object)request.getOfferPayload().getArbitratorSigner())) {
                errorMessage = "Cannot sign offer because offer payload is for a different arbitrator";
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            Offer offer = new Offer(request.getOfferPayload());
            if (offer.isPrivateOffer() && (offer.getChallengeHash() == null || offer.getChallengeHash().length() == 0)) {
                errorMessage = "Private offer must have challenge hash for offer " + request.offerId;
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            if (offer.getOfferPayload().getExtraInfo() != null && offer.getOfferPayload().getExtraInfo().length() > Restrictions.getMaxExtraInfoLength()) {
                errorMessage = "Extra info is too long for offer " + request.offerId + ". Max length is " + Restrictions.getMaxExtraInfoLength() + " but got " + offer.getOfferPayload().getExtraInfo().length();
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            if (request.getOfferPayload().getProtocolVersion() != 3) {
                errorMessage = "Unsupported protocol version: " + request.getOfferPayload().getProtocolVersion();
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            if (this.filterManager.getDisableTradeBelowVersion() != null && Version.compare((String)request.getOfferPayload().getVersionNr(), (String)this.filterManager.getDisableTradeBelowVersion()) < 0) {
                errorMessage = "Offer version number is too low: " + request.getOfferPayload().getVersionNr() + " < " + this.filterManager.getDisableTradeBelowVersion();
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            boolean bl = hasBuyerAsTakerWithoutDeposit = offer.getDirection() == OfferDirection.SELL && offer.isPrivateOffer() && offer.getChallengeHash() != null && offer.getChallengeHash().length() > 0 && offer.getTakerFeePct() == 0.0;
            if (hasBuyerAsTakerWithoutDeposit) {
                makerFeePct = HavenoUtils.getMakerFeePct(request.getOfferPayload().getCounterCurrencyCode(), hasBuyerAsTakerWithoutDeposit);
                if (offer.getMakerFeePct() != makerFeePct) {
                    errorMessage = "Wrong maker fee for offer " + request.offerId + ". Expected " + makerFeePct + " but got " + offer.getMakerFeePct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                if (offer.getTakerFeePct() != 0.0) {
                    errorMessage = "Wrong taker fee for offer " + request.offerId + ". Expected 0 but got " + offer.getTakerFeePct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                if (offer.getSellerSecurityDepositPct() != Restrictions.getMinSecurityDepositPct()) {
                    errorMessage = "Wrong seller security deposit for offer " + request.offerId + ". Expected " + Restrictions.getMinSecurityDepositPct() + " but got " + offer.getSellerSecurityDepositPct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                if (offer.getBuyerSecurityDepositPct() != 0.0) {
                    errorMessage = "Wrong buyer security deposit for offer " + request.offerId + ". Expected 0 but got " + offer.getBuyerSecurityDepositPct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
            } else {
                if (offer.isPrivateOffer() || offer.getChallengeHash() != null) {
                    errorMessage = "Private offer " + request.offerId + " is not valid. It must have direction SELL, taker fee of 0, and a challenge hash.";
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                makerFeePct = HavenoUtils.getMakerFeePct(request.getOfferPayload().getCounterCurrencyCode(), hasBuyerAsTakerWithoutDeposit);
                if (offer.getMakerFeePct() != makerFeePct) {
                    errorMessage = "Wrong maker fee for offer " + request.offerId + ". Expected " + makerFeePct + " but got " + offer.getMakerFeePct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                double takerFeePct = HavenoUtils.getTakerFeePct(request.getOfferPayload().getCounterCurrencyCode(), hasBuyerAsTakerWithoutDeposit);
                if (offer.getTakerFeePct() != takerFeePct) {
                    errorMessage = "Wrong taker fee for offer " + request.offerId + ". Expected " + takerFeePct + " but got " + offer.getTakerFeePct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                if (offer.getSellerSecurityDepositPct() < Restrictions.getMinSecurityDepositPct()) {
                    errorMessage = "Insufficient seller security deposit for offer " + request.offerId + ". Expected at least " + Restrictions.getMinSecurityDepositPct() + " but got " + offer.getSellerSecurityDepositPct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                if (offer.getBuyerSecurityDepositPct() < Restrictions.getMinSecurityDepositPct()) {
                    errorMessage = "Insufficient buyer security deposit for offer " + request.offerId + ". Expected at least " + Restrictions.getMinSecurityDepositPct() + " but got " + offer.getBuyerSecurityDepositPct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
                if (offer.getBuyerSecurityDepositPct() != offer.getSellerSecurityDepositPct()) {
                    errorMessage = "Buyer and seller security deposits are not equal for offer " + request.offerId + ": " + offer.getSellerSecurityDepositPct() + " vs " + offer.getBuyerSecurityDepositPct();
                    log.warn((String)errorMessage);
                    this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                    return;
                }
            }
            if (offer.getPenaltyFeePct() != 0.25) {
                errorMessage = "Wrong penalty fee percent for offer " + request.offerId + ". Expected 0.25 but got " + offer.getPenaltyFeePct();
                log.warn((String)errorMessage);
                this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
                return;
            }
            makerFeePct = HavenoUtils.getMakerFeePct(request.getOfferPayload().getCounterCurrencyCode(), hasBuyerAsTakerWithoutDeposit);
            BigInteger maxTradeFee = HavenoUtils.multiply(offer.getAmount(), makerFeePct);
            BigInteger sendTradeAmount = offer.getDirection() == OfferDirection.BUY ? BigInteger.ZERO : offer.getAmount();
            BigInteger securityDeposit = offer.getDirection() == OfferDirection.BUY ? offer.getMaxBuyerSecurityDeposit() : offer.getMaxSellerSecurityDeposit();
            BigInteger penaltyFee = HavenoUtils.multiply(securityDeposit, 0.25);
            MoneroTx verifiedTx = this.xmrWalletService.verifyReserveTx(offer.getId(), penaltyFee, maxTradeFee, sendTradeAmount, securityDeposit, request.getPayoutAddress(), request.getReserveTxHash(), request.getReserveTxHex(), request.getReserveTxKey(), request.getReserveTxKeyImages());
            byte[] signature = HavenoUtils.signOffer(request.getOfferPayload(), this.keyRing);
            OfferPayload signedOfferPayload = request.getOfferPayload();
            signedOfferPayload.setArbitratorSignature(signature);
            SignedOffer signedOffer = new SignedOffer(System.currentTimeMillis(), signedOfferPayload.getPubKeyRing().hashCode(), signedOfferPayload.getId(), offer.getAmount().longValueExact(), penaltyFee.longValueExact(), request.getReserveTxHash(), request.getReserveTxHex(), request.getReserveTxKeyImages(), verifiedTx.getFee().longValueExact(), signature);
            this.addSignedOffer(signedOffer);
            this.requestPersistence();
            final SignOfferResponse response = new SignOfferResponse(request.getOfferId(), UUID.randomUUID().toString(), Version.getP2PMessageVersion(), signedOfferPayload);
            this.p2PService.sendEncryptedDirectMessage(peer, request.getPubKeyRing(), (NetworkEnvelope)response, new SendDirectMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at peer: offerId={}; uid={}", new Object[]{((Object)((Object)response)).getClass().getSimpleName(), response.getOfferId(), response.getUid()});
                }

                public void onFault(String errorMessage) {
                    log.error("Sending {} failed: uid={}; peer={}; error={}", new Object[]{((Object)((Object)response)).getClass().getSimpleName(), response.getUid(), peer, errorMessage});
                }
            });
            result = true;
        }
        catch (Exception e) {
            errorMessage = "Exception at handleSignOfferRequest " + e.getMessage();
            log.error((String)errorMessage + "\n", (Throwable)e);
        }
        finally {
            if (!result && errorMessage == null) {
                log.warn("Arbitrator is NACKing SignOfferRequest for unknown reason with offerId={}. That should never happen", (Object)request.getOfferId());
                log.warn("Printing stacktrace:");
                Thread.dumpStack();
            }
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), result, (String)errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSignOfferResponse(SignOfferResponse response, NodeAddress peer) {
        PlaceOfferProtocol protocol;
        log.info("Received SignOfferResponse from {} with offerId {} and uid {}", new Object[]{peer, response.getOfferId(), response.getUid()});
        Map<String, PlaceOfferProtocol> map = this.placeOfferProtocols;
        synchronized (map) {
            protocol = this.placeOfferProtocols.get(response.getOfferId());
            if (protocol == null) {
                log.warn("No place offer protocol created for offer " + response.getOfferId());
                return;
            }
        }
        protocol.handleSignOfferResponse(response, peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOfferAvailabilityRequest(OfferAvailabilityRequest request, final NodeAddress peer) {
        log.info("Received OfferAvailabilityRequest from {} with offerId {} and uid {}", new Object[]{peer, request.getOfferId(), request.getUid()});
        boolean result = false;
        Object errorMessage = null;
        if (!this.p2PService.isBootstrapped()) {
            errorMessage = "We got a handleOfferAvailabilityRequest but we have not bootstrapped yet.";
            log.info((String)errorMessage);
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
            return;
        }
        if (!this.xmrConnectionService.isSyncedWithinTolerance()) {
            errorMessage = "We got a handleOfferAvailabilityRequest but our chain is not synced.";
            log.info((String)errorMessage);
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
            return;
        }
        if (!Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
            errorMessage = "We got a handleOfferAvailabilityRequest but we are not connected to a Monero node.";
            log.info((String)errorMessage);
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
            return;
        }
        if (this.stopped) {
            errorMessage = "We have stopped already. We ignore that handleOfferAvailabilityRequest call.";
            log.debug((String)errorMessage);
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
            return;
        }
        try {
            Validator.nonEmptyStringOf(request.offerId);
            Preconditions.checkNotNull((Object)request.getPubKeyRing());
        }
        catch (Throwable t) {
            errorMessage = "Message validation failed. Error=" + t.toString() + ", Message=" + request.toString();
            log.warn((String)errorMessage);
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), false, (String)errorMessage);
            return;
        }
        try {
            AvailabilityResult availabilityResult;
            byte[] makerSignature;
            block26: {
                Optional<OpenOffer> openOfferOptional = this.getOpenOffer(request.offerId);
                makerSignature = null;
                if (openOfferOptional.isPresent()) {
                    OpenOffer openOffer = openOfferOptional.get();
                    if (!this.apiUserDeniedByOffer(request)) {
                        if (!this.takerDeniedByMaker(request)) {
                            if (openOffer.getState() == OpenOffer.State.AVAILABLE) {
                                Offer offer = openOffer.getOffer();
                                if (this.preferences.getIgnoreTradersList().stream().noneMatch(fullAddress -> fullAddress.equals(peer.getFullAddress()))) {
                                    String tradeRequestAsJson = JsonUtil.objectToJson((Object)request.getTradeRequest());
                                    makerSignature = HavenoUtils.sign(this.keyRing, tradeRequestAsJson);
                                    try {
                                        offer.verifyTradePrice(request.getTakersTradePrice());
                                        availabilityResult = AvailabilityResult.AVAILABLE;
                                    }
                                    catch (TradePriceOutOfToleranceException e) {
                                        log.warn("Trade price check failed because takers price is outside out tolerance.");
                                        availabilityResult = AvailabilityResult.PRICE_OUT_OF_TOLERANCE;
                                    }
                                    catch (MarketPriceNotAvailableException e) {
                                        log.warn(e.getMessage());
                                        availabilityResult = AvailabilityResult.MARKET_PRICE_NOT_AVAILABLE;
                                    }
                                    catch (Throwable e) {
                                        log.warn("Trade price check failed. " + e.getMessage());
                                        if (this.coreContext.isApiUser()) {
                                            availabilityResult = AvailabilityResult.PRICE_CHECK_FAILED;
                                            break block26;
                                        }
                                        availabilityResult = AvailabilityResult.UNKNOWN_FAILURE;
                                    }
                                } else {
                                    availabilityResult = AvailabilityResult.USER_IGNORED;
                                }
                            } else {
                                availabilityResult = AvailabilityResult.OFFER_TAKEN;
                            }
                        } else {
                            availabilityResult = AvailabilityResult.MAKER_DENIED_TAKER;
                        }
                    } else {
                        availabilityResult = AvailabilityResult.MAKER_DENIED_API_USER;
                    }
                } else {
                    log.warn("handleOfferAvailabilityRequest: openOffer not found.");
                    availabilityResult = AvailabilityResult.OFFER_TAKEN;
                }
            }
            final OfferAvailabilityResponse offerAvailabilityResponse = new OfferAvailabilityResponse(request.offerId, availabilityResult, makerSignature);
            log.info("Send {} with offerId {}, uid {}, and result {} to peer {}", new Object[]{((Object)((Object)offerAvailabilityResponse)).getClass().getSimpleName(), offerAvailabilityResponse.getOfferId(), offerAvailabilityResponse.getUid(), availabilityResult, peer});
            this.p2PService.sendEncryptedDirectMessage(peer, request.getPubKeyRing(), (NetworkEnvelope)offerAvailabilityResponse, new SendDirectMessageListener(){

                public void onArrived() {
                    log.info("{} arrived at peer: offerId={}; uid={}", new Object[]{((Object)((Object)offerAvailabilityResponse)).getClass().getSimpleName(), offerAvailabilityResponse.getOfferId(), offerAvailabilityResponse.getUid()});
                }

                public void onFault(String errorMessage) {
                    log.error("Sending {} failed: uid={}; peer={}; error={}", new Object[]{((Object)((Object)offerAvailabilityResponse)).getClass().getSimpleName(), offerAvailabilityResponse.getUid(), peer, errorMessage});
                }
            });
            result = true;
        }
        catch (Throwable t) {
            errorMessage = "Exception at handleRequestIsOfferAvailableMessage " + t.getMessage();
            log.error((String)errorMessage + "\n", t);
        }
        finally {
            this.sendAckMessage(((Object)((Object)request)).getClass(), peer, request.getPubKeyRing(), request.getOfferId(), request.getUid(), result, (String)errorMessage);
        }
    }

    private boolean apiUserDeniedByOffer(OfferAvailabilityRequest request) {
        return this.preferences.isDenyApiTaker() && request.isTakerApiUser();
    }

    private boolean takerDeniedByMaker(OfferAvailabilityRequest request) {
        return request.getTradeRequest() == null;
    }

    private void sendAckMessage(final Class<?> reqClass, final NodeAddress sender, PubKeyRing senderPubKeyRing, final String offerId, String uid, boolean result, String errorMessage) {
        String sourceUid = uid;
        final AckMessage ackMessage = new AckMessage(this.p2PService.getNetworkNode().getNodeAddress(), AckMessageSourceType.OFFER_MESSAGE, reqClass.getSimpleName(), sourceUid, offerId, result, errorMessage);
        if (ackMessage.isSuccess()) {
            log.info("Send AckMessage for {} to peer {} with offerId {} and sourceUid {}", new Object[]{reqClass.getSimpleName(), sender, offerId, ackMessage.getSourceUid()});
        } else {
            log.warn("Sending NACK for {} to peer {} with offerId {} and sourceUid {}, errorMessage={}", new Object[]{reqClass.getSimpleName(), sender, offerId, ackMessage.getSourceUid(), errorMessage});
        }
        this.p2PService.sendEncryptedDirectMessage(sender, senderPubKeyRing, (NetworkEnvelope)ackMessage, new SendDirectMessageListener(){

            public void onArrived() {
                log.info("AckMessage for {} arrived at sender {}. offerId={}, sourceUid={}", new Object[]{reqClass.getSimpleName(), sender, offerId, ackMessage.getSourceUid()});
            }

            public void onFault(String errorMessage) {
                log.error("AckMessage for {} failed. AckMessage={}, sender={}, errorMessage={}", new Object[]{reqClass.getSimpleName(), ackMessage, sender, errorMessage});
            }
        });
    }

    private void maybeUpdatePersistedOffers() {
        ArrayList updatedOpenOffers = new ArrayList();
        this.getOpenOffers().forEach(originalOpenOffer -> {
            Offer originalOffer = originalOpenOffer.getOffer();
            OfferPayload originalOfferPayload = originalOffer.getOfferPayload();
            if (!(originalOfferPayload.getProtocolVersion() >= 3 && OfferRestrictions.hasOfferMandatoryCapability(originalOffer, Capability.MEDIATION) && OfferRestrictions.hasOfferMandatoryCapability(originalOffer, Capability.REFUND_AGENT) && originalOfferPayload.getOwnerNodeAddress().equals((Object)this.p2PService.getAddress()))) {
                NodeAddress ownerNodeAddress;
                HashMap<String, String> updatedExtraDataMap = new HashMap<String, String>();
                if (!OfferRestrictions.hasOfferMandatoryCapability(originalOffer, Capability.MEDIATION) || !OfferRestrictions.hasOfferMandatoryCapability(originalOffer, Capability.REFUND_AGENT)) {
                    Map<String, String> originalExtraDataMap = originalOfferPayload.getExtraDataMap();
                    if (originalExtraDataMap != null) {
                        updatedExtraDataMap.putAll(originalExtraDataMap);
                    }
                    updatedExtraDataMap.put("capabilities", Capabilities.app.toStringList());
                    log.info("Converted offer to support new Capability.MEDIATION and Capability.REFUND_AGENT capability. id={}", (Object)originalOffer.getId());
                } else {
                    updatedExtraDataMap = originalOfferPayload.getExtraDataMap();
                }
                int protocolVersion = originalOfferPayload.getProtocolVersion();
                if (protocolVersion < 3) {
                    protocolVersion = 3;
                    log.info("Updated the protocol version of offer id={}", (Object)originalOffer.getId());
                }
                if (!(ownerNodeAddress = originalOfferPayload.getOwnerNodeAddress()).equals((Object)this.p2PService.getAddress())) {
                    ownerNodeAddress = this.p2PService.getAddress();
                    log.info("Updated the owner nodeaddress of offer id={}", (Object)originalOffer.getId());
                }
                long normalizedPrice = originalOffer.isInverted() ? PriceUtil.invertLongPrice(originalOfferPayload.getPrice(), originalOffer.getCounterCurrencyCode()) : originalOfferPayload.getPrice();
                OfferPayload updatedPayload = new OfferPayload(originalOfferPayload.getId(), originalOfferPayload.getDate(), ownerNodeAddress, originalOfferPayload.getPubKeyRing(), originalOfferPayload.getDirection(), normalizedPrice, originalOfferPayload.getMarketPriceMarginPct(), originalOfferPayload.isUseMarketBasedPrice(), originalOfferPayload.getAmount(), originalOfferPayload.getMinAmount(), originalOfferPayload.getMakerFeePct(), originalOfferPayload.getTakerFeePct(), 0.25, originalOfferPayload.getBuyerSecurityDepositPct(), originalOfferPayload.getSellerSecurityDepositPct(), originalOffer.getBaseCurrencyCode(), originalOffer.getCounterCurrencyCode(), originalOfferPayload.getPaymentMethodId(), originalOfferPayload.getMakerPaymentAccountId(), originalOfferPayload.getCountryCode(), originalOfferPayload.getAcceptedCountryCodes(), originalOfferPayload.getBankId(), originalOfferPayload.getAcceptedBankIds(), "1.2.2", originalOfferPayload.getBlockHeightAtOfferCreation(), originalOfferPayload.getMaxTradeLimit(), originalOfferPayload.getMaxTradePeriod(), originalOfferPayload.isUseAutoClose(), originalOfferPayload.isUseReOpenAfterAutoClose(), originalOfferPayload.getLowerClosePrice(), originalOfferPayload.getUpperClosePrice(), originalOfferPayload.isPrivateOffer(), originalOfferPayload.getChallengeHash(), updatedExtraDataMap, protocolVersion, null, null, null, originalOfferPayload.getExtraInfo());
                log.info("Canceling outdated offer id={}", (Object)originalOffer.getId());
                this.doCancelOffer((OpenOffer)originalOpenOffer, false);
                Offer updatedOffer = new Offer(updatedPayload);
                updatedOffer.setPriceFeedService(this.priceFeedService);
                long normalizedTriggerPrice = originalOffer.isInverted() ? PriceUtil.invertLongPrice(originalOpenOffer.getTriggerPrice(), originalOffer.getCounterCurrencyCode()) : originalOpenOffer.getTriggerPrice();
                OpenOffer updatedOpenOffer = new OpenOffer(updatedOffer, normalizedTriggerPrice, originalOpenOffer.isReserveExactAmount(), originalOpenOffer.getGroupId());
                updatedOpenOffer.setChallenge(originalOpenOffer.getChallenge());
                updatedOpenOffers.add(updatedOpenOffer);
            }
        });
        updatedOpenOffers.forEach(updatedOpenOffer -> {
            this.addOpenOffer((OpenOffer)updatedOpenOffer);
            this.requestPersistence();
            log.info("Updating offer completed. id={}", (Object)updatedOpenOffer.getId());
        });
    }

    private void republishOffers() {
        if (this.stopped) {
            return;
        }
        this.stopPeriodicRefreshOffersTimer();
        ThreadUtils.execute(() -> this.processListForRepublishOffers(new ArrayList<OpenOffer>(this.getOpenOffers())), (String)THREAD_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processListForRepublishOffers(List<OpenOffer> list) {
        if (list.isEmpty()) {
            return;
        }
        OpenOffer openOffer = list.remove(0);
        boolean contained = false;
        List list2 = this.openOffers.getList();
        synchronized (list2) {
            contained = this.openOffers.contains(openOffer);
        }
        if (contained) {
            this.maybeRepublishOffer(openOffer, () -> this.processListForRepublishOffers(list));
        } else {
            this.processListForRepublishOffers(list);
        }
    }

    private void maybeRepublishOffer(OpenOffer openOffer, @Nullable Runnable completeHandler) {
        ThreadUtils.execute(() -> {
            if (this.preventedFromPublishing(openOffer)) {
                if (completeHandler != null) {
                    completeHandler.run();
                }
                return;
            }
            Object object = this.processOffersLock;
            synchronized (object) {
                CountDownLatch latch = new CountDownLatch(1);
                this.processOffer(this.getOpenOffers(), openOffer, transaction -> {
                    this.requestPersistence();
                    latch.countDown();
                    if (this.preventedFromPublishing(openOffer)) {
                        if (completeHandler != null) {
                            completeHandler.run();
                        }
                        return;
                    }
                    this.offerBookService.addOffer(openOffer.getOffer(), () -> {
                        if (!this.stopped) {
                            if (this.periodicRefreshOffersTimer == null) {
                                this.startPeriodicRefreshOffersTimer();
                            }
                            if (completeHandler != null) {
                                completeHandler.run();
                            }
                        }
                    }, errorMessage -> {
                        if (!this.stopped) {
                            log.error("Adding offer to P2P network failed. " + errorMessage);
                            this.stopRetryRepublishOffersTimer();
                            this.retryRepublishOffersTimer = UserThread.runAfter(this::republishOffers, (long)10L);
                            if (completeHandler != null) {
                                completeHandler.run();
                            }
                        }
                    });
                }, errorMessage -> {
                    log.warn("Error republishing offer {}: {}", (Object)openOffer.getId(), (Object)errorMessage);
                    latch.countDown();
                    if (completeHandler != null) {
                        completeHandler.run();
                    }
                });
                HavenoUtils.awaitLatch(latch);
            }
        }, (String)THREAD_ID);
    }

    private boolean preventedFromPublishing(OpenOffer openOffer) {
        if (!Boolean.TRUE.equals(this.xmrConnectionService.isConnected())) {
            return true;
        }
        return openOffer.isDeactivated() || openOffer.isCanceled() || openOffer.getOffer().getOfferPayload().getArbitratorSigner() == null || this.hasConflictingClone(openOffer);
    }

    private void startPeriodicRepublishOffersTimer() {
        this.stopped = false;
        if (this.periodicRepublishOffersTimer == null) {
            this.periodicRepublishOffersTimer = UserThread.runPeriodically(() -> {
                if (!this.stopped) {
                    this.republishOffers();
                }
            }, (long)REPUBLISH_INTERVAL_MS, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void startPeriodicRefreshOffersTimer() {
        this.stopped = false;
        if (this.periodicRefreshOffersTimer == null) {
            this.periodicRefreshOffersTimer = UserThread.runPeriodically(() -> {
                if (!this.stopped) {
                    log.info("Refreshing my open offers");
                    List list = this.openOffers.getList();
                    synchronized (list) {
                        int size = this.openOffers.size();
                        ArrayList openOffersList = new ArrayList(this.openOffers.getList());
                        for (int i = 0; i < size; ++i) {
                            long delay = 300L;
                            long minDelay = (long)(i + 1) * delay;
                            long maxDelay = (long)(i + 2) * delay;
                            OpenOffer openOffer = (OpenOffer)openOffersList.get(i);
                            UserThread.runAfterRandomDelay(() -> {
                                boolean contained = false;
                                List list = this.openOffers.getList();
                                synchronized (list) {
                                    contained = this.openOffers.contains(openOffer);
                                }
                                if (contained) {
                                    this.maybeRefreshOffer(openOffer, 0, 1);
                                }
                            }, (long)minDelay, (long)maxDelay, (TimeUnit)TimeUnit.MILLISECONDS);
                        }
                    }
                } else {
                    log.debug("We have stopped already. We ignore that periodicRefreshOffersTimer.run call.");
                }
            }, (long)REFRESH_INTERVAL_MS, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            log.trace("periodicRefreshOffersTimer already stated");
        }
    }

    private void maybeRefreshOffer(OpenOffer openOffer, int numAttempts, int maxAttempts) {
        if (this.preventedFromPublishing(openOffer)) {
            return;
        }
        this.offerBookService.refreshTTL(openOffer.getOffer().getOfferPayload(), () -> log.debug("Successful refreshed TTL for offer"), errorMessage -> {
            log.warn(errorMessage);
            if (numAttempts + 1 < maxAttempts) {
                UserThread.runAfter(() -> this.maybeRefreshOffer(openOffer, numAttempts + 1, maxAttempts), (long)10L);
            }
        });
    }

    private void restart() {
        log.debug("Restart after connection loss");
        if (this.retryRepublishOffersTimer == null) {
            this.retryRepublishOffersTimer = UserThread.runAfter(() -> {
                this.stopped = false;
                this.stopRetryRepublishOffersTimer();
                this.republishOffers();
            }, (long)10L);
        }
        this.startPeriodicRepublishOffersTimer();
    }

    private void requestPersistence() {
        this.persistenceManager.requestPersistence();
        this.signedOfferPersistenceManager.requestPersistence();
    }

    private void stopPeriodicRefreshOffersTimer() {
        if (this.periodicRefreshOffersTimer != null) {
            this.periodicRefreshOffersTimer.stop();
            this.periodicRefreshOffersTimer = null;
        }
    }

    private void stopPeriodicRepublishOffersTimer() {
        if (this.periodicRepublishOffersTimer != null) {
            this.periodicRepublishOffersTimer.stop();
            this.periodicRepublishOffersTimer = null;
        }
    }

    private void stopRetryRepublishOffersTimer() {
        if (this.retryRepublishOffersTimer != null) {
            this.retryRepublishOffersTimer.stop();
            this.retryRepublishOffersTimer = null;
        }
    }

    public XmrConnectionService getXmrConnectionService() {
        return this.xmrConnectionService;
    }

    public XmrWalletService getXmrWalletService() {
        return this.xmrWalletService;
    }

    public ObservableList<Tuple2<OpenOffer, String>> getInvalidOffers() {
        return this.invalidOffers;
    }

    public AccountAgeWitnessService getAccountAgeWitnessService() {
        return this.accountAgeWitnessService;
    }
}

