/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.OfferDirection;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import java.math.BigInteger;
import java.util.Date;
import javax.annotation.Nullable;
import org.bitcoinj.utils.MonetaryFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferForJson {
    private static final Logger log = LoggerFactory.getLogger(OfferForJson.class);
    public final OfferDirection direction;
    public final String currencyCode;
    public final long minAmount;
    public final long amount;
    public final long price;
    public final long date;
    public final boolean useMarketBasedPrice;
    public final double marketPriceMargin;
    public final String paymentMethod;
    public final String id;
    public String currencyPair;
    public OfferDirection primaryMarketDirection;
    public String priceDisplayString;
    public String primaryMarketAmountDisplayString;
    public String primaryMarketMinAmountDisplayString;
    public String primaryMarketVolumeDisplayString;
    public String primaryMarketMinVolumeDisplayString;
    public long primaryMarketPrice;
    public long primaryMarketAmount;
    public long primaryMarketMinAmount;
    public long primaryMarketVolume;
    public long primaryMarketMinVolume;
    @JsonIgnore
    private final transient MonetaryFormat traditionalFormat = new MonetaryFormat().shift(0).minDecimals(8).repeatOptionalDecimals(0, 0);
    @JsonIgnore
    private final transient MonetaryFormat cryptoFormat = new MonetaryFormat().shift(0).minDecimals(8).repeatOptionalDecimals(0, 0);
    @JsonIgnore
    private final transient MonetaryFormat coinFormat = MonetaryFormat.BTC;

    public OfferForJson(OfferDirection direction, String currencyCode, BigInteger minAmount, BigInteger amount, @Nullable Price price, Date date, String id, boolean useMarketBasedPrice, double marketPriceMargin, PaymentMethod paymentMethod) {
        this.direction = direction;
        this.currencyCode = currencyCode;
        this.minAmount = minAmount.longValueExact();
        this.amount = amount.longValueExact();
        this.price = price.getValue();
        this.date = date.getTime();
        this.id = id;
        this.useMarketBasedPrice = useMarketBasedPrice;
        this.marketPriceMargin = marketPriceMargin;
        this.paymentMethod = paymentMethod.getId();
        this.setDisplayStrings();
    }

    private void setDisplayStrings() {
        try {
            Price price = this.getPrice();
            this.primaryMarketDirection = this.direction;
            this.currencyPair = Res.getBaseCurrencyCode() + "/" + this.currencyCode;
            if (CurrencyUtil.isTraditionalCurrency(this.currencyCode)) {
                this.priceDisplayString = this.traditionalFormat.noCode().format(price.getMonetary()).toString();
                this.primaryMarketMinAmountDisplayString = HavenoUtils.formatXmr(this.getMinAmount()).toString();
                this.primaryMarketAmountDisplayString = HavenoUtils.formatXmr(this.getAmount()).toString();
                this.primaryMarketMinVolumeDisplayString = this.traditionalFormat.noCode().format(this.getMinVolume().getMonetary()).toString();
                this.primaryMarketVolumeDisplayString = this.traditionalFormat.noCode().format(this.getVolume().getMonetary()).toString();
            } else {
                this.priceDisplayString = this.cryptoFormat.noCode().format(price.getMonetary()).toString();
                this.primaryMarketMinAmountDisplayString = this.cryptoFormat.noCode().format(this.getMinVolume().getMonetary()).toString();
                this.primaryMarketAmountDisplayString = this.cryptoFormat.noCode().format(this.getVolume().getMonetary()).toString();
                this.primaryMarketMinVolumeDisplayString = HavenoUtils.formatXmr(this.getMinAmount()).toString();
                this.primaryMarketVolumeDisplayString = HavenoUtils.formatXmr(this.getAmount()).toString();
            }
            this.primaryMarketPrice = price.getValue();
            this.primaryMarketMinAmount = this.getMinVolume().getValue();
            this.primaryMarketAmount = this.getVolume().getValue();
            this.primaryMarketMinVolume = this.getMinAmount().longValueExact();
            this.primaryMarketVolume = this.getAmount().longValueExact();
        }
        catch (Throwable t) {
            log.error("Error at setDisplayStrings: " + t.getMessage());
        }
    }

    private Price getPrice() {
        return Price.valueOf(this.currencyCode, this.price);
    }

    private BigInteger getAmount() {
        return BigInteger.valueOf(this.amount);
    }

    private BigInteger getMinAmount() {
        return BigInteger.valueOf(this.minAmount);
    }

    private Volume getVolume() {
        return this.getPrice().getVolumeByAmount(this.getAmount());
    }

    private Volume getMinVolume() {
        return this.getPrice().getVolumeByAmount(this.getMinAmount());
    }
}

