/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.filter.FilterManager;
import haveno.core.offer.Offer;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.support.dispute.arbitration.arbitrator.Arbitrator;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.network.p2p.P2PService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OfferFilterService {
    private static final Logger log = LoggerFactory.getLogger(OfferFilterService.class);
    private final User user;
    private final P2PService p2PService;
    private final Preferences preferences;
    private final FilterManager filterManager;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final Map<String, Boolean> insufficientCounterpartyTradeLimitCache = new HashMap<String, Boolean>();
    private final Map<String, Boolean> myInsufficientTradeLimitCache = new HashMap<String, Boolean>();

    @Inject
    public OfferFilterService(User user, P2PService p2PService, Preferences preferences, FilterManager filterManager, AccountAgeWitnessService accountAgeWitnessService) {
        this.user = user;
        this.p2PService = p2PService;
        this.preferences = preferences;
        this.filterManager = filterManager;
        this.accountAgeWitnessService = accountAgeWitnessService;
        if (user != null && user.getPaymentAccountsAsObservable() != null) {
            user.getPaymentAccountsAsObservable().addListener(c -> this.myInsufficientTradeLimitCache.clear());
        }
    }

    public Result canTakeOffer(Offer offer, boolean isTakerApiUser) {
        if (isTakerApiUser && this.filterManager.getFilter() != null && this.filterManager.getFilter().isDisableApi()) {
            return Result.API_DISABLED;
        }
        if (!this.hasSameProtocolVersion(offer)) {
            return Result.HAS_NOT_SAME_PROTOCOL_VERSION;
        }
        if (this.isIgnored(offer)) {
            return Result.IS_IGNORED;
        }
        if (this.isOfferBanned(offer)) {
            return Result.IS_OFFER_BANNED;
        }
        if (this.isCurrencyBanned(offer)) {
            return Result.IS_CURRENCY_BANNED;
        }
        if (this.isPaymentMethodBanned(offer)) {
            return Result.IS_PAYMENT_METHOD_BANNED;
        }
        if (this.isNodeAddressBanned(offer)) {
            return Result.IS_NODE_ADDRESS_BANNED;
        }
        if (this.requireUpdateToNewVersion()) {
            return Result.REQUIRE_UPDATE_TO_NEW_VERSION;
        }
        if (this.isInsufficientCounterpartyTradeLimit(offer)) {
            return Result.IS_INSUFFICIENT_COUNTERPARTY_TRADE_LIMIT;
        }
        if (this.isMyInsufficientTradeLimit(offer)) {
            return Result.IS_MY_INSUFFICIENT_TRADE_LIMIT;
        }
        if (!this.hasValidArbitrator(offer)) {
            return Result.ARBITRATOR_NOT_VALIDATED;
        }
        if (!this.hasValidSignature(offer)) {
            return Result.SIGNATURE_NOT_VALIDATED;
        }
        if (this.isReservedFundsSpent(offer)) {
            return Result.RESERVE_FUNDS_SPENT;
        }
        if (!this.isAnyPaymentAccountValidForOffer(offer)) {
            return Result.HAS_NO_PAYMENT_ACCOUNT_VALID_FOR_OFFER;
        }
        return Result.VALID;
    }

    public boolean isAnyPaymentAccountValidForOffer(Offer offer) {
        return this.user.getPaymentAccounts() != null && PaymentAccountUtil.isAnyPaymentAccountValidForOffer(offer, this.user.getPaymentAccounts());
    }

    public boolean hasSameProtocolVersion(Offer offer) {
        return offer.getProtocolVersion() == 3L;
    }

    public boolean isIgnored(Offer offer) {
        return this.preferences.getIgnoreTradersList().stream().anyMatch(i -> i.equals(offer.getMakerNodeAddress().getFullAddress()));
    }

    public boolean isOfferBanned(Offer offer) {
        return this.filterManager.isOfferIdBanned(offer.getId());
    }

    public boolean isCurrencyBanned(Offer offer) {
        return this.filterManager.isCurrencyBanned(offer.getCounterCurrencyCode());
    }

    public boolean isPaymentMethodBanned(Offer offer) {
        return this.filterManager.isPaymentMethodBanned(offer.getPaymentMethod());
    }

    public boolean isNodeAddressBanned(Offer offer) {
        return this.filterManager.isNodeAddressBanned(offer.getMakerNodeAddress());
    }

    public boolean requireUpdateToNewVersion() {
        return this.filterManager.requireUpdateToNewVersionForTrading();
    }

    public boolean isInsufficientCounterpartyTradeLimit(Offer offer) {
        String offerId = offer.getId();
        if (this.insufficientCounterpartyTradeLimitCache.containsKey(offerId)) {
            return this.insufficientCounterpartyTradeLimitCache.get(offerId);
        }
        boolean result = offer.isTraditionalOffer() && !this.accountAgeWitnessService.verifyPeersTradeAmount(offer, offer.getAmount(), errorMessage -> {});
        this.insufficientCounterpartyTradeLimitCache.put(offerId, result);
        return result;
    }

    public boolean isMyInsufficientTradeLimit(Offer offer) {
        String offerId = offer.getId();
        if (this.myInsufficientTradeLimitCache.containsKey(offerId)) {
            return this.myInsufficientTradeLimitCache.get(offerId);
        }
        Optional<PaymentAccount> accountOptional = PaymentAccountUtil.getMostMaturePaymentAccountForOffer(offer, this.user.getPaymentAccounts(), this.accountAgeWitnessService);
        long myTradeLimit = accountOptional.map(paymentAccount -> this.accountAgeWitnessService.getMyTradeLimit((PaymentAccount)paymentAccount, offer.getCounterCurrencyCode(), offer.getMirroredDirection(), offer.hasBuyerAsTakerWithoutDeposit())).orElse(0L);
        long offerMinAmount = offer.getMinAmount().longValueExact();
        log.debug("isInsufficientTradeLimit accountOptional={}, myTradeLimit={}, offerMinAmount={}, ", new Object[]{accountOptional.isPresent() ? accountOptional.get().getAccountName() : "null", Coin.valueOf((long)myTradeLimit).toFriendlyString(), Coin.valueOf((long)offerMinAmount).toFriendlyString()});
        boolean result = offer.isTraditionalOffer() && accountOptional.isPresent() && myTradeLimit < offerMinAmount;
        this.myInsufficientTradeLimitCache.put(offerId, result);
        return result;
    }

    private boolean hasValidArbitrator(Offer offer) {
        Arbitrator arbitrator = this.getArbitrator(offer);
        return arbitrator != null;
    }

    private Arbitrator getArbitrator(Offer offer) {
        Arbitrator arbitrator = this.user.getAcceptedArbitratorByAddress(offer.getOfferPayload().getArbitratorSigner());
        if (arbitrator != null) {
            return arbitrator;
        }
        Arbitrator thisArbitrator = this.user.getRegisteredArbitrator();
        if (thisArbitrator != null && thisArbitrator.getNodeAddress().equals((Object)offer.getOfferPayload().getArbitratorSigner())) {
            return thisArbitrator;
        }
        return null;
    }

    private boolean hasValidSignature(Offer offer) {
        Arbitrator arbitrator = this.getArbitrator(offer);
        if (arbitrator == null) {
            return false;
        }
        return HavenoUtils.isArbitratorSignatureValid(offer.getOfferPayload(), arbitrator);
    }

    public boolean isReservedFundsSpent(Offer offer) {
        return offer.isReservedFundsSpent();
    }

    public static enum Result {
        VALID(true),
        API_DISABLED,
        HAS_NO_PAYMENT_ACCOUNT_VALID_FOR_OFFER,
        HAS_NOT_SAME_PROTOCOL_VERSION,
        IS_IGNORED,
        IS_OFFER_BANNED,
        IS_CURRENCY_BANNED,
        IS_PAYMENT_METHOD_BANNED,
        IS_NODE_ADDRESS_BANNED,
        REQUIRE_UPDATE_TO_NEW_VERSION,
        IS_INSUFFICIENT_COUNTERPARTY_TRADE_LIMIT,
        IS_MY_INSUFFICIENT_TRADE_LIMIT,
        ARBITRATOR_NOT_VALIDATED,
        SIGNATURE_NOT_VALIDATED,
        RESERVE_FUNDS_SPENT;

        private final boolean isValid;

        private Result(boolean isValid) {
            this.isValid = isValid;
        }

        private Result() {
            this(false);
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

