/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import haveno.common.ThreadUtils;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.file.JsonFileManager;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.api.XmrConnectionService;
import haveno.core.filter.FilterManager;
import haveno.core.locale.Res;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferForJson;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OfferRestrictions;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.util.JsonUtil;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.XmrKeyImageListener;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.storage.HashMapChangedListener;
import haveno.network.p2p.storage.payload.ProtectedStorageEntry;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import haveno.network.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import monero.daemon.model.MoneroKeyImageSpentStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfferBookService {
    private static final Logger log = LoggerFactory.getLogger(OfferBookService.class);
    private static final long INVALID_OFFERS_TIMEOUT = 300000L;
    private final P2PService p2PService;
    private final PriceFeedService priceFeedService;
    private final List<OfferBookChangedListener> offerBookChangedListeners = new LinkedList<OfferBookChangedListener>();
    private final FilterManager filterManager;
    private final JsonFileManager jsonFileManager;
    private final XmrConnectionService xmrConnectionService;
    private final List<Offer> validOffers = new ArrayList<Offer>();
    private final List<Offer> invalidOffers = new ArrayList<Offer>();
    private final Map<String, Timer> invalidOfferTimers = new HashMap<String, Timer>();

    @Inject
    public OfferBookService(P2PService p2PService, final PriceFeedService priceFeedService, FilterManager filterManager, XmrConnectionService xmrConnectionService, @Named(value="storageDir") File storageDir, @Named(value="dumpStatistics") boolean dumpStatistics) {
        this.p2PService = p2PService;
        this.priceFeedService = priceFeedService;
        this.filterManager = filterManager;
        this.xmrConnectionService = xmrConnectionService;
        this.jsonFileManager = new JsonFileManager(storageDir);
        p2PService.addHashSetChangedListener(new HashMapChangedListener(){

            public void onAdded(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                ThreadUtils.execute(() -> protectedStorageEntries.forEach(protectedStorageEntry -> {
                    if (protectedStorageEntry.getProtectedStoragePayload() instanceof OfferPayload) {
                        OfferPayload offerPayload = (OfferPayload)protectedStorageEntry.getProtectedStoragePayload();
                        Offer offer = new Offer(offerPayload);
                        offer.setPriceFeedService(priceFeedService);
                        List<Offer> list = OfferBookService.this.validOffers;
                        synchronized (list) {
                            try {
                                OfferBookService.this.validateOfferPayload(offerPayload);
                                OfferBookService.this.replaceValidOffer(offer);
                                OfferBookService.this.announceOfferAdded(offer);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                            }
                            catch (RuntimeException e) {
                                OfferBookService.this.replaceInvalidOffer(offer);
                            }
                        }
                    }
                }), (String)OfferBookService.class.getSimpleName());
            }

            public void onRemoved(Collection<ProtectedStorageEntry> protectedStorageEntries) {
                ThreadUtils.execute(() -> protectedStorageEntries.forEach(protectedStorageEntry -> {
                    if (protectedStorageEntry.getProtectedStoragePayload() instanceof OfferPayload) {
                        OfferPayload offerPayload = (OfferPayload)protectedStorageEntry.getProtectedStoragePayload();
                        OfferBookService.this.removeValidOffer(offerPayload.getId());
                        Offer offer = new Offer(offerPayload);
                        offer.setPriceFeedService(priceFeedService);
                        OfferBookService.this.announceOfferRemoved(offer);
                        List<Offer> list = OfferBookService.this.invalidOffers;
                        synchronized (list) {
                            for (Offer invalidOffer : new ArrayList<Offer>(OfferBookService.this.invalidOffers)) {
                                try {
                                    OfferBookService.this.validateOfferPayload(invalidOffer.getOfferPayload());
                                    OfferBookService.this.removeInvalidOffer(invalidOffer.getId());
                                    OfferBookService.this.replaceValidOffer(invalidOffer);
                                    OfferBookService.this.announceOfferAdded(invalidOffer);
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }), (String)OfferBookService.class.getSimpleName());
            }
        });
        if (dumpStatistics) {
            p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

                public void onDataReceived() {
                    OfferBookService.this.addOfferBookChangedListener(new OfferBookChangedListener(){

                        @Override
                        public void onAdded(Offer offer) {
                            OfferBookService.this.doDumpStatistics();
                        }

                        @Override
                        public void onRemoved(Offer offer) {
                            OfferBookService.this.doDumpStatistics();
                        }
                    });
                    UserThread.runAfter(OfferBookService.this::doDumpStatistics, (long)1L);
                }
            });
        }
        xmrConnectionService.getKeyImagePoller().addListener(new XmrKeyImageListener(){

            @Override
            public void onSpentStatusChanged(Map<String, MoneroKeyImageSpentStatus> spentStatuses) {
                for (String keyImage : spentStatuses.keySet()) {
                    OfferBookService.this.updateAffectedOffers(keyImage);
                }
            }
        });
    }

    public boolean hasOffer(String offerId) {
        return this.hasValidOffer(offerId);
    }

    public void addOffer(Offer offer, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (this.filterManager.requireUpdateToNewVersionForTrading()) {
            errorMessageHandler.handleErrorMessage(Res.get("popup.warning.mandatoryUpdate.trading"));
            return;
        }
        boolean result = this.p2PService.addProtectedStorageEntry((ProtectedStoragePayload)offer.getOfferPayload());
        if (result) {
            resultHandler.handleResult();
        } else {
            errorMessageHandler.handleErrorMessage("Add offer failed");
        }
    }

    public void refreshTTL(OfferPayload offerPayload, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (this.filterManager.requireUpdateToNewVersionForTrading()) {
            errorMessageHandler.handleErrorMessage(Res.get("popup.warning.mandatoryUpdate.trading"));
            return;
        }
        boolean result = this.p2PService.refreshTTL((ProtectedStoragePayload)offerPayload);
        if (result) {
            resultHandler.handleResult();
        } else {
            errorMessageHandler.handleErrorMessage("Refresh TTL failed.");
        }
    }

    public void activateOffer(Offer offer, @Nullable ResultHandler resultHandler, @Nullable ErrorMessageHandler errorMessageHandler) {
        this.addOffer(offer, resultHandler, errorMessageHandler);
    }

    public void deactivateOffer(OfferPayload offerPayload, @Nullable ResultHandler resultHandler, @Nullable ErrorMessageHandler errorMessageHandler) {
        this.removeOffer(offerPayload, resultHandler, errorMessageHandler);
    }

    public void removeOffer(OfferPayload offerPayload, @Nullable ResultHandler resultHandler, @Nullable ErrorMessageHandler errorMessageHandler) {
        if (this.p2PService.removeData((ProtectedStoragePayload)offerPayload)) {
            if (resultHandler != null) {
                resultHandler.handleResult();
            }
        } else if (errorMessageHandler != null) {
            errorMessageHandler.handleErrorMessage("Remove offer failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Offer> getOffers() {
        List<Offer> list = this.validOffers;
        synchronized (list) {
            return new ArrayList<Offer>(this.validOffers);
        }
    }

    public List<Offer> getOffersByCurrency(String direction, String currencyCode) {
        return this.getOffers().stream().filter(o -> o.getOfferPayload().getCounterCurrencyCode().equalsIgnoreCase(currencyCode) && o.getDirection().name() == direction).collect(Collectors.toList());
    }

    public void removeOfferAtShutDown(OfferPayload offerPayload) {
        this.removeOffer(offerPayload, null, null);
    }

    public boolean isBootstrapped() {
        return this.p2PService.isBootstrapped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOfferBookChangedListener(OfferBookChangedListener offerBookChangedListener) {
        List<OfferBookChangedListener> list = this.offerBookChangedListeners;
        synchronized (list) {
            this.offerBookChangedListeners.add(offerBookChangedListener);
        }
    }

    public void shutDown() {
        this.xmrConnectionService.getKeyImagePoller().removeKeyImages(OfferBookService.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceOfferAdded(Offer offer) {
        this.xmrConnectionService.getKeyImagePoller().addKeyImages(offer.getOfferPayload().getReserveTxKeyImages(), OfferBookService.class.getSimpleName());
        this.updateReservedFundsSpentStatus(offer);
        List<OfferBookChangedListener> list = this.offerBookChangedListeners;
        synchronized (list) {
            this.offerBookChangedListeners.forEach(listener -> listener.onAdded(offer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceOfferRemoved(Offer offer) {
        this.updateReservedFundsSpentStatus(offer);
        this.removeKeyImages(offer);
        List<OfferBookChangedListener> list = this.offerBookChangedListeners;
        synchronized (list) {
            this.offerBookChangedListeners.forEach(listener -> listener.onRemoved(offer));
        }
    }

    private boolean hasValidOffer(String offerId) {
        for (Offer offer : this.getOffers()) {
            if (!offer.getId().equals(offerId)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceValidOffer(Offer offer) {
        List<Offer> list = this.validOffers;
        synchronized (list) {
            this.removeValidOffer(offer.getId());
            this.validOffers.add(offer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceInvalidOffer(Offer offer) {
        List<Offer> list = this.invalidOffers;
        synchronized (list) {
            this.removeInvalidOffer(offer.getId());
            this.invalidOffers.add(offer);
            Map<String, Timer> map = this.invalidOfferTimers;
            synchronized (map) {
                Timer timer = this.invalidOfferTimers.get(offer.getId());
                if (timer != null) {
                    timer.stop();
                }
                timer = UserThread.runAfter(() -> this.removeInvalidOffer(offer.getId()), (long)300000L);
                this.invalidOfferTimers.put(offer.getId(), timer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeValidOffer(String offerId) {
        List<Offer> list = this.validOffers;
        synchronized (list) {
            this.validOffers.removeIf(offer -> offer.getId().equals(offerId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidOffer(String offerId) {
        List<Offer> list = this.invalidOffers;
        synchronized (list) {
            this.invalidOffers.removeIf(offer -> offer.getId().equals(offerId));
            Map<String, Timer> map = this.invalidOfferTimers;
            synchronized (map) {
                Timer timer = this.invalidOfferTimers.get(offerId);
                if (timer != null) {
                    timer.stop();
                }
                this.invalidOfferTimers.remove(offerId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateOfferPayload(OfferPayload offerPayload) {
        boolean isV3NodeAddressCompliant;
        if (this.filterManager.isOfferIdBanned(offerPayload.getId())) {
            throw new IllegalArgumentException("Offer is banned with offerId=" + offerPayload.getId());
        }
        boolean bl = isV3NodeAddressCompliant = !OfferRestrictions.requiresNodeAddressUpdate() || Utils.isV3Address((String)offerPayload.getOwnerNodeAddress().getHostName());
        if (!isV3NodeAddressCompliant) {
            throw new IllegalArgumentException("Offer with non-V3 node address is not allowed with offerId=" + offerPayload.getId());
        }
        List<Offer> list = this.validOffers;
        synchronized (list) {
            int numOffersWithSharedKeyImages = 0;
            for (Offer offer : this.validOffers) {
                if (!offer.getOfferPayload().getReserveTxKeyImages().equals(offerPayload.getReserveTxKeyImages()) && !Collections.disjoint(offer.getOfferPayload().getReserveTxKeyImages(), offerPayload.getReserveTxKeyImages())) {
                    throw new RuntimeException("Offer with overlapping key images already exists with offerId=" + offer.getId());
                }
                if (!offer.getId().equals(offerPayload.getId()) && offer.getOfferPayload().getReserveTxKeyImages().equals(offerPayload.getReserveTxKeyImages()) && offer.getOfferPayload().getPaymentMethodId().equals(offerPayload.getPaymentMethodId()) && offer.getOfferPayload().getBaseCurrencyCode().equals(offerPayload.getBaseCurrencyCode()) && offer.getOfferPayload().getCounterCurrencyCode().equals(offerPayload.getCounterCurrencyCode())) {
                    throw new RuntimeException("Offer with same key images, payment method, and currency already exists with offerId=" + offer.getId());
                }
                if (offer.getId().equals(offerPayload.getId()) || Collections.disjoint(offer.getOfferPayload().getReserveTxKeyImages(), offerPayload.getReserveTxKeyImages())) continue;
                numOffersWithSharedKeyImages = Math.max(2, numOffersWithSharedKeyImages + 1);
            }
            if (numOffersWithSharedKeyImages > Restrictions.getMaxOffersWithSharedFunds()) {
                throw new RuntimeException("More than " + Restrictions.getMaxOffersWithSharedFunds() + " offers exist with same same key images as new offerId=" + offerPayload.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeyImages(Offer offer) {
        HashSet<String> unsharedKeyImages = new HashSet<String>(offer.getOfferPayload().getReserveTxKeyImages());
        List<Offer> list = this.validOffers;
        synchronized (list) {
            for (Offer validOffer : this.validOffers) {
                if (validOffer.getId().equals(offer.getId())) continue;
                unsharedKeyImages.removeAll(validOffer.getOfferPayload().getReserveTxKeyImages());
            }
        }
        this.xmrConnectionService.getKeyImagePoller().removeKeyImages(unsharedKeyImages, OfferBookService.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAffectedOffers(String keyImage) {
        for (Offer offer : this.getOffers()) {
            if (!offer.getOfferPayload().getReserveTxKeyImages().contains(keyImage)) continue;
            this.updateReservedFundsSpentStatus(offer);
            List<OfferBookChangedListener> list = this.offerBookChangedListeners;
            synchronized (list) {
                this.offerBookChangedListeners.forEach(listener -> {
                    listener.onRemoved(offer);
                    listener.onAdded(offer);
                });
            }
        }
    }

    private void updateReservedFundsSpentStatus(Offer offer) {
        for (String keyImage : offer.getOfferPayload().getReserveTxKeyImages()) {
            if (!Boolean.TRUE.equals(this.xmrConnectionService.getKeyImagePoller().isSpent(keyImage))) continue;
            offer.setReservedFundsSpent(true);
        }
    }

    private void doDumpStatistics() {
        List offerForJsonList = this.getOffers().stream().filter(offer -> !offer.isUseMarketBasedPrice() || this.priceFeedService.getMarketPrice(offer.getCounterCurrencyCode()) != null).map(offer -> {
            try {
                return new OfferForJson(offer.getDirection(), offer.getCounterCurrencyCode(), offer.getMinAmount(), offer.getAmount(), offer.getPrice(), offer.getDate(), offer.getId(), offer.isUseMarketBasedPrice(), offer.getMarketPriceMarginPct(), offer.getPaymentMethod());
            }
            catch (Throwable t) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        this.jsonFileManager.writeToDiscThreaded(JsonUtil.objectToJson(offerForJsonList), "offers_statistics");
    }

    public static interface OfferBookChangedListener {
        public void onAdded(Offer var1);

        public void onRemoved(Offer var1);
    }
}

