/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.common.base.Preconditions;
import haveno.common.ThreadUtils;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.PubKeyRing;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.common.proto.network.NetworkPayload;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.common.util.JsonExclude;
import haveno.common.util.MathUtils;
import haveno.common.util.Utilities;
import haveno.core.exceptions.TradePriceOutOfToleranceException;
import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.monetary.Volume;
import haveno.core.offer.MarketPriceNotAvailableException;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.availability.OfferAvailabilityModel;
import haveno.core.offer.availability.OfferAvailabilityProtocol;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.core.util.coin.CoinUtil;
import haveno.network.p2p.NodeAddress;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Offer
implements NetworkPayload,
PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(Offer.class);
    private static final double PRICE_TOLERANCE = 0.01;
    private final OfferPayload offerPayload;
    @JsonExclude
    private final transient ObjectProperty<State> stateProperty = new SimpleObjectProperty((Object)State.UNKNOWN);
    @JsonExclude
    @Nullable
    private transient OfferAvailabilityProtocol availabilityProtocol;
    @JsonExclude
    private final transient StringProperty errorMessageProperty = new SimpleStringProperty();
    @JsonExclude
    @Nullable
    private transient PriceFeedService priceFeedService;
    @Nullable
    @JsonExclude
    private transient String currencyCode;
    @JsonExclude
    private transient boolean isReservedFundsSpent;
    @JsonExclude
    @Nullable
    private transient String challenge;

    public Offer(OfferPayload offerPayload) {
        this.offerPayload = offerPayload;
    }

    public protobuf.Offer toProtoMessage() {
        return protobuf.Offer.newBuilder().setOfferPayload(this.offerPayload.toProtoMessage().getOfferPayload()).build();
    }

    public static Offer fromProto(protobuf.Offer proto) {
        return new Offer(OfferPayload.fromProto(proto.getOfferPayload()));
    }

    public synchronized void checkOfferAvailability(OfferAvailabilityModel model, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.availabilityProtocol = new OfferAvailabilityProtocol(model, () -> {
            this.cancelAvailabilityRequest();
            new Thread(() -> resultHandler.handleResult()).start();
        }, errorMessage -> {
            if (this.availabilityProtocol != null) {
                this.availabilityProtocol.cancel();
            }
            log.error(errorMessage);
            errorMessageHandler.handleErrorMessage(errorMessage);
        });
        ThreadUtils.submitToPool(() -> this.availabilityProtocol.sendOfferAvailabilityRequest());
    }

    public void cancelAvailabilityRequest() {
        if (this.availabilityProtocol != null) {
            this.availabilityProtocol.cancel();
        }
    }

    @Nullable
    public Price getPrice() {
        String counterCurrencyCode = this.getCounterCurrencyCode();
        if (!this.offerPayload.isUseMarketBasedPrice()) {
            return Price.valueOf(counterCurrencyCode, this.isInverted() ? PriceUtil.invertLongPrice(this.offerPayload.getPrice(), counterCurrencyCode) : this.offerPayload.getPrice());
        }
        Preconditions.checkNotNull((Object)this.priceFeedService, (Object)"priceFeed must not be null");
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(counterCurrencyCode);
        if (marketPrice != null && marketPrice.isRecentExternalPriceAvailable()) {
            double marketPriceMargin = this.offerPayload.getMarketPriceMarginPct();
            double factor = this.getDirection() == OfferDirection.BUY ? 1.0 - marketPriceMargin : 1.0 + marketPriceMargin;
            double marketPriceAsDouble = marketPrice.getPrice();
            double targetPriceAsDouble = marketPriceAsDouble * factor;
            try {
                int precision = CurrencyUtil.isTraditionalCurrency(counterCurrencyCode) ? 8 : 8;
                double scaled = MathUtils.scaleUpByPowerOf10((double)targetPriceAsDouble, (int)precision);
                long roundedToLong = MathUtils.roundDoubleToLong((double)scaled);
                return Price.valueOf(counterCurrencyCode, roundedToLong);
            }
            catch (Exception e) {
                log.error("Exception at getPrice / parseToFiat: " + String.valueOf(e) + "\nThat case should never happen.");
                return null;
            }
        }
        log.trace("We don't have a market price. That case could only happen if you don't have a price feed.");
        return null;
    }

    public long getFixedPrice() {
        return this.offerPayload.getPrice();
    }

    public void verifyTradePrice(long price) throws TradePriceOutOfToleranceException, MarketPriceNotAvailableException, IllegalArgumentException {
        if (!this.isUseMarketBasedPrice()) {
            Preconditions.checkArgument((price == this.getFixedPrice() ? 1 : 0) != 0, (Object)("Takers price does not match offer price. Takers price=" + price + "; offer price=" + this.getFixedPrice()));
            return;
        }
        Price tradePrice = Price.valueOf(this.getCounterCurrencyCode(), price);
        Price offerPrice = this.getPrice();
        if (offerPrice == null) {
            throw new MarketPriceNotAvailableException("Market price required for calculating trade price is not available.");
        }
        Preconditions.checkArgument((price > 0L ? 1 : 0) != 0, (Object)"takersTradePrice must be positive");
        double relation = (double)price / (double)offerPrice.getValue();
        double deviation = Math.abs(1.0 - relation);
        log.info("Price at take-offer time: id={}, currency={}, takersPrice={}, makersPrice={}, deviation={}", new Object[]{this.getShortId(), this.getCounterCurrencyCode(), price, offerPrice.getValue(), deviation * 100.0 + "%"});
        if (deviation > 0.01) {
            String msg = "Taker's trade price is too far away from our calculated price based on the market price.\ntakersPrice=" + tradePrice.getValue() + "\nmakersPrice=" + offerPrice.getValue();
            log.warn(msg);
            throw new TradePriceOutOfToleranceException(msg);
        }
    }

    @Nullable
    public Volume getVolumeByAmount(BigInteger amount, BigInteger minAmount, BigInteger maxAmount) {
        Price price = this.getPrice();
        if (price == null || amount == null) {
            return null;
        }
        BigInteger adjustedAmount = CoinUtil.getRoundedAmount(amount, price, minAmount, maxAmount, this.getCounterCurrencyCode(), this.getPaymentMethodId());
        Volume volumeByAmount = price.getVolumeByAmount(adjustedAmount);
        volumeByAmount = VolumeUtil.getAdjustedVolume(volumeByAmount, this.getPaymentMethod().getId());
        return volumeByAmount;
    }

    public void resetState() {
        this.setState(State.UNKNOWN);
    }

    public void setState(State state) {
        this.stateProperty.set((Object)state);
    }

    public ObjectProperty<State> stateProperty() {
        return this.stateProperty;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageProperty.set((Object)errorMessage);
    }

    public BigInteger getAmountNeeded() {
        BigInteger amountNeeded;
        BigInteger bigInteger = amountNeeded = this.getDirection() == OfferDirection.BUY ? this.getMaxBuyerSecurityDeposit() : this.getMaxSellerSecurityDeposit();
        if (this.getDirection() == OfferDirection.SELL) {
            amountNeeded = amountNeeded.add(this.getAmount());
        }
        amountNeeded = amountNeeded.add(this.getMaxMakerFee());
        return amountNeeded;
    }

    public BigInteger getReservedAmount() {
        if (this.offerPayload.getReserveTxKeyImages() == null) {
            return null;
        }
        return HavenoUtils.xmrWalletService.getOutputsAmount(this.offerPayload.getReserveTxKeyImages());
    }

    public BigInteger getMaxMakerFee() {
        return this.offerPayload.getMaxMakerFee();
    }

    public BigInteger getMaxBuyerSecurityDeposit() {
        return this.offerPayload.getMaxBuyerSecurityDeposit();
    }

    public BigInteger getMaxSellerSecurityDeposit() {
        return this.offerPayload.getMaxSellerSecurityDeposit();
    }

    public double getMakerFeePct() {
        return this.offerPayload.getMakerFeePct();
    }

    public double getTakerFeePct() {
        return this.offerPayload.getTakerFeePct();
    }

    public double getPenaltyFeePct() {
        return this.offerPayload.getPenaltyFeePct();
    }

    public BigInteger getMakerFee(BigInteger tradeAmount) {
        return HavenoUtils.multiply(tradeAmount, this.getMakerFeePct());
    }

    public BigInteger getTakerFee(BigInteger tradeAmount) {
        return HavenoUtils.multiply(tradeAmount, this.getTakerFeePct());
    }

    public double getBuyerSecurityDepositPct() {
        return this.offerPayload.getBuyerSecurityDepositPct();
    }

    public double getSellerSecurityDepositPct() {
        return this.offerPayload.getSellerSecurityDepositPct();
    }

    public boolean isPrivateOffer() {
        return this.offerPayload.isPrivateOffer();
    }

    public String getChallengeHash() {
        return this.offerPayload.getChallengeHash();
    }

    public boolean hasBuyerAsTakerWithoutDeposit() {
        return this.getDirection() == OfferDirection.SELL && this.getBuyerSecurityDepositPct() == 0.0;
    }

    public BigInteger getMaxTradeLimit() {
        return BigInteger.valueOf(this.offerPayload.getMaxTradeLimit());
    }

    public BigInteger getAmount() {
        return BigInteger.valueOf(this.offerPayload.getAmount());
    }

    public BigInteger getMinAmount() {
        return BigInteger.valueOf(this.offerPayload.getMinAmount());
    }

    public boolean isRange() {
        return this.offerPayload.getAmount() != this.offerPayload.getMinAmount();
    }

    public Date getDate() {
        return new Date(this.offerPayload.getDate());
    }

    public PaymentMethod getPaymentMethod() {
        return PaymentMethod.getPaymentMethodOrNA(this.offerPayload.getPaymentMethodId());
    }

    public String getShortId() {
        return Utilities.getShortId((String)this.offerPayload.getId());
    }

    @Nullable
    public Volume getVolume() {
        return this.getVolumeByAmount(this.getAmount(), this.getMinAmount(), this.getAmount());
    }

    @Nullable
    public Volume getMinVolume() {
        return this.getVolumeByAmount(this.getMinAmount(), this.getMinAmount(), this.getAmount());
    }

    public boolean isBuyOffer() {
        return this.getDirection() == OfferDirection.BUY;
    }

    public OfferDirection getMirroredDirection() {
        return this.getDirection() == OfferDirection.BUY ? OfferDirection.SELL : OfferDirection.BUY;
    }

    public boolean isMyOffer(KeyRing keyRing) {
        return this.getPubKeyRing().equals((Object)keyRing.getPubKeyRing());
    }

    public Optional<String> getAccountAgeWitnessHashAsHex() {
        Map<String, String> extraDataMap = this.getExtraDataMap();
        if (extraDataMap != null && extraDataMap.containsKey("accountAgeWitnessHash")) {
            return Optional.of(extraDataMap.get("accountAgeWitnessHash"));
        }
        return Optional.empty();
    }

    public String getF2FCity() {
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("f2fCity")) {
            return this.getExtraDataMap().get("f2fCity");
        }
        return "";
    }

    public String getCombinedExtraInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.getOfferExtraInfo() != null && !this.getOfferExtraInfo().isEmpty()) {
            sb.append(this.getOfferExtraInfo());
        }
        if (this.getPaymentAccountExtraInfo() != null && !this.getPaymentAccountExtraInfo().isEmpty()) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(this.getPaymentAccountExtraInfo());
        }
        return sb.toString();
    }

    public String getOfferExtraInfo() {
        return this.offerPayload.getExtraInfo();
    }

    public String getPaymentAccountExtraInfo() {
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("f2fExtraInfo")) {
            return this.getExtraDataMap().get("f2fExtraInfo");
        }
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("payByMailExtraInfo")) {
            return this.getExtraDataMap().get("payByMailExtraInfo");
        }
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("australiaPayidExtraInfo")) {
            return this.getExtraDataMap().get("australiaPayidExtraInfo");
        }
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("payPalExtraInfo")) {
            return this.getExtraDataMap().get("payPalExtraInfo");
        }
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("cashAppExtraInfo")) {
            return this.getExtraDataMap().get("cashAppExtraInfo");
        }
        if (this.getExtraDataMap() != null && this.getExtraDataMap().containsKey("cashAtAtmExtraInfo")) {
            return this.getExtraDataMap().get("cashAtAtmExtraInfo");
        }
        return "";
    }

    public String getPaymentMethodNameWithCountryCode() {
        Object method = this.getPaymentMethod().getShortName();
        String methodCountryCode = this.getCountryCode();
        if (methodCountryCode != null) {
            method = (String)method + " (" + methodCountryCode + ")";
        }
        return method;
    }

    public State getState() {
        return (State)((Object)this.stateProperty.get());
    }

    public ReadOnlyStringProperty errorMessageProperty() {
        return this.errorMessageProperty;
    }

    public String getErrorMessage() {
        return (String)this.errorMessageProperty.get();
    }

    public OfferDirection getDirection() {
        return this.offerPayload.getDirection();
    }

    public String getId() {
        return this.offerPayload.getId();
    }

    @Nullable
    public List<String> getAcceptedBankIds() {
        return this.offerPayload.getAcceptedBankIds();
    }

    @Nullable
    public String getBankId() {
        return this.offerPayload.getBankId();
    }

    @Nullable
    public List<String> getAcceptedCountryCodes() {
        return this.offerPayload.getAcceptedCountryCodes();
    }

    @Nullable
    public String getCountryCode() {
        return this.offerPayload.getCountryCode();
    }

    public String getBaseCurrencyCode() {
        return this.isInverted() ? this.offerPayload.getCounterCurrencyCode() : this.offerPayload.getBaseCurrencyCode();
    }

    public String getCounterCurrencyCode() {
        if (this.currencyCode != null) {
            return this.currencyCode;
        }
        this.currencyCode = this.isInverted() ? this.offerPayload.getBaseCurrencyCode() : this.offerPayload.getCounterCurrencyCode();
        return this.currencyCode;
    }

    public boolean isInverted() {
        return !this.offerPayload.getBaseCurrencyCode().equals("XMR");
    }

    public String getPaymentMethodId() {
        return this.offerPayload.getPaymentMethodId();
    }

    public long getProtocolVersion() {
        return this.offerPayload.getProtocolVersion();
    }

    public boolean isUseMarketBasedPrice() {
        return this.offerPayload.isUseMarketBasedPrice();
    }

    public double getMarketPriceMarginPct() {
        return this.offerPayload.getMarketPriceMarginPct();
    }

    public NodeAddress getMakerNodeAddress() {
        return this.offerPayload.getOwnerNodeAddress();
    }

    public PubKeyRing getPubKeyRing() {
        return this.offerPayload.getPubKeyRing();
    }

    public String getMakerPaymentAccountId() {
        return this.offerPayload.getMakerPaymentAccountId();
    }

    public String getVersionNr() {
        return this.offerPayload.getVersionNr();
    }

    public long getMaxTradePeriod() {
        return this.offerPayload.getMaxTradePeriod();
    }

    public NodeAddress getOwnerNodeAddress() {
        return this.offerPayload.getOwnerNodeAddress();
    }

    public PublicKey getOwnerPubKey() {
        return this.offerPayload.getOwnerPubKey();
    }

    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.offerPayload.getExtraDataMap();
    }

    public boolean isUseAutoClose() {
        return this.offerPayload.isUseAutoClose();
    }

    public boolean isUseReOpenAfterAutoClose() {
        return this.offerPayload.isUseReOpenAfterAutoClose();
    }

    public boolean isTraditionalOffer() {
        return CurrencyUtil.isTraditionalCurrency(this.currencyCode);
    }

    public boolean isFiatOffer() {
        return CurrencyUtil.isFiatCurrency(this.currencyCode);
    }

    public byte[] getOfferPayloadHash() {
        return this.offerPayload.getHash();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offer offer = (Offer)o;
        if (this.offerPayload != null ? !this.offerPayload.equals(offer.offerPayload) : offer.offerPayload != null) {
            return false;
        }
        if (this.getState() != offer.getState()) {
            return false;
        }
        return !(this.getErrorMessage() == null ? offer.getErrorMessage() != null : !this.getErrorMessage().equals(offer.getErrorMessage()));
    }

    public int hashCode() {
        int result = this.offerPayload != null ? this.offerPayload.hashCode() : 0;
        result = 31 * result + (this.getState() != null ? this.getState().hashCode() : 0);
        result = 31 * result + (this.getErrorMessage() != null ? this.getErrorMessage().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Offer{getErrorMessage()='" + this.getErrorMessage() + "', state=" + String.valueOf((Object)this.getState()) + ", offerPayload=" + String.valueOf(this.offerPayload) + "}";
    }

    public OfferPayload getOfferPayload() {
        return this.offerPayload;
    }

    public ObjectProperty<State> getStateProperty() {
        return this.stateProperty;
    }

    public StringProperty getErrorMessageProperty() {
        return this.errorMessageProperty;
    }

    public void setPriceFeedService(@Nullable PriceFeedService priceFeedService) {
        this.priceFeedService = priceFeedService;
    }

    public boolean isReservedFundsSpent() {
        return this.isReservedFundsSpent;
    }

    public void setReservedFundsSpent(boolean isReservedFundsSpent) {
        this.isReservedFundsSpent = isReservedFundsSpent;
    }

    @Nullable
    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(@Nullable String challenge) {
        this.challenge = challenge;
    }

    public static enum State {
        UNKNOWN,
        OFFER_FEE_RESERVED,
        AVAILABLE,
        NOT_AVAILABLE,
        REMOVED,
        MAKER_OFFLINE,
        INVALID;

    }
}

