/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.PubKeyRingProvider;
import haveno.common.util.Utilities;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferPayload;
import haveno.core.offer.OfferUtil;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountUtil;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.user.User;
import haveno.core.util.coin.CoinUtil;
import haveno.core.xmr.wallet.Restrictions;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CreateOfferService {
    private static final Logger log = LoggerFactory.getLogger(CreateOfferService.class);
    private final OfferUtil offerUtil;
    private final PriceFeedService priceFeedService;
    private final P2PService p2PService;
    private final PubKeyRingProvider pubKeyRingProvider;
    private final User user;
    private final XmrWalletService xmrWalletService;
    private final TradeStatisticsManager tradeStatisticsManager;
    private final ArbitratorManager arbitratorManager;

    @Inject
    public CreateOfferService(OfferUtil offerUtil, PriceFeedService priceFeedService, P2PService p2PService, PubKeyRingProvider pubKeyRingProvider, User user, XmrWalletService xmrWalletService, TradeStatisticsManager tradeStatisticsManager, ArbitratorManager arbitratorManager) {
        this.offerUtil = offerUtil;
        this.priceFeedService = priceFeedService;
        this.p2PService = p2PService;
        this.pubKeyRingProvider = pubKeyRingProvider;
        this.user = user;
        this.xmrWalletService = xmrWalletService;
        this.tradeStatisticsManager = tradeStatisticsManager;
        this.arbitratorManager = arbitratorManager;
    }

    public String getRandomOfferId() {
        return Utilities.getRandomPrefix((int)5, (int)8) + "-" + UUID.randomUUID().toString() + "-" + "1.2.2".replace(".", "");
    }

    public Offer createAndGetOffer(String offerId, OfferDirection direction, String currencyCode, BigInteger amount, BigInteger minAmount, Price fixedPrice, boolean useMarketBasedPrice, double marketPriceMargin, double securityDepositPct, PaymentAccount paymentAccount, boolean isPrivateOffer, boolean buyerAsTakerWithoutDeposit, String extraInfo) {
        boolean useMarketBasedPriceValue;
        log.info("Create and get offer with offerId={}, currencyCode={}, direction={}, fixedPrice={}, useMarketBasedPrice={}, marketPriceMargin={}, amount={}, minAmount={}, securityDepositPct={}, isPrivateOffer={}, buyerAsTakerWithoutDeposit={}, extraInfo={}", new Object[]{offerId, currencyCode, direction, fixedPrice == null ? null : Long.valueOf(fixedPrice.getValue()), useMarketBasedPrice, marketPriceMargin, amount, minAmount, securityDepositPct, isPrivateOffer, buyerAsTakerWithoutDeposit, extraInfo});
        if ("".equals(extraInfo)) {
            extraInfo = null;
        }
        boolean isBuyerMaker = this.offerUtil.isBuyOffer(direction);
        if (buyerAsTakerWithoutDeposit || isPrivateOffer) {
            if (isBuyerMaker) {
                throw new IllegalArgumentException("Buyer must be taker for private offers without deposit");
            }
            if (!buyerAsTakerWithoutDeposit) {
                throw new IllegalArgumentException("Must set buyer as taker without deposit for private offers");
            }
            if (!isPrivateOffer) {
                throw new IllegalArgumentException("Must set offer to private for buyer as taker without deposit");
            }
        }
        if (fixedPrice != null) {
            if (useMarketBasedPrice) {
                throw new IllegalArgumentException("Can create offer with fixed price or floating market price but not both");
            }
            if (marketPriceMargin != 0.0) {
                throw new IllegalArgumentException("Cannot set market price margin with fixed price");
            }
        }
        boolean bl = useMarketBasedPriceValue = fixedPrice == null && useMarketBasedPrice && this.isExternalPriceAvailable(currencyCode) && !PaymentMethod.isFixedPriceOnly(paymentAccount.getPaymentMethod().getId());
        if (fixedPrice == null && !useMarketBasedPriceValue) {
            throw new IllegalArgumentException("Must provide fixed price");
        }
        BigInteger maxTradeLimit = this.offerUtil.getMaxTradeLimitForRelease(paymentAccount, currencyCode, direction, buyerAsTakerWithoutDeposit);
        amount = CoinUtil.getRoundedAmount(amount, fixedPrice, Restrictions.getMinTradeAmount(), maxTradeLimit, currencyCode, paymentAccount.getPaymentMethod().getId());
        minAmount = CoinUtil.getRoundedAmount(minAmount, fixedPrice, Restrictions.getMinTradeAmount(), maxTradeLimit, currencyCode, paymentAccount.getPaymentMethod().getId());
        String challenge = null;
        String challengeHash = null;
        if (isPrivateOffer) {
            challenge = HavenoUtils.generateChallenge();
            challengeHash = HavenoUtils.getChallengeHash(challenge);
        }
        long creationTime = new Date().getTime();
        NodeAddress makerAddress = this.p2PService.getAddress();
        long priceAsLong = fixedPrice != null ? fixedPrice.getValue() : 0L;
        double marketPriceMarginParam = useMarketBasedPriceValue ? marketPriceMargin : 0.0;
        long amountAsLong = amount != null ? amount.longValueExact() : 0L;
        long minAmountAsLong = minAmount != null ? minAmount.longValueExact() : 0L;
        String baseCurrencyCode = Res.getBaseCurrencyCode();
        String counterCurrencyCode = currencyCode;
        String countryCode = PaymentAccountUtil.getCountryCode(paymentAccount);
        ArrayList<String> acceptedCountryCodes = PaymentAccountUtil.getAcceptedCountryCodes(paymentAccount);
        String bankId = PaymentAccountUtil.getBankId(paymentAccount);
        List<String> acceptedBanks = PaymentAccountUtil.getAcceptedBanks(paymentAccount);
        long maxTradePeriod = paymentAccount.getMaxTradePeriod();
        boolean hasBuyerAsTakerWithoutDeposit = !isBuyerMaker && isPrivateOffer && buyerAsTakerWithoutDeposit;
        long maxTradeLimitAsLong = this.offerUtil.getMaxTradeLimit(paymentAccount, currencyCode, direction, hasBuyerAsTakerWithoutDeposit).longValueExact();
        boolean useAutoClose = false;
        boolean useReOpenAfterAutoClose = false;
        long lowerClosePrice = 0L;
        long upperClosePrice = 0L;
        Map<String, String> extraDataMap = this.offerUtil.getExtraDataMap(paymentAccount, currencyCode, direction);
        this.offerUtil.validateOfferData(securityDepositPct, paymentAccount, currencyCode);
        OfferPayload offerPayload = new OfferPayload(offerId, creationTime, makerAddress, this.pubKeyRingProvider.get(), OfferDirection.valueOf(direction.name()), priceAsLong, marketPriceMarginParam, useMarketBasedPriceValue, amountAsLong, minAmountAsLong, HavenoUtils.getMakerFeePct(currencyCode, hasBuyerAsTakerWithoutDeposit), HavenoUtils.getTakerFeePct(currencyCode, hasBuyerAsTakerWithoutDeposit), 0.25, hasBuyerAsTakerWithoutDeposit ? 0.0 : securityDepositPct, securityDepositPct, baseCurrencyCode, counterCurrencyCode, paymentAccount.getPaymentMethod().getId(), paymentAccount.getId(), countryCode, acceptedCountryCodes, bankId, acceptedBanks, "1.2.2", this.xmrWalletService.getHeight(), maxTradeLimitAsLong, maxTradePeriod, useAutoClose, useReOpenAfterAutoClose, upperClosePrice, lowerClosePrice, isPrivateOffer, challengeHash, extraDataMap, 3, null, null, null, extraInfo);
        Offer offer = new Offer(offerPayload);
        offer.setPriceFeedService(this.priceFeedService);
        offer.setChallenge(challenge);
        return offer;
    }

    public Offer createClonedOffer(Offer sourceOffer, String currencyCode, Price fixedPrice, boolean useMarketBasedPrice, double marketPriceMargin, PaymentAccount paymentAccount, String extraInfo) {
        log.info("Cloning offer with sourceId={}, currencyCode={}, fixedPrice={}, useMarketBasedPrice={}, marketPriceMargin={}, extraInfo={}", new Object[]{sourceOffer.getId(), currencyCode, fixedPrice == null ? null : Long.valueOf(fixedPrice.getValue()), useMarketBasedPrice, marketPriceMargin, extraInfo});
        OfferPayload sourceOfferPayload = sourceOffer.getOfferPayload();
        String newOfferId = OfferUtil.getRandomOfferId();
        Offer editedOffer = this.createAndGetOffer(newOfferId, sourceOfferPayload.getDirection(), currencyCode, BigInteger.valueOf(sourceOfferPayload.getAmount()), BigInteger.valueOf(sourceOfferPayload.getMinAmount()), fixedPrice, useMarketBasedPrice, marketPriceMargin, sourceOfferPayload.getSellerSecurityDepositPct(), paymentAccount, sourceOfferPayload.isPrivateOffer(), sourceOfferPayload.isBuyerAsTakerWithoutDeposit(), extraInfo);
        String challenge = null;
        String challengeHash = null;
        if (sourceOfferPayload.isPrivateOffer()) {
            challenge = HavenoUtils.generateChallenge();
            challengeHash = HavenoUtils.getChallengeHash(challenge);
        }
        OfferPayload editedOfferPayload = editedOffer.getOfferPayload();
        long date = new Date().getTime();
        OfferPayload clonedOfferPayload = new OfferPayload(newOfferId, date, sourceOfferPayload.getOwnerNodeAddress(), sourceOfferPayload.getPubKeyRing(), sourceOfferPayload.getDirection(), editedOfferPayload.getPrice(), editedOfferPayload.getMarketPriceMarginPct(), editedOfferPayload.isUseMarketBasedPrice(), sourceOfferPayload.getAmount(), sourceOfferPayload.getMinAmount(), sourceOfferPayload.getMakerFeePct(), sourceOfferPayload.getTakerFeePct(), sourceOfferPayload.getPenaltyFeePct(), sourceOfferPayload.getBuyerSecurityDepositPct(), sourceOfferPayload.getSellerSecurityDepositPct(), editedOfferPayload.getBaseCurrencyCode(), editedOfferPayload.getCounterCurrencyCode(), editedOfferPayload.getPaymentMethodId(), editedOfferPayload.getMakerPaymentAccountId(), editedOfferPayload.getCountryCode(), editedOfferPayload.getAcceptedCountryCodes(), editedOfferPayload.getBankId(), editedOfferPayload.getAcceptedBankIds(), editedOfferPayload.getVersionNr(), sourceOfferPayload.getBlockHeightAtOfferCreation(), editedOfferPayload.getMaxTradeLimit(), editedOfferPayload.getMaxTradePeriod(), sourceOfferPayload.isUseAutoClose(), sourceOfferPayload.isUseReOpenAfterAutoClose(), sourceOfferPayload.getLowerClosePrice(), sourceOfferPayload.getUpperClosePrice(), sourceOfferPayload.isPrivateOffer(), challengeHash, editedOfferPayload.getExtraDataMap(), sourceOfferPayload.getProtocolVersion(), null, null, sourceOfferPayload.getReserveTxKeyImages(), editedOfferPayload.getExtraInfo());
        Offer clonedOffer = new Offer(clonedOfferPayload);
        clonedOffer.setPriceFeedService(this.priceFeedService);
        clonedOffer.setChallenge(challenge);
        clonedOffer.setState(Offer.State.AVAILABLE);
        return clonedOffer;
    }

    private boolean isExternalPriceAvailable(String currencyCode) {
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
        return marketPrice != null && marketPrice.isExternallyProvidedPrice();
    }
}

