/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.offer;

public enum AvailabilityResult {
    UNKNOWN_FAILURE("cannot take offer for unknown reason"),
    AVAILABLE("offer available"),
    OFFER_TAKEN("offer taken"),
    PRICE_OUT_OF_TOLERANCE("cannot take offer because taker's price is outside tolerance"),
    MARKET_PRICE_NOT_AVAILABLE("cannot take offer because market price for calculating trade price is unavailable"),
    NO_ARBITRATORS("cannot take offer because no arbitrators are available"),
    NO_MEDIATORS("cannot take offer because no mediators are available"),
    USER_IGNORED("cannot take offer because user is ignored"),
    MISSING_MANDATORY_CAPABILITY("description not available"),
    NO_REFUND_AGENTS("cannot take offer because no refund agents are available"),
    UNCONF_TX_LIMIT_HIT("cannot take offer because you have too many unconfirmed transactions at this moment"),
    MAKER_DENIED_API_USER("cannot take offer because maker is api user"),
    PRICE_CHECK_FAILED("cannot take offer because trade price check failed"),
    MAKER_DENIED_TAKER("cannot take offer because maker denied taker");

    private final String description;

    private AvailabilityResult(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public static AvailabilityResult fromProto(protobuf.AvailabilityResult proto) {
        return AvailabilityResult.valueOf(proto.name());
    }
}

