/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications.alerts.price;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.notifications.MobileMessage;
import haveno.core.notifications.MobileMessageType;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.notifications.alerts.price.PriceAlertFilter;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PriceAlert {
    private static final Logger log = LoggerFactory.getLogger(PriceAlert.class);
    private final PriceFeedService priceFeedService;
    private final MobileNotificationService mobileNotificationService;
    private final User user;

    @Inject
    public PriceAlert(PriceFeedService priceFeedService, MobileNotificationService mobileNotificationService, User user) {
        this.priceFeedService = priceFeedService;
        this.user = user;
        this.mobileNotificationService = mobileNotificationService;
    }

    public void onAllServicesInitialized() {
        this.priceFeedService.updateCounterProperty().addListener((observable, oldValue, newValue) -> this.update());
    }

    private void update() {
        PriceAlertFilter filter;
        String currencyCode;
        MarketPrice marketPrice;
        if (this.user.getPriceAlertFilter() != null && (marketPrice = this.priceFeedService.getMarketPrice(currencyCode = (filter = this.user.getPriceAlertFilter()).getCurrencyCode())) != null) {
            int exp = CurrencyUtil.isTraditionalCurrency(currencyCode) ? 8 : 8;
            double priceAsDouble = marketPrice.getPrice();
            long priceAsLong = MathUtils.roundDoubleToLong((double)MathUtils.scaleUpByPowerOf10((double)priceAsDouble, (int)exp));
            String currencyName = CurrencyUtil.getNameByCode(currencyCode);
            if (priceAsLong > filter.getHigh() || priceAsLong < filter.getLow()) {
                String msg = Res.get("account.notifications.priceAlert.message.msg", currencyName, FormattingUtils.formatMarketPrice(priceAsDouble, currencyCode), CurrencyUtil.getCurrencyPair(currencyCode));
                MobileMessage message = new MobileMessage(Res.get("account.notifications.priceAlert.message.title", currencyName), msg, MobileMessageType.PRICE);
                log.error(msg);
                try {
                    this.mobileNotificationService.sendMessage(message);
                    this.user.removePriceAlertFilter();
                }
                catch (Exception e) {
                    log.error(e.toString());
                    e.printStackTrace();
                }
            }
        }
    }

    public static MobileMessage getTestMsg() {
        String currencyCode = "USD";
        String currencyName = CurrencyUtil.getNameByCode(currencyCode);
        String msg = Res.get("account.notifications.priceAlert.message.msg", currencyName, "6023.34", "BTC/USD");
        return new MobileMessage(Res.get("account.notifications.priceAlert.message.title", currencyName), msg, MobileMessageType.PRICE);
    }
}

