/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications.alerts.market;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.crypto.KeyRing;
import haveno.common.util.MathUtils;
import haveno.core.locale.CurrencyUtil;
import haveno.core.locale.Res;
import haveno.core.monetary.Price;
import haveno.core.notifications.MobileMessage;
import haveno.core.notifications.MobileMessageType;
import haveno.core.notifications.MobileNotificationService;
import haveno.core.notifications.alerts.market.MarketAlertFilter;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OfferDirection;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.User;
import haveno.core.util.FormattingUtils;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MarketAlerts {
    private static final Logger log = LoggerFactory.getLogger(MarketAlerts.class);
    private final OfferBookService offerBookService;
    private final MobileNotificationService mobileNotificationService;
    private final User user;
    private final PriceFeedService priceFeedService;
    private final KeyRing keyRing;

    @Inject
    private MarketAlerts(OfferBookService offerBookService, MobileNotificationService mobileNotificationService, User user, PriceFeedService priceFeedService, KeyRing keyRing) {
        this.offerBookService = offerBookService;
        this.mobileNotificationService = mobileNotificationService;
        this.user = user;
        this.priceFeedService = priceFeedService;
        this.keyRing = keyRing;
    }

    public void onAllServicesInitialized() {
        this.offerBookService.addOfferBookChangedListener(new OfferBookService.OfferBookChangedListener(){

            @Override
            public void onAdded(Offer offer) {
                MarketAlerts.this.onOfferAdded(offer);
            }

            @Override
            public void onRemoved(Offer offer) {
            }
        });
        this.applyFilterOnAllOffers();
    }

    public void addMarketAlertFilter(MarketAlertFilter filter) {
        this.user.addMarketAlertFilter(filter);
        this.applyFilterOnAllOffers();
    }

    public void removeMarketAlertFilter(MarketAlertFilter filter) {
        this.user.removeMarketAlertFilter(filter);
    }

    public List<MarketAlertFilter> getMarketAlertFilters() {
        return this.user.getMarketAlertFilters();
    }

    private void applyFilterOnAllOffers() {
        this.offerBookService.getOffers().forEach(this::onOfferAdded);
    }

    private String getAlertId(Offer offer) {
        double price = offer.isUseMarketBasedPrice() ? offer.getMarketPriceMarginPct() * 10000.0 : (double)offer.getOfferPayload().getPrice();
        String priceString = String.valueOf((long)price);
        return offer.getId() + "|" + priceString;
    }

    private void onOfferAdded(Offer offer) {
        String currencyCode = offer.getCounterCurrencyCode();
        MarketPrice marketPrice = this.priceFeedService.getMarketPrice(currencyCode);
        Price offerPrice = offer.getPrice();
        if (marketPrice != null && offerPrice != null) {
            boolean isSellOffer = offer.getDirection() == OfferDirection.SELL;
            String shortOfferId = offer.getShortId();
            String alertId = this.getAlertId(offer);
            this.user.getMarketAlertFilters().stream().filter(marketAlertFilter -> !offer.isMyOffer(this.keyRing)).filter(marketAlertFilter -> offer.getPaymentMethod().equals(marketAlertFilter.getPaymentAccount().getPaymentMethod())).filter(marketAlertFilter -> marketAlertFilter.notContainsAlertId(alertId)).forEach(marketAlertFilter -> {
                boolean isTriggerForSellOfferAndTriggered;
                boolean triggered;
                int triggerValue = marketAlertFilter.getTriggerValue();
                boolean isTriggerForBuyOffer = marketAlertFilter.isBuyOffer();
                double marketPriceAsDouble1 = marketPrice.getPrice();
                int precision = CurrencyUtil.isTraditionalCurrency(currencyCode) ? 8 : 8;
                double marketPriceAsDouble = MathUtils.scaleUpByPowerOf10((double)marketPriceAsDouble1, (int)precision);
                double offerPriceValue = offerPrice.getValue();
                double ratio = offerPriceValue / marketPriceAsDouble;
                ratio = 1.0 - ratio;
                if (isSellOffer) {
                    ratio *= -1.0;
                }
                boolean bl = triggered = (ratio *= 10000.0) <= (double)triggerValue;
                if (!triggered) {
                    return;
                }
                boolean isTriggerForBuyOfferAndTriggered = !isSellOffer && isTriggerForBuyOffer;
                boolean bl2 = isTriggerForSellOfferAndTriggered = isSellOffer && !isTriggerForBuyOffer;
                if (isTriggerForBuyOfferAndTriggered || isTriggerForSellOfferAndTriggered) {
                    String direction;
                    String string = direction = isSellOffer ? Res.get("shared.sell") : Res.get("shared.buy");
                    String marketDir = isSellOffer ? (ratio > 0.0 ? Res.get("account.notifications.marketAlert.message.msg.above") : Res.get("account.notifications.marketAlert.message.msg.below")) : (ratio < 0.0 ? Res.get("account.notifications.marketAlert.message.msg.above") : Res.get("account.notifications.marketAlert.message.msg.below"));
                    ratio = Math.abs(ratio);
                    String msg = Res.get("account.notifications.marketAlert.message.msg", direction, CurrencyUtil.getCurrencyPair(currencyCode), FormattingUtils.formatPrice(offerPrice), FormattingUtils.formatToPercentWithSymbol(ratio / 10000.0), marketDir, Res.get(offer.getPaymentMethod().getId()), shortOfferId);
                    MobileMessage message = new MobileMessage(Res.get("account.notifications.marketAlert.message.title"), msg, shortOfferId, MobileMessageType.MARKET);
                    try {
                        boolean wasSent = this.mobileNotificationService.sendMessage(message);
                        if (wasSent) {
                            marketAlertFilter.addAlertId(alertId);
                            this.user.requestPersistence();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static MobileMessage getTestMsg() {
        String shortId = UUID.randomUUID().toString().substring(0, 8);
        return new MobileMessage(Res.get("account.notifications.marketAlert.message.title"), "A new 'sell BTC/USD' offer with price 6019.2744 (5.36% below market price) and payment method 'Perfect Money' was published to the Haveno offerbook.\nOffer ID: wygiaw.", shortId, MobileMessageType.MARKET);
    }
}

