/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.notifications.MobileModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MobileNotificationValidator {
    private static final Logger log = LoggerFactory.getLogger(MobileNotificationValidator.class);

    @Inject
    public MobileNotificationValidator() {
    }

    public boolean isValid(String keyAndToken) {
        if (keyAndToken == null) {
            return false;
        }
        String[] tokens = keyAndToken.split("\\|");
        if (tokens.length != 4) {
            log.error("invalid pairing ID format: not 4 sections separated by |");
            return false;
        }
        String magic = tokens[0];
        String key = tokens[2];
        String phoneId = tokens[3];
        if (key.length() != 32) {
            log.error("invalid pairing ID format: key not 32 bytes");
            return false;
        }
        if (magic.equals(MobileModel.OS.IOS.getMagicString()) || magic.equals(MobileModel.OS.IOS_DEV.getMagicString())) {
            if (phoneId.length() != 64) {
                log.error("invalid Haveno MobileModel ID format: iOS token not 64 bytes");
                return false;
            }
        } else if (magic.equals(MobileModel.OS.ANDROID.getMagicString())) {
            if (phoneId.length() < 32) {
                log.error("invalid Haveno MobileModel ID format: Android token too short (<32 bytes)");
                return false;
            }
        } else {
            log.error("invalid Haveno MobileModel ID format");
            return false;
        }
        return true;
    }
}

