/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MobileModel {
    private static final Logger log = LoggerFactory.getLogger(MobileModel.class);
    public static final String PHONE_SEPARATOR_ESCAPED = "\\|";
    public static final String PHONE_SEPARATOR_WRITING = "|";
    @Nullable
    private OS os;
    @Nullable
    private String descriptor;
    @Nullable
    private String key;
    @Nullable
    private String token;
    private boolean isContentAvailable = true;

    @Inject
    public MobileModel() {
    }

    public void reset() {
        this.os = null;
        this.key = null;
        this.token = null;
    }

    public void applyKeyAndToken(String keyAndToken) {
        log.info("applyKeyAndToken: keyAndToken={}", (Object)(keyAndToken.substring(0, 20) + "...(truncated in log for privacy reasons)"));
        String[] tokens = keyAndToken.split(PHONE_SEPARATOR_ESCAPED);
        String magic = tokens[0];
        this.descriptor = tokens[1];
        this.key = tokens[2];
        this.token = tokens[3];
        if (magic.equals(OS.IOS.getMagicString())) {
            this.os = OS.IOS;
        } else if (magic.equals(OS.IOS_DEV.getMagicString())) {
            this.os = OS.IOS_DEV;
        } else if (magic.equals(OS.ANDROID.getMagicString())) {
            this.os = OS.ANDROID;
        }
        this.isContentAvailable = this.parseDescriptor(this.descriptor);
    }

    @VisibleForTesting
    boolean parseDescriptor(String descriptor) {
        String[] descriptorTokens;
        if (descriptor != null && (descriptorTokens = descriptor.split(" ")).length >= 1) {
            String model = descriptorTokens[0];
            if (model.equals("iPhone")) {
                String versionString = descriptorTokens[1];
                String[] validVersions = new String[]{"X", "XS", "XR"};
                if (Arrays.asList(validVersions).contains(versionString)) {
                    return true;
                }
                String versionSuffix = "";
                if (versionString.matches("\\d[^\\d]")) {
                    versionSuffix = versionString.substring(1);
                    versionString = versionString.substring(0, 1);
                } else if (versionString.matches("\\d{2}[^\\d]")) {
                    versionSuffix = versionString.substring(2);
                    versionString = versionString.substring(0, 2);
                }
                try {
                    int version = Integer.parseInt(versionString);
                    return version > 6 || version == 6 && versionSuffix.equalsIgnoreCase("s");
                }
                catch (Throwable throwable) {}
            } else {
                return model.equals("iPad") && descriptorTokens[1].equals("Pro");
            }
        }
        return false;
    }

    @Nullable
    public OS getOs() {
        return this.os;
    }

    @Nullable
    public String getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public boolean isContentAvailable() {
        return this.isContentAvailable;
    }

    public void setOs(@Nullable OS os) {
        this.os = os;
    }

    public void setDescriptor(@Nullable String descriptor) {
        this.descriptor = descriptor;
    }

    public void setKey(@Nullable String key) {
        this.key = key;
    }

    public void setToken(@Nullable String token) {
        this.token = token;
    }

    public void setContentAvailable(boolean isContentAvailable) {
        this.isContentAvailable = isContentAvailable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileModel)) {
            return false;
        }
        MobileModel other = (MobileModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isContentAvailable() != other.isContentAvailable()) {
            return false;
        }
        OS this$os = this.getOs();
        OS other$os = other.getOs();
        if (this$os == null ? other$os != null : !((Object)((Object)this$os)).equals((Object)other$os)) {
            return false;
        }
        String this$descriptor = this.getDescriptor();
        String other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MobileModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContentAvailable() ? 79 : 97);
        OS $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : ((Object)((Object)$os)).hashCode());
        String $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    public String toString() {
        return "MobileModel(os=" + String.valueOf((Object)this.getOs()) + ", descriptor=" + this.getDescriptor() + ", key=" + this.getKey() + ", token=" + this.getToken() + ", isContentAvailable=" + this.isContentAvailable() + ")";
    }

    public static enum OS {
        UNDEFINED(""),
        IOS("iOS"),
        IOS_DEV("iOSDev"),
        ANDROID("android");

        private String magicString;

        private OS(String magicString) {
            this.magicString = magicString;
        }

        public String getMagicString() {
            return this.magicString;
        }
    }
}

