/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.notifications;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MobileMessageEncryption {
    private static final Logger log = LoggerFactory.getLogger(MobileMessageEncryption.class);
    private SecretKeySpec keySpec;
    private Cipher cipher;

    @Inject
    public MobileMessageEncryption() {
    }

    public void setKey(String key) {
        this.keySpec = new SecretKeySpec(key.getBytes(Charsets.UTF_8), "AES");
        try {
            this.cipher = Cipher.getInstance("AES/CBC/NOPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    public String encrypt(String valueToEncrypt, String iv) throws Exception {
        while (((String)valueToEncrypt).length() % 16 != 0) {
            valueToEncrypt = (String)valueToEncrypt + " ";
        }
        if (iv.length() != 16) {
            throw new Exception("iv not 16 characters");
        }
        IvParameterSpec ivSpec = new IvParameterSpec(iv.getBytes(Charsets.UTF_8));
        byte[] encryptedBytes = this.doEncrypt((String)valueToEncrypt, ivSpec);
        return Base64.encodeBase64String((byte[])encryptedBytes);
    }

    private byte[] doEncrypt(String text, IvParameterSpec ivSpec) throws Exception {
        byte[] encrypted;
        if (text == null || text.length() == 0) {
            throw new Exception("Empty string");
        }
        try {
            this.cipher.init(1, (Key)this.keySpec, ivSpec);
            encrypted = this.cipher.doFinal(text.getBytes(Charsets.UTF_8));
        }
        catch (Exception e) {
            throw new Exception("[encrypt] " + e.getMessage());
        }
        return encrypted;
    }
}

