/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.seed;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.Config;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.seed.SeedNodeRepository;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultSeedNodeRepository
implements SeedNodeRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultSeedNodeRepository.class);
    private static final Pattern pattern = Pattern.compile("^([a-z0-9]+\\.onion:\\d+)");
    private static final String ENDING = ".seednodes";
    private final Collection<NodeAddress> cache = new HashSet<NodeAddress>();
    private final Config config;

    @Inject
    public DefaultSeedNodeRepository(Config config) {
        this.config = config;
    }

    private void reload() {
        try {
            if (!this.config.seedNodes.isEmpty()) {
                this.cache.clear();
                this.config.seedNodes.forEach(s -> this.cache.add(new NodeAddress(s)));
                return;
            }
            this.cache.clear();
            List<NodeAddress> result = DefaultSeedNodeRepository.getSeedNodeAddressesFromPropertyFile(this.config.baseCurrencyNetwork.name().toLowerCase());
            this.cache.addAll(result);
            this.cache.removeAll(this.config.bannedSeedNodes.stream().filter(n -> !n.isEmpty()).map(NodeAddress::new).collect(Collectors.toSet()));
            log.info("Seed nodes: {}", this.cache);
        }
        catch (Throwable t) {
            log.error("exception in DefaultSeedNodeRepository", t);
            t.printStackTrace();
            throw t;
        }
    }

    public static Optional<BufferedReader> readSeedNodePropertyFile(String fileName) {
        InputStream fileInputStream = DefaultSeedNodeRepository.class.getClassLoader().getResourceAsStream(fileName + ENDING);
        if (fileInputStream == null) {
            return Optional.empty();
        }
        return Optional.of(new BufferedReader(new InputStreamReader(fileInputStream)));
    }

    public static List<NodeAddress> getSeedNodeAddressesFromPropertyFile(String fileName) {
        ArrayList<NodeAddress> list = new ArrayList<NodeAddress>();
        DefaultSeedNodeRepository.readSeedNodePropertyFile(fileName).ifPresent(seedNodeFile -> seedNodeFile.lines().forEach(line -> {
            Matcher matcher = pattern.matcher((CharSequence)line);
            if (matcher.find()) {
                list.add(new NodeAddress(matcher.group(1)));
            }
            if (line.startsWith("localhost")) {
                String[] strings = line.split(" \\(@");
                String node = strings[0];
                list.add(new NodeAddress(node));
            }
        }));
        return list;
    }

    public Collection<NodeAddress> getSeedNodeAddresses() {
        if (this.cache.isEmpty()) {
            this.reload();
        }
        return this.cache;
    }

    public boolean isSeedNode(NodeAddress nodeAddress) {
        if (this.cache.isEmpty()) {
            this.reload();
        }
        return this.cache.contains(nodeAddress);
    }
}

