/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.inventory.model;

import haveno.common.util.Tuple2;
import haveno.core.network.p2p.inventory.model.DeviationSeverity;
import haveno.core.network.p2p.inventory.model.DeviationType;
import haveno.core.network.p2p.inventory.model.InventoryItem;
import haveno.core.network.p2p.inventory.model.RequestInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class DeviationByIntegerDiff
implements DeviationType {
    private final int warnTrigger;
    private final int alertTrigger;

    public DeviationByIntegerDiff(int warnTrigger, int alertTrigger) {
        this.warnTrigger = warnTrigger;
        this.alertTrigger = alertTrigger;
    }

    public DeviationSeverity getDeviationSeverity(Collection<List<RequestInfo>> collection, @Nullable String value, InventoryItem inventoryItem) {
        DeviationSeverity deviationSeverity = DeviationSeverity.OK;
        if (value == null) {
            return deviationSeverity;
        }
        HashMap<String, Integer> sameItemsByValue = new HashMap<String, Integer>();
        collection.stream().filter(list -> !list.isEmpty()).map(list -> (RequestInfo)list.get(list.size() - 1)).map(RequestInfo::getDataMap).map(e -> ((RequestInfo.Data)e.get((Object)inventoryItem)).getValue()).filter(Objects::nonNull).forEach(e -> {
            sameItemsByValue.putIfAbsent((String)e, 0);
            int prev = (Integer)sameItemsByValue.get(e);
            sameItemsByValue.put((String)e, prev + 1);
        });
        if (sameItemsByValue.size() > 1) {
            ArrayList<Tuple2> sameItems = new ArrayList<Tuple2>();
            sameItemsByValue.forEach((k, v) -> sameItems.add(new Tuple2(k, v)));
            sameItems.sort(Comparator.comparing(o -> (Integer)o.second));
            Collections.reverse(sameItems);
            String majority = (String)((Tuple2)sameItems.get((int)0)).first;
            if (!majority.equals(value)) {
                int valueAsInt;
                int majorityAsInt = Integer.parseInt(majority);
                int diff = Math.abs(majorityAsInt - (valueAsInt = Integer.parseInt(value)));
                deviationSeverity = diff >= this.alertTrigger ? DeviationSeverity.ALERT : (diff >= this.warnTrigger ? DeviationSeverity.WARN : DeviationSeverity.OK);
            }
        }
        return deviationSeverity;
    }
}

