/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.inventory;

import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.proto.network.NetworkEnvelope;
import haveno.core.network.p2p.inventory.messages.GetInventoryRequest;
import haveno.core.network.p2p.inventory.messages.GetInventoryResponse;
import haveno.core.network.p2p.inventory.model.InventoryItem;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import haveno.network.p2p.network.MessageListener;
import haveno.network.p2p.network.NetworkNode;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInventoryRequester
implements MessageListener,
ConnectionListener {
    private static final Logger log = LoggerFactory.getLogger(GetInventoryRequester.class);
    private static final int TIMEOUT_SEC = 180;
    private final NetworkNode networkNode;
    private final NodeAddress nodeAddress;
    private final Consumer<Map<InventoryItem, String>> resultHandler;
    private final ErrorMessageHandler errorMessageHandler;
    private Timer timer;

    public GetInventoryRequester(NetworkNode networkNode, NodeAddress nodeAddress, Consumer<Map<InventoryItem, String>> resultHandler, ErrorMessageHandler errorMessageHandler) {
        this.networkNode = networkNode;
        this.nodeAddress = nodeAddress;
        this.resultHandler = resultHandler;
        this.errorMessageHandler = errorMessageHandler;
    }

    public void request() {
        this.networkNode.addMessageListener((MessageListener)this);
        this.networkNode.addConnectionListener((ConnectionListener)this);
        this.timer = UserThread.runAfter(this::onTimeOut, (long)180L);
        GetInventoryRequest getInventoryRequest = new GetInventoryRequest("1.2.2");
        this.networkNode.sendMessage(this.nodeAddress, (NetworkEnvelope)getInventoryRequest);
    }

    private void onTimeOut() {
        this.errorMessageHandler.handleErrorMessage("Request timeout");
        this.shutDown();
    }

    public void onMessage(NetworkEnvelope networkEnvelope, Connection connection) {
        if (networkEnvelope instanceof GetInventoryResponse) {
            connection.getPeersNodeAddressOptional().ifPresent(peer -> {
                if (peer.equals((Object)this.nodeAddress)) {
                    GetInventoryResponse getInventoryResponse = (GetInventoryResponse)networkEnvelope;
                    this.resultHandler.accept(getInventoryResponse.getInventory());
                    this.shutDown();
                    UserThread.runAfter(() -> connection.shutDown(CloseConnectionReason.CLOSE_REQUESTED_BY_PEER), (long)1L);
                }
            });
        }
    }

    public void shutDown() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.networkNode.removeMessageListener((MessageListener)this);
        this.networkNode.removeConnectionListener((ConnectionListener)this);
    }

    public void onConnection(Connection connection) {
    }

    public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
        connection.getPeersNodeAddressOptional().ifPresent(address -> {
            if (address.equals((Object)this.nodeAddress)) {
                if (!closeConnectionReason.isIntended) {
                    this.errorMessageHandler.handleErrorMessage("Connected closed because of " + closeConnectionReason.name());
                }
                this.shutDown();
            }
        });
    }
}

