/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.network.p2p.inventory;

import com.google.inject.Inject;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.core.network.p2p.inventory.GetInventoryRequester;
import haveno.core.network.p2p.inventory.model.InventoryItem;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.network.NetworkNode;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetInventoryRequestManager {
    private static final Logger log = LoggerFactory.getLogger(GetInventoryRequestManager.class);
    private final NetworkNode networkNode;
    private final Map<NodeAddress, GetInventoryRequester> requesterMap = new HashMap<NodeAddress, GetInventoryRequester>();

    @Inject
    public GetInventoryRequestManager(NetworkNode networkNode) {
        this.networkNode = networkNode;
    }

    public void request(NodeAddress nodeAddress, Consumer<Map<InventoryItem, String>> resultHandler, ErrorMessageHandler errorMessageHandler) {
        if (this.requesterMap.containsKey(nodeAddress)) {
            log.warn("There was still a pending request for {}. We shut it down and make a new request", (Object)nodeAddress.getFullAddress());
            this.requesterMap.get(nodeAddress).shutDown();
        }
        GetInventoryRequester getInventoryRequester = new GetInventoryRequester(this.networkNode, nodeAddress, resultMap -> {
            this.requesterMap.remove(nodeAddress);
            resultHandler.accept((Map<InventoryItem, String>)resultMap);
        }, errorMessage -> {
            this.requesterMap.remove(nodeAddress);
            errorMessageHandler.handleErrorMessage(errorMessage);
        });
        this.requesterMap.put(nodeAddress, getInventoryRequester);
        getInventoryRequester.request();
    }

    public void shutDown() {
        this.requesterMap.values().forEach(GetInventoryRequester::shutDown);
        this.requesterMap.clear();
    }
}

