/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.CryptoMoney;
import haveno.core.monetary.MonetaryWrapper;
import haveno.core.monetary.TraditionalMoney;
import haveno.core.util.ParsingUtils;
import org.bitcoinj.core.Monetary;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Volume
extends MonetaryWrapper
implements Comparable<Volume> {
    private static final Logger log = LoggerFactory.getLogger(Volume.class);

    public Volume(Monetary monetary) {
        super(monetary);
    }

    public static Volume parse(String input, String currencyCode) {
        String cleaned = ParsingUtils.convertCharsForNumber(input);
        if (CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            return new Volume(TraditionalMoney.parseTraditionalMoney(currencyCode, cleaned));
        }
        return new Volume(CryptoMoney.parseCrypto(currencyCode, cleaned));
    }

    @Override
    public int compareTo(@NotNull Volume other) {
        if (!this.getCurrencyCode().equals(other.getCurrencyCode())) {
            return this.getCurrencyCode().compareTo(other.getCurrencyCode());
        }
        if (this.getValue() != other.getValue()) {
            return this.getValue() > other.getValue() ? 1 : -1;
        }
        return 0;
    }

    public String getCurrencyCode() {
        return this.monetary instanceof CryptoMoney ? ((CryptoMoney)this.monetary).getCurrencyCode() : ((TraditionalMoney)this.monetary).getCurrencyCode();
    }

    public String toPlainString() {
        return this.monetary instanceof CryptoMoney ? ((CryptoMoney)this.monetary).toPlainString() : ((TraditionalMoney)this.monetary).toPlainString();
    }

    public String toString() {
        return this.toPlainString();
    }
}

