/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Longs;
import java.io.Serializable;
import java.math.BigDecimal;
import org.bitcoinj.core.Monetary;
import org.bitcoinj.utils.MonetaryFormat;

public final class TraditionalMoney
implements Monetary,
Comparable<TraditionalMoney>,
Serializable {
    public static final int SMALLEST_UNIT_EXPONENT = 8;
    public final long value;
    public final String currencyCode;
    private static final MonetaryFormat FRIENDLY_FORMAT = MonetaryFormat.FIAT.postfixCode();
    private static final MonetaryFormat PLAIN_FORMAT = MonetaryFormat.FIAT.minDecimals(0).repeatOptionalDecimals(1, 8).noCode();

    private TraditionalMoney(String currencyCode, long value) {
        this.value = value;
        this.currencyCode = currencyCode;
    }

    public static TraditionalMoney valueOf(String currencyCode, long value) {
        return new TraditionalMoney(currencyCode, value);
    }

    public int smallestUnitExponent() {
        return 8;
    }

    public long getValue() {
        return this.value;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public static TraditionalMoney parseTraditionalMoney(String currencyCode, String str) {
        try {
            long val = new BigDecimal(str).movePointRight(8).longValueExact();
            return TraditionalMoney.valueOf(currencyCode, val);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TraditionalMoney parseTraditionalMoneyInexact(String currencyCode, String str) {
        try {
            long val = new BigDecimal(str).movePointRight(8).longValue();
            return TraditionalMoney.valueOf(currencyCode, val);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public TraditionalMoney add(TraditionalMoney value) {
        Preconditions.checkArgument((boolean)value.currencyCode.equals(this.currencyCode));
        return new TraditionalMoney(this.currencyCode, LongMath.checkedAdd((long)this.value, (long)value.value));
    }

    public TraditionalMoney subtract(TraditionalMoney value) {
        Preconditions.checkArgument((boolean)value.currencyCode.equals(this.currencyCode));
        return new TraditionalMoney(this.currencyCode, LongMath.checkedSubtract((long)this.value, (long)value.value));
    }

    public TraditionalMoney multiply(long factor) {
        return new TraditionalMoney(this.currencyCode, LongMath.checkedMultiply((long)this.value, (long)factor));
    }

    public TraditionalMoney divide(long divisor) {
        return new TraditionalMoney(this.currencyCode, this.value / divisor);
    }

    public TraditionalMoney[] divideAndRemainder(long divisor) {
        return new TraditionalMoney[]{new TraditionalMoney(this.currencyCode, this.value / divisor), new TraditionalMoney(this.currencyCode, this.value % divisor)};
    }

    public long divide(TraditionalMoney divisor) {
        Preconditions.checkArgument((boolean)divisor.currencyCode.equals(this.currencyCode));
        return this.value / divisor.value;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isGreaterThan(TraditionalMoney other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(TraditionalMoney other) {
        return this.compareTo(other) < 0;
    }

    public int signum() {
        if (this.value == 0L) {
            return 0;
        }
        return this.value < 0L ? -1 : 1;
    }

    public TraditionalMoney negate() {
        return new TraditionalMoney(this.currencyCode, -this.value);
    }

    public long longValue() {
        return this.value;
    }

    public String toFriendlyString() {
        return FRIENDLY_FORMAT.code(0, this.currencyCode).format((Monetary)this).toString();
    }

    public String toPlainString() {
        return PLAIN_FORMAT.format((Monetary)this).toString();
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TraditionalMoney other = (TraditionalMoney)o;
        return this.value == other.value && this.currencyCode.equals(other.currencyCode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.currencyCode});
    }

    @Override
    public int compareTo(TraditionalMoney other) {
        if (!this.currencyCode.equals(other.currencyCode)) {
            return this.currencyCode.compareTo(other.currencyCode);
        }
        return Longs.compare((long)this.value, (long)other.value);
    }
}

