/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import haveno.core.monetary.TraditionalMoney;
import java.io.Serializable;
import java.math.BigInteger;
import org.bitcoinj.core.Coin;

public class TraditionalExchangeRate
implements Serializable {
    public final Coin coin;
    public final TraditionalMoney traditionalMoney;

    public TraditionalExchangeRate(Coin coin, TraditionalMoney traditionalMoney) {
        Preconditions.checkArgument((boolean)coin.isPositive());
        Preconditions.checkArgument((boolean)traditionalMoney.isPositive());
        Preconditions.checkArgument((traditionalMoney.currencyCode != null ? 1 : 0) != 0, (Object)"currency code required");
        this.coin = coin;
        this.traditionalMoney = traditionalMoney;
    }

    public TraditionalExchangeRate(TraditionalMoney traditionalMoney) {
        this(Coin.COIN, traditionalMoney);
    }

    public TraditionalMoney coinToTraditionalMoney(Coin convertCoin) {
        BigInteger converted = BigInteger.valueOf(convertCoin.value).multiply(BigInteger.valueOf(this.traditionalMoney.value)).divide(BigInteger.valueOf(this.coin.value));
        if (converted.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || converted.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return TraditionalMoney.valueOf(this.traditionalMoney.currencyCode, converted.longValue());
    }

    public Coin traditionalMoneyToCoin(TraditionalMoney convertTraditionalMoney) {
        Preconditions.checkArgument((boolean)convertTraditionalMoney.currencyCode.equals(this.traditionalMoney.currencyCode), (String)"Currency mismatch: %s vs %s", (Object)convertTraditionalMoney.currencyCode, (Object)this.traditionalMoney.currencyCode);
        BigInteger converted = BigInteger.valueOf(convertTraditionalMoney.value).multiply(BigInteger.valueOf(this.coin.value)).divide(BigInteger.valueOf(this.traditionalMoney.value));
        if (converted.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || converted.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Overflow");
        }
        try {
            return Coin.valueOf((long)converted.longValue());
        }
        catch (IllegalArgumentException x) {
            throw new ArithmeticException("Overflow: " + x.getMessage());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraditionalExchangeRate other = (TraditionalExchangeRate)o;
        return Objects.equal((Object)this.coin, (Object)other.coin) && Objects.equal((Object)this.traditionalMoney, (Object)other.traditionalMoney);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.coin, this.traditionalMoney});
    }
}

