/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.CryptoExchangeRate;
import haveno.core.monetary.CryptoMoney;
import haveno.core.monetary.MonetaryWrapper;
import haveno.core.monetary.TraditionalExchangeRate;
import haveno.core.monetary.TraditionalMoney;
import haveno.core.monetary.Volume;
import haveno.core.trade.HavenoUtils;
import haveno.core.util.ParsingUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.bitcoinj.core.Monetary;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Price
extends MonetaryWrapper
implements Comparable<Price> {
    private static final Logger log = LoggerFactory.getLogger(Price.class);

    public Price(Monetary monetary) {
        super(monetary);
    }

    public static Price parse(String currencyCode, String input) {
        String cleaned = ParsingUtils.convertCharsForNumber(input);
        if (CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            return new Price(TraditionalMoney.parseTraditionalMoney(currencyCode, cleaned));
        }
        return new Price(CryptoMoney.parseCrypto(currencyCode, cleaned));
    }

    public static Price valueOf(String currencyCode, long value) {
        if (CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            return new Price(TraditionalMoney.valueOf(currencyCode, value));
        }
        return new Price(CryptoMoney.valueOf(currencyCode, value));
    }

    public Volume getVolumeByAmount(BigInteger amount) {
        if (this.monetary instanceof TraditionalMoney) {
            return new Volume(new TraditionalExchangeRate((TraditionalMoney)this.monetary).coinToTraditionalMoney(HavenoUtils.atomicUnitsToCoin(amount)));
        }
        if (this.monetary instanceof CryptoMoney) {
            return new Volume(new CryptoExchangeRate((CryptoMoney)this.monetary).coinToCrypto(HavenoUtils.atomicUnitsToCoin(amount)));
        }
        throw new IllegalStateException("Monetary must be either of type TraditionalMoney or CryptoMoney");
    }

    public BigInteger getAmountByVolume(Volume volume) {
        Monetary monetary = volume.getMonetary();
        if (monetary instanceof TraditionalMoney && this.monetary instanceof TraditionalMoney) {
            return HavenoUtils.coinToAtomicUnits(new TraditionalExchangeRate((TraditionalMoney)this.monetary).traditionalMoneyToCoin((TraditionalMoney)monetary));
        }
        if (monetary instanceof CryptoMoney && this.monetary instanceof CryptoMoney) {
            return HavenoUtils.coinToAtomicUnits(new CryptoExchangeRate((CryptoMoney)this.monetary).cryptoToCoin((CryptoMoney)monetary));
        }
        return BigInteger.ZERO;
    }

    public String getCurrencyCode() {
        return this.monetary instanceof CryptoMoney ? ((CryptoMoney)this.monetary).getCurrencyCode() : ((TraditionalMoney)this.monetary).getCurrencyCode();
    }

    @Override
    public long getValue() {
        return this.monetary.getValue();
    }

    public double getDoubleValue() {
        return BigDecimal.valueOf(this.monetary.getValue()).movePointLeft(this.monetary.smallestUnitExponent()).doubleValue();
    }

    @Override
    public int compareTo(@NotNull Price other) {
        if (!this.getCurrencyCode().equals(other.getCurrencyCode())) {
            return this.getCurrencyCode().compareTo(other.getCurrencyCode());
        }
        if (this.getValue() != other.getValue()) {
            return this.getValue() > other.getValue() ? 1 : -1;
        }
        return 0;
    }

    public boolean isPositive() {
        return this.monetary instanceof CryptoMoney ? ((CryptoMoney)this.monetary).isPositive() : ((TraditionalMoney)this.monetary).isPositive();
    }

    public Price subtract(Price other) {
        if (this.monetary instanceof CryptoMoney) {
            return new Price(((CryptoMoney)this.monetary).subtract((CryptoMoney)other.monetary));
        }
        return new Price(((TraditionalMoney)this.monetary).subtract((TraditionalMoney)other.monetary));
    }

    public String toFriendlyString() {
        return this.monetary instanceof CryptoMoney ? ((CryptoMoney)this.monetary).toFriendlyString().replace(((CryptoMoney)this.monetary).currencyCode, "") + "XMR/" + ((CryptoMoney)this.monetary).currencyCode : ((TraditionalMoney)this.monetary).toFriendlyString().replace(((TraditionalMoney)this.monetary).currencyCode, "") + "XMR/" + ((TraditionalMoney)this.monetary).currencyCode;
    }

    public String toPlainString() {
        return this.monetary instanceof CryptoMoney ? ((CryptoMoney)this.monetary).toPlainString() : ((TraditionalMoney)this.monetary).toPlainString();
    }

    public String toString() {
        return this.toPlainString();
    }
}

