/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import haveno.core.util.ParsingUtils;
import java.math.BigDecimal;
import org.bitcoinj.core.Monetary;
import org.bitcoinj.utils.MonetaryFormat;
import org.jetbrains.annotations.NotNull;

public final class CryptoMoney
implements Monetary,
Comparable<CryptoMoney> {
    public static final int SMALLEST_UNIT_EXPONENT = 8;
    private static final MonetaryFormat FRIENDLY_FORMAT = new MonetaryFormat().shift(0).minDecimals(2).repeatOptionalDecimals(2, 1).postfixCode();
    private static final MonetaryFormat PLAIN_FORMAT = new MonetaryFormat().shift(0).minDecimals(0).repeatOptionalDecimals(1, 8).noCode();
    public final long value;
    public final String currencyCode;

    private CryptoMoney(String currencyCode, long value) {
        this.value = value;
        this.currencyCode = currencyCode;
    }

    public static CryptoMoney valueOf(String currencyCode, long value) {
        return new CryptoMoney(currencyCode, value);
    }

    public int smallestUnitExponent() {
        return 8;
    }

    public long getValue() {
        return this.value;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public static CryptoMoney parseCrypto(String currencyCode, String input) {
        String cleaned = ParsingUtils.convertCharsForNumber(input);
        try {
            long val = new BigDecimal(cleaned).movePointRight(8).toBigIntegerExact().longValue();
            return CryptoMoney.valueOf(currencyCode, val);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public CryptoMoney add(CryptoMoney value) {
        Preconditions.checkArgument((boolean)value.currencyCode.equals(this.currencyCode));
        return new CryptoMoney(this.currencyCode, LongMath.checkedAdd((long)this.value, (long)value.value));
    }

    public CryptoMoney subtract(CryptoMoney value) {
        Preconditions.checkArgument((boolean)value.currencyCode.equals(this.currencyCode));
        return new CryptoMoney(this.currencyCode, LongMath.checkedSubtract((long)this.value, (long)value.value));
    }

    public CryptoMoney multiply(long factor) {
        return new CryptoMoney(this.currencyCode, LongMath.checkedMultiply((long)this.value, (long)factor));
    }

    public CryptoMoney divide(long divisor) {
        return new CryptoMoney(this.currencyCode, this.value / divisor);
    }

    public CryptoMoney[] divideAndRemainder(long divisor) {
        return new CryptoMoney[]{new CryptoMoney(this.currencyCode, this.value / divisor), new CryptoMoney(this.currencyCode, this.value % divisor)};
    }

    public long divide(CryptoMoney divisor) {
        Preconditions.checkArgument((boolean)divisor.currencyCode.equals(this.currencyCode));
        return this.value / divisor.value;
    }

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public boolean isZero() {
        return this.signum() == 0;
    }

    public boolean isGreaterThan(CryptoMoney other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(CryptoMoney other) {
        return this.compareTo(other) < 0;
    }

    public int signum() {
        if (this.value == 0L) {
            return 0;
        }
        return this.value < 0L ? -1 : 1;
    }

    public CryptoMoney negate() {
        return new CryptoMoney(this.currencyCode, -this.value);
    }

    public String toFriendlyString() {
        return FRIENDLY_FORMAT.code(0, this.currencyCode).format((Monetary)this).toString();
    }

    public String toPlainString() {
        return PLAIN_FORMAT.format((Monetary)this).toString();
    }

    public String toString() {
        return this.toPlainString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        CryptoMoney other = (CryptoMoney)o;
        return this.value == other.value && this.currencyCode.equals(other.currencyCode);
    }

    public int hashCode() {
        return (int)this.value + 37 * this.currencyCode.hashCode();
    }

    @Override
    public int compareTo(@NotNull CryptoMoney other) {
        if (!this.currencyCode.equals(other.currencyCode)) {
            return this.currencyCode.compareTo(other.currencyCode);
        }
        if (this.value != other.value) {
            return this.value > other.value ? 1 : -1;
        }
        return 0;
    }
}

