/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.monetary;

import com.google.common.base.Preconditions;
import haveno.core.monetary.CryptoMoney;
import java.math.BigInteger;
import org.bitcoinj.core.Coin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoExchangeRate {
    private static final Logger log = LoggerFactory.getLogger(CryptoExchangeRate.class);
    public final Coin coin;
    public final CryptoMoney cryptoMoney;

    public CryptoExchangeRate(Coin coin, CryptoMoney crypto) {
        Preconditions.checkArgument((boolean)coin.isPositive());
        Preconditions.checkArgument((boolean)crypto.isPositive());
        Preconditions.checkArgument((crypto.currencyCode != null ? 1 : 0) != 0, (Object)"currency code required");
        this.coin = coin;
        this.cryptoMoney = crypto;
    }

    public CryptoExchangeRate(CryptoMoney crypto) {
        this(Coin.COIN, crypto);
    }

    public CryptoMoney coinToCrypto(Coin convertCoin) {
        BigInteger converted = BigInteger.valueOf(convertCoin.value).multiply(BigInteger.valueOf(this.cryptoMoney.value)).divide(BigInteger.valueOf(this.coin.value));
        if (converted.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || converted.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return CryptoMoney.valueOf(this.cryptoMoney.currencyCode, converted.longValue());
    }

    public Coin cryptoToCoin(CryptoMoney convertCrypto) {
        Preconditions.checkArgument((boolean)convertCrypto.currencyCode.equals(this.cryptoMoney.currencyCode), (String)"Currency mismatch: %s vs %s", (Object)convertCrypto.currencyCode, (Object)this.cryptoMoney.currencyCode);
        BigInteger converted = BigInteger.valueOf(convertCrypto.value).multiply(BigInteger.valueOf(this.coin.value)).divide(BigInteger.valueOf(this.cryptoMoney.value));
        if (converted.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0 || converted.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) < 0) {
            throw new ArithmeticException("Overflow");
        }
        try {
            return Coin.valueOf((long)converted.longValue());
        }
        catch (IllegalArgumentException x) {
            throw new ArithmeticException("Overflow: " + x.getMessage());
        }
    }
}

