/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import haveno.common.proto.ProtobufferRuntimeException;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.TraditionalCurrency;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.TradeCurrency;

public abstract class TradeCurrency
implements PersistablePayload,
Comparable<TradeCurrency> {
    private static final Logger log = LoggerFactory.getLogger(TradeCurrency.class);
    protected final String code;
    protected final String name;

    public TradeCurrency(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static TradeCurrency fromProto(protobuf.TradeCurrency proto) {
        switch (proto.getMessageCase()) {
            case TRADITIONAL_CURRENCY: {
                return TraditionalCurrency.fromProto(proto);
            }
            case CRYPTO_CURRENCY: {
                return CryptoCurrency.fromProto(proto);
            }
        }
        throw new ProtobufferRuntimeException("Unknown message case: " + String.valueOf(proto.getMessageCase()));
    }

    public TradeCurrency.Builder getTradeCurrencyBuilder() {
        return protobuf.TradeCurrency.newBuilder().setCode(this.code).setName(this.name);
    }

    public String getDisplayPrefix() {
        return "";
    }

    public String getNameAndCode() {
        return this.name + " (" + this.code + ")";
    }

    public String getCodeAndName() {
        return this.code + " (" + this.name + ")";
    }

    @Override
    public int compareTo(@NotNull TradeCurrency other) {
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TradeCurrency) {
            TradeCurrency other = (TradeCurrency)obj;
            return this.code.equals(other.code);
        }
        return false;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public String toString() {
        return "TradeCurrency(code=" + this.getCode() + ", name=" + this.getName() + ")";
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

