/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.util.Utilities;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.UTF8Control;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Res {
    private static final Logger log = LoggerFactory.getLogger(Res.class);
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n.displayStrings", GlobalSettings.getLocale(), new UTF8Control());
    private static String baseCurrencyCode;
    private static String baseCurrencyName;
    private static String baseCurrencyNameLowerCase;

    public static void setup() {
        BaseCurrencyNetwork baseCurrencyNetwork = Config.baseCurrencyNetwork();
        Res.setBaseCurrencyCode(baseCurrencyNetwork.getCurrencyCode());
        Res.setBaseCurrencyName(baseCurrencyNetwork.getCurrencyName());
    }

    public static String getWithCol(String key) {
        return Res.get(key) + ":";
    }

    public static String getWithColAndCap(String key) {
        return StringUtils.capitalize((String)Res.get(key)) + ":";
    }

    public static ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static void setBaseCurrencyCode(String baseCurrencyCode) {
        Res.baseCurrencyCode = baseCurrencyCode;
    }

    public static void setBaseCurrencyName(String baseCurrencyName) {
        Res.baseCurrencyName = baseCurrencyName;
        baseCurrencyNameLowerCase = baseCurrencyName.toLowerCase();
    }

    public static String getBaseCurrencyCode() {
        return baseCurrencyCode;
    }

    public static String getBaseCurrencyName() {
        return baseCurrencyName;
    }

    public static String getWithCap(String key) {
        return StringUtils.capitalize((String)Res.get(key));
    }

    public static String getWithCol(String key, Object ... arguments) {
        return Res.get(key, arguments) + ":";
    }

    public static String get(String key, Object ... arguments) {
        return MessageFormat.format(Res.escapeQuotes(Res.get(key)), arguments);
    }

    private static String escapeQuotes(String s) {
        return s.replace("'", "''");
    }

    public static String get(String key) {
        try {
            return resourceBundle.getString(key).replace("XMR", baseCurrencyCode).replace("Monero", baseCurrencyName).replace("monero", baseCurrencyNameLowerCase);
        }
        catch (MissingResourceException e) {
            log.warn("Missing resource for key: {}", (Object)key);
            if (DevEnv.isDevMode()) {
                e.printStackTrace();
                UserThread.runAfter(() -> {
                    throw new RuntimeException("Missing resource for key: " + key);
                }, (long)1L);
            }
            return key;
        }
    }

    public static List<String> getWrappedAsList(String key, int wrapLength) {
        String[] raw = Res.get(key).split("\n");
        ArrayList<String> wrapped = new ArrayList<String>();
        for (String s : raw) {
            List list = Utilities.toListOfWrappedStrings((String)s, (int)wrapLength);
            for (String line : list) {
                if (line.isEmpty()) continue;
                wrapped.add(line);
            }
        }
        return wrapped;
    }

    static {
        GlobalSettings.localeProperty().addListener((observable, oldValue, newValue) -> {
            if ("en".equalsIgnoreCase(newValue.getLanguage())) {
                newValue = Locale.ROOT;
            }
            resourceBundle = ResourceBundle.getBundle("i18n.displayStrings", newValue, new UTF8Control());
        });
    }
}

