/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import haveno.core.locale.GlobalSettings;
import haveno.core.locale.LocaleUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageUtil {
    private static final Logger log = LoggerFactory.getLogger(LanguageUtil.class);
    private static final List<String> userLanguageCodes = Arrays.asList("en", "de", "es", "pt", "pt-BR", "zh-Hans", "zh-Hant", "ru", "fr", "vi", "th", "ja", "fa", "it", "cs", "pl", "tr");
    private static final List<String> rtlLanguagesCodes = Arrays.asList("fa", "ar", "iw");

    public static List<String> getAllLanguageCodes() {
        List<Locale> allLocales = LocaleUtil.getAllLocales();
        Set allLocalesAsSet = allLocales.stream().filter(locale -> !locale.getLanguage().isEmpty() && !locale.getDisplayLanguage().isEmpty()).map(Locale::getLanguage).collect(Collectors.toSet());
        ArrayList<String> allLanguageCodes = new ArrayList<String>();
        allLanguageCodes.addAll(allLocalesAsSet);
        allLanguageCodes.sort((o1, o2) -> LanguageUtil.getDisplayName(o1).compareTo(LanguageUtil.getDisplayName(o2)));
        return allLanguageCodes;
    }

    public static String getDefaultLanguage() {
        return LanguageUtil.getLocale().getLanguage();
    }

    public static String getDefaultLanguageLocaleAsCode() {
        return new Locale(LanguageUtil.getDefaultLanguage()).getLanguage();
    }

    public static String getEnglishLanguageLocaleCode() {
        return new Locale(Locale.ENGLISH.getLanguage()).getLanguage();
    }

    public static String getDisplayName(String code) {
        Locale locale = Locale.forLanguageTag(code);
        return locale.getDisplayName(locale);
    }

    public static boolean isDefaultLanguageRTL() {
        return rtlLanguagesCodes.contains(LanguageUtil.getDefaultLanguageLocaleAsCode());
    }

    public static List<String> getUserLanguageCodes() {
        return userLanguageCodes;
    }

    private static Locale getLocale() {
        return GlobalSettings.getLocale();
    }
}

