/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import com.google.common.base.Suppliers;
import haveno.asset.Asset;
import haveno.asset.AssetRegistry;
import haveno.asset.Coin;
import haveno.asset.Token;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.core.filter.FilterManager;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.CryptoCurrency;
import haveno.core.locale.GlobalSettings;
import haveno.core.locale.LanguageUtil;
import haveno.core.locale.Res;
import haveno.core.locale.TradeCurrency;
import haveno.core.locale.TraditionalCurrency;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyUtil {
    private static final Logger log = LoggerFactory.getLogger(CurrencyUtil.class);
    private static final AssetRegistry assetRegistry = new AssetRegistry();
    private static String baseCurrencyCode = "XMR";
    private static final Map<String, Boolean> isTraditionalCurrencyMap = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> isCryptoCurrencyMap = new ConcurrentHashMap<String, Boolean>();
    private static final Supplier<Map<String, TraditionalCurrency>> traditionalCurrencyMapSupplier = Suppliers.memoize(CurrencyUtil::createTraditionalCurrencyMap);
    private static final Supplier<Map<String, CryptoCurrency>> cryptoCurrencyMapSupplier = Suppliers.memoize(CurrencyUtil::createCryptoCurrencyMap);

    public static void setup() {
        CurrencyUtil.setBaseCurrencyCode(baseCurrencyCode);
    }

    public static void setBaseCurrencyCode(String baseCurrencyCode) {
        CurrencyUtil.baseCurrencyCode = baseCurrencyCode;
    }

    public static Collection<TraditionalCurrency> getAllSortedFiatCurrencies(Comparator comparator) {
        return CurrencyUtil.getAllSortedTraditionalCurrencies(comparator).stream().filter(currency -> CurrencyUtil.isFiatCurrency(currency.getCode())).collect(Collectors.toList());
    }

    public static List<TradeCurrency> getAllFiatCurrencies() {
        return CurrencyUtil.getAllTraditionalCurrencies().stream().filter(currency -> CurrencyUtil.isFiatCurrency(currency.getCode())).collect(Collectors.toList());
    }

    public static List<TradeCurrency> getAllSortedFiatCurrencies() {
        return CurrencyUtil.getAllSortedTraditionalCurrencies().stream().filter(currency -> CurrencyUtil.isFiatCurrency(currency.getCode())).collect(Collectors.toList());
    }

    public static Collection<TraditionalCurrency> getAllSortedTraditionalCurrencies() {
        return traditionalCurrencyMapSupplier.get().values();
    }

    public static List<TradeCurrency> getAllTraditionalCurrencies() {
        return new ArrayList<TradeCurrency>(traditionalCurrencyMapSupplier.get().values());
    }

    public static List<TraditionalCurrency> getTraditionalNonFiatCurrencies() {
        return Arrays.asList(new TraditionalCurrency("XAG", "Silver"), new TraditionalCurrency("XAU", "Gold"), new TraditionalCurrency("XGB", "Goldback"));
    }

    public static Collection<TraditionalCurrency> getAllSortedTraditionalCurrencies(Comparator comparator) {
        return CurrencyUtil.getAllSortedTraditionalCurrencies().stream().sorted(comparator).collect(Collectors.toList());
    }

    private static Map<String, TraditionalCurrency> createTraditionalCurrencyMap() {
        List currencies = CountryUtil.getAllCountries().stream().map(country -> CurrencyUtil.getCurrencyByCountryCode(country.code)).collect(Collectors.toList());
        currencies.addAll(CurrencyUtil.getTraditionalNonFiatCurrencies());
        return currencies.stream().sorted(TradeCurrency::compareTo).distinct().collect(Collectors.toMap(TradeCurrency::getCode, Function.identity(), (x, y) -> x, LinkedHashMap::new));
    }

    public static List<TraditionalCurrency> getMainFiatCurrencies() {
        ArrayList<TraditionalCurrency> list = new ArrayList<TraditionalCurrency>();
        list.add(new TraditionalCurrency("USD"));
        list.add(new TraditionalCurrency("EUR"));
        list.add(new TraditionalCurrency("GBP"));
        list.add(new TraditionalCurrency("CAD"));
        list.add(new TraditionalCurrency("AUD"));
        list.add(new TraditionalCurrency("RUB"));
        list.add(new TraditionalCurrency("INR"));
        list.add(new TraditionalCurrency("NGN"));
        CurrencyUtil.postProcessTraditionalCurrenciesList(list);
        return list;
    }

    public static List<TraditionalCurrency> getMainTraditionalCurrencies() {
        List<TraditionalCurrency> list = CurrencyUtil.getMainFiatCurrencies();
        list.addAll(CurrencyUtil.getTraditionalNonFiatCurrencies());
        CurrencyUtil.postProcessTraditionalCurrenciesList(list);
        return list;
    }

    private static boolean isTraditionalNonFiatCurrency(String currencyCode) {
        return CurrencyUtil.getTraditionalNonFiatCurrencies().stream().anyMatch(c -> c.getCode().equals(currencyCode));
    }

    private static void postProcessTraditionalCurrenciesList(List<TraditionalCurrency> list) {
        TraditionalCurrency defaultTraditionalCurrency;
        list.sort(TradeCurrency::compareTo);
        TradeCurrency defaultTradeCurrency = CurrencyUtil.getDefaultTradeCurrency();
        TraditionalCurrency traditionalCurrency = defaultTraditionalCurrency = defaultTradeCurrency instanceof TraditionalCurrency ? (TraditionalCurrency)defaultTradeCurrency : null;
        if (defaultTraditionalCurrency != null && list.contains(defaultTraditionalCurrency)) {
            list.remove(defaultTradeCurrency);
            list.add(0, defaultTraditionalCurrency);
        }
    }

    public static Collection<CryptoCurrency> getAllSortedCryptoCurrencies() {
        return cryptoCurrencyMapSupplier.get().values();
    }

    private static Map<String, CryptoCurrency> createCryptoCurrencyMap() {
        return CurrencyUtil.getSortedAssetStream().map(CurrencyUtil::assetToCryptoCurrency).collect(Collectors.toMap(TradeCurrency::getCode, Function.identity(), (x, y) -> x, LinkedHashMap::new));
    }

    public static Stream<Asset> getSortedAssetStream() {
        return assetRegistry.stream().filter(CurrencyUtil::assetIsNotBaseCurrency).filter(asset -> CurrencyUtil.assetMatchesNetworkIfMainnet(asset, Config.baseCurrencyNetwork())).sorted(Comparator.comparing(Asset::getName));
    }

    public static List<CryptoCurrency> getMainCryptoCurrencies() {
        ArrayList<CryptoCurrency> result = new ArrayList<CryptoCurrency>();
        result.add(new CryptoCurrency("BTC", "Bitcoin"));
        result.add(new CryptoCurrency("BCH", "Bitcoin Cash"));
        result.add(new CryptoCurrency("DOGE", "Dogecoin"));
        result.add(new CryptoCurrency("ETH", "Ether"));
        result.add(new CryptoCurrency("LTC", "Litecoin"));
        result.add(new CryptoCurrency("XRP", "Ripple"));
        result.add(new CryptoCurrency("ADA", "Cardano"));
        result.add(new CryptoCurrency("SOL", "Solana"));
        result.add(new CryptoCurrency("TRX", "Tron"));
        result.add(new CryptoCurrency("DAI-ERC20", "Dai Stablecoin"));
        result.add(new CryptoCurrency("USDT-ERC20", "Tether USD"));
        result.add(new CryptoCurrency("USDC-ERC20", "USD Coin"));
        result.sort(TradeCurrency::compareTo);
        return result;
    }

    public static List<CryptoCurrency> getRemovedCryptoCurrencies() {
        ArrayList<CryptoCurrency> currencies = new ArrayList<CryptoCurrency>();
        currencies.add(new CryptoCurrency("BCHC", "Bitcoin Clashic"));
        currencies.add(new CryptoCurrency("ACH", "AchieveCoin"));
        currencies.add(new CryptoCurrency("SC", "Siacoin"));
        currencies.add(new CryptoCurrency("PPI", "PiedPiper Coin"));
        currencies.add(new CryptoCurrency("PEPECASH", "Pepe Cash"));
        currencies.add(new CryptoCurrency("GRC", "Gridcoin"));
        currencies.add(new CryptoCurrency("LTZ", "LitecoinZ"));
        currencies.add(new CryptoCurrency("ZOC", "01coin"));
        currencies.add(new CryptoCurrency("BURST", "Burstcoin"));
        currencies.add(new CryptoCurrency("STEEM", "Steem"));
        currencies.add(new CryptoCurrency("DAC", "DACash"));
        currencies.add(new CryptoCurrency("RDD", "ReddCoin"));
        return currencies;
    }

    public static List<TradeCurrency> getMatureMarketCurrencies() {
        ArrayList<TradeCurrency> currencies = new ArrayList<TradeCurrency>(Arrays.asList(new TraditionalCurrency("EUR"), new TraditionalCurrency("USD"), new TraditionalCurrency("GBP"), new TraditionalCurrency("CAD"), new TraditionalCurrency("AUD"), new TraditionalCurrency("BRL")));
        currencies.sort(Comparator.comparing(TradeCurrency::getCode));
        return currencies;
    }

    public static boolean isFiatCurrency(String currencyCode) {
        if (!CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            return false;
        }
        return !CurrencyUtil.isTraditionalNonFiatCurrency(currencyCode);
    }

    public static boolean isTraditionalCurrency(String currencyCode) {
        if (currencyCode != null) {
            currencyCode = currencyCode.toUpperCase();
        }
        if (currencyCode != null && isTraditionalCurrencyMap.containsKey(currencyCode)) {
            return isTraditionalCurrencyMap.get(currencyCode);
        }
        try {
            boolean isTraditionalCurrency;
            boolean bl = isTraditionalCurrency = currencyCode != null && !currencyCode.isEmpty() && !CurrencyUtil.isCryptoCurrency(currencyCode) && (CurrencyUtil.isTraditionalNonFiatCurrency(currencyCode) || Currency.getInstance(currencyCode) != null);
            if (currencyCode != null) {
                isTraditionalCurrencyMap.put(currencyCode, isTraditionalCurrency);
            }
            return isTraditionalCurrency;
        }
        catch (Throwable t) {
            isTraditionalCurrencyMap.put(currencyCode, false);
            return false;
        }
    }

    public static boolean isVolumeRoundedToNearestUnit(String currencyCode) {
        return CurrencyUtil.isFiatCurrency(currencyCode) || "XGB".equals(currencyCode.toUpperCase());
    }

    public static boolean isPricePrecise(String currencyCode) {
        return CurrencyUtil.isCryptoCurrency(currencyCode) || "XAU".equals(currencyCode.toUpperCase()) || "XAG".equals(currencyCode.toUpperCase());
    }

    public static Optional<TraditionalCurrency> getTraditionalCurrency(String currencyCode) {
        return Optional.ofNullable(traditionalCurrencyMapSupplier.get().get(currencyCode));
    }

    public static boolean isCryptoCurrency(String currencyCode) {
        if (currencyCode != null) {
            currencyCode = currencyCode.toUpperCase();
        }
        if (currencyCode != null && isCryptoCurrencyMap.containsKey(currencyCode.toUpperCase())) {
            return isCryptoCurrencyMap.get(currencyCode.toUpperCase());
        }
        if (CurrencyUtil.isCryptoCurrencyCodeBase(currencyCode)) {
            return true;
        }
        boolean isCryptoCurrency = currencyCode == null ? false : (CurrencyUtil.getCryptoCurrency(currencyCode).isPresent() ? true : CurrencyUtil.getTraditionalCurrency(currencyCode).isEmpty());
        if (currencyCode != null) {
            isCryptoCurrencyMap.put(currencyCode, isCryptoCurrency);
        }
        return isCryptoCurrency;
    }

    private static boolean isCryptoCurrencyCodeBase(String currencyCode) {
        if (currencyCode == null) {
            return false;
        }
        return (currencyCode = currencyCode.toUpperCase()).equals("USDT") || currencyCode.equals("USDC") || currencyCode.equals("DAI");
    }

    public static String getCurrencyCodeBase(String currencyCode) {
        if (currencyCode == null) {
            return null;
        }
        if ((currencyCode = currencyCode.toUpperCase()).contains("USDT")) {
            return "USDT";
        }
        if (currencyCode.contains("USDC")) {
            return "USDC";
        }
        if (currencyCode.contains("DAI")) {
            return "DAI";
        }
        return currencyCode;
    }

    public static Optional<CryptoCurrency> getCryptoCurrency(String currencyCode) {
        return Optional.ofNullable(cryptoCurrencyMapSupplier.get().get(currencyCode));
    }

    public static Optional<TradeCurrency> getTradeCurrency(String currencyCode) {
        Optional<TraditionalCurrency> traditionalCurrencyOptional = CurrencyUtil.getTraditionalCurrency(currencyCode);
        if (traditionalCurrencyOptional.isPresent() && CurrencyUtil.isTraditionalCurrency(currencyCode)) {
            return Optional.of((TradeCurrency)traditionalCurrencyOptional.get());
        }
        Optional<CryptoCurrency> cryptoCurrencyOptional = CurrencyUtil.getCryptoCurrency(currencyCode);
        if (cryptoCurrencyOptional.isPresent() && CurrencyUtil.isCryptoCurrency(currencyCode)) {
            return Optional.of((TradeCurrency)cryptoCurrencyOptional.get());
        }
        return Optional.empty();
    }

    public static Optional<List<TradeCurrency>> getTradeCurrencies(List<String> currencyCodes) {
        ArrayList tradeCurrencies = new ArrayList();
        currencyCodes.stream().forEachOrdered(c -> tradeCurrencies.add(CurrencyUtil.getTradeCurrency(c).orElseThrow(() -> new IllegalArgumentException(String.format("%s is not a valid trade currency code", c)))));
        return tradeCurrencies.isEmpty() ? Optional.empty() : Optional.of(tradeCurrencies);
    }

    public static Optional<List<TradeCurrency>> getTradeCurrenciesInList(List<String> currencyCodes, List<TradeCurrency> validCurrencies) {
        Optional<List<TradeCurrency>> tradeCurrencies = CurrencyUtil.getTradeCurrencies(currencyCodes);
        Consumer<List> validateCandidateCurrencies = list -> {
            for (TradeCurrency tradeCurrency : list) {
                if (validCurrencies.contains(tradeCurrency)) continue;
                throw new IllegalArgumentException(String.format("%s is not a member of valid currencies list", tradeCurrency.getCode()));
            }
        };
        tradeCurrencies.ifPresent(validateCandidateCurrencies);
        return tradeCurrencies;
    }

    public static TraditionalCurrency getCurrencyByCountryCode(String countryCode) {
        if (countryCode.equals("XK")) {
            return new TraditionalCurrency("EUR");
        }
        Currency currency = Currency.getInstance(new Locale(LanguageUtil.getDefaultLanguage(), countryCode));
        return new TraditionalCurrency(currency.getCurrencyCode());
    }

    public static String getNameByCode(String currencyCode) {
        if (CurrencyUtil.isCryptoCurrency(currencyCode)) {
            Optional<CryptoCurrency> removedCryptoCurrency = CurrencyUtil.getRemovedCryptoCurrencies().stream().filter(cryptoCurrency -> cryptoCurrency.getCode().equals(currencyCode)).findAny();
            String xmrOrRemovedAsset = "XMR".equals(currencyCode) ? "Monero" : (removedCryptoCurrency.isPresent() ? removedCryptoCurrency.get().getName() : Res.get("shared.na"));
            return CurrencyUtil.getCryptoCurrency(currencyCode).map(TradeCurrency::getName).orElse(xmrOrRemovedAsset);
        }
        if (CurrencyUtil.isTraditionalNonFiatCurrency(currencyCode)) {
            return CurrencyUtil.getTraditionalNonFiatCurrencies().stream().filter(currency -> currency.getCode().equals(currencyCode)).findAny().map(TradeCurrency::getName).orElse(currencyCode);
        }
        try {
            return Currency.getInstance(currencyCode).getDisplayName();
        }
        catch (Throwable t) {
            log.debug("No currency name available {}", (Object)t.getMessage());
            return currencyCode;
        }
    }

    public static Optional<CryptoCurrency> findCryptoCurrencyByName(String currencyName) {
        return CurrencyUtil.getAllSortedCryptoCurrencies().stream().filter(e -> e.getName().equals(currencyName)).findAny();
    }

    public static String getNameAndCode(String currencyCode) {
        return CurrencyUtil.getNameByCode(currencyCode) + " (" + currencyCode + ")";
    }

    public static TradeCurrency getDefaultTradeCurrency() {
        return GlobalSettings.getDefaultTradeCurrency();
    }

    private static boolean assetIsNotBaseCurrency(Asset asset) {
        return !CurrencyUtil.assetMatchesCurrencyCode(asset, baseCurrencyCode);
    }

    public static boolean assetMatchesNetwork(Asset asset, BaseCurrencyNetwork baseCurrencyNetwork) {
        return !(asset instanceof Coin) || ((Coin)asset).getNetwork().name().equals(baseCurrencyNetwork.getNetwork());
    }

    public static boolean assetMatchesNetworkIfMainnet(Asset asset, BaseCurrencyNetwork baseCurrencyNetwork) {
        return !(asset instanceof Coin) || CurrencyUtil.coinMatchesNetworkIfMainnet((Coin)asset, baseCurrencyNetwork);
    }

    public static boolean coinMatchesNetworkIfMainnet(Coin coin, BaseCurrencyNetwork baseCurrencyNetwork) {
        boolean matchesNetwork = CurrencyUtil.assetMatchesNetwork((Asset)coin, baseCurrencyNetwork);
        return !baseCurrencyNetwork.isMainnet() || matchesNetwork;
    }

    private static CryptoCurrency assetToCryptoCurrency(Asset asset) {
        return new CryptoCurrency(asset.getTickerSymbol(), asset.getName(), asset instanceof Token);
    }

    public static boolean assetMatchesCurrencyCode(Asset asset, String currencyCode) {
        return currencyCode.equals(asset.getTickerSymbol());
    }

    public static Optional<Asset> findAsset(AssetRegistry assetRegistry, String currencyCode, BaseCurrencyNetwork baseCurrencyNetwork) {
        List assets = assetRegistry.stream().filter(asset -> CurrencyUtil.assetMatchesCurrencyCode(asset, currencyCode)).collect(Collectors.toList());
        if (assets.stream().findFirst().isEmpty()) {
            return Optional.empty();
        }
        Optional<Asset> optionalAssetMatchesNetwork = assets.stream().filter(asset -> CurrencyUtil.assetMatchesNetwork(asset, baseCurrencyNetwork)).findFirst();
        if (optionalAssetMatchesNetwork.isPresent()) {
            return optionalAssetMatchesNetwork;
        }
        if (!baseCurrencyNetwork.isMainnet()) {
            Optional<Asset> optionalAsset = assets.stream().findFirst();
            return optionalAsset;
        }
        throw new IllegalArgumentException("We are on mainnet and we could not find an asset with network type mainnet");
    }

    public static Optional<Asset> findAsset(String tickerSymbol) {
        return assetRegistry.stream().filter(asset -> asset.getTickerSymbol().equals(tickerSymbol)).findAny();
    }

    public static Optional<Asset> findAsset(String tickerSymbol, BaseCurrencyNetwork baseCurrencyNetwork) {
        return assetRegistry.stream().filter(asset -> asset.getTickerSymbol().equals(tickerSymbol)).filter(asset -> CurrencyUtil.assetMatchesNetwork(asset, baseCurrencyNetwork)).findAny();
    }

    public static List<CryptoCurrency> getActiveSortedCryptoCurrencies(FilterManager filterManager) {
        return CurrencyUtil.getAllSortedCryptoCurrencies().stream().filter(e -> !filterManager.isCurrencyBanned(e.getCode())).collect(Collectors.toList());
    }

    public static String getCurrencyPair(String currencyCode) {
        return Res.getBaseCurrencyCode() + "/" + currencyCode;
    }

    public static String getCounterCurrency(String currencyCode) {
        return currencyCode;
    }

    public static String getPriceWithCurrencyCode(String currencyCode) {
        return CurrencyUtil.getPriceWithCurrencyCode(currencyCode, "shared.priceInCurForCur");
    }

    public static String getPriceWithCurrencyCode(String currencyCode, String translationKey) {
        return Res.get(translationKey, currencyCode, Res.getBaseCurrencyCode());
    }

    public static String getOfferVolumeCode(String currencyCode) {
        return Res.get("shared.offerVolumeCode", currencyCode);
    }

    public static List<TradeCurrency> getAllTransferwiseUSDCurrencies() {
        return List.of(new TraditionalCurrency("USD"));
    }
}

