/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.locale;

import haveno.core.locale.Country;
import haveno.core.locale.CountryUtil;
import haveno.core.locale.Res;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankUtil {
    private static final Logger log = LoggerFactory.getLogger(BankUtil.class);

    public static boolean isBankNameRequired(String countryCode) {
        return true;
    }

    public static String getBankNameLabel(String countryCode) {
        switch (countryCode) {
            case "BR": {
                return Res.get("payment.bank.name");
            }
        }
        return BankUtil.isBankNameRequired(countryCode) ? Res.get("payment.bank.name") : Res.get("payment.bank.nameOptional");
    }

    public static boolean isBankIdRequired(String countryCode) {
        switch (countryCode) {
            case "GB": 
            case "US": 
            case "BR": 
            case "NZ": 
            case "AU": 
            case "SE": 
            case "CL": 
            case "NO": 
            case "AR": {
                return false;
            }
            case "CA": 
            case "MX": 
            case "HK": {
                return true;
            }
        }
        return true;
    }

    public static String getBankIdLabel(String countryCode) {
        switch (countryCode) {
            case "CA": {
                return "Institution Number";
            }
            case "MX": 
            case "HK": {
                return Res.get("payment.bankCode");
            }
        }
        return BankUtil.isBankIdRequired(countryCode) ? Res.get("payment.bankId") : Res.get("payment.bankIdOptional");
    }

    public static boolean isBranchIdRequired(String countryCode) {
        switch (countryCode) {
            case "GB": 
            case "US": 
            case "BR": 
            case "AU": 
            case "CA": {
                return true;
            }
            case "NZ": 
            case "MX": 
            case "HK": 
            case "SE": 
            case "NO": {
                return false;
            }
        }
        return true;
    }

    public static String getBranchIdLabel(String countryCode) {
        switch (countryCode) {
            case "GB": {
                return "UK sort code";
            }
            case "US": {
                return "Routing Number";
            }
            case "BR": {
                return "C\u00f3digo da Ag\u00eancia";
            }
            case "AU": {
                return "BSB code";
            }
            case "CA": {
                return "Transit Number";
            }
        }
        return BankUtil.isBranchIdRequired(countryCode) ? Res.get("payment.branchNr") : Res.get("payment.branchNrOptional");
    }

    public static boolean isAccountNrRequired(String countryCode) {
        switch (countryCode) {
            default: 
        }
        return true;
    }

    public static String getAccountNrLabel(String countryCode) {
        switch (countryCode) {
            case "GB": 
            case "US": 
            case "BR": 
            case "NZ": 
            case "AU": 
            case "CA": 
            case "HK": {
                return Res.get("payment.accountNr");
            }
            case "NO": {
                return "Kontonummer";
            }
            case "SE": {
                return "Kontonummer";
            }
            case "MX": {
                return "CLABE";
            }
            case "CL": {
                return "Cuenta";
            }
            case "AR": {
                return "N\u00famero de cuenta";
            }
        }
        return Res.get("payment.accountNrLabel");
    }

    public static boolean isAccountTypeRequired(String countryCode) {
        switch (countryCode) {
            case "US": 
            case "BR": 
            case "CA": {
                return true;
            }
        }
        return false;
    }

    public static String getAccountTypeLabel(String countryCode) {
        switch (countryCode) {
            case "US": 
            case "BR": 
            case "CA": {
                return Res.get("payment.accountType");
            }
        }
        return "";
    }

    public static List<String> getAccountTypeValues(String countryCode) {
        switch (countryCode) {
            case "US": 
            case "BR": 
            case "CA": {
                return Arrays.asList(Res.get("payment.checking"), Res.get("payment.savings"));
            }
        }
        return new ArrayList<String>();
    }

    public static boolean isHolderIdRequired(String countryCode) {
        switch (countryCode) {
            case "BR": 
            case "CL": 
            case "AR": {
                return true;
            }
        }
        return false;
    }

    public static String getHolderIdLabel(String countryCode) {
        switch (countryCode) {
            case "BR": {
                return "Cadastro de Pessoas F\u00edsicas (CPF)";
            }
            case "CL": {
                return "Rol \u00danico Tributario (RUT)";
            }
            case "AR": {
                return "CUIL/CUIT";
            }
        }
        return Res.get("payment.personalId");
    }

    public static String getHolderIdLabelShort(String countryCode) {
        switch (countryCode) {
            case "BR": {
                return "CPF";
            }
            case "CL": {
                return "RUT";
            }
            case "AR": {
                return "CUIT";
            }
        }
        return "ID";
    }

    public static boolean useValidation(String countryCode) {
        switch (countryCode) {
            case "GB": 
            case "US": 
            case "BR": 
            case "AU": 
            case "CA": 
            case "NZ": 
            case "MX": 
            case "HK": 
            case "SE": 
            case "NO": 
            case "AR": {
                return true;
            }
        }
        return false;
    }

    public static List<Country> getAllStateRequiredCountries() {
        List<String> codes = List.of("US", "CA", "AU", "MY", "MX", "CN");
        List<Country> list = CountryUtil.getCountries(codes);
        list.sort((a, b) -> a.name.compareTo(b.name));
        return list;
    }

    public static boolean isStateRequired(String countryCode) {
        return BankUtil.getAllStateRequiredCountries().stream().map(country -> country.code).collect(Collectors.toList()).contains(countryCode);
    }

    public static boolean isNationalAccountIdRequired(String countryCode) {
        switch (countryCode) {
            case "AR": {
                return true;
            }
        }
        return false;
    }

    public static String getNationalAccountIdLabel(String countryCode) {
        switch (countryCode) {
            case "AR": {
                return Res.get("payment.national.account.id.AR");
            }
        }
        return "";
    }
}

