/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import haveno.common.crypto.Sig;
import haveno.common.proto.ProtoUtil;
import haveno.common.util.CollectionUtils;
import haveno.common.util.ExtraDataMapValidator;
import haveno.common.util.Utilities;
import haveno.core.filter.PaymentAccountFilter;
import haveno.network.p2p.storage.payload.ExpirablePayload;
import haveno.network.p2p.storage.payload.ProtectedStoragePayload;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.Filter;
import protobuf.StoragePayload;

public final class Filter
implements ProtectedStoragePayload,
ExpirablePayload {
    private static final Logger log = LoggerFactory.getLogger(Filter.class);
    public static final long TTL = TimeUnit.DAYS.toMillis(180L);
    private final List<String> bannedOfferIds;
    private final List<String> nodeAddressesBannedFromTrading;
    private final List<String> bannedAutoConfExplorers;
    private final List<PaymentAccountFilter> bannedPaymentAccounts;
    private final List<String> bannedCurrencies;
    private final List<String> bannedPaymentMethods;
    private final List<String> arbitrators;
    private final List<String> seedNodes;
    private final List<String> priceRelayNodes;
    private final boolean preventPublicXmrNetwork;
    private final List<String> xmrNodes;
    @Nullable
    private final String signatureAsBase64;
    private final String signerPubKeyAsHex;
    private final byte[] ownerPubKeyBytes;
    private final String disableTradeBelowVersion;
    private final List<String> mediators;
    private final List<String> refundAgents;
    private final List<String> bannedAccountWitnessSignerPubKeys;
    private final List<String> xmrFeeReceiverAddresses;
    private final long creationDate;
    private final List<String> bannedPrivilegedDevPubKeys;
    @Nullable
    private final Map<String, String> extraDataMap;
    private final transient PublicKey ownerPubKey;
    private final boolean disableAutoConf;
    private final Set<String> nodeAddressesBannedFromNetwork;
    private final boolean disableApi;
    private final boolean disableMempoolValidation;

    static Filter cloneWithSig(Filter filter, String signatureAsBase64) {
        return new Filter(filter.getBannedOfferIds(), filter.getNodeAddressesBannedFromTrading(), filter.getBannedPaymentAccounts(), filter.getBannedCurrencies(), filter.getBannedPaymentMethods(), filter.getArbitrators(), filter.getSeedNodes(), filter.getPriceRelayNodes(), filter.isPreventPublicXmrNetwork(), filter.getXmrNodes(), filter.getDisableTradeBelowVersion(), filter.getMediators(), filter.getRefundAgents(), filter.getBannedAccountWitnessSignerPubKeys(), filter.getXmrFeeReceiverAddresses(), filter.getOwnerPubKeyBytes(), filter.getCreationDate(), filter.getExtraDataMap(), signatureAsBase64, filter.getSignerPubKeyAsHex(), filter.getBannedPrivilegedDevPubKeys(), filter.isDisableAutoConf(), filter.getBannedAutoConfExplorers(), filter.getNodeAddressesBannedFromNetwork(), filter.isDisableMempoolValidation(), filter.isDisableApi());
    }

    static Filter cloneWithoutSig(Filter filter) {
        return new Filter(filter.getBannedOfferIds(), filter.getNodeAddressesBannedFromTrading(), filter.getBannedPaymentAccounts(), filter.getBannedCurrencies(), filter.getBannedPaymentMethods(), filter.getArbitrators(), filter.getSeedNodes(), filter.getPriceRelayNodes(), filter.isPreventPublicXmrNetwork(), filter.getXmrNodes(), filter.getDisableTradeBelowVersion(), filter.getMediators(), filter.getRefundAgents(), filter.getBannedAccountWitnessSignerPubKeys(), filter.getXmrFeeReceiverAddresses(), filter.getOwnerPubKeyBytes(), filter.getCreationDate(), filter.getExtraDataMap(), null, filter.getSignerPubKeyAsHex(), filter.getBannedPrivilegedDevPubKeys(), filter.isDisableAutoConf(), filter.getBannedAutoConfExplorers(), filter.getNodeAddressesBannedFromNetwork(), filter.isDisableMempoolValidation(), filter.isDisableApi());
    }

    public Filter(List<String> bannedOfferIds, List<String> nodeAddressesBannedFromTrading, List<PaymentAccountFilter> bannedPaymentAccounts, List<String> bannedCurrencies, List<String> bannedPaymentMethods, List<String> arbitrators, List<String> seedNodes, List<String> priceRelayNodes, boolean preventPublicXmrNetwork, List<String> xmrNodes, String disableTradeBelowVersion, List<String> mediators, List<String> refundAgents, List<String> bannedAccountWitnessSignerPubKeys, List<String> xmrFeeReceiverAddresses, PublicKey ownerPubKey, String signerPubKeyAsHex, List<String> bannedPrivilegedDevPubKeys, boolean disableAutoConf, List<String> bannedAutoConfExplorers, Set<String> nodeAddressesBannedFromNetwork, boolean disableMempoolValidation, boolean disableApi) {
        this(bannedOfferIds, nodeAddressesBannedFromTrading, bannedPaymentAccounts, bannedCurrencies, bannedPaymentMethods, arbitrators, seedNodes, priceRelayNodes, preventPublicXmrNetwork, xmrNodes, disableTradeBelowVersion, mediators, refundAgents, bannedAccountWitnessSignerPubKeys, xmrFeeReceiverAddresses, Sig.getPublicKeyBytes((PublicKey)ownerPubKey), System.currentTimeMillis(), null, null, signerPubKeyAsHex, bannedPrivilegedDevPubKeys, disableAutoConf, bannedAutoConfExplorers, nodeAddressesBannedFromNetwork, disableMempoolValidation, disableApi);
    }

    @VisibleForTesting
    public Filter(List<String> bannedOfferIds, List<String> nodeAddressesBannedFromTrading, List<PaymentAccountFilter> bannedPaymentAccounts, List<String> bannedCurrencies, List<String> bannedPaymentMethods, List<String> arbitrators, List<String> seedNodes, List<String> priceRelayNodes, boolean preventPublicXmrNetwork, List<String> xmrNodes, String disableTradeBelowVersion, List<String> mediators, List<String> refundAgents, List<String> bannedAccountWitnessSignerPubKeys, List<String> xmrFeeReceiverAddresses, byte[] ownerPubKeyBytes, long creationDate, @Nullable Map<String, String> extraDataMap, @Nullable String signatureAsBase64, String signerPubKeyAsHex, List<String> bannedPrivilegedDevPubKeys, boolean disableAutoConf, List<String> bannedAutoConfExplorers, Set<String> nodeAddressesBannedFromNetwork, boolean disableMempoolValidation, boolean disableApi) {
        this.bannedOfferIds = bannedOfferIds;
        this.nodeAddressesBannedFromTrading = nodeAddressesBannedFromTrading;
        this.bannedPaymentAccounts = bannedPaymentAccounts;
        this.bannedCurrencies = bannedCurrencies;
        this.bannedPaymentMethods = bannedPaymentMethods;
        this.arbitrators = arbitrators;
        this.seedNodes = seedNodes;
        this.priceRelayNodes = priceRelayNodes;
        this.preventPublicXmrNetwork = preventPublicXmrNetwork;
        this.xmrNodes = xmrNodes;
        this.disableTradeBelowVersion = disableTradeBelowVersion;
        this.mediators = mediators;
        this.refundAgents = refundAgents;
        this.bannedAccountWitnessSignerPubKeys = bannedAccountWitnessSignerPubKeys;
        this.xmrFeeReceiverAddresses = xmrFeeReceiverAddresses;
        this.ownerPubKeyBytes = ownerPubKeyBytes;
        this.creationDate = creationDate;
        this.extraDataMap = ExtraDataMapValidator.getValidatedExtraDataMap(extraDataMap);
        this.signatureAsBase64 = signatureAsBase64;
        this.signerPubKeyAsHex = signerPubKeyAsHex;
        this.bannedPrivilegedDevPubKeys = bannedPrivilegedDevPubKeys;
        this.disableAutoConf = disableAutoConf;
        this.bannedAutoConfExplorers = bannedAutoConfExplorers;
        this.nodeAddressesBannedFromNetwork = nodeAddressesBannedFromNetwork;
        this.disableMempoolValidation = disableMempoolValidation;
        this.disableApi = disableApi;
        this.ownerPubKey = ownerPubKeyBytes != null ? Sig.getPublicKeyFromBytes((byte[])ownerPubKeyBytes) : null;
    }

    public StoragePayload toProtoMessage() {
        List paymentAccountFilterList = this.bannedPaymentAccounts.stream().map(PaymentAccountFilter::toProtoMessage).collect(Collectors.toList());
        Filter.Builder builder = protobuf.Filter.newBuilder().addAllBannedOfferIds(this.bannedOfferIds).addAllNodeAddressesBannedFromTrading(this.nodeAddressesBannedFromTrading).addAllBannedPaymentAccounts(paymentAccountFilterList).addAllBannedCurrencies(this.bannedCurrencies).addAllBannedPaymentMethods(this.bannedPaymentMethods).addAllArbitrators(this.arbitrators).addAllSeedNodes(this.seedNodes).addAllPriceRelayNodes(this.priceRelayNodes).setPreventPublicXmrNetwork(this.preventPublicXmrNetwork).addAllXmrNodes(this.xmrNodes).setDisableTradeBelowVersion(this.disableTradeBelowVersion).addAllMediators(this.mediators).addAllRefundAgents(this.refundAgents).addAllBannedSignerPubKeys(this.bannedAccountWitnessSignerPubKeys).addAllXmrFeeReceiverAddresses(this.xmrFeeReceiverAddresses).setOwnerPubKeyBytes(ByteString.copyFrom((byte[])this.ownerPubKeyBytes)).setSignerPubKeyAsHex(this.signerPubKeyAsHex).setCreationDate(this.creationDate).addAllBannedPrivilegedDevPubKeys(this.bannedPrivilegedDevPubKeys).setDisableAutoConf(this.disableAutoConf).addAllBannedAutoConfExplorers(this.bannedAutoConfExplorers).addAllNodeAddressesBannedFromNetwork(this.nodeAddressesBannedFromNetwork).setDisableMempoolValidation(this.disableMempoolValidation).setDisableApi(this.disableApi);
        Optional.ofNullable(this.signatureAsBase64).ifPresent(arg_0 -> ((Filter.Builder)builder).setSignatureAsBase64(arg_0));
        Optional.ofNullable(this.extraDataMap).ifPresent(arg_0 -> ((Filter.Builder)builder).putAllExtraData(arg_0));
        return StoragePayload.newBuilder().setFilter(builder).build();
    }

    public static Filter fromProto(protobuf.Filter proto) {
        List<PaymentAccountFilter> bannedPaymentAccountsList = proto.getBannedPaymentAccountsList().stream().map(PaymentAccountFilter::fromProto).collect(Collectors.toList());
        return new Filter(ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getBannedOfferIdsList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getNodeAddressesBannedFromTradingList()), bannedPaymentAccountsList, ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getBannedCurrenciesList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getBannedPaymentMethodsList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getArbitratorsList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getSeedNodesList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getPriceRelayNodesList()), proto.getPreventPublicXmrNetwork(), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getXmrNodesList()), proto.getDisableTradeBelowVersion(), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getMediatorsList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getRefundAgentsList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getBannedSignerPubKeysList()), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getXmrFeeReceiverAddressesList()), proto.getOwnerPubKeyBytes().toByteArray(), proto.getCreationDate(), CollectionUtils.isEmpty((Map)proto.getExtraDataMap()) ? null : proto.getExtraDataMap(), proto.getSignatureAsBase64(), proto.getSignerPubKeyAsHex(), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getBannedPrivilegedDevPubKeysList()), proto.getDisableAutoConf(), ProtoUtil.protocolStringListToList((ProtocolStringList)proto.getBannedAutoConfExplorersList()), ProtoUtil.protocolStringListToSet((ProtocolStringList)proto.getNodeAddressesBannedFromNetworkList()), proto.getDisableMempoolValidation(), proto.getDisableApi());
    }

    public long getTTL() {
        return TTL;
    }

    public String toString() {
        return "Filter{\n     bannedOfferIds=" + String.valueOf(this.bannedOfferIds) + ",\n     nodeAddressesBannedFromTrading=" + String.valueOf(this.nodeAddressesBannedFromTrading) + ",\n     bannedAutoConfExplorers=" + String.valueOf(this.bannedAutoConfExplorers) + ",\n     bannedPaymentAccounts=" + String.valueOf(this.bannedPaymentAccounts) + ",\n     bannedCurrencies=" + String.valueOf(this.bannedCurrencies) + ",\n     bannedPaymentMethods=" + String.valueOf(this.bannedPaymentMethods) + ",\n     arbitrators=" + String.valueOf(this.arbitrators) + ",\n     seedNodes=" + String.valueOf(this.seedNodes) + ",\n     priceRelayNodes=" + String.valueOf(this.priceRelayNodes) + ",\n     preventPublicXmrNetwork=" + this.preventPublicXmrNetwork + ",\n     xmrNodes=" + String.valueOf(this.xmrNodes) + ",\n     signatureAsBase64='" + this.signatureAsBase64 + "',\n     signerPubKeyAsHex='" + this.signerPubKeyAsHex + "',\n     ownerPubKeyBytes=" + Utilities.bytesAsHexString((byte[])this.ownerPubKeyBytes) + ",\n     disableTradeBelowVersion='" + this.disableTradeBelowVersion + "',\n     mediators=" + String.valueOf(this.mediators) + ",\n     refundAgents=" + String.valueOf(this.refundAgents) + ",\n     bannedAccountWitnessSignerPubKeys=" + String.valueOf(this.bannedAccountWitnessSignerPubKeys) + ",\n     xmrFeeReceiverAddresses=" + String.valueOf(this.xmrFeeReceiverAddresses) + ",\n     creationDate=" + this.creationDate + ",\n     bannedPrivilegedDevPubKeys=" + String.valueOf(this.bannedPrivilegedDevPubKeys) + ",\n     extraDataMap=" + String.valueOf(this.extraDataMap) + ",\n     ownerPubKey=" + String.valueOf(this.ownerPubKey) + ",\n     disableAutoConf=" + this.disableAutoConf + ",\n     nodeAddressesBannedFromNetwork=" + String.valueOf(this.nodeAddressesBannedFromNetwork) + ",\n     disableMempoolValidation=" + this.disableMempoolValidation + ",\n     disableApi=" + this.disableApi + "\n}";
    }

    public List<String> getBannedOfferIds() {
        return this.bannedOfferIds;
    }

    public List<String> getNodeAddressesBannedFromTrading() {
        return this.nodeAddressesBannedFromTrading;
    }

    public List<String> getBannedAutoConfExplorers() {
        return this.bannedAutoConfExplorers;
    }

    public List<PaymentAccountFilter> getBannedPaymentAccounts() {
        return this.bannedPaymentAccounts;
    }

    public List<String> getBannedCurrencies() {
        return this.bannedCurrencies;
    }

    public List<String> getBannedPaymentMethods() {
        return this.bannedPaymentMethods;
    }

    public List<String> getArbitrators() {
        return this.arbitrators;
    }

    public List<String> getSeedNodes() {
        return this.seedNodes;
    }

    public List<String> getPriceRelayNodes() {
        return this.priceRelayNodes;
    }

    public boolean isPreventPublicXmrNetwork() {
        return this.preventPublicXmrNetwork;
    }

    public List<String> getXmrNodes() {
        return this.xmrNodes;
    }

    @Nullable
    public String getSignatureAsBase64() {
        return this.signatureAsBase64;
    }

    public String getSignerPubKeyAsHex() {
        return this.signerPubKeyAsHex;
    }

    public byte[] getOwnerPubKeyBytes() {
        return this.ownerPubKeyBytes;
    }

    public String getDisableTradeBelowVersion() {
        return this.disableTradeBelowVersion;
    }

    public List<String> getMediators() {
        return this.mediators;
    }

    public List<String> getRefundAgents() {
        return this.refundAgents;
    }

    public List<String> getBannedAccountWitnessSignerPubKeys() {
        return this.bannedAccountWitnessSignerPubKeys;
    }

    public List<String> getXmrFeeReceiverAddresses() {
        return this.xmrFeeReceiverAddresses;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public List<String> getBannedPrivilegedDevPubKeys() {
        return this.bannedPrivilegedDevPubKeys;
    }

    @Nullable
    public Map<String, String> getExtraDataMap() {
        return this.extraDataMap;
    }

    public PublicKey getOwnerPubKey() {
        return this.ownerPubKey;
    }

    public boolean isDisableAutoConf() {
        return this.disableAutoConf;
    }

    public Set<String> getNodeAddressesBannedFromNetwork() {
        return this.nodeAddressesBannedFromNetwork;
    }

    public boolean isDisableApi() {
        return this.disableApi;
    }

    public boolean isDisableMempoolValidation() {
        return this.disableMempoolValidation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filter)) {
            return false;
        }
        Filter other = (Filter)o;
        if (this.isPreventPublicXmrNetwork() != other.isPreventPublicXmrNetwork()) {
            return false;
        }
        if (this.getCreationDate() != other.getCreationDate()) {
            return false;
        }
        if (this.isDisableAutoConf() != other.isDisableAutoConf()) {
            return false;
        }
        if (this.isDisableApi() != other.isDisableApi()) {
            return false;
        }
        if (this.isDisableMempoolValidation() != other.isDisableMempoolValidation()) {
            return false;
        }
        List<String> this$bannedOfferIds = this.getBannedOfferIds();
        List<String> other$bannedOfferIds = other.getBannedOfferIds();
        if (this$bannedOfferIds == null ? other$bannedOfferIds != null : !((Object)this$bannedOfferIds).equals(other$bannedOfferIds)) {
            return false;
        }
        List<String> this$nodeAddressesBannedFromTrading = this.getNodeAddressesBannedFromTrading();
        List<String> other$nodeAddressesBannedFromTrading = other.getNodeAddressesBannedFromTrading();
        if (this$nodeAddressesBannedFromTrading == null ? other$nodeAddressesBannedFromTrading != null : !((Object)this$nodeAddressesBannedFromTrading).equals(other$nodeAddressesBannedFromTrading)) {
            return false;
        }
        List<String> this$bannedAutoConfExplorers = this.getBannedAutoConfExplorers();
        List<String> other$bannedAutoConfExplorers = other.getBannedAutoConfExplorers();
        if (this$bannedAutoConfExplorers == null ? other$bannedAutoConfExplorers != null : !((Object)this$bannedAutoConfExplorers).equals(other$bannedAutoConfExplorers)) {
            return false;
        }
        List<PaymentAccountFilter> this$bannedPaymentAccounts = this.getBannedPaymentAccounts();
        List<PaymentAccountFilter> other$bannedPaymentAccounts = other.getBannedPaymentAccounts();
        if (this$bannedPaymentAccounts == null ? other$bannedPaymentAccounts != null : !((Object)this$bannedPaymentAccounts).equals(other$bannedPaymentAccounts)) {
            return false;
        }
        List<String> this$bannedCurrencies = this.getBannedCurrencies();
        List<String> other$bannedCurrencies = other.getBannedCurrencies();
        if (this$bannedCurrencies == null ? other$bannedCurrencies != null : !((Object)this$bannedCurrencies).equals(other$bannedCurrencies)) {
            return false;
        }
        List<String> this$bannedPaymentMethods = this.getBannedPaymentMethods();
        List<String> other$bannedPaymentMethods = other.getBannedPaymentMethods();
        if (this$bannedPaymentMethods == null ? other$bannedPaymentMethods != null : !((Object)this$bannedPaymentMethods).equals(other$bannedPaymentMethods)) {
            return false;
        }
        List<String> this$arbitrators = this.getArbitrators();
        List<String> other$arbitrators = other.getArbitrators();
        if (this$arbitrators == null ? other$arbitrators != null : !((Object)this$arbitrators).equals(other$arbitrators)) {
            return false;
        }
        List<String> this$seedNodes = this.getSeedNodes();
        List<String> other$seedNodes = other.getSeedNodes();
        if (this$seedNodes == null ? other$seedNodes != null : !((Object)this$seedNodes).equals(other$seedNodes)) {
            return false;
        }
        List<String> this$priceRelayNodes = this.getPriceRelayNodes();
        List<String> other$priceRelayNodes = other.getPriceRelayNodes();
        if (this$priceRelayNodes == null ? other$priceRelayNodes != null : !((Object)this$priceRelayNodes).equals(other$priceRelayNodes)) {
            return false;
        }
        List<String> this$xmrNodes = this.getXmrNodes();
        List<String> other$xmrNodes = other.getXmrNodes();
        if (this$xmrNodes == null ? other$xmrNodes != null : !((Object)this$xmrNodes).equals(other$xmrNodes)) {
            return false;
        }
        String this$signatureAsBase64 = this.getSignatureAsBase64();
        String other$signatureAsBase64 = other.getSignatureAsBase64();
        if (this$signatureAsBase64 == null ? other$signatureAsBase64 != null : !this$signatureAsBase64.equals(other$signatureAsBase64)) {
            return false;
        }
        String this$signerPubKeyAsHex = this.getSignerPubKeyAsHex();
        String other$signerPubKeyAsHex = other.getSignerPubKeyAsHex();
        if (this$signerPubKeyAsHex == null ? other$signerPubKeyAsHex != null : !this$signerPubKeyAsHex.equals(other$signerPubKeyAsHex)) {
            return false;
        }
        if (!Arrays.equals(this.getOwnerPubKeyBytes(), other.getOwnerPubKeyBytes())) {
            return false;
        }
        String this$disableTradeBelowVersion = this.getDisableTradeBelowVersion();
        String other$disableTradeBelowVersion = other.getDisableTradeBelowVersion();
        if (this$disableTradeBelowVersion == null ? other$disableTradeBelowVersion != null : !this$disableTradeBelowVersion.equals(other$disableTradeBelowVersion)) {
            return false;
        }
        List<String> this$mediators = this.getMediators();
        List<String> other$mediators = other.getMediators();
        if (this$mediators == null ? other$mediators != null : !((Object)this$mediators).equals(other$mediators)) {
            return false;
        }
        List<String> this$refundAgents = this.getRefundAgents();
        List<String> other$refundAgents = other.getRefundAgents();
        if (this$refundAgents == null ? other$refundAgents != null : !((Object)this$refundAgents).equals(other$refundAgents)) {
            return false;
        }
        List<String> this$bannedAccountWitnessSignerPubKeys = this.getBannedAccountWitnessSignerPubKeys();
        List<String> other$bannedAccountWitnessSignerPubKeys = other.getBannedAccountWitnessSignerPubKeys();
        if (this$bannedAccountWitnessSignerPubKeys == null ? other$bannedAccountWitnessSignerPubKeys != null : !((Object)this$bannedAccountWitnessSignerPubKeys).equals(other$bannedAccountWitnessSignerPubKeys)) {
            return false;
        }
        List<String> this$xmrFeeReceiverAddresses = this.getXmrFeeReceiverAddresses();
        List<String> other$xmrFeeReceiverAddresses = other.getXmrFeeReceiverAddresses();
        if (this$xmrFeeReceiverAddresses == null ? other$xmrFeeReceiverAddresses != null : !((Object)this$xmrFeeReceiverAddresses).equals(other$xmrFeeReceiverAddresses)) {
            return false;
        }
        List<String> this$bannedPrivilegedDevPubKeys = this.getBannedPrivilegedDevPubKeys();
        List<String> other$bannedPrivilegedDevPubKeys = other.getBannedPrivilegedDevPubKeys();
        if (this$bannedPrivilegedDevPubKeys == null ? other$bannedPrivilegedDevPubKeys != null : !((Object)this$bannedPrivilegedDevPubKeys).equals(other$bannedPrivilegedDevPubKeys)) {
            return false;
        }
        Map<String, String> this$extraDataMap = this.getExtraDataMap();
        Map<String, String> other$extraDataMap = other.getExtraDataMap();
        if (this$extraDataMap == null ? other$extraDataMap != null : !((Object)this$extraDataMap).equals(other$extraDataMap)) {
            return false;
        }
        Set<String> this$nodeAddressesBannedFromNetwork = this.getNodeAddressesBannedFromNetwork();
        Set<String> other$nodeAddressesBannedFromNetwork = other.getNodeAddressesBannedFromNetwork();
        return !(this$nodeAddressesBannedFromNetwork == null ? other$nodeAddressesBannedFromNetwork != null : !((Object)this$nodeAddressesBannedFromNetwork).equals(other$nodeAddressesBannedFromNetwork));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreventPublicXmrNetwork() ? 79 : 97);
        long $creationDate = this.getCreationDate();
        result = result * 59 + (int)($creationDate >>> 32 ^ $creationDate);
        result = result * 59 + (this.isDisableAutoConf() ? 79 : 97);
        result = result * 59 + (this.isDisableApi() ? 79 : 97);
        result = result * 59 + (this.isDisableMempoolValidation() ? 79 : 97);
        List<String> $bannedOfferIds = this.getBannedOfferIds();
        result = result * 59 + ($bannedOfferIds == null ? 43 : ((Object)$bannedOfferIds).hashCode());
        List<String> $nodeAddressesBannedFromTrading = this.getNodeAddressesBannedFromTrading();
        result = result * 59 + ($nodeAddressesBannedFromTrading == null ? 43 : ((Object)$nodeAddressesBannedFromTrading).hashCode());
        List<String> $bannedAutoConfExplorers = this.getBannedAutoConfExplorers();
        result = result * 59 + ($bannedAutoConfExplorers == null ? 43 : ((Object)$bannedAutoConfExplorers).hashCode());
        List<PaymentAccountFilter> $bannedPaymentAccounts = this.getBannedPaymentAccounts();
        result = result * 59 + ($bannedPaymentAccounts == null ? 43 : ((Object)$bannedPaymentAccounts).hashCode());
        List<String> $bannedCurrencies = this.getBannedCurrencies();
        result = result * 59 + ($bannedCurrencies == null ? 43 : ((Object)$bannedCurrencies).hashCode());
        List<String> $bannedPaymentMethods = this.getBannedPaymentMethods();
        result = result * 59 + ($bannedPaymentMethods == null ? 43 : ((Object)$bannedPaymentMethods).hashCode());
        List<String> $arbitrators = this.getArbitrators();
        result = result * 59 + ($arbitrators == null ? 43 : ((Object)$arbitrators).hashCode());
        List<String> $seedNodes = this.getSeedNodes();
        result = result * 59 + ($seedNodes == null ? 43 : ((Object)$seedNodes).hashCode());
        List<String> $priceRelayNodes = this.getPriceRelayNodes();
        result = result * 59 + ($priceRelayNodes == null ? 43 : ((Object)$priceRelayNodes).hashCode());
        List<String> $xmrNodes = this.getXmrNodes();
        result = result * 59 + ($xmrNodes == null ? 43 : ((Object)$xmrNodes).hashCode());
        String $signatureAsBase64 = this.getSignatureAsBase64();
        result = result * 59 + ($signatureAsBase64 == null ? 43 : $signatureAsBase64.hashCode());
        String $signerPubKeyAsHex = this.getSignerPubKeyAsHex();
        result = result * 59 + ($signerPubKeyAsHex == null ? 43 : $signerPubKeyAsHex.hashCode());
        result = result * 59 + Arrays.hashCode(this.getOwnerPubKeyBytes());
        String $disableTradeBelowVersion = this.getDisableTradeBelowVersion();
        result = result * 59 + ($disableTradeBelowVersion == null ? 43 : $disableTradeBelowVersion.hashCode());
        List<String> $mediators = this.getMediators();
        result = result * 59 + ($mediators == null ? 43 : ((Object)$mediators).hashCode());
        List<String> $refundAgents = this.getRefundAgents();
        result = result * 59 + ($refundAgents == null ? 43 : ((Object)$refundAgents).hashCode());
        List<String> $bannedAccountWitnessSignerPubKeys = this.getBannedAccountWitnessSignerPubKeys();
        result = result * 59 + ($bannedAccountWitnessSignerPubKeys == null ? 43 : ((Object)$bannedAccountWitnessSignerPubKeys).hashCode());
        List<String> $xmrFeeReceiverAddresses = this.getXmrFeeReceiverAddresses();
        result = result * 59 + ($xmrFeeReceiverAddresses == null ? 43 : ((Object)$xmrFeeReceiverAddresses).hashCode());
        List<String> $bannedPrivilegedDevPubKeys = this.getBannedPrivilegedDevPubKeys();
        result = result * 59 + ($bannedPrivilegedDevPubKeys == null ? 43 : ((Object)$bannedPrivilegedDevPubKeys).hashCode());
        Map<String, String> $extraDataMap = this.getExtraDataMap();
        result = result * 59 + ($extraDataMap == null ? 43 : ((Object)$extraDataMap).hashCode());
        Set<String> $nodeAddressesBannedFromNetwork = this.getNodeAddressesBannedFromNetwork();
        result = result * 59 + ($nodeAddressesBannedFromNetwork == null ? 43 : ((Object)$nodeAddressesBannedFromNetwork).hashCode());
        return result;
    }
}

