/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app.misc;

import com.google.inject.Singleton;
import com.google.inject.name.Names;
import haveno.common.ClockWatcher;
import haveno.common.app.AppModule;
import haveno.common.config.Config;
import haveno.common.crypto.KeyRing;
import haveno.common.crypto.KeyStorage;
import haveno.common.proto.network.NetworkProtoResolver;
import haveno.common.proto.persistable.PersistenceProtoResolver;
import haveno.core.alert.AlertModule;
import haveno.core.app.TorSetup;
import haveno.core.filter.FilterModule;
import haveno.core.network.CoreBanFilter;
import haveno.core.network.p2p.seed.DefaultSeedNodeRepository;
import haveno.core.offer.OfferModule;
import haveno.core.proto.network.CoreNetworkProtoResolver;
import haveno.core.proto.persistable.CorePersistenceProtoResolver;
import haveno.core.trade.TradeModule;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.xmr.XmrConnectionModule;
import haveno.core.xmr.XmrModule;
import haveno.network.crypto.EncryptionServiceModule;
import haveno.network.p2p.P2PModule;
import haveno.network.p2p.network.BanFilter;
import haveno.network.p2p.network.BridgeAddressProvider;
import haveno.network.p2p.seed.SeedNodeRepository;
import java.io.File;
import java.lang.annotation.Annotation;

public class ModuleForAppWithP2p
extends AppModule {
    public ModuleForAppWithP2p(Config config) {
        super(config);
    }

    protected void configure() {
        this.bind(Config.class).toInstance((Object)this.config);
        this.bind(KeyStorage.class).in(Singleton.class);
        this.bind(KeyRing.class).in(Singleton.class);
        this.bind(User.class).in(Singleton.class);
        this.bind(ClockWatcher.class).in(Singleton.class);
        this.bind(NetworkProtoResolver.class).to(CoreNetworkProtoResolver.class).in(Singleton.class);
        this.bind(PersistenceProtoResolver.class).to(CorePersistenceProtoResolver.class).in(Singleton.class);
        this.bind(Preferences.class).in(Singleton.class);
        this.bind(BridgeAddressProvider.class).to(Preferences.class).in(Singleton.class);
        this.bind(TorSetup.class).in(Singleton.class);
        this.bind(SeedNodeRepository.class).to(DefaultSeedNodeRepository.class).in(Singleton.class);
        this.bind(BanFilter.class).to(CoreBanFilter.class).in(Singleton.class);
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"storageDir")).toInstance((Object)this.config.storageDir);
        this.bind(File.class).annotatedWith((Annotation)Names.named((String)"keyStorageDir")).toInstance((Object)this.config.keyStorageDir);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"useDevPrivilegeKeys")).to(this.config.useDevPrivilegeKeys);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"useDevMode")).to(this.config.useDevMode);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"useDevModeHeader")).to(this.config.useDevModeHeader);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"referralId")).to(this.config.referralId);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"preventPeriodicShutdownAtSeedNode")).to(this.config.preventPeriodicShutdownAtSeedNode);
        this.install(new TradeModule(this.config));
        this.install((AppModule)new EncryptionServiceModule(this.config));
        this.install(new OfferModule(this.config));
        this.install((AppModule)new P2PModule(this.config));
        this.install(new XmrModule(this.config));
        this.install(new AlertModule(this.config));
        this.install(new FilterModule(this.config));
        this.install(new XmrConnectionModule(this.config));
    }
}

