/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app.misc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.config.Config;
import haveno.common.file.JsonFileManager;
import haveno.common.handlers.ResultHandler;
import haveno.common.persistence.PersistenceManager;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.common.util.Profiler;
import haveno.core.api.XmrConnectionService;
import haveno.core.app.AvoidStandbyModeService;
import haveno.core.app.HavenoExecutable;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OpenOfferManager;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.support.dispute.arbitration.arbitrator.ArbitratorManager;
import haveno.core.trade.TradeManager;
import haveno.core.trade.statistics.TradeStatisticsManager;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.BtcWalletService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.seed.SeedNodeRepository;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutableForAppWithP2p
extends HavenoExecutable {
    private static final Logger log = LoggerFactory.getLogger(ExecutableForAppWithP2p.class);
    private static final long CHECK_MEMORY_PERIOD_SEC = 300L;
    private static final long CHECK_SHUTDOWN_SEC = TimeUnit.HOURS.toSeconds(1L);
    private static final long SHUTDOWN_INTERVAL = TimeUnit.HOURS.toMillis(24L);
    private volatile boolean stopped;
    private final long startTime = System.currentTimeMillis();

    public ExecutableForAppWithP2p(String fullName, String scriptName, String appName, String version) {
        super(fullName, scriptName, appName, version);
    }

    @Override
    protected void configUserThread() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName()).setDaemon(true).build();
        UserThread.setExecutor((Executor)Executors.newSingleThreadExecutor(threadFactory));
    }

    @Override
    public void onSetupComplete() {
        log.info("onSetupComplete");
    }

    @Override
    public void gracefulShutDown(ResultHandler resultHandler) {
        block6: {
            log.info("Starting graceful shut down of {}", (Object)this.getClass().getSimpleName());
            if (this.isShutDownStarted) {
                log.info("Ignoring call to gracefulShutDown, already started");
                return;
            }
            this.isShutDownStarted = true;
            try {
                if (this.injector != null) {
                    HashSet<Runnable> tasks = new HashSet<Runnable>();
                    tasks.add(() -> ((TradeManager)this.injector.getInstance(TradeManager.class)).onShutDownStarted());
                    tasks.add(() -> ((XmrWalletService)this.injector.getInstance(XmrWalletService.class)).onShutDownStarted());
                    tasks.add(() -> ((XmrConnectionService)this.injector.getInstance(XmrConnectionService.class)).onShutDownStarted());
                    try {
                        ThreadUtils.awaitTasks(tasks, (int)tasks.size(), (Long)120000L);
                    }
                    catch (Exception e) {
                        log.error("Error awaiting tasks to complete: {}\n", (Object)e.getMessage(), (Object)e);
                    }
                    JsonFileManager.shutDownAllInstances();
                    ((PriceFeedService)this.injector.getInstance(PriceFeedService.class)).shutDown();
                    ((ArbitratorManager)this.injector.getInstance(ArbitratorManager.class)).shutDown();
                    ((TradeStatisticsManager)this.injector.getInstance(TradeStatisticsManager.class)).shutDown();
                    ((AvoidStandbyModeService)this.injector.getInstance(AvoidStandbyModeService.class)).shutDown();
                    log.info("Shutting down OpenOfferManager");
                    ((OpenOfferManager)this.injector.getInstance(OpenOfferManager.class)).shutDown(() -> {
                        ((WalletsSetup)this.injector.getInstance(WalletsSetup.class)).shutDownComplete.addListener((ov, o, n) -> {
                            log.info("Shutting down P2P service");
                            ((P2PService)this.injector.getInstance(P2PService.class)).shutDown(() -> {
                                this.module.close(this.injector);
                                PersistenceManager.flushAllDataToDiskAtShutdown(() -> {
                                    log.info("Graceful shutdown completed. Exiting now.");
                                    resultHandler.handleResult();
                                    UserThread.runAfter(() -> System.exit(0), (long)1L);
                                });
                            });
                        });
                        log.info("Shutting down trade and wallet services");
                        ((OfferBookService)this.injector.getInstance(OfferBookService.class)).shutDown();
                        ((TradeManager)this.injector.getInstance(TradeManager.class)).shutDown();
                        ((BtcWalletService)this.injector.getInstance(BtcWalletService.class)).shutDown();
                        ((XmrWalletService)this.injector.getInstance(XmrWalletService.class)).shutDown();
                        ((XmrConnectionService)this.injector.getInstance(XmrConnectionService.class)).shutDown();
                        ((WalletsSetup)this.injector.getInstance(WalletsSetup.class)).shutDown();
                    });
                    UserThread.runAfter(() -> PersistenceManager.flushAllDataToDiskAtShutdown(() -> {
                        resultHandler.handleResult();
                        log.warn("Graceful shutdown caused a timeout. Exiting now.");
                        UserThread.runAfter(() -> System.exit(0), (long)1L);
                    }), (long)5L);
                    break block6;
                }
                UserThread.runAfter(() -> {
                    resultHandler.handleResult();
                    System.exit(0);
                }, (long)1L);
            }
            catch (Throwable t) {
                log.info("App shutdown failed with exception: {}\n", (Object)t.getMessage(), (Object)t);
                PersistenceManager.flushAllDataToDiskAtShutdown(() -> {
                    resultHandler.handleResult();
                    log.info("Graceful shutdown resulted in an error. Exiting now.");
                    UserThread.runAfter(() -> System.exit(1), (long)1L);
                });
            }
        }
    }

    public void startShutDownInterval(GracefulShutDownHandler gracefulShutDownHandler) {
        if (DevEnv.isDevMode() || ((Config)this.injector.getInstance(Config.class)).useLocalhostForP2P) {
            return;
        }
        ArrayList<NodeAddress> seedNodeAddresses = new ArrayList<NodeAddress>(((SeedNodeRepository)this.injector.getInstance(SeedNodeRepository.class)).getSeedNodeAddresses());
        seedNodeAddresses.sort(Comparator.comparing(NodeAddress::getFullAddress));
        NodeAddress myAddress = ((P2PService)this.injector.getInstance(P2PService.class)).getNetworkNode().getNodeAddress();
        int myIndex = -1;
        for (int i = 0; i < seedNodeAddresses.size(); ++i) {
            if (!((NodeAddress)seedNodeAddresses.get(i)).equals((Object)myAddress)) continue;
            myIndex = i;
            break;
        }
        if (myIndex == -1) {
            log.warn("We did not find our node address in the seed nodes repository. We use a 24 hour delay after startup as shut down strategy.myAddress={}, seedNodeAddresses={}", (Object)myAddress, seedNodeAddresses);
            UserThread.runPeriodically(() -> {
                if (System.currentTimeMillis() - this.startTime > SHUTDOWN_INTERVAL) {
                    log.warn("\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\nShut down as node was running longer as {} hours\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n", (Object)(SHUTDOWN_INTERVAL / 3600000L));
                    this.shutDown(gracefulShutDownHandler);
                }
            }, (long)CHECK_SHUTDOWN_SEC);
            return;
        }
        int target = myIndex;
        UserThread.runAfter(() -> UserThread.runPeriodically(() -> {
            int currentHour = ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).getHour();
            if (currentHour == target) {
                log.warn("\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\nShut down node at hour {} (UTC time is {})\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n", (Object)target, (Object)ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).toString());
                this.shutDown(gracefulShutDownHandler);
            }
        }, (long)TimeUnit.MINUTES.toSeconds(10L)), (long)TimeUnit.HOURS.toSeconds(2L));
    }

    protected void checkMemory(Config config, GracefulShutDownHandler gracefulShutDownHandler) {
        int maxMemory = config.maxMemory;
        UserThread.runPeriodically(() -> {
            Profiler.printSystemLoad();
            if (!this.stopped) {
                double warningTrigger;
                long usedMemoryInMB = Profiler.getUsedMemoryInMB();
                if ((double)usedMemoryInMB > (warningTrigger = (double)maxMemory * 0.8)) {
                    log.warn("\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\nWe are over 80% of our memory limit ({}) and call the GC. usedMemory: {} MB. freeMemory: {} MB\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n", new Object[]{(int)warningTrigger, usedMemoryInMB, Profiler.getFreeMemoryInMB()});
                    System.gc();
                    Profiler.printSystemLoad();
                }
                UserThread.runAfter(() -> log.info("Memory 2 sec. after calling the GC. usedMemory: {} MB. freeMemory: {} MB", (Object)Profiler.getUsedMemoryInMB(), (Object)Profiler.getFreeMemoryInMB()), (long)2L);
                UserThread.runAfter(() -> {
                    long usedMemory = Profiler.getUsedMemoryInMB();
                    if (usedMemory > (long)maxMemory) {
                        log.warn("\n\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\nWe are over our memory limit ({}) and trigger a shutdown. usedMemory: {} MB. freeMemory: {} MB\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n\n", new Object[]{maxMemory, usedMemory, Profiler.getFreeMemoryInMB()});
                        this.shutDown(gracefulShutDownHandler);
                    }
                }, (long)5L);
            }
        }, (long)300L);
    }

    protected void shutDown(GracefulShutDownHandler gracefulShutDownHandler) {
        this.stopped = true;
        gracefulShutDownHandler.gracefulShutDown(() -> {
            log.info("Shutdown complete");
            System.exit(1);
        });
    }
}

