/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app.misc;

import com.google.inject.Inject;
import haveno.common.app.Version;
import haveno.common.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppSetup {
    private static final Logger log = LoggerFactory.getLogger(AppSetup.class);
    protected final Config config;

    @Inject
    public AppSetup(Config config) {
        this.config = config;
        Version.setBaseCryptoNetworkId((int)this.config.baseCurrencyNetwork.ordinal());
        Version.printVersion();
    }

    public void start() {
        this.initPersistedDataHosts();
        this.initBasicServices();
    }

    abstract void initPersistedDataHosts();

    abstract void initBasicServices();
}

