/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.file.FileUtil;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TorSetup {
    private static final Logger log = LoggerFactory.getLogger(TorSetup.class);
    private final File torDir;

    @Inject
    public TorSetup(@Named(value="torDir") File torDir) {
        this.torDir = Preconditions.checkDir((File)torDir);
    }

    public void cleanupTorFiles(@Nullable Runnable resultHandler, @Nullable ErrorMessageHandler errorMessageHandler) {
        block3: {
            File hiddenservice = new File(Paths.get(this.torDir.getAbsolutePath(), "hiddenservice").toString());
            try {
                FileUtil.deleteDirectory((File)this.torDir, (File)hiddenservice, (boolean)true);
                if (resultHandler != null) {
                    resultHandler.run();
                }
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
                if (errorMessageHandler == null) break block3;
                errorMessageHandler.handleErrorMessage(e.toString());
            }
        }
    }
}

