/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.UserThread;
import haveno.core.api.XmrConnectionService;
import haveno.core.locale.Res;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.user.Preferences;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import haveno.network.p2p.network.CloseConnectionReason;
import haveno.network.p2p.network.Connection;
import haveno.network.p2p.network.ConnectionListener;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class P2PNetworkSetup {
    private static final Logger log = LoggerFactory.getLogger(P2PNetworkSetup.class);
    private final PriceFeedService priceFeedService;
    private final P2PService p2PService;
    private final XmrConnectionService xmrConnectionService;
    private final Preferences preferences;
    private MonadicBinding<String> p2PNetworkInfoBinding;
    final StringProperty p2PNetworkInfo = new SimpleStringProperty();
    final StringProperty p2PNetworkIconId = new SimpleStringProperty();
    final StringProperty p2PNetworkStatusIconId = new SimpleStringProperty();
    final BooleanProperty splashP2PNetworkAnimationVisible = new SimpleBooleanProperty(true);
    final StringProperty p2pNetworkLabelId = new SimpleStringProperty("footer-pane");
    final StringProperty p2pNetworkWarnMsg = new SimpleStringProperty();
    final BooleanProperty updatedDataReceived = new SimpleBooleanProperty();
    final BooleanProperty p2pNetworkFailed = new SimpleBooleanProperty();

    @Inject
    public P2PNetworkSetup(PriceFeedService priceFeedService, P2PService p2PService, XmrConnectionService xmrConnectionService, Preferences preferences) {
        this.priceFeedService = priceFeedService;
        this.p2PService = p2PService;
        this.xmrConnectionService = xmrConnectionService;
        this.preferences = preferences;
    }

    BooleanProperty init(Runnable onReadyHandler, @Nullable Consumer<Boolean> displayTorNetworkSettingsHandler) {
        SimpleStringProperty bootstrapState = new SimpleStringProperty();
        SimpleStringProperty bootstrapWarning = new SimpleStringProperty();
        SimpleBooleanProperty hiddenServicePublished = new SimpleBooleanProperty();
        SimpleBooleanProperty initialP2PNetworkDataReceived = new SimpleBooleanProperty();
        this.p2PNetworkInfoBinding = EasyBind.combine((ObservableValue)bootstrapState, (ObservableValue)bootstrapWarning, (ObservableValue)this.p2PService.getNumConnectedPeers(), (ObservableValue)this.xmrConnectionService.numConnectionsProperty(), (ObservableValue)hiddenServicePublished, (ObservableValue)initialP2PNetworkDataReceived, (state, warning, numP2pPeers, numXmrPeers, hiddenService, dataReceived) -> {
            Object result;
            int p2pPeers = (Integer)numP2pPeers;
            if (warning != null && p2pPeers == 0) {
                result = warning;
            } else {
                String p2pInfo = (String)((Integer)numXmrPeers >= 0 ? Res.get("mainView.footer.xmrPeers", numXmrPeers) + " / " : "") + Res.get("mainView.footer.p2pPeers", numP2pPeers);
                result = dataReceived != false && hiddenService != false ? p2pInfo : (p2pPeers == 0 ? state : state + " / " + p2pInfo);
            }
            return result;
        });
        this.p2PNetworkInfoBinding.subscribe((observable, oldValue, newValue) -> UserThread.execute(() -> this.p2PNetworkInfo.set(newValue)));
        bootstrapState.set((Object)Res.get("mainView.bootstrapState.connectionToTorNetwork"));
        this.p2PService.getNetworkNode().addConnectionListener(new ConnectionListener(){

            public void onConnection(Connection connection) {
                P2PNetworkSetup.this.updateNetworkStatusIndicator();
            }

            public void onDisconnect(CloseConnectionReason closeConnectionReason, Connection connection) {
                P2PNetworkSetup.this.updateNetworkStatusIndicator();
                if (connection.getConnectionState().isSeedNode() && closeConnectionReason == CloseConnectionReason.RULE_VIOLATION) {
                    log.warn("RULE_VIOLATION onDisconnect closeConnectionReason={}, connection={}", (Object)closeConnectionReason, (Object)connection);
                }
            }
        });
        SimpleBooleanProperty p2pNetworkInitialized = new SimpleBooleanProperty();
        this.p2PService.start(new P2PServiceListener(){
            final /* synthetic */ StringProperty val$bootstrapState;
            final /* synthetic */ Runnable val$onReadyHandler;
            final /* synthetic */ BooleanProperty val$hiddenServicePublished;
            final /* synthetic */ BooleanProperty val$initialP2PNetworkDataReceived;
            final /* synthetic */ BooleanProperty val$p2pNetworkInitialized;
            final /* synthetic */ StringProperty val$bootstrapWarning;
            final /* synthetic */ Consumer val$displayTorNetworkSettingsHandler;
            {
                this.val$bootstrapState = stringProperty;
                this.val$onReadyHandler = runnable;
                this.val$hiddenServicePublished = booleanProperty;
                this.val$initialP2PNetworkDataReceived = booleanProperty2;
                this.val$p2pNetworkInitialized = booleanProperty3;
                this.val$bootstrapWarning = stringProperty2;
                this.val$displayTorNetworkSettingsHandler = consumer;
            }

            public void onTorNodeReady() {
                log.debug("onTorNodeReady");
                this.val$bootstrapState.set((Object)Res.get("mainView.bootstrapState.torNodeCreated"));
                P2PNetworkSetup.this.p2PNetworkIconId.set((Object)"image-connection-tor");
                P2PNetworkSetup.this.priceFeedService.setCurrencyCodeOnInit();
                P2PNetworkSetup.this.priceFeedService.requestPrices();
                this.val$onReadyHandler.run();
            }

            public void onHiddenServicePublished() {
                log.debug("onHiddenServicePublished");
                this.val$hiddenServicePublished.set(true);
                this.val$bootstrapState.set((Object)Res.get("mainView.bootstrapState.hiddenServicePublished"));
            }

            public void onDataReceived() {
                log.debug("onRequestingDataCompleted");
                this.val$initialP2PNetworkDataReceived.set(true);
                this.val$bootstrapState.set((Object)Res.get("mainView.bootstrapState.initialDataReceived"));
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                this.val$p2pNetworkInitialized.set(true);
            }

            public void onNoSeedNodeAvailable() {
                log.warn("onNoSeedNodeAvailable");
                if (P2PNetworkSetup.this.p2PService.getNumConnectedPeers().get() == 0) {
                    this.val$bootstrapWarning.set((Object)Res.get("mainView.bootstrapWarning.noSeedNodesAvailable"));
                } else {
                    this.val$bootstrapWarning.set(null);
                }
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                this.val$p2pNetworkInitialized.set(true);
            }

            public void onNoPeersAvailable() {
                log.warn("onNoPeersAvailable");
                if (P2PNetworkSetup.this.p2PService.getNumConnectedPeers().get() == 0) {
                    P2PNetworkSetup.this.p2pNetworkWarnMsg.set((Object)Res.get("mainView.p2pNetworkWarnMsg.noNodesAvailable"));
                    this.val$bootstrapWarning.set((Object)Res.get("mainView.bootstrapWarning.noNodesAvailable"));
                    P2PNetworkSetup.this.p2pNetworkLabelId.set((Object)"splash-error-state-msg");
                } else {
                    this.val$bootstrapWarning.set(null);
                    P2PNetworkSetup.this.p2pNetworkLabelId.set((Object)"footer-pane");
                }
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                this.val$p2pNetworkInitialized.set(true);
            }

            public void onUpdatedDataReceived() {
                log.debug("onUpdatedDataReceived");
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                P2PNetworkSetup.this.updatedDataReceived.set(true);
            }

            public void onSetupFailed(Throwable throwable) {
                log.error("onSetupFailed");
                P2PNetworkSetup.this.p2pNetworkWarnMsg.set((Object)Res.get("mainView.p2pNetworkWarnMsg.connectionToP2PFailed", throwable.getMessage()));
                P2PNetworkSetup.this.splashP2PNetworkAnimationVisible.set(false);
                this.val$bootstrapWarning.set((Object)Res.get("mainView.bootstrapWarning.bootstrappingToP2PFailed"));
                P2PNetworkSetup.this.p2pNetworkLabelId.set((Object)"splash-error-state-msg");
                P2PNetworkSetup.this.p2pNetworkFailed.set(true);
            }

            public void onRequestCustomBridges() {
                if (this.val$displayTorNetworkSettingsHandler != null) {
                    this.val$displayTorNetworkSettingsHandler.accept(true);
                }
            }
        });
        return p2pNetworkInitialized;
    }

    public void setSplashP2PNetworkAnimationVisible(boolean value) {
        this.splashP2PNetworkAnimationVisible.set(value);
    }

    private void updateNetworkStatusIndicator() {
        if (this.p2PService.getNetworkNode().getInboundConnectionCount() > 0) {
            this.p2PNetworkStatusIconId.set((Object)"image-green_circle");
        } else if (this.p2PService.getNetworkNode().getOutboundConnectionCount() > 0) {
            this.p2PNetworkStatusIconId.set((Object)"image-yellow_circle");
        } else {
            this.p2PNetworkStatusIconId.set((Object)"image-alert-round");
        }
    }

    public StringProperty getP2PNetworkInfo() {
        return this.p2PNetworkInfo;
    }

    public StringProperty getP2PNetworkIconId() {
        return this.p2PNetworkIconId;
    }

    public StringProperty getP2PNetworkStatusIconId() {
        return this.p2PNetworkStatusIconId;
    }

    public BooleanProperty getSplashP2PNetworkAnimationVisible() {
        return this.splashP2PNetworkAnimationVisible;
    }

    public StringProperty getP2pNetworkLabelId() {
        return this.p2pNetworkLabelId;
    }

    public StringProperty getP2pNetworkWarnMsg() {
        return this.p2pNetworkWarnMsg;
    }

    public BooleanProperty getUpdatedDataReceived() {
        return this.updatedDataReceived;
    }

    public BooleanProperty getP2pNetworkFailed() {
        return this.p2pNetworkFailed;
    }
}

