/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import haveno.common.Timer;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.app.Version;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.file.FileUtil;
import haveno.common.util.InvalidVersionException;
import haveno.common.util.Utilities;
import haveno.core.account.sign.SignedWitness;
import haveno.core.account.sign.SignedWitnessStorageService;
import haveno.core.account.witness.AccountAgeWitnessService;
import haveno.core.alert.Alert;
import haveno.core.alert.AlertManager;
import haveno.core.alert.PrivateNotificationManager;
import haveno.core.alert.PrivateNotificationPayload;
import haveno.core.api.CoreContext;
import haveno.core.api.XmrConnectionService;
import haveno.core.api.XmrLocalNode;
import haveno.core.app.AppStartupState;
import haveno.core.app.DomainInitialisation;
import haveno.core.app.P2PNetworkSetup;
import haveno.core.app.TorSetup;
import haveno.core.app.WalletAppSetup;
import haveno.core.locale.Res;
import haveno.core.offer.OpenOfferManager;
import haveno.core.payment.AmazonGiftCardAccount;
import haveno.core.payment.RevolutAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.support.dispute.Dispute;
import haveno.core.support.dispute.arbitration.ArbitrationManager;
import haveno.core.support.dispute.mediation.MediationManager;
import haveno.core.support.dispute.refund.RefundManager;
import haveno.core.trade.HavenoUtils;
import haveno.core.trade.TradeManager;
import haveno.core.user.Preferences;
import haveno.core.user.User;
import haveno.core.util.coin.CoinFormatter;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.WalletsManager;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.Socks5ProxyProvider;
import haveno.network.p2p.NodeAddress;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.storage.payload.PersistableNetworkPayload;
import haveno.network.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.annotation.Nullable;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class HavenoSetup {
    private static final Logger log = LoggerFactory.getLogger(HavenoSetup.class);
    private static final String VERSION_FILE_NAME = "version";
    private static final int STARTUP_TIMEOUT_MINUTES = 5;
    private final DomainInitialisation domainInitialisation;
    private final P2PNetworkSetup p2PNetworkSetup;
    private final WalletAppSetup walletAppSetup;
    private final WalletsManager walletsManager;
    private final WalletsSetup walletsSetup;
    private final XmrConnectionService xmrConnectionService;
    private final XmrWalletService xmrWalletService;
    private final P2PService p2PService;
    private final PrivateNotificationManager privateNotificationManager;
    private final SignedWitnessStorageService signedWitnessStorageService;
    private final TradeManager tradeManager;
    private final OpenOfferManager openOfferManager;
    private final Preferences preferences;
    private final User user;
    private final AlertManager alertManager;
    private final Config config;
    private final CoreContext coreContext;
    private final AccountAgeWitnessService accountAgeWitnessService;
    private final TorSetup torSetup;
    private final CoinFormatter formatter;
    private final XmrLocalNode xmrLocalNode;
    private final AppStartupState appStartupState;
    private final MediationManager mediationManager;
    private final RefundManager refundManager;
    private final ArbitrationManager arbitrationManager;
    private final StringProperty topErrorMsg = new SimpleStringProperty();
    @Nullable
    private Consumer<Runnable> displayTacHandler;
    @Nullable
    private Consumer<String> chainFileLockedExceptionHandler;
    @Nullable
    private Consumer<String> lockedUpFundsHandler;
    @Nullable
    private Consumer<String> filterWarningHandler;
    @Nullable
    private Consumer<String> displaySecurityRecommendationHandler;
    @Nullable
    private Consumer<String> displayLocalhostHandler;
    @Nullable
    private Consumer<String> wrongOSArchitectureHandler;
    @Nullable
    private Consumer<String> displaySignedByArbitratorHandler;
    @Nullable
    private Consumer<String> displaySignedByPeerHandler;
    @Nullable
    private Consumer<String> displayPeerLimitLiftedHandler;
    @Nullable
    private Consumer<String> displayPeerSignerHandler;
    @Nullable
    private Consumer<String> rejectedTxErrorMessageHandler;
    @Nullable
    private Consumer<XmrConnectionService.XmrConnectionFallbackType> displayMoneroConnectionFallbackHandler;
    @Nullable
    private Consumer<Boolean> displayTorNetworkSettingsHandler;
    @Nullable
    private Runnable showFirstPopupIfResyncSPVRequestedHandler;
    @Nullable
    private Consumer<Alert> displayAlertHandler;
    @Nullable
    private BiConsumer<Alert, String> displayUpdateHandler;
    @Nullable
    private Consumer<PrivateNotificationPayload> displayPrivateNotificationHandler;
    @Nullable
    private Runnable showPopupIfInvalidXmrConfigHandler;
    @Nullable
    private Consumer<List<RevolutAccount>> revolutAccountsUpdateHandler;
    @Nullable
    private Consumer<List<AmazonGiftCardAccount>> amazonGiftCardAccountsUpdateHandler;
    @Nullable
    private Runnable osxKeyLoggerWarningHandler;
    @Nullable
    private Runnable qubesOSInfoHandler;
    @Nullable
    private Runnable torAddressUpgradeHandler;
    @Nullable
    private Consumer<String> downGradePreventionHandler;
    final BooleanProperty newVersionAvailableProperty = new SimpleBooleanProperty(false);
    private BooleanProperty p2pNetworkReady;
    private final BooleanProperty walletInitialized = new SimpleBooleanProperty();
    private boolean allBasicServicesInitialized;
    private MonadicBinding<Boolean> p2pNetworkAndWalletInitialized;
    private Timer startupTimeout;
    private final List<HavenoSetupListener> havenoSetupListeners = new ArrayList<HavenoSetupListener>();

    @Inject
    public HavenoSetup(DomainInitialisation domainInitialisation, P2PNetworkSetup p2PNetworkSetup, WalletAppSetup walletAppSetup, WalletsManager walletsManager, WalletsSetup walletsSetup, XmrConnectionService xmrConnectionService, XmrWalletService xmrWalletService, P2PService p2PService, PrivateNotificationManager privateNotificationManager, SignedWitnessStorageService signedWitnessStorageService, TradeManager tradeManager, OpenOfferManager openOfferManager, Preferences preferences, User user, AlertManager alertManager, Config config, CoreContext coreContext, AccountAgeWitnessService accountAgeWitnessService, TorSetup torSetup, @Named(value="BTC") CoinFormatter formatter, XmrLocalNode xmrLocalNode, AppStartupState appStartupState, Socks5ProxyProvider socks5ProxyProvider, MediationManager mediationManager, RefundManager refundManager, ArbitrationManager arbitrationManager) {
        this.domainInitialisation = domainInitialisation;
        this.p2PNetworkSetup = p2PNetworkSetup;
        this.walletAppSetup = walletAppSetup;
        this.walletsManager = walletsManager;
        this.walletsSetup = walletsSetup;
        this.xmrConnectionService = xmrConnectionService;
        this.xmrWalletService = xmrWalletService;
        this.p2PService = p2PService;
        this.privateNotificationManager = privateNotificationManager;
        this.signedWitnessStorageService = signedWitnessStorageService;
        this.tradeManager = tradeManager;
        this.openOfferManager = openOfferManager;
        this.preferences = preferences;
        this.user = user;
        this.alertManager = alertManager;
        this.config = config;
        this.coreContext = coreContext;
        this.accountAgeWitnessService = accountAgeWitnessService;
        this.torSetup = torSetup;
        this.formatter = formatter;
        this.xmrLocalNode = xmrLocalNode;
        this.appStartupState = appStartupState;
        this.mediationManager = mediationManager;
        this.refundManager = refundManager;
        this.arbitrationManager = arbitrationManager;
        HavenoUtils.havenoSetup = this;
        HavenoUtils.preferences = preferences;
    }

    public void displayAlertIfPresent(Alert alert, boolean openNewVersionPopup) {
        if (alert == null) {
            return;
        }
        if (alert.isSoftwareUpdateNotification()) {
            if (alert.isNewVersion(this.preferences)) {
                this.user.setDisplayedAlert(alert);
                this.newVersionAvailableProperty.set(true);
                if ((alert.canShowPopup(this.preferences) || openNewVersionPopup) && this.displayUpdateHandler != null) {
                    this.displayUpdateHandler.accept(alert, alert.showAgainKey());
                }
            }
        } else {
            Alert displayedAlert = this.user.getDisplayedAlert();
            if (!(displayedAlert != null && displayedAlert.equals(alert) || this.displayAlertHandler == null)) {
                this.displayAlertHandler.accept(alert);
            }
        }
    }

    public void addHavenoSetupListener(HavenoSetupListener listener) {
        this.havenoSetupListeners.add(listener);
    }

    public void start() {
        if (Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_MAINNET && HavenoSetup.hasDowngraded(this.downGradePreventionHandler)) {
            return;
        }
        HavenoSetup.persistHavenoVersion();
        this.maybeShowTac(this::step2);
    }

    private void step2() {
        this.readMapsFromResources(this::step3);
        this.checkForCorrectOSArchitecture();
        this.checkOSXVersion();
        this.checkIfRunningOnQubesOS();
    }

    private void step3() {
        this.maybeInstallDependencies();
        this.startP2pNetworkAndWallet(this::step4);
    }

    private void step4() {
        this.initDomainServices();
        this.havenoSetupListeners.forEach(HavenoSetupListener::onSetupComplete);
        this.maybeShowSecurityRecommendation();
        this.maybeShowLocalhostRunningInfo();
        this.maybeShowAccountSigningStateInfo();
        this.maybeShowTorAddressUpgradeInformation();
        this.checkInboundConnections();
    }

    private void maybeShowTac(Runnable nextStep) {
        if (!this.preferences.isTacAcceptedV120() && !DevEnv.isDevMode()) {
            if (this.displayTacHandler != null) {
                this.displayTacHandler.accept(() -> {
                    this.preferences.setTacAcceptedV120(true);
                    nextStep.run();
                });
            }
        } else {
            nextStep.run();
        }
    }

    private void maybeInstallDependencies() {
        try {
            File monerodFile = new File(XmrLocalNode.MONEROD_PATH);
            String monerodResourcePath = "bin/" + XmrLocalNode.MONEROD_NAME;
            if (!monerodFile.exists() || this.config.updateXmrBinaries && !FileUtil.resourceEqualToFile((String)monerodResourcePath, (File)monerodFile)) {
                log.info("Installing monerod");
                monerodFile.getParentFile().mkdirs();
                FileUtil.resourceToFile((String)("bin/" + XmrLocalNode.MONEROD_NAME), (File)monerodFile);
                monerodFile.setExecutable(true);
            }
            File moneroWalletRpcFile = new File(XmrWalletService.MONERO_WALLET_RPC_PATH);
            String moneroWalletRpcResourcePath = "bin/" + XmrWalletService.MONERO_WALLET_RPC_NAME;
            if (!moneroWalletRpcFile.exists() || this.config.updateXmrBinaries && !FileUtil.resourceEqualToFile((String)moneroWalletRpcResourcePath, (File)moneroWalletRpcFile)) {
                log.info("Installing monero-wallet-rpc");
                moneroWalletRpcFile.getParentFile().mkdirs();
                FileUtil.resourceToFile((String)moneroWalletRpcResourcePath, (File)moneroWalletRpcFile);
                moneroWalletRpcFile.setExecutable(true);
            }
        }
        catch (Exception e) {
            log.warn("Failed to install Monero binaries: {}\n", (Object)e.getMessage(), (Object)e);
        }
    }

    private void readMapsFromResources(Runnable completeHandler) {
        String postFix = "_" + this.config.baseCurrencyNetwork.name();
        this.p2PService.getP2PDataStorage().readFromResources(postFix, completeHandler);
    }

    private synchronized void resetStartupTimeout() {
        if (this.p2pNetworkAndWalletInitialized != null && ((Boolean)this.p2pNetworkAndWalletInitialized.get()).booleanValue()) {
            return;
        }
        if (this.startupTimeout != null) {
            this.startupTimeout.stop();
        }
        this.startupTimeout = UserThread.runAfter(() -> {
            if (this.p2PNetworkSetup.p2pNetworkFailed.get() || this.walletsSetup.walletsSetupFailed.get()) {
                return;
            }
            log.warn("startupTimeout called");
            if (this.displayTorNetworkSettingsHandler != null) {
                this.displayTorNetworkSettingsHandler.accept(true);
            }
        }, (long)5L, (TimeUnit)TimeUnit.MINUTES);
    }

    private void startP2pNetworkAndWallet(Runnable nextStep) {
        ChangeListener walletInitializedListener = (observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && !this.p2pNetworkReady.get() && this.displayTorNetworkSettingsHandler != null) {
                this.displayTorNetworkSettingsHandler.accept(true);
            }
        };
        this.resetStartupTimeout();
        this.getXmrDaemonSyncProgress().addListener((observable, oldValue, newValue) -> this.resetStartupTimeout());
        this.getXmrWalletSyncProgress().addListener((observable, oldValue, newValue) -> this.resetStartupTimeout());
        this.getConnectionServiceFallbackType().addListener((observable, oldValue, newValue) -> {
            if (this.displayMoneroConnectionFallbackHandler == null) {
                return;
            }
            this.displayMoneroConnectionFallbackHandler.accept((XmrConnectionService.XmrConnectionFallbackType)((Object)newValue));
        });
        log.info("Init P2P network");
        this.havenoSetupListeners.forEach(HavenoSetupListener::onInitP2pNetwork);
        this.p2pNetworkReady = this.p2PNetworkSetup.init(this::initWallet, this.displayTorNetworkSettingsHandler);
        this.p2pNetworkAndWalletInitialized = EasyBind.combine((ObservableValue)this.walletInitialized, (ObservableValue)this.p2pNetworkReady, (a, b) -> {
            log.info("walletInitialized={}, p2pNetWorkReady={}", a, b);
            return a != false && b != false;
        });
        this.p2pNetworkAndWalletInitialized.subscribe((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.startupTimeout.stop();
                this.walletInitialized.removeListener(walletInitializedListener);
                if (this.displayTorNetworkSettingsHandler != null) {
                    this.displayTorNetworkSettingsHandler.accept(false);
                }
                nextStep.run();
            }
        });
    }

    private void initWallet() {
        log.info("Init wallet");
        this.havenoSetupListeners.forEach(HavenoSetupListener::onInitWallet);
        this.walletAppSetup.init(this.chainFileLockedExceptionHandler, this.showFirstPopupIfResyncSPVRequestedHandler, this.showPopupIfInvalidXmrConfigHandler, () -> {}, () -> {});
    }

    private void initDomainServices() {
        log.info("initDomainServices");
        this.domainInitialisation.initDomainServices(this.rejectedTxErrorMessageHandler, this.displayPrivateNotificationHandler, this.filterWarningHandler, this.revolutAccountsUpdateHandler, this.amazonGiftCardAccountsUpdateHandler);
        this.alertManager.alertMessageProperty().addListener((observable, oldValue, newValue) -> this.displayAlertIfPresent((Alert)newValue, false));
        this.displayAlertIfPresent((Alert)this.alertManager.alertMessageProperty().get(), false);
        this.allBasicServicesInitialized = true;
        this.appStartupState.onDomainServicesInitialized();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getLastHavenoVersion() {
        File versionFile = HavenoSetup.getVersionFile();
        if (!versionFile.exists()) {
            return null;
        }
        try (Scanner scanner = new Scanner(versionFile);){
            if (!scanner.hasNextLine()) return null;
            String string = scanner.nextLine();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static File getVersionFile() {
        return new File(Config.appDataDir(), VERSION_FILE_NAME);
    }

    public static boolean hasDowngraded() {
        return HavenoSetup.hasDowngraded(HavenoSetup.getLastHavenoVersion());
    }

    public static boolean hasDowngraded(String lastVersion) {
        return lastVersion != null && Version.isNewVersion((String)lastVersion, (String)"1.2.2");
    }

    public static boolean hasDowngraded(@Nullable Consumer<String> downGradePreventionHandler) {
        String lastVersion = HavenoSetup.getLastHavenoVersion();
        boolean hasDowngraded = HavenoSetup.hasDowngraded(lastVersion);
        if (hasDowngraded) {
            log.error("Downgrade from version {} to version {} is not supported", (Object)lastVersion, (Object)"1.2.2");
            if (downGradePreventionHandler != null) {
                downGradePreventionHandler.accept(lastVersion);
            }
        }
        return hasDowngraded;
    }

    public static void persistHavenoVersion() {
        File versionFile = HavenoSetup.getVersionFile();
        if (!versionFile.exists()) {
            try {
                if (!versionFile.createNewFile()) {
                    log.error("Version file could not be created");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("Version file could not be created. {}", (Object)e.toString());
            }
        }
        try (FileWriter fileWriter = new FileWriter(versionFile, false);){
            fileWriter.write("1.2.2");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Writing Version failed. {}", (Object)e.toString());
        }
    }

    private void checkForCorrectOSArchitecture() {
        if (!Utilities.isCorrectOSArchitecture() && this.wrongOSArchitectureHandler != null) {
            String osArchitecture = Utilities.getOSArchitecture();
            this.wrongOSArchitectureHandler.accept(Res.get("popup.warning.wrongVersion", osArchitecture, Utilities.getJVMArchitecture(), osArchitecture));
        }
    }

    private void checkOSXVersion() {
        if (Utilities.isOSX() && this.osxKeyLoggerWarningHandler != null) {
            try {
                if (Utilities.getMajorVersion() >= 10 && Utilities.getMinorVersion() >= 14) {
                    this.osxKeyLoggerWarningHandler.run();
                }
            }
            catch (InvalidVersionException | NumberFormatException e) {
                log.warn(e.getMessage());
            }
        }
    }

    private void checkIfRunningOnQubesOS() {
        if (Utilities.isQubesOS() && this.qubesOSInfoHandler != null) {
            this.qubesOSInfoHandler.run();
        }
    }

    private void checkInboundConnections() {
        NodeAddress onionAddress = (NodeAddress)this.p2PService.getNetworkNode().nodeAddressProperty().get();
        if (onionAddress == null || !onionAddress.getFullAddress().contains("onion")) {
            return;
        }
        if (this.p2PService.getNetworkNode().upTime() > TimeUnit.HOURS.toMillis(1L) && this.p2PService.getNetworkNode().getInboundConnectionCount() == 0) {
            log.info("no recent inbound connections found, starting the self-ping test");
            this.privateNotificationManager.sendPing(onionAddress, stringResult -> {
                log.info(stringResult);
                if (stringResult.contains("failed")) {
                    this.getP2PNetworkStatusIconId().set((Object)"flashing:image-yellow_circle");
                }
            });
        }
        int nextCheckInMinutes = 30 + new Random().nextInt(30);
        log.debug("next inbound connections check in {} minutes", (Object)nextCheckInMinutes);
        UserThread.runAfter(this::checkInboundConnections, (long)nextCheckInMinutes, (TimeUnit)TimeUnit.MINUTES);
    }

    private void maybeShowSecurityRecommendation() {
        if (this.user.getPaymentAccountsAsObservable() == null) {
            return;
        }
        String key = "remindPasswordAndBackup";
        this.user.getPaymentAccountsAsObservable().addListener(change -> {
            if (!this.walletsManager.areWalletsEncrypted() && !this.user.isPaymentAccountImport() && this.preferences.showAgain(key) && change.wasAdded() && this.displaySecurityRecommendationHandler != null) {
                this.displaySecurityRecommendationHandler.accept(key);
            }
        });
    }

    private void maybeShowLocalhostRunningInfo() {
        this.maybeTriggerDisplayHandler("xmrLocalNode", this.displayLocalhostHandler, this.xmrLocalNode.shouldBeUsed());
    }

    private void maybeShowAccountSigningStateInfo() {
        String keySignedByArbitrator = "accountSignedByArbitrator";
        String keySignedByPeer = "accountSignedByPeer";
        String keyPeerLimitedLifted = "accountLimitLifted";
        String keyPeerSigner = "accountPeerSigner";
        this.checkSigningState(AccountAgeWitnessService.SignState.ARBITRATOR, keySignedByArbitrator, this.displaySignedByArbitratorHandler);
        this.checkSigningState(AccountAgeWitnessService.SignState.PEER_INITIAL, keySignedByPeer, this.displaySignedByPeerHandler);
        this.checkSigningState(AccountAgeWitnessService.SignState.PEER_LIMIT_LIFTED, keyPeerLimitedLifted, this.displayPeerLimitLiftedHandler);
        this.checkSigningState(AccountAgeWitnessService.SignState.PEER_SIGNER, keyPeerSigner, this.displayPeerSignerHandler);
        this.p2PService.getP2PDataStorage().addAppendOnlyDataStoreListener(payload -> {
            this.maybeTriggerDisplayHandler(keySignedByArbitrator, this.displaySignedByArbitratorHandler, this.isSignedWitnessOfMineWithState(payload, AccountAgeWitnessService.SignState.ARBITRATOR));
            this.maybeTriggerDisplayHandler(keySignedByPeer, this.displaySignedByPeerHandler, this.isSignedWitnessOfMineWithState(payload, AccountAgeWitnessService.SignState.PEER_INITIAL));
            this.maybeTriggerDisplayHandler(keyPeerLimitedLifted, this.displayPeerLimitLiftedHandler, this.isSignedWitnessOfMineWithState(payload, AccountAgeWitnessService.SignState.PEER_LIMIT_LIFTED));
            this.maybeTriggerDisplayHandler(keyPeerSigner, this.displayPeerSignerHandler, this.isSignedWitnessOfMineWithState(payload, AccountAgeWitnessService.SignState.PEER_SIGNER));
        });
    }

    private void checkSigningState(AccountAgeWitnessService.SignState state, String key, Consumer<String> displayHandler) {
        boolean signingStateFound = this.signedWitnessStorageService.getMap().values().stream().anyMatch(payload -> this.isSignedWitnessOfMineWithState((PersistableNetworkPayload)payload, state));
        this.maybeTriggerDisplayHandler(key, displayHandler, signingStateFound);
    }

    private boolean isSignedWitnessOfMineWithState(PersistableNetworkPayload payload, AccountAgeWitnessService.SignState state) {
        if (payload instanceof SignedWitness && this.user.getPaymentAccounts() != null) {
            return this.user.getPaymentAccounts().stream().filter(a -> PaymentMethod.hasChargebackRisk(a.getPaymentMethod(), a.getTradeCurrencies())).filter(a -> Arrays.equals(((SignedWitness)payload).getAccountAgeWitnessHash(), this.accountAgeWitnessService.getMyWitness(a.getPaymentAccountPayload()).getHash())).anyMatch(a -> this.accountAgeWitnessService.getSignState(this.accountAgeWitnessService.getMyWitness(a.getPaymentAccountPayload())).equals((Object)state));
        }
        return false;
    }

    private void maybeTriggerDisplayHandler(String key, Consumer<String> displayHandler, boolean signingStateFound) {
        if (signingStateFound && this.preferences.showAgain(key) && displayHandler != null) {
            displayHandler.accept(key);
        }
    }

    private void maybeShowTorAddressUpgradeInformation() {
        if (Config.baseCurrencyNetwork().isTestnet() || Utils.isV3Address((String)Objects.requireNonNull(this.p2PService.getNetworkNode().getNodeAddress()).getHostName())) {
            return;
        }
        this.maybeRunTorNodeAddressUpgradeHandler();
        this.tradeManager.getNumPendingTrades().addListener((observable, oldValue, newValue) -> {
            long numPendingTrades = (Long)newValue;
            if (numPendingTrades == 0L) {
                this.maybeRunTorNodeAddressUpgradeHandler();
            }
        });
    }

    private void maybeRunTorNodeAddressUpgradeHandler() {
        if (this.mediationManager.getDisputesAsObservableList().stream().allMatch(Dispute::isClosed) && this.refundManager.getDisputesAsObservableList().stream().allMatch(Dispute::isClosed) && this.arbitrationManager.getDisputesAsObservableList().stream().allMatch(Dispute::isClosed) && this.tradeManager.getNumPendingTrades().isEqualTo(0).get()) {
            Objects.requireNonNull(this.torAddressUpgradeHandler).run();
        }
    }

    public StringProperty getXmrInfo() {
        return this.walletAppSetup.getXmrInfo();
    }

    public DoubleProperty getXmrDaemonSyncProgress() {
        return this.walletAppSetup.getXmrDaemonSyncProgress();
    }

    public DoubleProperty getXmrWalletSyncProgress() {
        return this.walletAppSetup.getXmrWalletSyncProgress();
    }

    public StringProperty getConnectionServiceErrorMsg() {
        return this.xmrConnectionService.getConnectionServiceErrorMsg();
    }

    public ObjectProperty<XmrConnectionService.XmrConnectionFallbackType> getConnectionServiceFallbackType() {
        return this.xmrConnectionService.getConnectionServiceFallbackType();
    }

    public StringProperty getTopErrorMsg() {
        return this.topErrorMsg;
    }

    public StringProperty getXmrSplashSyncIconId() {
        return this.walletAppSetup.getXmrSplashSyncIconId();
    }

    public ObjectProperty<Preferences.UseTorForXmr> getUseTorForXmr() {
        return this.walletAppSetup.getUseTorForXmr();
    }

    public StringProperty getP2PNetworkInfo() {
        return this.p2PNetworkSetup.getP2PNetworkInfo();
    }

    public BooleanProperty getSplashP2PNetworkAnimationVisible() {
        return this.p2PNetworkSetup.getSplashP2PNetworkAnimationVisible();
    }

    public StringProperty getP2pNetworkWarnMsg() {
        return this.p2PNetworkSetup.getP2pNetworkWarnMsg();
    }

    public StringProperty getP2PNetworkIconId() {
        return this.p2PNetworkSetup.getP2PNetworkIconId();
    }

    public StringProperty getP2PNetworkStatusIconId() {
        return this.p2PNetworkSetup.getP2PNetworkStatusIconId();
    }

    public BooleanProperty getUpdatedDataReceived() {
        return this.p2PNetworkSetup.getUpdatedDataReceived();
    }

    public StringProperty getP2pNetworkLabelId() {
        return this.p2PNetworkSetup.getP2pNetworkLabelId();
    }

    public BooleanProperty getWalletInitialized() {
        return this.walletInitialized;
    }

    public AppStartupState getAppStartupState() {
        return this.appStartupState;
    }

    public XmrWalletService getXmrWalletService() {
        return this.xmrWalletService;
    }

    public Config getConfig() {
        return this.config;
    }

    public CoreContext getCoreContext() {
        return this.coreContext;
    }

    public void setDisplayTacHandler(@Nullable Consumer<Runnable> displayTacHandler) {
        this.displayTacHandler = displayTacHandler;
    }

    public void setChainFileLockedExceptionHandler(@Nullable Consumer<String> chainFileLockedExceptionHandler) {
        this.chainFileLockedExceptionHandler = chainFileLockedExceptionHandler;
    }

    public void setLockedUpFundsHandler(@Nullable Consumer<String> lockedUpFundsHandler) {
        this.lockedUpFundsHandler = lockedUpFundsHandler;
    }

    public void setFilterWarningHandler(@Nullable Consumer<String> filterWarningHandler) {
        this.filterWarningHandler = filterWarningHandler;
    }

    public void setDisplaySecurityRecommendationHandler(@Nullable Consumer<String> displaySecurityRecommendationHandler) {
        this.displaySecurityRecommendationHandler = displaySecurityRecommendationHandler;
    }

    public void setDisplayLocalhostHandler(@Nullable Consumer<String> displayLocalhostHandler) {
        this.displayLocalhostHandler = displayLocalhostHandler;
    }

    public void setWrongOSArchitectureHandler(@Nullable Consumer<String> wrongOSArchitectureHandler) {
        this.wrongOSArchitectureHandler = wrongOSArchitectureHandler;
    }

    public void setDisplaySignedByArbitratorHandler(@Nullable Consumer<String> displaySignedByArbitratorHandler) {
        this.displaySignedByArbitratorHandler = displaySignedByArbitratorHandler;
    }

    public void setDisplaySignedByPeerHandler(@Nullable Consumer<String> displaySignedByPeerHandler) {
        this.displaySignedByPeerHandler = displaySignedByPeerHandler;
    }

    public void setDisplayPeerLimitLiftedHandler(@Nullable Consumer<String> displayPeerLimitLiftedHandler) {
        this.displayPeerLimitLiftedHandler = displayPeerLimitLiftedHandler;
    }

    public void setDisplayPeerSignerHandler(@Nullable Consumer<String> displayPeerSignerHandler) {
        this.displayPeerSignerHandler = displayPeerSignerHandler;
    }

    public void setRejectedTxErrorMessageHandler(@Nullable Consumer<String> rejectedTxErrorMessageHandler) {
        this.rejectedTxErrorMessageHandler = rejectedTxErrorMessageHandler;
    }

    public void setDisplayMoneroConnectionFallbackHandler(@Nullable Consumer<XmrConnectionService.XmrConnectionFallbackType> displayMoneroConnectionFallbackHandler) {
        this.displayMoneroConnectionFallbackHandler = displayMoneroConnectionFallbackHandler;
    }

    public void setDisplayTorNetworkSettingsHandler(@Nullable Consumer<Boolean> displayTorNetworkSettingsHandler) {
        this.displayTorNetworkSettingsHandler = displayTorNetworkSettingsHandler;
    }

    public void setShowFirstPopupIfResyncSPVRequestedHandler(@Nullable Runnable showFirstPopupIfResyncSPVRequestedHandler) {
        this.showFirstPopupIfResyncSPVRequestedHandler = showFirstPopupIfResyncSPVRequestedHandler;
    }

    public void setDisplayAlertHandler(@Nullable Consumer<Alert> displayAlertHandler) {
        this.displayAlertHandler = displayAlertHandler;
    }

    public void setDisplayUpdateHandler(@Nullable BiConsumer<Alert, String> displayUpdateHandler) {
        this.displayUpdateHandler = displayUpdateHandler;
    }

    public void setDisplayPrivateNotificationHandler(@Nullable Consumer<PrivateNotificationPayload> displayPrivateNotificationHandler) {
        this.displayPrivateNotificationHandler = displayPrivateNotificationHandler;
    }

    public void setShowPopupIfInvalidXmrConfigHandler(@Nullable Runnable showPopupIfInvalidXmrConfigHandler) {
        this.showPopupIfInvalidXmrConfigHandler = showPopupIfInvalidXmrConfigHandler;
    }

    public void setRevolutAccountsUpdateHandler(@Nullable Consumer<List<RevolutAccount>> revolutAccountsUpdateHandler) {
        this.revolutAccountsUpdateHandler = revolutAccountsUpdateHandler;
    }

    public void setAmazonGiftCardAccountsUpdateHandler(@Nullable Consumer<List<AmazonGiftCardAccount>> amazonGiftCardAccountsUpdateHandler) {
        this.amazonGiftCardAccountsUpdateHandler = amazonGiftCardAccountsUpdateHandler;
    }

    public void setOsxKeyLoggerWarningHandler(@Nullable Runnable osxKeyLoggerWarningHandler) {
        this.osxKeyLoggerWarningHandler = osxKeyLoggerWarningHandler;
    }

    public void setQubesOSInfoHandler(@Nullable Runnable qubesOSInfoHandler) {
        this.qubesOSInfoHandler = qubesOSInfoHandler;
    }

    public void setTorAddressUpgradeHandler(@Nullable Runnable torAddressUpgradeHandler) {
        this.torAddressUpgradeHandler = torAddressUpgradeHandler;
    }

    public void setDownGradePreventionHandler(@Nullable Consumer<String> downGradePreventionHandler) {
        this.downGradePreventionHandler = downGradePreventionHandler;
    }

    public BooleanProperty getNewVersionAvailableProperty() {
        return this.newVersionAvailableProperty;
    }

    public static interface HavenoSetupListener {
        default public void onInitP2pNetwork() {
        }

        default public void onInitWallet() {
        }

        default public void onRequestWalletPassword() {
        }

        public void onSetupComplete();
    }
}

