/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import haveno.common.UserThread;
import haveno.common.app.AppModule;
import haveno.core.app.CoreModule;
import haveno.core.app.HavenoExecutable;
import haveno.core.app.HavenoHeadlessApp;
import haveno.core.app.HeadlessApp;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoHeadlessAppMain
extends HavenoExecutable {
    private static final Logger log = LoggerFactory.getLogger(HavenoHeadlessAppMain.class);
    protected HeadlessApp headlessApp;

    public HavenoHeadlessAppMain() {
        super("Haveno Daemon", "havenod", "Haveno-reto", "1.2.2");
    }

    public static void main(String[] args) throws Exception {
        Thread.currentThread().setContextClassLoader(HavenoHeadlessAppMain.class.getClassLoader());
        new HavenoHeadlessAppMain().execute(args);
    }

    @Override
    protected int doExecute() {
        super.doExecute();
        return this.keepRunning();
    }

    @Override
    protected void configUserThread() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName()).setDaemon(true).build();
        UserThread.setExecutor((Executor)Executors.newSingleThreadExecutor(threadFactory));
    }

    @Override
    protected void launchApplication() {
        this.headlessApp = new HavenoHeadlessApp();
        UserThread.execute(this::onApplicationLaunched);
    }

    @Override
    protected void onApplicationLaunched() {
        super.onApplicationLaunched();
        this.headlessApp.setGracefulShutDownHandler(this);
    }

    @Override
    public void handleUncaughtException(Throwable throwable, boolean doShutDown) {
        this.headlessApp.handleUncaughtException(throwable, doShutDown);
    }

    @Override
    public void onSetupComplete() {
        log.info("onSetupComplete");
    }

    @Override
    protected AppModule getModule() {
        return new CoreModule(this.config);
    }

    @Override
    protected void applyInjector() {
        super.applyInjector();
        this.headlessApp.setInjector(this.injector);
    }

    @Override
    protected void startApplication() {
        this.headlessApp.startApplication();
        this.onApplicationStarted();
    }
}

