/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Injector;
import haveno.common.UserThread;
import haveno.common.file.CorruptedStorageFileHandler;
import haveno.common.setup.GracefulShutDownHandler;
import haveno.core.app.HavenoSetup;
import haveno.core.app.HeadlessApp;
import haveno.core.trade.TradeManager;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HavenoHeadlessApp
implements HeadlessApp {
    private static final Logger log = LoggerFactory.getLogger(HavenoHeadlessApp.class);
    private static Runnable shutDownHandler;
    public static Runnable onGracefulShutDownHandler;
    protected Injector injector;
    private GracefulShutDownHandler gracefulShutDownHandler;
    private boolean shutDownRequested;
    protected HavenoSetup havenoSetup;
    private CorruptedStorageFileHandler corruptedStorageFileHandler;
    private TradeManager tradeManager;

    public HavenoHeadlessApp() {
        shutDownHandler = this::stop;
    }

    @Override
    public void startApplication() {
        try {
            this.havenoSetup = (HavenoSetup)this.injector.getInstance(HavenoSetup.class);
            this.havenoSetup.addHavenoSetupListener(this);
            this.corruptedStorageFileHandler = (CorruptedStorageFileHandler)this.injector.getInstance(CorruptedStorageFileHandler.class);
            this.tradeManager = (TradeManager)this.injector.getInstance(TradeManager.class);
            this.setupHandlers();
        }
        catch (Throwable throwable) {
            log.error("Error during app init", throwable);
            this.handleUncaughtException(throwable, false);
        }
    }

    @Override
    public void onSetupComplete() {
        log.info("onSetupComplete");
    }

    protected void setupHandlers() {
        this.havenoSetup.setDisplayTacHandler(acceptedHandler -> {
            log.info("onDisplayTacHandler: We accept the tacs automatically in headless mode");
            acceptedHandler.run();
        });
        this.havenoSetup.setDisplayMoneroConnectionFallbackHandler(show -> log.warn("onDisplayMoneroConnectionFallbackHandler: show={}", (Object)show));
        this.havenoSetup.setDisplayTorNetworkSettingsHandler(show -> log.info("onDisplayTorNetworkSettingsHandler: show={}", show));
        this.havenoSetup.setChainFileLockedExceptionHandler(msg -> log.error("onChainFileLockedExceptionHandler: msg={}", msg));
        this.tradeManager.setLockedUpFundsHandler(msg -> log.info("onLockedUpFundsHandler: msg={}", msg));
        this.havenoSetup.setShowFirstPopupIfResyncSPVRequestedHandler(() -> log.info("onShowFirstPopupIfResyncSPVRequestedHandler"));
        this.havenoSetup.setDisplayUpdateHandler((alert, key) -> log.info("onDisplayUpdateHandler"));
        this.havenoSetup.setDisplayAlertHandler(alert -> log.info("onDisplayAlertHandler. alert={}", alert));
        this.havenoSetup.setDisplayPrivateNotificationHandler(privateNotification -> log.info("onDisplayPrivateNotificationHandler. privateNotification={}", privateNotification));
        this.havenoSetup.setDisplaySecurityRecommendationHandler(key -> log.info("onDisplaySecurityRecommendationHandler"));
        this.havenoSetup.setWrongOSArchitectureHandler(msg -> log.error("onWrongOSArchitectureHandler. msg={}", msg));
        this.havenoSetup.setRejectedTxErrorMessageHandler(errorMessage -> log.warn("setRejectedTxErrorMessageHandler. errorMessage={}", errorMessage));
        this.havenoSetup.setShowPopupIfInvalidXmrConfigHandler(() -> log.error("onShowPopupIfInvalidXmrConfigHandler"));
        this.havenoSetup.setRevolutAccountsUpdateHandler(revolutAccountList -> log.info("setRevolutAccountsUpdateHandler: revolutAccountList={}", revolutAccountList));
        this.havenoSetup.setOsxKeyLoggerWarningHandler(() -> log.info("setOsxKeyLoggerWarningHandler"));
        this.havenoSetup.setQubesOSInfoHandler(() -> log.info("setQubesOSInfoHandler"));
        this.havenoSetup.setDownGradePreventionHandler(lastVersion -> log.info("Downgrade from version {} to version {} is not supported", lastVersion, (Object)"1.2.2"));
        this.havenoSetup.setTorAddressUpgradeHandler(() -> log.info("setTorAddressUpgradeHandler"));
        this.corruptedStorageFileHandler.getFiles().ifPresent(files -> log.warn("getCorruptedDatabaseFiles. files={}", files));
    }

    public void stop() {
        if (!this.shutDownRequested) {
            UserThread.runAfter(() -> {
                if (this.gracefulShutDownHandler != null) {
                    this.gracefulShutDownHandler.gracefulShutDown(() -> {
                        log.debug("App shutdown complete");
                        if (onGracefulShutDownHandler != null) {
                            onGracefulShutDownHandler.run();
                        }
                    });
                } else if (onGracefulShutDownHandler != null) {
                    onGracefulShutDownHandler.run();
                }
            }, (long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.shutDownRequested = true;
        }
    }

    public void handleUncaughtException(Throwable throwable, boolean doShutDown) {
        block6: {
            if (!this.shutDownRequested) {
                try {
                    try {
                        log.error(throwable.getMessage());
                    }
                    catch (Throwable throwable3) {
                        log.error("Error at displaying Throwable.");
                        throwable3.printStackTrace();
                    }
                    if (doShutDown) {
                        this.stop();
                    }
                }
                catch (Throwable throwable2) {
                    log.error(throwable2.toString());
                    if (!doShutDown) break block6;
                    this.stop();
                }
            }
        }
    }

    public static Runnable getShutDownHandler() {
        return shutDownHandler;
    }

    public static void setOnGracefulShutDownHandler(Runnable onGracefulShutDownHandler) {
        HavenoHeadlessApp.onGracefulShutDownHandler = onGracefulShutDownHandler;
    }

    @Override
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    @Override
    public void setGracefulShutDownHandler(GracefulShutDownHandler gracefulShutDownHandler) {
        this.gracefulShutDownHandler = gracefulShutDownHandler;
    }
}

