/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import haveno.core.app.ConsoleInputReadTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConsoleInput {
    private final int tries;
    private final int timeout;
    private final TimeUnit unit;
    private Future<String> future;

    public ConsoleInput(int tries, int timeout, TimeUnit unit) {
        this.tries = tries;
        this.timeout = timeout;
        this.unit = unit;
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws InterruptedException {
        ExecutorService ex = Executors.newSingleThreadExecutor();
        String input = null;
        try {
            for (int i = 0; i < this.tries; ++i) {
                this.future = ex.submit(new ConsoleInputReadTask());
                try {
                    input = this.future.get(this.timeout, this.unit);
                    break;
                }
                catch (ExecutionException e) {
                    e.getCause().printStackTrace();
                    continue;
                }
                catch (TimeoutException e) {
                    this.future.cancel(true);
                    continue;
                }
                finally {
                    this.future = null;
                }
            }
        }
        finally {
            ex.shutdownNow();
        }
        return input;
    }
}

