/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.app;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.api.CoreNotificationService;
import haveno.core.api.XmrConnectionService;
import haveno.core.xmr.wallet.XmrWalletService;
import haveno.network.p2p.BootstrapListener;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AppStartupState {
    private static final Logger log = LoggerFactory.getLogger(AppStartupState.class);
    private final MonadicBinding<Boolean> p2pNetworkAndWalletInitialized;
    private final BooleanProperty walletAndNetworkReady = new SimpleBooleanProperty();
    private final BooleanProperty allDomainServicesInitialized = new SimpleBooleanProperty();
    private final BooleanProperty applicationFullyInitialized = new SimpleBooleanProperty();
    private final BooleanProperty updatedDataReceived = new SimpleBooleanProperty();
    private final BooleanProperty isBlockDownloadComplete = new SimpleBooleanProperty();
    private final BooleanProperty isWalletSynced = new SimpleBooleanProperty();
    private final BooleanProperty hasSufficientPeersForBroadcast = new SimpleBooleanProperty();

    @Inject
    public AppStartupState(CoreNotificationService notificationService, XmrConnectionService xmrConnectionService, XmrWalletService xmrWalletService, P2PService p2PService) {
        p2PService.addP2PServiceListener((P2PServiceListener)new BootstrapListener(){

            public void onDataReceived() {
                AppStartupState.this.updatedDataReceived.set(true);
            }
        });
        xmrConnectionService.downloadPercentageProperty().addListener((observable, oldValue, newValue) -> {
            if (xmrConnectionService.isDownloadComplete()) {
                this.isBlockDownloadComplete.set(true);
            }
        });
        xmrWalletService.downloadPercentageProperty().addListener((observable, oldValue, newValue) -> {
            if (xmrWalletService.isDownloadComplete()) {
                this.isWalletSynced.set(true);
            }
        });
        xmrConnectionService.numConnectionsProperty().addListener((observable, oldValue, newValue) -> {
            if (xmrConnectionService.hasSufficientPeersForBroadcast()) {
                this.hasSufficientPeersForBroadcast.set(true);
            }
        });
        this.p2pNetworkAndWalletInitialized = EasyBind.combine((ObservableValue)this.updatedDataReceived, (ObservableValue)this.isBlockDownloadComplete, (ObservableValue)this.isWalletSynced, (ObservableValue)this.hasSufficientPeersForBroadcast, (ObservableValue)this.allDomainServicesInitialized, (a, b, c, d, e) -> {
            log.info("Combined initialized state = {} = updatedDataReceived={} && isBlockDownloadComplete={} && isWalletSynced={} && hasSufficientPeersForBroadcast={} && allDomainServicesInitialized={}", new Object[]{a != false && b != false && c != false && d != false && e != false, this.updatedDataReceived.get(), this.isBlockDownloadComplete.get(), this.isWalletSynced.get(), this.hasSufficientPeersForBroadcast.get(), this.allDomainServicesInitialized.get()});
            if (a.booleanValue() && b.booleanValue() && c.booleanValue()) {
                this.walletAndNetworkReady.set(true);
            }
            return a != false && e != false;
        });
        this.p2pNetworkAndWalletInitialized.subscribe((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.applicationFullyInitialized.set(true);
                notificationService.sendAppInitializedNotification();
                log.info("Application fully initialized");
            }
        });
    }

    public void onDomainServicesInitialized() {
        this.allDomainServicesInitialized.set(true);
    }

    public boolean isWalletAndNetworkReady() {
        return this.walletAndNetworkReady.get();
    }

    public ReadOnlyBooleanProperty walletAndNetworkReadyProperty() {
        return this.walletAndNetworkReady;
    }

    public boolean isAllDomainServicesInitialized() {
        return this.allDomainServicesInitialized.get();
    }

    public ReadOnlyBooleanProperty allDomainServicesInitializedProperty() {
        return this.allDomainServicesInitialized;
    }

    public boolean isApplicationFullyInitialized() {
        return this.applicationFullyInitialized.get();
    }

    public ReadOnlyBooleanProperty applicationFullyInitializedProperty() {
        return this.applicationFullyInitialized;
    }

    public boolean isUpdatedDataReceived() {
        return this.updatedDataReceived.get();
    }

    public ReadOnlyBooleanProperty updatedDataReceivedProperty() {
        return this.updatedDataReceived;
    }

    public boolean isBlockDownloadComplete() {
        return this.isBlockDownloadComplete.get();
    }

    public boolean isWalletSynced() {
        return this.isWalletSynced.get();
    }

    public ReadOnlyBooleanProperty isBlockDownloadCompleteProperty() {
        return this.isBlockDownloadComplete;
    }

    public boolean isHasSufficientPeersForBroadcast() {
        return this.hasSufficientPeersForBroadcast.get();
    }

    public ReadOnlyBooleanProperty hasSufficientPeersForBroadcastProperty() {
        return this.hasSufficientPeersForBroadcast;
    }
}

