/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.Payload;
import java.math.BigInteger;
import monero.wallet.model.MoneroDestination;

public class XmrDestination
implements Payload {
    private final String address;
    private final BigInteger amount;

    public XmrDestination(XmrDestinationBuilder builder) {
        this.address = builder.address;
        this.amount = builder.amount;
    }

    public static XmrDestination toXmrDestination(MoneroDestination dst) {
        return new XmrDestinationBuilder().withAddress(dst.getAddress()).withAmount(dst.getAmount()).build();
    }

    public haveno.proto.grpc.XmrDestination toProtoMessage() {
        return haveno.proto.grpc.XmrDestination.newBuilder().setAddress(this.address).setAmount(this.amount.toString()).build();
    }

    public static XmrDestination fromProto(haveno.proto.grpc.XmrDestination proto) {
        return new XmrDestinationBuilder().withAddress(proto.getAddress()).withAmount(new BigInteger(proto.getAmount())).build();
    }

    public String toString() {
        return "XmrDestination{address=" + this.address + ", amount" + String.valueOf(this.amount) + "}";
    }

    public String getAddress() {
        return this.address;
    }

    public BigInteger getAmount() {
        return this.amount;
    }

    public static class XmrDestinationBuilder {
        private String address;
        private BigInteger amount;

        public XmrDestinationBuilder withAddress(String address) {
            this.address = address;
            return this;
        }

        public XmrDestinationBuilder withAmount(BigInteger amount) {
            this.amount = amount;
            return this;
        }

        public XmrDestination build() {
            return new XmrDestination(this);
        }
    }
}

