/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import haveno.common.proto.ProtoUtil;
import haveno.common.proto.persistable.PersistablePayload;
import haveno.core.api.model.PaymentAccountFormField;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.PaymentAccountFactory;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.trade.HavenoUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import protobuf.PaymentAccountForm;

@Immutable
public final class PaymentAccountForm
implements PersistablePayload {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountForm.class);
    private final FormId id;
    private final List<PaymentAccountFormField> fields;

    public PaymentAccountForm(FormId id) {
        this.id = id;
        this.fields = new ArrayList<PaymentAccountFormField>();
    }

    public PaymentAccountForm(FormId id, List<PaymentAccountFormField> fields) {
        this.id = id;
        this.fields = fields;
    }

    public protobuf.PaymentAccountForm toProtoMessage() {
        return protobuf.PaymentAccountForm.newBuilder().setId(FormId.toProtoMessage(this.id)).addAllFields((Iterable)this.fields.stream().map(field -> field.toProtoMessage()).collect(Collectors.toList())).build();
    }

    public static PaymentAccountForm fromProto(protobuf.PaymentAccountForm proto) {
        List<PaymentAccountFormField> fields = proto.getFieldsList().isEmpty() ? null : proto.getFieldsList().stream().map(PaymentAccountFormField::fromProto).collect(Collectors.toList());
        return new PaymentAccountForm(FormId.fromProto(proto.getId()), fields);
    }

    public void addField(PaymentAccountFormField field) {
        this.fields.add(field);
    }

    public String getValue(PaymentAccountFormField.FieldId fieldId) {
        for (PaymentAccountFormField field : this.fields) {
            if (field.getId() != fieldId) continue;
            return field.getValue();
        }
        throw new IllegalArgumentException("Form does not contain field " + String.valueOf((Object)fieldId));
    }

    public String toPaymentAccountJsonString() {
        HashMap<String, String> formMap = new HashMap<String, String>();
        formMap.put("paymentMethodId", this.getId().toString());
        for (PaymentAccountFormField field : this.getFields()) {
            formMap.put(HavenoUtils.toCamelCase(field.getId().toString()), field.getValue());
        }
        return new Gson().toJson(formMap);
    }

    public PaymentAccount toPaymentAccount() {
        return PaymentAccount.fromJson(this.toPaymentAccountJsonString());
    }

    public static PaymentAccountForm getForm(String paymentMethodId) {
        PaymentAccount paymentAccount = PaymentAccountFactory.getPaymentAccount(PaymentMethod.getPaymentMethod(paymentMethodId));
        return paymentAccount.toForm();
    }

    public static File getPaymentAccountForm(String paymentMethodId) {
        PaymentMethod paymentMethod = PaymentMethod.getPaymentMethod(paymentMethodId);
        File file = PaymentAccountForm.getTmpJsonFile(paymentMethodId);
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream((File)Preconditions.checkNotNull((Object)file), false), StandardCharsets.UTF_8);){
            PaymentAccount paymentAccount = PaymentAccountFactory.getPaymentAccount(paymentMethod);
            String json = paymentAccount.toForm().toPaymentAccountJsonString();
            outputStreamWriter.write(json);
        }
        catch (Exception ex) {
            String errMsg = String.format("cannot create a payment account form for a %s payment method", paymentMethodId);
            log.error(StringUtils.capitalize((String)errMsg) + ".", (Throwable)ex);
            throw new IllegalStateException(errMsg);
        }
        return file;
    }

    @VisibleForTesting
    public static PaymentAccount toPaymentAccount(File jsonForm) {
        return PaymentAccount.fromJson(PaymentAccountForm.toJsonString(jsonForm));
    }

    public static String toJsonString(File jsonFile) {
        try {
            Preconditions.checkNotNull((Object)jsonFile, (Object)"json file cannot be null");
            return new String(Files.readAllBytes(Paths.get(jsonFile.getAbsolutePath(), new String[0])));
        }
        catch (IOException ex) {
            String errMsg = String.format("cannot read json string from file '%s'", jsonFile.getAbsolutePath());
            log.error(StringUtils.capitalize((String)errMsg) + ".", (Throwable)ex);
            throw new IllegalStateException(errMsg);
        }
    }

    @VisibleForTesting
    public static URI getClickableURI(File jsonFile) {
        try {
            return new URI("file", "", jsonFile.toURI().getPath(), null, null);
        }
        catch (URISyntaxException ex) {
            String errMsg = String.format("cannot create clickable url to file '%s'", jsonFile.getAbsolutePath());
            log.error(StringUtils.capitalize((String)errMsg) + ".", (Throwable)ex);
            throw new IllegalStateException(errMsg);
        }
    }

    @VisibleForTesting
    public static File getTmpJsonFile(String paymentMethodId) {
        File file;
        try {
            file = File.createTempFile(paymentMethodId.toLowerCase() + "_form_", ".json", Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toFile());
        }
        catch (IOException ex) {
            String errMsg = String.format("cannot create json file for a %s payment method", paymentMethodId);
            log.error(StringUtils.capitalize((String)errMsg) + ".", (Throwable)ex);
            throw new IllegalStateException(errMsg);
        }
        return file;
    }

    public FormId getId() {
        return this.id;
    }

    public List<PaymentAccountFormField> getFields() {
        return this.fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentAccountForm)) {
            return false;
        }
        PaymentAccountForm other = (PaymentAccountForm)o;
        FormId this$id = this.getId();
        FormId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)((Object)this$id)).equals((Object)other$id)) {
            return false;
        }
        List<PaymentAccountFormField> this$fields = this.getFields();
        List<PaymentAccountFormField> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FormId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)((Object)$id)).hashCode());
        List<PaymentAccountFormField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "PaymentAccountForm(id=" + String.valueOf((Object)this.getId()) + ", fields=" + String.valueOf(this.getFields()) + ")";
    }

    public static enum FormId {
        BLOCK_CHAINS,
        CASH_AT_ATM,
        FASTER_PAYMENTS,
        F2F,
        MONEY_GRAM,
        PAXUM,
        PAY_BY_MAIL,
        REVOLUT,
        SEPA,
        SEPA_INSTANT,
        STRIKE,
        SWIFT,
        TRANSFERWISE,
        UPHOLD,
        ZELLE,
        AUSTRALIA_PAYID,
        CASH_APP,
        PAYPAL,
        VENMO,
        PAYSAFE,
        WECHAT_PAY,
        ALI_PAY,
        SWISH,
        TRANSFERWISE_USD,
        AMAZON_GIFT_CARD,
        ACH_TRANSFER,
        INTERAC_E_TRANSFER,
        US_POSTAL_MONEY_ORDER;


        public static FormId fromProto(PaymentAccountForm.FormId formId) {
            return (FormId)ProtoUtil.enumFromProto(FormId.class, (String)formId.name());
        }

        public static PaymentAccountForm.FormId toProtoMessage(FormId formId) {
            return PaymentAccountForm.FormId.valueOf((String)formId.name());
        }
    }
}

