/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import haveno.common.Payload;
import haveno.common.util.MathUtils;
import haveno.core.api.model.builder.OfferInfoBuilder;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OpenOffer;
import haveno.core.util.PriceUtil;
import haveno.core.util.VolumeUtil;
import haveno.proto.grpc.OfferInfo;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class OfferInfo
implements Payload {
    private final String id;
    private final String direction;
    private final String price;
    private final boolean useMarketBasedPrice;
    private final double marketPriceMarginPct;
    private final long amount;
    private final long minAmount;
    private final String volume;
    private final String minVolume;
    private final double makerFeePct;
    private final double takerFeePct;
    private final double penaltyFeePct;
    private final double buyerSecurityDepositPct;
    private final double sellerSecurityDepositPct;
    private final String triggerPrice;
    private final String paymentAccountId;
    private final String paymentMethodId;
    private final String paymentMethodShortName;
    private final String baseCurrencyCode;
    private final String counterCurrencyCode;
    private final long date;
    private final String state;
    private final boolean isActivated;
    private final boolean isMyOffer;
    private final String ownerNodeAddress;
    private final String pubKeyRing;
    private final String versionNumber;
    private final int protocolVersion;
    @Nullable
    private final String arbitratorSigner;
    @Nullable
    private final String splitOutputTxHash;
    private final long splitOutputTxFee;
    private final boolean isPrivateOffer;
    private final String challenge;
    private final String extraInfo;

    public OfferInfo(OfferInfoBuilder builder) {
        this.id = builder.getId();
        this.direction = builder.getDirection();
        this.price = builder.getPrice();
        this.useMarketBasedPrice = builder.isUseMarketBasedPrice();
        this.marketPriceMarginPct = builder.getMarketPriceMarginPct();
        this.amount = builder.getAmount();
        this.minAmount = builder.getMinAmount();
        this.makerFeePct = builder.getMakerFeePct();
        this.takerFeePct = builder.getTakerFeePct();
        this.penaltyFeePct = builder.getPenaltyFeePct();
        this.buyerSecurityDepositPct = builder.getBuyerSecurityDepositPct();
        this.sellerSecurityDepositPct = builder.getSellerSecurityDepositPct();
        this.volume = builder.getVolume();
        this.minVolume = builder.getMinVolume();
        this.triggerPrice = builder.getTriggerPrice();
        this.paymentAccountId = builder.getPaymentAccountId();
        this.paymentMethodId = builder.getPaymentMethodId();
        this.paymentMethodShortName = builder.getPaymentMethodShortName();
        this.baseCurrencyCode = builder.getBaseCurrencyCode();
        this.counterCurrencyCode = builder.getCounterCurrencyCode();
        this.date = builder.getDate();
        this.state = builder.getState();
        this.isActivated = builder.isActivated();
        this.isMyOffer = builder.isMyOffer();
        this.ownerNodeAddress = builder.getOwnerNodeAddress();
        this.pubKeyRing = builder.getPubKeyRing();
        this.versionNumber = builder.getVersionNumber();
        this.protocolVersion = builder.getProtocolVersion();
        this.arbitratorSigner = builder.getArbitratorSigner();
        this.splitOutputTxHash = builder.getSplitOutputTxHash();
        this.splitOutputTxFee = builder.getSplitOutputTxFee();
        this.isPrivateOffer = builder.isPrivateOffer();
        this.challenge = builder.getChallenge();
        this.extraInfo = builder.getExtraInfo();
    }

    public static OfferInfo toOfferInfo(Offer offer) {
        return OfferInfo.getBuilder(offer).withIsMyOffer(false).withIsActivated(true).build();
    }

    public static OfferInfo toMyOfferInfo(OpenOffer openOffer) {
        Offer offer = openOffer.getOffer();
        String currencyCode = offer.getCounterCurrencyCode();
        boolean isActivated = !openOffer.isDeactivated();
        Optional<Price> optionalTriggerPrice = openOffer.getTriggerPrice() > 0L ? Optional.of(Price.valueOf(currencyCode, openOffer.getTriggerPrice())) : Optional.empty();
        String preciseTriggerPrice = optionalTriggerPrice.map(value -> PriceUtil.reformatMarketPrice(value.toPlainString(), currencyCode)).orElse("0");
        return OfferInfo.getBuilder(offer).withTriggerPrice(preciseTriggerPrice).withState(openOffer.getState().name()).withIsActivated(isActivated).withSplitOutputTxHash(openOffer.getSplitOutputTxHash()).withSplitOutputTxFee(openOffer.getSplitOutputTxFee()).withChallenge(openOffer.getChallenge()).build();
    }

    private static OfferInfoBuilder getBuilder(Offer offer) {
        String currencyCode = offer.getCounterCurrencyCode();
        String preciseOfferPrice = PriceUtil.reformatMarketPrice(Objects.requireNonNull(offer.getPrice()).toPlainString(), currencyCode);
        double marketPriceMarginAsPctLiteral = MathUtils.exactMultiply((double)offer.getMarketPriceMarginPct(), (double)100.0);
        String roundedVolume = VolumeUtil.formatVolume(Objects.requireNonNull(offer.getVolume()));
        String roundedMinVolume = VolumeUtil.formatVolume(Objects.requireNonNull(offer.getMinVolume()));
        return new OfferInfoBuilder().withId(offer.getId()).withDirection(offer.getDirection().name()).withPrice(preciseOfferPrice).withUseMarketBasedPrice(offer.isUseMarketBasedPrice()).withMarketPriceMarginPct(marketPriceMarginAsPctLiteral).withAmount(offer.getAmount().longValueExact()).withMinAmount(offer.getMinAmount().longValueExact()).withMakerFeePct(offer.getMakerFeePct()).withTakerFeePct(offer.getTakerFeePct()).withPenaltyFeePct(offer.getPenaltyFeePct()).withSellerSecurityDepositPct(offer.getSellerSecurityDepositPct()).withBuyerSecurityDepositPct(offer.getBuyerSecurityDepositPct()).withSellerSecurityDepositPct(offer.getSellerSecurityDepositPct()).withVolume(roundedVolume).withMinVolume(roundedMinVolume).withPaymentAccountId(offer.getMakerPaymentAccountId()).withPaymentMethodId(offer.getPaymentMethod().getId()).withPaymentMethodShortName(offer.getPaymentMethod().getShortName()).withBaseCurrencyCode(offer.getBaseCurrencyCode()).withCounterCurrencyCode(offer.getCounterCurrencyCode()).withDate(offer.getDate().getTime()).withState(offer.getState().name()).withOwnerNodeAddress(offer.getOfferPayload().getOwnerNodeAddress().getFullAddress()).withPubKeyRing(offer.getOfferPayload().getPubKeyRing().toString()).withVersionNumber(offer.getOfferPayload().getVersionNr()).withProtocolVersion(offer.getOfferPayload().getProtocolVersion()).withArbitratorSigner(offer.getOfferPayload().getArbitratorSigner() == null ? null : offer.getOfferPayload().getArbitratorSigner().getFullAddress()).withIsPrivateOffer(offer.isPrivateOffer()).withChallenge(offer.getChallenge()).withExtraInfo(offer.getCombinedExtraInfo());
    }

    public haveno.proto.grpc.OfferInfo toProtoMessage() {
        OfferInfo.Builder builder = haveno.proto.grpc.OfferInfo.newBuilder().setId(this.id).setDirection(this.direction).setPrice(this.price).setUseMarketBasedPrice(this.useMarketBasedPrice).setMarketPriceMarginPct(this.marketPriceMarginPct).setAmount(this.amount).setMinAmount(this.minAmount).setVolume(this.volume).setMinVolume(this.minVolume).setMakerFeePct(this.makerFeePct).setTakerFeePct(this.takerFeePct).setPenaltyFeePct(this.penaltyFeePct).setBuyerSecurityDepositPct(this.buyerSecurityDepositPct).setSellerSecurityDepositPct(this.sellerSecurityDepositPct).setTriggerPrice(this.triggerPrice == null ? "0" : this.triggerPrice).setPaymentAccountId(this.paymentAccountId).setPaymentMethodId(this.paymentMethodId).setPaymentMethodShortName(this.paymentMethodShortName).setBaseCurrencyCode(this.baseCurrencyCode).setCounterCurrencyCode(this.counterCurrencyCode).setDate(this.date).setState(this.state).setIsActivated(this.isActivated).setIsMyOffer(this.isMyOffer).setOwnerNodeAddress(this.ownerNodeAddress).setPubKeyRing(this.pubKeyRing).setVersionNr(this.versionNumber).setProtocolVersion(this.protocolVersion).setSplitOutputTxFee(this.splitOutputTxFee).setIsPrivateOffer(this.isPrivateOffer);
        Optional.ofNullable(this.arbitratorSigner).ifPresent(arg_0 -> ((OfferInfo.Builder)builder).setArbitratorSigner(arg_0));
        Optional.ofNullable(this.splitOutputTxHash).ifPresent(arg_0 -> ((OfferInfo.Builder)builder).setSplitOutputTxHash(arg_0));
        Optional.ofNullable(this.challenge).ifPresent(arg_0 -> ((OfferInfo.Builder)builder).setChallenge(arg_0));
        Optional.ofNullable(this.extraInfo).ifPresent(arg_0 -> ((OfferInfo.Builder)builder).setExtraInfo(arg_0));
        return builder.build();
    }

    public static OfferInfo fromProto(haveno.proto.grpc.OfferInfo proto) {
        return new OfferInfoBuilder().withId(proto.getId()).withDirection(proto.getDirection()).withPrice(proto.getPrice()).withUseMarketBasedPrice(proto.getUseMarketBasedPrice()).withMarketPriceMarginPct(proto.getMarketPriceMarginPct()).withAmount(proto.getAmount()).withMinAmount(proto.getMinAmount()).withVolume(proto.getVolume()).withMinVolume(proto.getMinVolume()).withMakerFeePct(proto.getMakerFeePct()).withTakerFeePct(proto.getTakerFeePct()).withPenaltyFeePct(proto.getPenaltyFeePct()).withBuyerSecurityDepositPct(proto.getBuyerSecurityDepositPct()).withSellerSecurityDepositPct(proto.getSellerSecurityDepositPct()).withTriggerPrice(proto.getTriggerPrice()).withPaymentAccountId(proto.getPaymentAccountId()).withPaymentMethodId(proto.getPaymentMethodId()).withPaymentMethodShortName(proto.getPaymentMethodShortName()).withBaseCurrencyCode(proto.getBaseCurrencyCode()).withCounterCurrencyCode(proto.getCounterCurrencyCode()).withDate(proto.getDate()).withState(proto.getState()).withIsActivated(proto.getIsActivated()).withIsMyOffer(proto.getIsMyOffer()).withOwnerNodeAddress(proto.getOwnerNodeAddress()).withPubKeyRing(proto.getPubKeyRing()).withVersionNumber(proto.getVersionNr()).withProtocolVersion(proto.getProtocolVersion()).withArbitratorSigner(proto.getArbitratorSigner()).withSplitOutputTxHash(proto.getSplitOutputTxHash()).withSplitOutputTxFee(proto.getSplitOutputTxFee()).withIsPrivateOffer(proto.getIsPrivateOffer()).withChallenge(proto.getChallenge()).withExtraInfo(proto.getExtraInfo()).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OfferInfo)) {
            return false;
        }
        OfferInfo other = (OfferInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseMarketBasedPrice() != other.isUseMarketBasedPrice()) {
            return false;
        }
        if (Double.compare(this.getMarketPriceMarginPct(), other.getMarketPriceMarginPct()) != 0) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getMinAmount() != other.getMinAmount()) {
            return false;
        }
        if (Double.compare(this.getMakerFeePct(), other.getMakerFeePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getTakerFeePct(), other.getTakerFeePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getPenaltyFeePct(), other.getPenaltyFeePct()) != 0) {
            return false;
        }
        if (Double.compare(this.getBuyerSecurityDepositPct(), other.getBuyerSecurityDepositPct()) != 0) {
            return false;
        }
        if (Double.compare(this.getSellerSecurityDepositPct(), other.getSellerSecurityDepositPct()) != 0) {
            return false;
        }
        if (this.getDate() != other.getDate()) {
            return false;
        }
        if (this.isActivated() != other.isActivated()) {
            return false;
        }
        if (this.isMyOffer() != other.isMyOffer()) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        if (this.getSplitOutputTxFee() != other.getSplitOutputTxFee()) {
            return false;
        }
        if (this.isPrivateOffer() != other.isPrivateOffer()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$direction = this.getDirection();
        String other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        String this$volume = this.getVolume();
        String other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !this$volume.equals(other$volume)) {
            return false;
        }
        String this$minVolume = this.getMinVolume();
        String other$minVolume = other.getMinVolume();
        if (this$minVolume == null ? other$minVolume != null : !this$minVolume.equals(other$minVolume)) {
            return false;
        }
        String this$triggerPrice = this.getTriggerPrice();
        String other$triggerPrice = other.getTriggerPrice();
        if (this$triggerPrice == null ? other$triggerPrice != null : !this$triggerPrice.equals(other$triggerPrice)) {
            return false;
        }
        String this$paymentAccountId = this.getPaymentAccountId();
        String other$paymentAccountId = other.getPaymentAccountId();
        if (this$paymentAccountId == null ? other$paymentAccountId != null : !this$paymentAccountId.equals(other$paymentAccountId)) {
            return false;
        }
        String this$paymentMethodId = this.getPaymentMethodId();
        String other$paymentMethodId = other.getPaymentMethodId();
        if (this$paymentMethodId == null ? other$paymentMethodId != null : !this$paymentMethodId.equals(other$paymentMethodId)) {
            return false;
        }
        String this$paymentMethodShortName = this.getPaymentMethodShortName();
        String other$paymentMethodShortName = other.getPaymentMethodShortName();
        if (this$paymentMethodShortName == null ? other$paymentMethodShortName != null : !this$paymentMethodShortName.equals(other$paymentMethodShortName)) {
            return false;
        }
        String this$baseCurrencyCode = this.getBaseCurrencyCode();
        String other$baseCurrencyCode = other.getBaseCurrencyCode();
        if (this$baseCurrencyCode == null ? other$baseCurrencyCode != null : !this$baseCurrencyCode.equals(other$baseCurrencyCode)) {
            return false;
        }
        String this$counterCurrencyCode = this.getCounterCurrencyCode();
        String other$counterCurrencyCode = other.getCounterCurrencyCode();
        if (this$counterCurrencyCode == null ? other$counterCurrencyCode != null : !this$counterCurrencyCode.equals(other$counterCurrencyCode)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$ownerNodeAddress = this.getOwnerNodeAddress();
        String other$ownerNodeAddress = other.getOwnerNodeAddress();
        if (this$ownerNodeAddress == null ? other$ownerNodeAddress != null : !this$ownerNodeAddress.equals(other$ownerNodeAddress)) {
            return false;
        }
        String this$pubKeyRing = this.getPubKeyRing();
        String other$pubKeyRing = other.getPubKeyRing();
        if (this$pubKeyRing == null ? other$pubKeyRing != null : !this$pubKeyRing.equals(other$pubKeyRing)) {
            return false;
        }
        String this$versionNumber = this.getVersionNumber();
        String other$versionNumber = other.getVersionNumber();
        if (this$versionNumber == null ? other$versionNumber != null : !this$versionNumber.equals(other$versionNumber)) {
            return false;
        }
        String this$arbitratorSigner = this.getArbitratorSigner();
        String other$arbitratorSigner = other.getArbitratorSigner();
        if (this$arbitratorSigner == null ? other$arbitratorSigner != null : !this$arbitratorSigner.equals(other$arbitratorSigner)) {
            return false;
        }
        String this$splitOutputTxHash = this.getSplitOutputTxHash();
        String other$splitOutputTxHash = other.getSplitOutputTxHash();
        if (this$splitOutputTxHash == null ? other$splitOutputTxHash != null : !this$splitOutputTxHash.equals(other$splitOutputTxHash)) {
            return false;
        }
        String this$challenge = this.getChallenge();
        String other$challenge = other.getChallenge();
        if (this$challenge == null ? other$challenge != null : !this$challenge.equals(other$challenge)) {
            return false;
        }
        String this$extraInfo = this.getExtraInfo();
        String other$extraInfo = other.getExtraInfo();
        return !(this$extraInfo == null ? other$extraInfo != null : !this$extraInfo.equals(other$extraInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OfferInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseMarketBasedPrice() ? 79 : 97);
        long $marketPriceMarginPct = Double.doubleToLongBits(this.getMarketPriceMarginPct());
        result = result * 59 + (int)($marketPriceMarginPct >>> 32 ^ $marketPriceMarginPct);
        long $amount = this.getAmount();
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $minAmount = this.getMinAmount();
        result = result * 59 + (int)($minAmount >>> 32 ^ $minAmount);
        long $makerFeePct = Double.doubleToLongBits(this.getMakerFeePct());
        result = result * 59 + (int)($makerFeePct >>> 32 ^ $makerFeePct);
        long $takerFeePct = Double.doubleToLongBits(this.getTakerFeePct());
        result = result * 59 + (int)($takerFeePct >>> 32 ^ $takerFeePct);
        long $penaltyFeePct = Double.doubleToLongBits(this.getPenaltyFeePct());
        result = result * 59 + (int)($penaltyFeePct >>> 32 ^ $penaltyFeePct);
        long $buyerSecurityDepositPct = Double.doubleToLongBits(this.getBuyerSecurityDepositPct());
        result = result * 59 + (int)($buyerSecurityDepositPct >>> 32 ^ $buyerSecurityDepositPct);
        long $sellerSecurityDepositPct = Double.doubleToLongBits(this.getSellerSecurityDepositPct());
        result = result * 59 + (int)($sellerSecurityDepositPct >>> 32 ^ $sellerSecurityDepositPct);
        long $date = this.getDate();
        result = result * 59 + (int)($date >>> 32 ^ $date);
        result = result * 59 + (this.isActivated() ? 79 : 97);
        result = result * 59 + (this.isMyOffer() ? 79 : 97);
        result = result * 59 + this.getProtocolVersion();
        long $splitOutputTxFee = this.getSplitOutputTxFee();
        result = result * 59 + (int)($splitOutputTxFee >>> 32 ^ $splitOutputTxFee);
        result = result * 59 + (this.isPrivateOffer() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        String $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : $volume.hashCode());
        String $minVolume = this.getMinVolume();
        result = result * 59 + ($minVolume == null ? 43 : $minVolume.hashCode());
        String $triggerPrice = this.getTriggerPrice();
        result = result * 59 + ($triggerPrice == null ? 43 : $triggerPrice.hashCode());
        String $paymentAccountId = this.getPaymentAccountId();
        result = result * 59 + ($paymentAccountId == null ? 43 : $paymentAccountId.hashCode());
        String $paymentMethodId = this.getPaymentMethodId();
        result = result * 59 + ($paymentMethodId == null ? 43 : $paymentMethodId.hashCode());
        String $paymentMethodShortName = this.getPaymentMethodShortName();
        result = result * 59 + ($paymentMethodShortName == null ? 43 : $paymentMethodShortName.hashCode());
        String $baseCurrencyCode = this.getBaseCurrencyCode();
        result = result * 59 + ($baseCurrencyCode == null ? 43 : $baseCurrencyCode.hashCode());
        String $counterCurrencyCode = this.getCounterCurrencyCode();
        result = result * 59 + ($counterCurrencyCode == null ? 43 : $counterCurrencyCode.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $ownerNodeAddress = this.getOwnerNodeAddress();
        result = result * 59 + ($ownerNodeAddress == null ? 43 : $ownerNodeAddress.hashCode());
        String $pubKeyRing = this.getPubKeyRing();
        result = result * 59 + ($pubKeyRing == null ? 43 : $pubKeyRing.hashCode());
        String $versionNumber = this.getVersionNumber();
        result = result * 59 + ($versionNumber == null ? 43 : $versionNumber.hashCode());
        String $arbitratorSigner = this.getArbitratorSigner();
        result = result * 59 + ($arbitratorSigner == null ? 43 : $arbitratorSigner.hashCode());
        String $splitOutputTxHash = this.getSplitOutputTxHash();
        result = result * 59 + ($splitOutputTxHash == null ? 43 : $splitOutputTxHash.hashCode());
        String $challenge = this.getChallenge();
        result = result * 59 + ($challenge == null ? 43 : $challenge.hashCode());
        String $extraInfo = this.getExtraInfo();
        result = result * 59 + ($extraInfo == null ? 43 : $extraInfo.hashCode());
        return result;
    }

    public String toString() {
        return "OfferInfo(id=" + this.getId() + ", direction=" + this.getDirection() + ", price=" + this.getPrice() + ", useMarketBasedPrice=" + this.isUseMarketBasedPrice() + ", marketPriceMarginPct=" + this.getMarketPriceMarginPct() + ", amount=" + this.getAmount() + ", minAmount=" + this.getMinAmount() + ", volume=" + this.getVolume() + ", minVolume=" + this.getMinVolume() + ", makerFeePct=" + this.getMakerFeePct() + ", takerFeePct=" + this.getTakerFeePct() + ", penaltyFeePct=" + this.getPenaltyFeePct() + ", buyerSecurityDepositPct=" + this.getBuyerSecurityDepositPct() + ", sellerSecurityDepositPct=" + this.getSellerSecurityDepositPct() + ", triggerPrice=" + this.getTriggerPrice() + ", paymentAccountId=" + this.getPaymentAccountId() + ", paymentMethodId=" + this.getPaymentMethodId() + ", paymentMethodShortName=" + this.getPaymentMethodShortName() + ", baseCurrencyCode=" + this.getBaseCurrencyCode() + ", counterCurrencyCode=" + this.getCounterCurrencyCode() + ", date=" + this.getDate() + ", state=" + this.getState() + ", isActivated=" + this.isActivated() + ", isMyOffer=" + this.isMyOffer() + ", ownerNodeAddress=" + this.getOwnerNodeAddress() + ", pubKeyRing=" + this.getPubKeyRing() + ", versionNumber=" + this.getVersionNumber() + ", protocolVersion=" + this.getProtocolVersion() + ", arbitratorSigner=" + this.getArbitratorSigner() + ", splitOutputTxHash=" + this.getSplitOutputTxHash() + ", splitOutputTxFee=" + this.getSplitOutputTxFee() + ", isPrivateOffer=" + this.isPrivateOffer() + ", challenge=" + this.getChallenge() + ", extraInfo=" + this.getExtraInfo() + ")";
    }

    public String getId() {
        return this.id;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getPrice() {
        return this.price;
    }

    public boolean isUseMarketBasedPrice() {
        return this.useMarketBasedPrice;
    }

    public double getMarketPriceMarginPct() {
        return this.marketPriceMarginPct;
    }

    public long getAmount() {
        return this.amount;
    }

    public long getMinAmount() {
        return this.minAmount;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getMinVolume() {
        return this.minVolume;
    }

    public double getMakerFeePct() {
        return this.makerFeePct;
    }

    public double getTakerFeePct() {
        return this.takerFeePct;
    }

    public double getPenaltyFeePct() {
        return this.penaltyFeePct;
    }

    public double getBuyerSecurityDepositPct() {
        return this.buyerSecurityDepositPct;
    }

    public double getSellerSecurityDepositPct() {
        return this.sellerSecurityDepositPct;
    }

    public String getTriggerPrice() {
        return this.triggerPrice;
    }

    public String getPaymentAccountId() {
        return this.paymentAccountId;
    }

    public String getPaymentMethodId() {
        return this.paymentMethodId;
    }

    public String getPaymentMethodShortName() {
        return this.paymentMethodShortName;
    }

    public String getBaseCurrencyCode() {
        return this.baseCurrencyCode;
    }

    public String getCounterCurrencyCode() {
        return this.counterCurrencyCode;
    }

    public long getDate() {
        return this.date;
    }

    public String getState() {
        return this.state;
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public boolean isMyOffer() {
        return this.isMyOffer;
    }

    public String getOwnerNodeAddress() {
        return this.ownerNodeAddress;
    }

    public String getPubKeyRing() {
        return this.pubKeyRing;
    }

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Nullable
    public String getArbitratorSigner() {
        return this.arbitratorSigner;
    }

    @Nullable
    public String getSplitOutputTxHash() {
        return this.splitOutputTxHash;
    }

    public long getSplitOutputTxFee() {
        return this.splitOutputTxFee;
    }

    public boolean isPrivateOffer() {
        return this.isPrivateOffer;
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }
}

