/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import com.google.protobuf.ByteString;
import haveno.common.proto.persistable.PersistablePayload;
import java.util.Arrays;

public final class EncryptedConnection
implements PersistablePayload {
    private final String url;
    private final String username;
    private final byte[] encryptedPassword;
    private final byte[] encryptionSalt;
    private final int priority;

    public protobuf.EncryptedConnection toProtoMessage() {
        return protobuf.EncryptedConnection.newBuilder().setUrl(this.url).setUsername(this.username).setEncryptedPassword(ByteString.copyFrom((byte[])this.encryptedPassword)).setEncryptionSalt(ByteString.copyFrom((byte[])this.encryptionSalt)).setPriority(this.priority).build();
    }

    public static EncryptedConnection fromProto(protobuf.EncryptedConnection encryptedConnection) {
        return new EncryptedConnection(encryptedConnection.getUrl(), encryptedConnection.getUsername(), encryptedConnection.getEncryptedPassword().toByteArray(), encryptedConnection.getEncryptionSalt().toByteArray(), encryptedConnection.getPriority());
    }

    EncryptedConnection(String url, String username, byte[] encryptedPassword, byte[] encryptionSalt, int priority) {
        this.url = url;
        this.username = username;
        this.encryptedPassword = encryptedPassword;
        this.encryptionSalt = encryptionSalt;
        this.priority = priority;
    }

    public static EncryptedConnectionBuilder builder() {
        return new EncryptedConnectionBuilder();
    }

    public EncryptedConnectionBuilder toBuilder() {
        return new EncryptedConnectionBuilder().url(this.url).username(this.username).encryptedPassword(this.encryptedPassword).encryptionSalt(this.encryptionSalt).priority(this.priority);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public byte[] getEncryptionSalt() {
        return this.encryptionSalt;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptedConnection)) {
            return false;
        }
        EncryptedConnection other = (EncryptedConnection)o;
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        if (!Arrays.equals(this.getEncryptedPassword(), other.getEncryptedPassword())) {
            return false;
        }
        return Arrays.equals(this.getEncryptionSalt(), other.getEncryptionSalt());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.hashCode(this.getEncryptedPassword());
        result = result * 59 + Arrays.hashCode(this.getEncryptionSalt());
        return result;
    }

    public String toString() {
        return "EncryptedConnection(url=" + this.getUrl() + ", username=" + this.getUsername() + ", encryptedPassword=" + Arrays.toString(this.getEncryptedPassword()) + ", encryptionSalt=" + Arrays.toString(this.getEncryptionSalt()) + ", priority=" + this.getPriority() + ")";
    }

    public static class EncryptedConnectionBuilder {
        private String url;
        private String username;
        private byte[] encryptedPassword;
        private byte[] encryptionSalt;
        private int priority;

        EncryptedConnectionBuilder() {
        }

        public EncryptedConnectionBuilder url(String url) {
            this.url = url;
            return this;
        }

        public EncryptedConnectionBuilder username(String username) {
            this.username = username;
            return this;
        }

        public EncryptedConnectionBuilder encryptedPassword(byte[] encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this;
        }

        public EncryptedConnectionBuilder encryptionSalt(byte[] encryptionSalt) {
            this.encryptionSalt = encryptionSalt;
            return this;
        }

        public EncryptedConnectionBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public EncryptedConnection build() {
            return new EncryptedConnection(this.url, this.username, this.encryptedPassword, this.encryptionSalt, this.priority);
        }

        public String toString() {
            return "EncryptedConnection.EncryptedConnectionBuilder(url=" + this.url + ", username=" + this.username + ", encryptedPassword=" + Arrays.toString(this.encryptedPassword) + ", encryptionSalt=" + Arrays.toString(this.encryptionSalt) + ", priority=" + this.priority + ")";
        }
    }
}

