/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api.model;

import com.google.common.annotations.VisibleForTesting;
import haveno.common.Payload;

public class BtcBalanceInfo
implements Payload {
    public static final BtcBalanceInfo EMPTY = new BtcBalanceInfo(-1L, -1L, -1L, -1L);
    private final long availableBalance;
    private final long reservedBalance;
    private final long totalAvailableBalance;
    private final long lockedBalance;

    public BtcBalanceInfo(long availableBalance, long reservedBalance, long totalAvailableBalance, long lockedBalance) {
        this.availableBalance = availableBalance;
        this.reservedBalance = reservedBalance;
        this.totalAvailableBalance = totalAvailableBalance;
        this.lockedBalance = lockedBalance;
    }

    @VisibleForTesting
    public static BtcBalanceInfo valueOf(long availableBalance, long reservedBalance, long totalAvailableBalance, long lockedBalance) {
        return new BtcBalanceInfo(availableBalance, reservedBalance, totalAvailableBalance, lockedBalance);
    }

    public haveno.proto.grpc.BtcBalanceInfo toProtoMessage() {
        return haveno.proto.grpc.BtcBalanceInfo.newBuilder().setAvailableBalance(this.availableBalance).setReservedBalance(this.reservedBalance).setTotalAvailableBalance(this.totalAvailableBalance).setLockedBalance(this.lockedBalance).build();
    }

    public static BtcBalanceInfo fromProto(haveno.proto.grpc.BtcBalanceInfo proto) {
        return new BtcBalanceInfo(proto.getAvailableBalance(), proto.getReservedBalance(), proto.getTotalAvailableBalance(), proto.getLockedBalance());
    }

    public String toString() {
        return "BtcBalanceInfo{availableBalance=" + this.availableBalance + ", reservedBalance=" + this.reservedBalance + ", totalAvailableBalance=" + this.totalAvailableBalance + ", lockedBalance=" + this.lockedBalance + "}";
    }

    public long getAvailableBalance() {
        return this.availableBalance;
    }

    public long getReservedBalance() {
        return this.reservedBalance;
    }

    public long getTotalAvailableBalance() {
        return this.totalAvailableBalance;
    }

    public long getLockedBalance() {
        return this.lockedBalance;
    }
}

