/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.common.util.Utilities;
import haveno.core.api.XmrLocalNodeListener;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.xmr.XmrNodeSettings;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.core.xmr.nodes.XmrNodesSetupPreferences;
import haveno.core.xmr.wallet.XmrWalletService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import monero.common.MoneroConnectionManager;
import monero.common.MoneroUtils;
import monero.daemon.MoneroDaemonRpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class XmrLocalNode {
    private static final Logger log = LoggerFactory.getLogger(XmrLocalNode.class);
    public static final long REFRESH_PERIOD_LOCAL_MS = 5000L;
    public static final String MONEROD_NAME = Utilities.isWindows() ? "monerod.exe" : "monerod";
    public static final String MONEROD_PATH = XmrWalletService.MONERO_BINS_DIR + File.separator + MONEROD_NAME;
    private static final String MONEROD_DATADIR = Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_LOCAL ? XmrWalletService.MONERO_BINS_DIR + File.separator + Config.baseCurrencyNetwork().toString().toLowerCase() + File.separator + "node1" : null;
    private MoneroDaemonRpc daemon;
    private MoneroConnectionManager connectionManager;
    private final Config config;
    private final Preferences preferences;
    private final XmrNodes xmrNodes;
    private final List<XmrLocalNodeListener> listeners = new ArrayList<XmrLocalNodeListener>();
    private static final List<String> MONEROD_ARGS = new ArrayList<String>();

    @Inject
    public XmrLocalNode(Config config, Preferences preferences, XmrNodes xmrNodes) {
        this.config = config;
        this.preferences = preferences;
        this.xmrNodes = xmrNodes;
        this.daemon = new MoneroDaemonRpc(this.getUri());
        this.connectionManager = new MoneroConnectionManager().setConnection(this.daemon.getRpcConnection());
        this.connectionManager.setTimeout(5000L);
        this.connectionManager.addListener(connection -> {
            for (XmrLocalNodeListener listener : this.listeners) {
                listener.onConnectionChanged(connection);
            }
        });
        this.connectionManager.startPolling(Long.valueOf(5000L));
    }

    public String getUri() {
        return "http://127.0.0.1:" + HavenoUtils.getDefaultMoneroPort();
    }

    public boolean shouldBeUsed() {
        return !this.shouldBeIgnored() && this.isDetected();
    }

    public boolean shouldBeIgnored() {
        if (this.config.ignoreLocalXmrNode) {
            return true;
        }
        if (!"".equals(this.config.xmrNode)) {
            return !HavenoUtils.isLocalHost(this.config.xmrNode);
        }
        boolean hasConfiguredLocalNode = false;
        for (XmrNodes.XmrNode node : this.xmrNodes.selectPreferredNodes(new XmrNodesSetupPreferences(this.preferences))) {
            if (!node.hasClearNetAddress() || !this.equalsUri(node.getClearNetUri())) continue;
            hasConfiguredLocalNode = true;
            break;
        }
        return !hasConfiguredLocalNode;
    }

    public void addListener(XmrLocalNodeListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(XmrLocalNodeListener listener) {
        return this.listeners.remove(listener);
    }

    public MoneroDaemonRpc getDaemon() {
        return this.daemon;
    }

    public boolean equalsUri(String uri) {
        try {
            return HavenoUtils.isLocalHost(uri) && MoneroUtils.parseUri((String)uri).getPort() == HavenoUtils.getDefaultMoneroPort();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDetected() {
        this.checkConnection();
        return Boolean.TRUE.equals(this.connectionManager.getConnection().isOnline());
    }

    public boolean isConnected() {
        this.checkConnection();
        return Boolean.TRUE.equals(this.connectionManager.isConnected());
    }

    private void checkConnection() {
        this.connectionManager.checkConnection();
    }

    public XmrNodeSettings getNodeSettings() {
        return this.preferences.getXmrNodeSettings();
    }

    public void start() throws IOException {
        XmrNodeSettings settings = this.preferences.getXmrNodeSettings();
        this.start(settings);
    }

    public void start(XmrNodeSettings settings) throws IOException {
        List<String> flags;
        Boolean syncBlockchain;
        String bootstrapUrl;
        if (this.isDetected()) {
            throw new IllegalStateException("Local Monero node already online");
        }
        log.info("Starting local Monero node: " + String.valueOf(settings));
        ArrayList<String> args = new ArrayList<String>(MONEROD_ARGS);
        String dataDir = "";
        if (this.config.xmrBlockchainPath == null || this.config.xmrBlockchainPath.isEmpty()) {
            dataDir = settings.getBlockchainPath();
            if (dataDir == null || dataDir.isEmpty()) {
                dataDir = MONEROD_DATADIR;
            }
        } else {
            dataDir = this.config.xmrBlockchainPath;
        }
        if (dataDir != null && !dataDir.isEmpty()) {
            args.add("--data-dir=" + dataDir);
        }
        if ((bootstrapUrl = settings.getBootstrapUrl()) != null && !bootstrapUrl.isEmpty()) {
            args.add("--bootstrap-daemon-address=" + bootstrapUrl);
        }
        if ((syncBlockchain = settings.getSyncBlockchain()) != null && !syncBlockchain.booleanValue()) {
            args.add("--no-sync");
        }
        if ((flags = settings.getStartupFlags()) != null) {
            args.addAll(flags);
        }
        this.daemon = new MoneroDaemonRpc(args);
        this.preferences.setXmrNodeSettings(settings);
        for (XmrLocalNodeListener listener : this.listeners) {
            listener.onNodeStarted(this.daemon);
        }
    }

    public void stop() {
        if (!this.isDetected()) {
            throw new IllegalStateException("Local Monero node is not running");
        }
        if (this.daemon.getProcess() == null || !this.daemon.getProcess().isAlive()) {
            throw new IllegalStateException("Cannot stop local Monero node because we don't own its process");
        }
        this.daemon.stopProcess();
        for (XmrLocalNodeListener listener : this.listeners) {
            listener.onNodeStopped();
        }
    }

    static {
        MONEROD_ARGS.add(MONEROD_PATH);
        MONEROD_ARGS.add("--no-igd");
        MONEROD_ARGS.add("--hide-my-port");
        MONEROD_ARGS.add("--p2p-bind-ip");
        MONEROD_ARGS.add("127.0.0.1");
        if (!Config.baseCurrencyNetwork().isMainnet()) {
            MONEROD_ARGS.add("--" + Config.baseCurrencyNetwork().getNetwork().toLowerCase());
        }
    }
}

