/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.ThreadUtils;
import haveno.common.UserThread;
import haveno.common.app.DevEnv;
import haveno.common.config.BaseCurrencyNetwork;
import haveno.common.config.Config;
import haveno.core.api.AccountServiceListener;
import haveno.core.api.CoreAccountService;
import haveno.core.api.CoreContext;
import haveno.core.api.XmrLocalNode;
import haveno.core.api.XmrLocalNodeListener;
import haveno.core.locale.Res;
import haveno.core.trade.HavenoUtils;
import haveno.core.user.Preferences;
import haveno.core.xmr.model.EncryptedConnectionList;
import haveno.core.xmr.nodes.XmrNodes;
import haveno.core.xmr.nodes.XmrNodesSetupPreferences;
import haveno.core.xmr.setup.DownloadListener;
import haveno.core.xmr.setup.WalletsSetup;
import haveno.core.xmr.wallet.XmrKeyImagePoller;
import haveno.network.Socks5ProxyProvider;
import haveno.network.p2p.P2PService;
import haveno.network.p2p.P2PServiceListener;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import monero.common.MoneroConnectionManager;
import monero.common.MoneroConnectionManagerListener;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;
import monero.daemon.MoneroDaemon;
import monero.daemon.MoneroDaemonRpc;
import monero.daemon.model.MoneroDaemonInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class XmrConnectionService {
    private static final Logger log = LoggerFactory.getLogger(XmrConnectionService.class);
    private static final int MIN_BROADCAST_CONNECTIONS = 0;
    private static final long REFRESH_PERIOD_HTTP_MS = 20000L;
    private static final long REFRESH_PERIOD_ONION_MS = 30000L;
    private static final long KEY_IMAGE_REFRESH_PERIOD_MS_LOCAL = 20000L;
    private static final long KEY_IMAGE_REFRESH_PERIOD_MS_REMOTE = 300000L;
    private static final int MAX_CONSECUTIVE_ERRORS = 3;
    private static int numConsecutiveErrors = 0;
    private final Object lock = new Object();
    private final Object pollLock = new Object();
    private final Object listenerLock = new Object();
    private final Config config;
    private final CoreContext coreContext;
    private final Preferences preferences;
    private final CoreAccountService accountService;
    private final XmrNodes xmrNodes;
    private final XmrLocalNode xmrLocalNode;
    private final MoneroConnectionManager connectionManager;
    private final EncryptedConnectionList connectionList;
    private final ObjectProperty<List<MoneroRpcConnection>> connections = new SimpleObjectProperty();
    private final IntegerProperty numConnections = new SimpleIntegerProperty(-1);
    private final ObjectProperty<MoneroRpcConnection> connectionProperty = new SimpleObjectProperty();
    private final LongProperty chainHeight = new SimpleLongProperty(0L);
    private final DownloadListener downloadListener = new DownloadListener();
    private final ObjectProperty<XmrConnectionFallbackType> connectionServiceFallbackType = new SimpleObjectProperty();
    private final StringProperty connectionServiceErrorMsg = new SimpleStringProperty();
    private final LongProperty numUpdates = new SimpleLongProperty(0L);
    private Socks5ProxyProvider socks5ProxyProvider;
    private boolean isInitialized;
    private boolean pollInProgress;
    private MoneroDaemonRpc monerod;
    private Boolean isConnected = false;
    private MoneroDaemonInfo lastInfo;
    private Long lastFallbackInvocation;
    private Long lastLogPollErrorTimestamp;
    private long lastLogMonerodNotSyncedTimestamp;
    private Long syncStartHeight;
    private TaskLooper monerodPollLooper;
    private long lastRefreshPeriodMs;
    private boolean isShutDownStarted;
    private List<MoneroConnectionManagerListener> listeners = new ArrayList<MoneroConnectionManagerListener>();
    private XmrKeyImagePoller keyImagePoller;
    private static final int EXCLUDE_CONNECTION_SECONDS = 180;
    private static final int MAX_SWITCH_REQUESTS_PER_MINUTE = 2;
    private static final int SKIP_SWITCH_WITHIN_MS = 10000;
    private int numRequestsLastMinute;
    private long lastSwitchTimestamp;
    private Set<MoneroRpcConnection> excludedConnections = new HashSet<MoneroRpcConnection>();
    private static final long FALLBACK_INVOCATION_PERIOD_MS = 30000L;
    private boolean fallbackApplied;
    private boolean usedSyncingLocalNodeBeforeStartup;

    @Inject
    public XmrConnectionService(P2PService p2PService, Config config, CoreContext coreContext, Preferences preferences, WalletsSetup walletsSetup, CoreAccountService accountService, XmrNodes xmrNodes, XmrLocalNode xmrLocalNode, MoneroConnectionManager connectionManager, EncryptedConnectionList connectionList, Socks5ProxyProvider socks5ProxyProvider) {
        this.config = config;
        this.coreContext = coreContext;
        this.preferences = preferences;
        this.accountService = accountService;
        this.xmrNodes = xmrNodes;
        this.xmrLocalNode = xmrLocalNode;
        this.connectionManager = connectionManager;
        this.connectionList = connectionList;
        this.socks5ProxyProvider = socks5ProxyProvider;
        p2PService.addP2PServiceListener(new P2PServiceListener(){

            public void onTorNodeReady() {
                ThreadUtils.submitToPool(() -> {
                    try {
                        XmrConnectionService.this.initialize();
                    }
                    catch (Exception e) {
                        log.warn("Error initializing connection service, error={}\n", (Object)e.getMessage(), (Object)e);
                    }
                });
            }

            public void onHiddenServicePublished() {
            }

            public void onDataReceived() {
            }

            public void onNoSeedNodeAvailable() {
            }

            public void onNoPeersAvailable() {
            }

            public void onUpdatedDataReceived() {
            }
        });
    }

    public void onShutDownStarted() {
        log.info("{}.onShutDownStarted()", (Object)this.getClass().getSimpleName());
        this.isShutDownStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        log.info("Shutting down {}", (Object)this.getClass().getSimpleName());
        this.isInitialized = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.monerodPollLooper != null) {
                this.monerodPollLooper.stop();
            }
            this.monerod = null;
        }
    }

    public MoneroDaemonRpc getMonerod() {
        this.accountService.checkAccountOpen();
        return this.monerod;
    }

    public String getProxyUri() {
        return this.socks5ProxyProvider.getSocks5Proxy() == null ? null : this.socks5ProxyProvider.getSocks5Proxy().getInetAddress().getHostAddress() + ":" + this.socks5ProxyProvider.getSocks5Proxy().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(MoneroConnectionManagerListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    public Boolean isConnected() {
        return this.isConnected;
    }

    public void addConnection(MoneroRpcConnection connection) {
        this.accountService.checkAccountOpen();
        if (this.coreContext.isApiUser()) {
            this.connectionList.addConnection(connection);
        }
        this.connectionManager.addConnection(connection);
    }

    public void removeConnection(String uri) {
        this.accountService.checkAccountOpen();
        this.connectionList.removeConnection(uri);
        this.connectionManager.removeConnection(uri);
    }

    public MoneroRpcConnection getConnection() {
        this.accountService.checkAccountOpen();
        return this.connectionManager.getConnection();
    }

    public List<MoneroRpcConnection> getConnections() {
        this.accountService.checkAccountOpen();
        return this.connectionManager.getConnections();
    }

    public void setConnection(String connectionUri) {
        this.accountService.checkAccountOpen();
        this.connectionManager.setConnection(connectionUri);
    }

    public void setConnection(MoneroRpcConnection connection) {
        this.accountService.checkAccountOpen();
        this.connectionManager.setConnection(connection);
    }

    public MoneroRpcConnection checkConnection() {
        this.accountService.checkAccountOpen();
        this.connectionManager.checkConnection();
        return this.getConnection();
    }

    public List<MoneroRpcConnection> checkConnections() {
        this.accountService.checkAccountOpen();
        this.connectionManager.checkConnections();
        return this.getConnections();
    }

    public void startCheckingConnection(Long refreshPeriod) {
        this.accountService.checkAccountOpen();
        this.connectionList.setRefreshPeriod(refreshPeriod);
        this.updatePolling();
    }

    public void stopCheckingConnection() {
        this.accountService.checkAccountOpen();
        this.connectionList.setRefreshPeriod(-1L);
        this.updatePolling();
    }

    public MoneroRpcConnection getBestConnection() {
        return this.getBestConnection(new ArrayList<MoneroRpcConnection>());
    }

    private MoneroRpcConnection getBestConnection(Collection<MoneroRpcConnection> ignoredConnections) {
        this.accountService.checkAccountOpen();
        if (this.fallbackRequiredBeforeConnectionSwitch()) {
            log.warn("Cannot get best connection on startup because we last synced local node and user has not opted to fallback");
            return null;
        }
        HashSet<MoneroRpcConnection> ignoredConnectionsSet = new HashSet<MoneroRpcConnection>(ignoredConnections);
        this.addLocalNodeIfIgnored(ignoredConnectionsSet);
        MoneroRpcConnection bestConnection = this.connectionManager.getBestAvailableConnection(ignoredConnectionsSet.toArray(new MoneroRpcConnection[0]));
        if (bestConnection == null && this.connectionManager.getConnections().size() == 1 && !ignoredConnectionsSet.contains(this.connectionManager.getConnections().get(0))) {
            bestConnection = (MoneroRpcConnection)this.connectionManager.getConnections().get(0);
        }
        return bestConnection;
    }

    private boolean fallbackRequiredBeforeConnectionSwitch() {
        return this.lastInfo == null && !this.fallbackApplied && this.usedSyncingLocalNodeBeforeStartup && (!this.xmrLocalNode.isDetected() || this.xmrLocalNode.shouldBeIgnored());
    }

    private void addLocalNodeIfIgnored(Collection<MoneroRpcConnection> ignoredConnections) {
        if (this.xmrLocalNode.shouldBeIgnored() && this.connectionManager.hasConnection(this.xmrLocalNode.getUri())) {
            ignoredConnections.add(this.connectionManager.getConnectionByUri(this.xmrLocalNode.getUri()));
        }
    }

    private void switchToBestConnection() {
        if (this.isFixedConnection() || !this.connectionManager.getAutoSwitch()) {
            log.info("Skipping switch to best Monero connection because connection is fixed or auto switch is disabled");
            return;
        }
        MoneroRpcConnection bestConnection = this.getBestConnection();
        if (bestConnection != null) {
            this.setConnection(bestConnection);
        }
    }

    public synchronized boolean requestSwitchToNextBestConnection() {
        return this.requestSwitchToNextBestConnection(null);
    }

    public synchronized boolean requestSwitchToNextBestConnection(MoneroRpcConnection sourceConnection) {
        boolean skipSwitch;
        log.warn("Requesting switch to next best monerod, source monerod={}", sourceConnection == null ? (this.getConnection() == null ? null : this.getConnection().getUri()) : sourceConnection.getUri());
        if (this.isShutDownStarted) {
            log.warn("Skipping switch to next best Monero connection because shut down has started");
            return false;
        }
        if (sourceConnection != null && sourceConnection != this.getConnection()) {
            log.warn("Skipping switch to next best Monero connection because source connection is not current connection");
            return false;
        }
        if (this.isFixedConnection() || !this.connectionManager.getAutoSwitch()) {
            log.warn("Skipping switch to next best Monero connection because connection is fixed or auto switch is disabled");
            return false;
        }
        boolean bl = skipSwitch = System.currentTimeMillis() - this.lastSwitchTimestamp < 10000L;
        if (skipSwitch) {
            log.warn("Skipping switch to next best Monero connection because last switch was less than {} seconds ago", (Object)10);
            return false;
        }
        if (this.numRequestsLastMinute > 2) {
            log.warn("Skipping switch to next best Monero connection because more than {} requests were made in the last minute", (Object)2);
            return false;
        }
        ++this.numRequestsLastMinute;
        UserThread.runAfter(() -> --this.numRequestsLastMinute, (long)60L);
        MoneroRpcConnection currentConnection = this.getConnection();
        if (currentConnection != null) {
            this.excludedConnections.add(currentConnection);
        }
        MoneroRpcConnection bestConnection = this.getBestConnection(this.excludedConnections);
        UserThread.runAfter(() -> {
            if (currentConnection != null) {
                this.excludedConnections.remove(currentConnection);
            }
        }, (long)180L);
        if (bestConnection == null || !Boolean.TRUE.equals(bestConnection.isConnected())) {
            log.warn("No connection to switch to");
            return false;
        }
        this.lastSwitchTimestamp = System.currentTimeMillis();
        this.setConnection(bestConnection);
        return true;
    }

    public void setAutoSwitch(boolean autoSwitch) {
        this.accountService.checkAccountOpen();
        this.connectionManager.setAutoSwitch(autoSwitch);
        this.connectionList.setAutoSwitch(autoSwitch);
    }

    public boolean getAutoSwitch() {
        this.accountService.checkAccountOpen();
        return this.connectionList.getAutoSwitch();
    }

    public boolean isConnectionLocalHost() {
        return this.isConnectionLocalHost(this.getConnection());
    }

    public boolean isProxyApplied() {
        return this.isProxyApplied(this.getConnection());
    }

    public long getRefreshPeriodMs() {
        return this.connectionList.getRefreshPeriod() > 0L ? this.connectionList.getRefreshPeriod() : this.getDefaultRefreshPeriodMs(false);
    }

    private long getInternalRefreshPeriodMs() {
        return this.connectionList.getRefreshPeriod() > 0L ? this.connectionList.getRefreshPeriod() : this.getDefaultRefreshPeriodMs(true);
    }

    public void verifyConnection() {
        if (this.monerod == null) {
            throw new RuntimeException("No connection to Monero node");
        }
        if (!Boolean.TRUE.equals(this.isConnected())) {
            throw new RuntimeException("No connection to Monero node");
        }
        if (!this.isSyncedWithinTolerance()) {
            throw new RuntimeException("Monero node is not synced");
        }
    }

    public Long getHeight() {
        if (this.lastInfo == null) {
            return null;
        }
        return this.lastInfo.getHeight();
    }

    public Long getTargetHeight() {
        if (this.lastInfo == null) {
            return null;
        }
        return this.lastInfo.getTargetHeight() == 0L ? this.lastInfo.getHeight() : this.lastInfo.getTargetHeight();
    }

    public boolean isSyncedWithinTolerance() {
        Long targetHeight = this.getTargetHeight();
        if (targetHeight == null) {
            return false;
        }
        return targetHeight - this.chainHeight.get() <= 3L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmrKeyImagePoller getKeyImagePoller() {
        Object object = this.lock;
        synchronized (object) {
            if (this.keyImagePoller == null) {
                this.keyImagePoller = new XmrKeyImagePoller();
            }
            return this.keyImagePoller;
        }
    }

    private long getKeyImageRefreshPeriodMs() {
        return this.isConnectionLocalHost() ? 20000L : 300000L;
    }

    public ReadOnlyIntegerProperty numConnectionsProperty() {
        return this.numConnections;
    }

    public ReadOnlyObjectProperty<List<MoneroRpcConnection>> connectionsProperty() {
        return this.connections;
    }

    public ReadOnlyObjectProperty<MoneroRpcConnection> connectionProperty() {
        return this.connectionProperty;
    }

    public boolean hasSufficientPeersForBroadcast() {
        if (this.numConnections.get() < 0) {
            return true;
        }
        return this.numConnections.get() >= this.getMinBroadcastConnections();
    }

    public LongProperty chainHeightProperty() {
        return this.chainHeight;
    }

    public ReadOnlyDoubleProperty downloadPercentageProperty() {
        return this.downloadListener.percentageProperty();
    }

    public int getMinBroadcastConnections() {
        return 0;
    }

    public boolean isDownloadComplete() {
        return this.downloadPercentageProperty().get() == 1.0;
    }

    public ReadOnlyLongProperty numUpdatesProperty() {
        return this.numUpdates;
    }

    public void fallbackToBestConnection() {
        if (this.isShutDownStarted) {
            return;
        }
        this.fallbackApplied = true;
        if (this.isProvidedConnections() || this.xmrNodes.getProvidedXmrNodes().isEmpty()) {
            log.warn("Falling back to public nodes");
            this.preferences.setMoneroNodesOptionOrdinal(XmrNodes.MoneroNodesOption.PUBLIC.ordinal());
            this.initializeConnections();
        } else {
            log.warn("Falling back to provided nodes");
            this.preferences.setMoneroNodesOptionOrdinal(XmrNodes.MoneroNodesOption.PROVIDED.ordinal());
            this.initializeConnections();
            if (this.getConnection() == null) {
                log.warn("No provided nodes available, falling back to public nodes");
                this.fallbackToBestConnection();
            }
        }
    }

    private void doneDownload() {
        this.downloadListener.doneDownload();
    }

    private boolean isConnectionLocalHost(MoneroRpcConnection connection) {
        return connection != null && HavenoUtils.isLocalHost(connection.getUri());
    }

    private long getDefaultRefreshPeriodMs(boolean internal) {
        MoneroRpcConnection connection = this.getConnection();
        if (connection == null) {
            return 5000L;
        }
        if (this.isConnectionLocalHost(connection)) {
            if (internal) {
                return 5000L;
            }
            if (this.lastInfo != null && this.lastInfo.getHeightWithoutBootstrap() != null && this.lastInfo.getHeightWithoutBootstrap() > 0L && this.lastInfo.getHeightWithoutBootstrap() < this.lastInfo.getHeight()) {
                return 20000L;
            }
            return 5000L;
        }
        if (this.isProxyApplied(connection)) {
            return 30000L;
        }
        return 20000L;
    }

    private boolean isProxyApplied(MoneroRpcConnection connection) {
        if (connection == null) {
            return false;
        }
        return connection.isOnion() || this.preferences.getUseTorForXmr().isUseTorForXmr() && !HavenoUtils.isPrivateIp(connection.getUri());
    }

    private void initialize() {
        this.getKeyImagePoller();
        new Thread(() -> {
            HavenoUtils.waitFor(20000L);
            this.keyImagePoller.poll();
        }).start();
        this.initializeConnections();
        this.accountService.addListener(new AccountServiceListener(){

            @Override
            public void onAccountOpened() {
                try {
                    log.info(String.valueOf(this.getClass()) + ".onAccountOpened() called");
                    XmrConnectionService.this.initialize();
                }
                catch (Exception e) {
                    log.error("Error initializing connection service after account opened, error={}\n", (Object)e.getMessage(), (Object)e);
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onPasswordChanged(String oldPassword, String newPassword) {
                log.info(String.valueOf(this.getClass()) + ".onPasswordChanged({}, {}) called", (Object)(oldPassword == null ? null : "***"), (Object)(newPassword == null ? null : "***"));
                XmrConnectionService.this.connectionList.changePassword(oldPassword, newPassword);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeConnections() {
        Object object = this.lock;
        synchronized (object) {
            this.connectionManager.reset();
            this.connectionManager.setTimeout(20000L);
            if (!this.isInitialized) {
                this.xmrLocalNode.addListener(new XmrLocalNodeListener(){

                    @Override
                    public void onNodeStarted(MoneroDaemonRpc monerod) {
                        log.info("Local monero node started, height={}", (Object)monerod.getHeight());
                    }

                    @Override
                    public void onNodeStopped() {
                        log.info("Local monero node stopped");
                    }

                    @Override
                    public void onConnectionChanged(MoneroRpcConnection connection) {
                        MoneroRpcConnection bestConnection;
                        log.info("Local monerod connection changed: " + String.valueOf(connection));
                        if (XmrConnectionService.this.isShutDownStarted || !XmrConnectionService.this.connectionManager.getAutoSwitch() || !XmrConnectionService.this.accountService.isAccountOpen() || !XmrConnectionService.this.connectionManager.hasConnection(connection.getUri()) || XmrConnectionService.this.xmrLocalNode.shouldBeIgnored()) {
                            return;
                        }
                        boolean isConnected = false;
                        if (XmrConnectionService.this.xmrLocalNode.isConnected()) {
                            MoneroRpcConnection conn = XmrConnectionService.this.connectionManager.getConnectionByUri(connection.getUri());
                            conn.checkConnection(XmrConnectionService.this.connectionManager.getTimeout());
                            isConnected = Boolean.TRUE.equals(conn.isConnected());
                        }
                        if (isConnected) {
                            XmrConnectionService.this.setConnection(connection.getUri());
                            if (XmrConnectionService.this.connectionServiceFallbackType.get() == XmrConnectionFallbackType.LOCAL && XmrConnectionService.this.isConnectionLocalHost()) {
                                XmrConnectionService.this.connectionServiceFallbackType.set(null);
                            }
                        } else if (XmrConnectionService.this.getConnection() != null && XmrConnectionService.this.getConnection().getUri().equals(connection.getUri()) && (bestConnection = XmrConnectionService.this.getBestConnection()) != null) {
                            XmrConnectionService.this.setConnection(bestConnection);
                        }
                    }
                });
            }
            if (!this.isFixedConnection()) {
                MoneroRpcConnection bestConnection;
                if (this.coreContext.isApiUser()) {
                    for (MoneroRpcConnection connection : this.connectionList.getConnections()) {
                        this.connectionManager.addConnection(connection);
                    }
                    log.info("Read " + this.connectionList.getConnections().size() + " previous connections from disk");
                    for (XmrNodes.XmrNode node : this.xmrNodes.getAllXmrNodes()) {
                        if (!(!node.hasClearNetAddress() || this.xmrLocalNode.shouldBeIgnored() && this.xmrLocalNode.equalsUri(node.getClearNetUri()) || this.connectionList.hasConnection((connection = new MoneroRpcConnection(node.getHostNameOrAddress() + ":" + node.getPort()).setPriority(node.getPriority())).getUri()))) {
                            this.addConnection(connection);
                        }
                        if (!node.hasOnionAddress() || this.connectionList.hasConnection((connection = new MoneroRpcConnection(node.getOnionAddress() + ":" + node.getPort()).setPriority(node.getPriority())).getUri())) continue;
                        this.addConnection(connection);
                    }
                } else {
                    for (XmrNodes.XmrNode node : this.xmrNodes.selectPreferredNodes(new XmrNodesSetupPreferences(this.preferences))) {
                        if (!(!node.hasClearNetAddress() || this.xmrLocalNode.shouldBeIgnored() && this.xmrLocalNode.equalsUri(node.getClearNetUri()))) {
                            connection = new MoneroRpcConnection(node.getHostNameOrAddress() + ":" + node.getPort()).setPriority(node.getPriority());
                            this.addConnection(connection);
                        }
                        if (!node.hasOnionAddress()) continue;
                        connection = new MoneroRpcConnection(node.getOnionAddress() + ":" + node.getPort()).setPriority(node.getPriority());
                        this.addConnection(connection);
                    }
                }
                if (this.connectionList.getCurrentConnectionUri().isPresent() && this.connectionManager.hasConnection(this.connectionList.getCurrentConnectionUri().get()) && (!this.xmrLocalNode.shouldBeIgnored() || !this.xmrLocalNode.equalsUri(this.connectionList.getCurrentConnectionUri().get()))) {
                    this.connectionManager.setConnection(this.connectionList.getCurrentConnectionUri().get());
                }
                if (!this.isInitialized) {
                    this.usedSyncingLocalNodeBeforeStartup = this.connectionList.getCurrentConnectionUri().isPresent() && this.xmrLocalNode.equalsUri(this.connectionList.getCurrentConnectionUri().get()) && this.preferences.getXmrNodeSettings().getSyncBlockchain() != false;
                }
                log.info("TOR proxy URI: " + this.getProxyUri());
                for (MoneroRpcConnection connection : this.connectionManager.getConnections()) {
                    if (!this.isProxyApplied(connection)) continue;
                    connection.setProxyUri(this.getProxyUri());
                }
                if (this.coreContext.isApiUser()) {
                    this.connectionManager.setAutoSwitch(this.connectionList.getAutoSwitch());
                } else {
                    this.connectionManager.setAutoSwitch(true);
                }
                if ((this.connectionManager.getConnection() == null || this.connectionManager.getAutoSwitch()) && (bestConnection = this.getBestConnection()) != null) {
                    this.setConnection(bestConnection);
                }
            } else if (!this.isInitialized) {
                this.connectionManager.setAutoSwitch(false);
                MoneroRpcConnection connection = new MoneroRpcConnection(this.config.xmrNode, this.config.xmrNodeUsername, this.config.xmrNodePassword).setPriority(1);
                if (this.isProxyApplied(connection)) {
                    connection.setProxyUri(this.getProxyUri());
                }
                this.connectionManager.setConnection(connection);
            }
            this.connectionManager.addListener(this::onConnectionChanged);
            this.isInitialized = true;
        }
        this.lastRefreshPeriodMs = this.getRefreshPeriodMs();
        this.onConnectionChanged(this.connectionManager.getConnection());
    }

    public void startLocalNode() throws Exception {
        if (HavenoUtils.isSeedNode()) {
            throw new RuntimeException("Cannot start local node on seed node");
        }
        log.info("Starting local node");
        this.xmrLocalNode.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnectionChanged(MoneroRpcConnection currentConnection) {
        if (this.isShutDownStarted || !this.accountService.isAccountOpen()) {
            return;
        }
        if (currentConnection == null) {
            log.warn("Setting monerod connection to null", new Throwable("Stack trace"));
        }
        Object object = this.lock;
        synchronized (object) {
            if (currentConnection == null) {
                this.monerod = null;
                this.isConnected = false;
                this.connectionList.setCurrentConnectionUri(null);
            } else {
                this.monerod = new MoneroDaemonRpc(currentConnection);
                this.isConnected = currentConnection.isConnected();
                this.connectionList.removeConnection(currentConnection.getUri());
                this.connectionList.addConnection(currentConnection);
                this.connectionList.setCurrentConnectionUri(currentConnection.getUri());
            }
            UserThread.execute(() -> {
                this.connectionProperty.set((Object)currentConnection);
                this.numUpdates.set(this.numUpdates.get() + 1L);
            });
        }
        this.keyImagePoller.setMonerod((MoneroDaemon)this.getMonerod());
        this.keyImagePoller.setRefreshPeriodMs(this.getKeyImageRefreshPeriodMs());
        this.tryPollMonerod();
        if (currentConnection != this.getConnection()) {
            return;
        }
        UserThread.runAfter(() -> this.updatePolling(), (long)(this.getInternalRefreshPeriodMs() / 1000L));
        log.info("XmrConnectionService.onConnectionChanged() uri={}, connected={}", (Object)(currentConnection == null ? null : currentConnection.getUri()), currentConnection == null ? "false" : this.isConnected);
        object = this.listenerLock;
        synchronized (object) {
            for (MoneroConnectionManagerListener listener : this.listeners) {
                ThreadUtils.submitToPool(() -> listener.onConnectionChanged(currentConnection));
            }
        }
    }

    private void updatePolling() {
        this.stopPolling();
        if (this.connectionList.getRefreshPeriod() >= 0L) {
            this.startPolling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPolling() {
        Object object = this.lock;
        synchronized (object) {
            if (this.monerodPollLooper != null) {
                this.monerodPollLooper.stop();
            }
            this.monerodPollLooper = new TaskLooper(() -> {
                if (!this.pollInProgress) {
                    this.tryPollMonerod();
                }
            });
            this.monerodPollLooper.start(this.getInternalRefreshPeriodMs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPolling() {
        Object object = this.lock;
        synchronized (object) {
            if (this.monerodPollLooper != null) {
                this.monerodPollLooper.stop();
                this.monerodPollLooper = null;
            }
        }
    }

    private void tryPollMonerod() {
        try {
            this.pollMonerod();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void pollMonerod() {
        var1_1 = this.pollLock;
        synchronized (var1_1) {
            block35: {
                this.pollInProgress = true;
                if (this.isShutDownStarted) {
                    return;
                }
                try {
                    block34: {
                        if (this.monerod == null && !this.fallbackRequiredBeforeConnectionSwitch()) {
                            this.switchToBestConnection();
                        }
                        try {
                            if (this.monerod == null) {
                                throw new RuntimeException("No connection to Monero daemon");
                            }
                            this.lastInfo = this.monerod.getInfo();
                            XmrConnectionService.numConsecutiveErrors = 0;
                            ** GOTO lbl55
                        }
                        catch (Exception e) {
                            block33: {
                                block32: {
                                    if (this.isShutDownStarted) {
                                        this.pollInProgress = false;
                                        return;
                                    }
                                    if (++XmrConnectionService.numConsecutiveErrors > 3) break block32;
                                    this.pollInProgress = false;
                                    return;
                                }
                                XmrConnectionService.numConsecutiveErrors = 0;
                                v0 = canFallback = this.isFixedConnection() != false || this.isProvidedConnections() != false || this.isCustomConnections() != false || this.usedSyncingLocalNodeBeforeStartup != false;
                                if (this.lastInfo != null || !canFallback) break block33;
                                if (this.connectionServiceFallbackType.get() == null && (this.lastFallbackInvocation == null || System.currentTimeMillis() - this.lastFallbackInvocation > 30000L)) {
                                    this.lastFallbackInvocation = System.currentTimeMillis();
                                    if (this.usedSyncingLocalNodeBeforeStartup) {
                                        XmrConnectionService.log.warn("Failed to fetch monerod info from local connection on startup: " + e.getMessage());
                                        this.connectionServiceFallbackType.set((Object)XmrConnectionFallbackType.LOCAL);
                                    } else if (this.isProvidedConnections()) {
                                        XmrConnectionService.log.warn("Failed to fetch monerod info from provided connections on startup: " + e.getMessage());
                                        this.connectionServiceFallbackType.set((Object)XmrConnectionFallbackType.PROVIDED);
                                    } else {
                                        XmrConnectionService.log.warn("Failed to fetch monerod info from custom connection on startup: " + e.getMessage());
                                        this.connectionServiceFallbackType.set((Object)XmrConnectionFallbackType.CUSTOM);
                                    }
                                }
                                this.pollInProgress = false;
                                return;
                            }
                            if (this.lastWarningOutsidePeriod()) {
                                connection = this.getConnection();
                                XmrConnectionService.log.warn("Error fetching daemon info after max attempts. Trying to switch to best connection. monerod={}, error={}", (Object)(connection == null ? "null" : connection.getUri()), (Object)e.getMessage());
                                if (DevEnv.isDevMode()) {
                                    XmrConnectionService.log.error(ExceptionUtils.getStackTrace((Throwable)e));
                                }
                                this.lastLogPollErrorTimestamp = System.currentTimeMillis();
                            }
                            this.switchToBestConnection();
                            if (this.monerod == null) {
                                throw new RuntimeException("No connection to Monero daemon after error handling");
                            }
                            this.lastInfo = this.monerod.getInfo();
lbl55:
                            // 2 sources

                            this.isConnected = true;
                            this.connectionServiceFallbackType.set(null);
                            this.chainHeight.set(this.lastInfo.getHeight().longValue());
                            blockchainSyncing = this.lastInfo.getHeight().equals(this.lastInfo.getHeightWithoutBootstrap()) != false || this.lastInfo.getTargetHeight().equals(0L) != false && this.lastInfo.getHeightWithoutBootstrap().equals(0L) != false;
                            this.preferences.getXmrNodeSettings().setSyncBlockchain(blockchainSyncing);
                            if (!this.isSyncedWithinTolerance() && System.currentTimeMillis() - this.lastLogMonerodNotSyncedTimestamp > 30000L) {
                                XmrConnectionService.log.warn("Our chain height: {} is out of sync with peer nodes chain height: {}", (Object)this.getHeight(), (Object)this.getTargetHeight());
                                this.lastLogMonerodNotSyncedTimestamp = System.currentTimeMillis();
                            }
                            if (this.getRefreshPeriodMs() == this.lastRefreshPeriodMs) break block34;
                            this.lastRefreshPeriodMs = this.getRefreshPeriodMs();
                            this.onConnectionChanged(this.getConnection());
                        }
                        return;
                    }
                    numOutgoingConnections = Boolean.TRUE.equals(this.lastInfo.isRestricted()) != false ? -1 : this.lastInfo.getNumOutgoingConnections();
                    UserThread.execute((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$pollMonerod$7(int ), ()V)((XmrConnectionService)this, (int)numOutgoingConnections));
                    if (numOutgoingConnections == 0) {
                        errorMsg = "The Monero node has no connected peers. It may be experiencing a network connectivity issue.";
                        XmrConnectionService.log.warn(errorMsg);
                        throw new RuntimeException(errorMsg);
                    }
                    if (this.lastLogPollErrorTimestamp != null) {
                        XmrConnectionService.log.info("Successfully fetched monerod info after previous error");
                        this.lastLogPollErrorTimestamp = null;
                    }
                    this.getConnectionServiceErrorMsg().set(null);
                    break block35;
                    {
                        catch (Exception e) {
                            this.isConnected = false;
                            if (this.isShutDownStarted) {
                                return;
                            }
                            errorMsg = e.getMessage();
                            if (errorMsg != null && errorMsg.contains(": ")) {
                                errorMsg = errorMsg.substring(errorMsg.indexOf(": ") + 2);
                            }
                            errorMsg = Res.get("popup.warning.moneroConnection", new Object[]{errorMsg});
                            this.getConnectionServiceErrorMsg().set((Object)errorMsg);
                            throw e;
                        }
                        catch (Throwable var5_8) {
                            throw var5_8;
                        }
                    }
                }
                finally {
                    this.pollInProgress = false;
                }
            }
        }
    }

    private boolean lastWarningOutsidePeriod() {
        return this.lastLogPollErrorTimestamp == null || System.currentTimeMillis() - this.lastLogPollErrorTimestamp > 240000L;
    }

    private boolean isFixedConnection() {
        return !"".equals(this.config.xmrNode) && (!HavenoUtils.isLocalHost(this.config.xmrNode) || !this.xmrLocalNode.shouldBeIgnored()) && !this.fallbackApplied;
    }

    private boolean isCustomConnections() {
        return this.preferences.getMoneroNodesOption() == XmrNodes.MoneroNodesOption.CUSTOM;
    }

    private boolean isProvidedConnections() {
        return this.preferences.getMoneroNodesOption() == XmrNodes.MoneroNodesOption.PROVIDED;
    }

    public ObjectProperty<XmrConnectionFallbackType> getConnectionServiceFallbackType() {
        return this.connectionServiceFallbackType;
    }

    public StringProperty getConnectionServiceErrorMsg() {
        return this.connectionServiceErrorMsg;
    }

    public MoneroDaemonInfo getLastInfo() {
        return this.lastInfo;
    }

    public boolean isShutDownStarted() {
        return this.isShutDownStarted;
    }

    private /* synthetic */ void lambda$pollMonerod$7(int numOutgoingConnections) {
        boolean isTestnet;
        boolean bl = isTestnet = Config.baseCurrencyNetwork() == BaseCurrencyNetwork.XMR_LOCAL;
        if (this.lastInfo.isSynchronized().booleanValue() || isTestnet) {
            this.doneDownload();
        } else if (this.lastInfo.isBusySyncing().booleanValue()) {
            long targetHeight = this.lastInfo.getTargetHeight();
            long blocksLeft = targetHeight - this.lastInfo.getHeight();
            if (this.syncStartHeight == null) {
                this.syncStartHeight = this.lastInfo.getHeight();
            }
            double percent = Math.min(1.0, targetHeight == this.syncStartHeight ? 1.0 : (double)Math.max(1L, this.lastInfo.getHeight() - this.syncStartHeight) / (double)(targetHeight - this.syncStartHeight));
            this.downloadListener.progress(percent, blocksLeft, null);
        }
        ArrayList<MoneroRpcConnection> availableConnections = new ArrayList<MoneroRpcConnection>();
        for (MoneroRpcConnection connection : this.connectionManager.getConnections()) {
            if (!Boolean.TRUE.equals(connection.isOnline()) || !Boolean.TRUE.equals(connection.isAuthenticated())) continue;
            availableConnections.add(connection);
        }
        this.connections.set(availableConnections);
        this.numConnections.set(numOutgoingConnections);
        this.numUpdates.set(this.numUpdates.get() + 1L);
    }

    public static enum XmrConnectionFallbackType {
        LOCAL,
        CUSTOM,
        PROVIDED;

    }
}

