/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.common.handlers.ErrorMessageHandler;
import haveno.common.handlers.ResultHandler;
import haveno.core.api.CoreContext;
import haveno.core.api.CoreWalletsService;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferDirection;
import haveno.core.offer.OfferUtil;
import haveno.core.offer.takeoffer.TakeOfferModel;
import haveno.core.payment.PaymentAccount;
import haveno.core.payment.payload.PaymentMethod;
import haveno.core.support.messages.ChatMessage;
import haveno.core.support.traderchat.TradeChatSession;
import haveno.core.support.traderchat.TraderChatManager;
import haveno.core.trade.ClosedTradableManager;
import haveno.core.trade.Trade;
import haveno.core.trade.TradeManager;
import haveno.core.trade.TradeUtil;
import haveno.core.trade.protocol.BuyerProtocol;
import haveno.core.trade.protocol.SellerProtocol;
import haveno.core.trade.protocol.TradeProtocol;
import haveno.core.user.User;
import haveno.core.util.coin.CoinUtil;
import haveno.core.xmr.wallet.BtcWalletService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class CoreTradesService {
    private static final Logger log = LoggerFactory.getLogger(CoreTradesService.class);
    private final CoreContext coreContext;
    private final CoreWalletsService coreWalletsService;
    private final BtcWalletService btcWalletService;
    private final ClosedTradableManager closedTradableManager;
    private final TakeOfferModel takeOfferModel;
    private final TradeManager tradeManager;
    private final TraderChatManager traderChatManager;
    private final OfferUtil offerUtil;
    private final User user;

    @Inject
    public CoreTradesService(CoreContext coreContext, CoreWalletsService coreWalletsService, BtcWalletService btcWalletService, ClosedTradableManager closedTradableManager, TakeOfferModel takeOfferModel, TradeManager tradeManager, TraderChatManager traderChatManager, TradeUtil tradeUtil, OfferUtil offerUtil, User user) {
        this.coreContext = coreContext;
        this.coreWalletsService = coreWalletsService;
        this.btcWalletService = btcWalletService;
        this.closedTradableManager = closedTradableManager;
        this.takeOfferModel = takeOfferModel;
        this.tradeManager = tradeManager;
        this.traderChatManager = traderChatManager;
        this.offerUtil = offerUtil;
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void takeOffer(Offer offer, String paymentAccountId, long amountAsLong, Consumer<Trade> resultHandler, ErrorMessageHandler errorMessageHandler) {
        try {
            BigInteger fundsNeededForTrade;
            this.coreWalletsService.verifyWalletsAreAvailable();
            this.coreWalletsService.verifyEncryptedWalletIsUnlocked();
            PaymentAccount paymentAccount = this.user.getPaymentAccount(paymentAccountId);
            if (paymentAccount == null) {
                throw new IllegalArgumentException(String.format("payment account with id '%s' not found", paymentAccountId));
            }
            boolean useSavingsWallet = true;
            BigInteger amount = amountAsLong == 0L ? offer.getAmount() : BigInteger.valueOf(amountAsLong);
            String currencyCode = offer.getCounterCurrencyCode();
            OfferDirection direction = offer.getOfferPayload().getDirection();
            BigInteger maxAmount = this.offerUtil.getMaxTradeLimit(paymentAccount, currencyCode, direction, offer.hasBuyerAsTakerWithoutDeposit());
            if (offer.getPrice() != null) {
                if (PaymentMethod.isRoundedForAtmCash(paymentAccount.getPaymentMethod().getId())) {
                    amount = CoinUtil.getRoundedAtmCashAmount(amount, offer.getPrice(), offer.getMinAmount(), maxAmount);
                } else if (offer.isTraditionalOffer() && offer.isRange()) {
                    amount = CoinUtil.getRoundedAmount(amount, offer.getPrice(), offer.getMinAmount(), maxAmount, offer.getCounterCurrencyCode(), offer.getPaymentMethodId());
                }
            }
            TakeOfferModel takeOfferModel = this.takeOfferModel;
            synchronized (takeOfferModel) {
                this.takeOfferModel.initModel(offer, paymentAccount, amount, useSavingsWallet);
                fundsNeededForTrade = this.takeOfferModel.getFundsNeededForTrade();
                log.debug("Initiating take {} offer, {}", (Object)(offer.isBuyOffer() ? "buy" : "sell"), (Object)this.takeOfferModel);
            }
            this.tradeManager.onTakeOffer(amount, fundsNeededForTrade, offer, paymentAccountId, useSavingsWallet, this.coreContext.isApiUser(), resultHandler::accept, errorMessageHandler);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            errorMessageHandler.handleErrorMessage(e.getMessage());
        }
    }

    void confirmPaymentSent(String tradeId, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Trade trade = this.getTrade(tradeId);
        if (!this.isFollowingBuyerProtocol(trade)) {
            throw new IllegalStateException("you are the seller and not sending payment");
        }
        TradeProtocol tradeProtocol = this.tradeManager.getTradeProtocol(trade);
        ((BuyerProtocol)tradeProtocol).onPaymentSent(resultHandler, errorMessageHandler);
    }

    void confirmPaymentReceived(String tradeId, ResultHandler resultHandler, ErrorMessageHandler errorMessageHandler) {
        Trade trade = this.getTrade(tradeId);
        if (this.isFollowingBuyerProtocol(trade)) {
            throw new IllegalStateException("you are the buyer, and not receiving payment");
        }
        TradeProtocol tradeProtocol = this.tradeManager.getTradeProtocol(trade);
        ((SellerProtocol)tradeProtocol).onPaymentReceived(resultHandler, errorMessageHandler);
    }

    void closeTrade(String tradeId) {
        this.coreWalletsService.verifyWalletsAreAvailable();
        this.coreWalletsService.verifyEncryptedWalletIsUnlocked();
        this.verifyTradeIsNotClosed(tradeId);
        Trade trade = this.getOpenTrade(tradeId).orElseThrow(() -> new IllegalArgumentException(String.format("trade with id '%s' not found", tradeId)));
        this.tradeManager.onTradeCompleted(trade);
    }

    String getTradeRole(String tradeId) {
        this.coreWalletsService.verifyWalletsAreAvailable();
        this.coreWalletsService.verifyEncryptedWalletIsUnlocked();
        return TradeUtil.getRole(this.getTrade(tradeId));
    }

    Trade getTrade(String tradeId) {
        this.coreWalletsService.verifyWalletsAreAvailable();
        this.coreWalletsService.verifyEncryptedWalletIsUnlocked();
        return this.getOpenTrade(tradeId).orElseGet(() -> this.getClosedTrade(tradeId).orElseThrow(() -> new IllegalArgumentException(String.format("trade with id '%s' not found", tradeId))));
    }

    private Optional<Trade> getOpenTrade(String tradeId) {
        return this.tradeManager.getOpenTrade(tradeId);
    }

    private Optional<Trade> getClosedTrade(String tradeId) {
        return this.closedTradableManager.getTradeById(tradeId);
    }

    List<Trade> getTrades() {
        this.coreWalletsService.verifyWalletsAreAvailable();
        this.coreWalletsService.verifyEncryptedWalletIsUnlocked();
        ArrayList<Trade> trades = new ArrayList<Trade>(this.tradeManager.getOpenTrades());
        trades.addAll(this.closedTradableManager.getClosedTrades());
        return trades;
    }

    List<ChatMessage> getChatMessages(String tradeId) {
        Optional<Trade> tradeOptional = this.tradeManager.getOpenTrade(tradeId);
        if (!tradeOptional.isPresent()) {
            throw new IllegalStateException(String.format("trade with id '%s' not found", tradeId));
        }
        Trade trade = tradeOptional.get();
        boolean isMaker = this.tradeManager.isMyOffer(trade.getOffer());
        TradeChatSession tradeChatSession = new TradeChatSession(trade, !isMaker);
        return tradeChatSession.getObservableChatMessageList();
    }

    void sendChatMessage(String tradeId, String message) {
        Optional<Trade> tradeOptional = this.tradeManager.getOpenTrade(tradeId);
        if (!tradeOptional.isPresent()) {
            throw new IllegalStateException(String.format("trade with id '%s' not found", tradeId));
        }
        Trade trade = tradeOptional.get();
        boolean isMaker = this.tradeManager.isMyOffer(trade.getOffer());
        TradeChatSession tradeChatSession = new TradeChatSession(trade, !isMaker);
        ChatMessage chatMessage = new ChatMessage(this.traderChatManager.getSupportType(), tradeChatSession.getTradeId(), tradeChatSession.getClientId(), tradeChatSession.isClient(), message, this.traderChatManager.getMyAddress());
        this.traderChatManager.addAndPersistChatMessage(chatMessage);
        this.traderChatManager.sendChatMessage(chatMessage);
    }

    private boolean isFollowingBuyerProtocol(Trade trade) {
        return this.tradeManager.getTradeProtocol(trade) instanceof BuyerProtocol;
    }

    private void verifyTradeIsNotClosed(String tradeId) {
        if (this.getClosedTrade(tradeId).isPresent()) {
            throw new IllegalArgumentException(String.format("trade '%s' is already closed", tradeId));
        }
    }
}

