/*
 * Decompiled with CFR 0.152.
 */
package haveno.core.api;

import com.google.common.math.LongMath;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import haveno.core.api.model.MarketDepthInfo;
import haveno.core.api.model.MarketPriceInfo;
import haveno.core.locale.CurrencyUtil;
import haveno.core.monetary.Price;
import haveno.core.offer.Offer;
import haveno.core.offer.OfferBookService;
import haveno.core.offer.OfferDirection;
import haveno.core.provider.price.MarketPrice;
import haveno.core.provider.price.PriceFeedService;
import haveno.core.trade.HavenoUtils;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class CorePriceService {
    private static final Logger log = LoggerFactory.getLogger(CorePriceService.class);
    private final PriceFeedService priceFeedService;
    private final OfferBookService offerBookService;

    @Inject
    public CorePriceService(PriceFeedService priceFeedService, OfferBookService offerBookService) {
        this.priceFeedService = priceFeedService;
        this.offerBookService = offerBookService;
    }

    public double getMarketPrice(String currencyCode) throws ExecutionException, InterruptedException, TimeoutException, IllegalArgumentException {
        MarketPrice marketPrice = this.priceFeedService.requestAllPrices().get(CurrencyUtil.getCurrencyCodeBase(currencyCode));
        if (marketPrice == null) {
            throw new IllegalArgumentException("Currency not found: " + currencyCode);
        }
        if (!marketPrice.isExternallyProvidedPrice()) {
            throw new IllegalArgumentException("Price is not available externally: " + currencyCode);
        }
        return marketPrice.getPrice();
    }

    public List<MarketPriceInfo> getMarketPrices() throws ExecutionException, InterruptedException, TimeoutException {
        return this.priceFeedService.requestAllPrices().values().stream().map(marketPrice -> new MarketPriceInfo(marketPrice.getCurrencyCode(), marketPrice.getPrice())).collect(Collectors.toList());
    }

    public MarketDepthInfo getMarketDepth(String currencyCode) throws ExecutionException, InterruptedException, TimeoutException, IllegalArgumentException {
        if (this.priceFeedService.requestAllPrices().get(currencyCode.toUpperCase()) == null) {
            throw new IllegalArgumentException("Currency not found: " + currencyCode);
        }
        Comparator<Offer> offerPriceComparator = Comparator.comparing(Offer::getPrice, Comparator.nullsLast(Comparator.naturalOrder()));
        Comparator<Offer> offerAmountComparator = Comparator.comparing(Offer::getAmount).reversed();
        Comparator<Offer> buyOfferSortComparator = offerPriceComparator.reversed().thenComparing(offerAmountComparator);
        Comparator<Offer> sellOfferSortComparator = offerPriceComparator.thenComparing(offerAmountComparator);
        List buyOffers = this.offerBookService.getOffersByCurrency(OfferDirection.BUY.name(), currencyCode).stream().sorted(buyOfferSortComparator).collect(Collectors.toList());
        List sellOffers = this.offerBookService.getOffersByCurrency(OfferDirection.SELL.name(), currencyCode).stream().sorted(sellOfferSortComparator).collect(Collectors.toList());
        double accumulatedAmount = 0.0;
        LinkedHashMap<Double, Double> buyTM = new LinkedHashMap<Double, Double>();
        for (Object offer : buyOffers) {
            Price price = ((Offer)offer).getPrice();
            if (price == null) continue;
            double amount = (double)((Offer)offer).getAmount().longValueExact() / (double)LongMath.pow((long)10L, (int)HavenoUtils.XMR_SMALLEST_UNIT_EXPONENT);
            double priceAsDouble = (double)price.getValue() / (double)LongMath.pow((long)10L, (int)price.smallestUnitExponent());
            buyTM.put(priceAsDouble, accumulatedAmount += amount);
        }
        accumulatedAmount = 0.0;
        LinkedHashMap<Double, Double> sellTM = new LinkedHashMap<Double, Double>();
        for (Offer offer : sellOffers) {
            Price price = offer.getPrice();
            if (price == null) continue;
            double amount = (double)offer.getAmount().longValueExact() / (double)LongMath.pow((long)10L, (int)HavenoUtils.XMR_SMALLEST_UNIT_EXPONENT);
            double priceAsDouble = (double)price.getValue() / (double)LongMath.pow((long)10L, (int)price.smallestUnitExponent());
            sellTM.put(priceAsDouble, accumulatedAmount += amount);
        }
        Double[] buyDepth = buyTM.values().toArray(new Double[buyTM.size()]);
        Double[] buyPrices = buyTM.keySet().toArray(new Double[buyTM.size()]);
        Double[] sellDepth = sellTM.values().toArray(new Double[sellTM.size()]);
        Double[] sellPrices = sellTM.keySet().toArray(new Double[sellTM.size()]);
        return new MarketDepthInfo(currencyCode, buyPrices, buyDepth, sellPrices, sellDepth);
    }
}

